package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
 * <p>
 * Expandable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
 * <p>
 * Referenceable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.SortRestrictions</b>
 * <p>
 * Sortable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * false
 */@JsonPropertyOrder({
    "@odata.type", 
    "resource", 
    "changeType", 
    "clientState", 
    "notificationUrl", 
    "expirationDateTime", 
    "applicationId", 
    "creatorId", 
    "includeProperties", 
    "includeResourceData", 
    "lifecycleNotificationUrl", 
    "encryptionCertificate", 
    "encryptionCertificateId", 
    "latestSupportedTlsVersion"})
@JsonInclude(Include.NON_NULL)
public class Subscription extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.subscription";
    }

    @JsonProperty("resource")
    protected String resource;

    @JsonProperty("changeType")
    protected String changeType;

    @JsonProperty("clientState")
    protected String clientState;

    @JsonProperty("notificationUrl")
    protected String notificationUrl;

    @JsonProperty("expirationDateTime")
    protected OffsetDateTime expirationDateTime;

    @JsonProperty("applicationId")
    protected String applicationId;

    @JsonProperty("creatorId")
    protected String creatorId;

    @JsonProperty("includeProperties")
    protected Boolean includeProperties;

    @JsonProperty("includeResourceData")
    protected Boolean includeResourceData;

    @JsonProperty("lifecycleNotificationUrl")
    protected String lifecycleNotificationUrl;

    @JsonProperty("encryptionCertificate")
    protected String encryptionCertificate;

    @JsonProperty("encryptionCertificateId")
    protected String encryptionCertificateId;

    @JsonProperty("latestSupportedTlsVersion")
    protected String latestSupportedTlsVersion;

    protected Subscription() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSubscription() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String resource;
        private String changeType;
        private String clientState;
        private String notificationUrl;
        private OffsetDateTime expirationDateTime;
        private String applicationId;
        private String creatorId;
        private Boolean includeProperties;
        private Boolean includeResourceData;
        private String lifecycleNotificationUrl;
        private String encryptionCertificate;
        private String encryptionCertificateId;
        private String latestSupportedTlsVersion;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder resource(String resource) {
            this.resource = resource;
            this.changedFields = changedFields.add("resource");
            return this;
        }

        public Builder changeType(String changeType) {
            this.changeType = changeType;
            this.changedFields = changedFields.add("changeType");
            return this;
        }

        public Builder clientState(String clientState) {
            this.clientState = clientState;
            this.changedFields = changedFields.add("clientState");
            return this;
        }

        public Builder notificationUrl(String notificationUrl) {
            this.notificationUrl = notificationUrl;
            this.changedFields = changedFields.add("notificationUrl");
            return this;
        }

        public Builder expirationDateTime(OffsetDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            this.changedFields = changedFields.add("expirationDateTime");
            return this;
        }

        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            this.changedFields = changedFields.add("applicationId");
            return this;
        }

        public Builder creatorId(String creatorId) {
            this.creatorId = creatorId;
            this.changedFields = changedFields.add("creatorId");
            return this;
        }

        public Builder includeProperties(Boolean includeProperties) {
            this.includeProperties = includeProperties;
            this.changedFields = changedFields.add("includeProperties");
            return this;
        }

        public Builder includeResourceData(Boolean includeResourceData) {
            this.includeResourceData = includeResourceData;
            this.changedFields = changedFields.add("includeResourceData");
            return this;
        }

        public Builder lifecycleNotificationUrl(String lifecycleNotificationUrl) {
            this.lifecycleNotificationUrl = lifecycleNotificationUrl;
            this.changedFields = changedFields.add("lifecycleNotificationUrl");
            return this;
        }

        public Builder encryptionCertificate(String encryptionCertificate) {
            this.encryptionCertificate = encryptionCertificate;
            this.changedFields = changedFields.add("encryptionCertificate");
            return this;
        }

        public Builder encryptionCertificateId(String encryptionCertificateId) {
            this.encryptionCertificateId = encryptionCertificateId;
            this.changedFields = changedFields.add("encryptionCertificateId");
            return this;
        }

        public Builder latestSupportedTlsVersion(String latestSupportedTlsVersion) {
            this.latestSupportedTlsVersion = latestSupportedTlsVersion;
            this.changedFields = changedFields.add("latestSupportedTlsVersion");
            return this;
        }

        public Subscription build() {
            Subscription _x = new Subscription();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.subscription";
            _x.id = id;
            _x.resource = resource;
            _x.changeType = changeType;
            _x.clientState = clientState;
            _x.notificationUrl = notificationUrl;
            _x.expirationDateTime = expirationDateTime;
            _x.applicationId = applicationId;
            _x.creatorId = creatorId;
            _x.includeProperties = includeProperties;
            _x.includeResourceData = includeResourceData;
            _x.lifecycleNotificationUrl = lifecycleNotificationUrl;
            _x.encryptionCertificate = encryptionCertificate;
            _x.encryptionCertificateId = encryptionCertificateId;
            _x.latestSupportedTlsVersion = latestSupportedTlsVersion;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="resource")
    @JsonIgnore
    public Optional<String> getResource() {
        return Optional.ofNullable(resource);
    }

    public Subscription withResource(String resource) {
        Subscription _x = _copy();
        _x.changedFields = changedFields.add("resource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscription");
        _x.resource = resource;
        return _x;
    }

    @Property(name="changeType")
    @JsonIgnore
    public Optional<String> getChangeType() {
        return Optional.ofNullable(changeType);
    }

    public Subscription withChangeType(String changeType) {
        Subscription _x = _copy();
        _x.changedFields = changedFields.add("changeType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscription");
        _x.changeType = changeType;
        return _x;
    }

    @Property(name="clientState")
    @JsonIgnore
    public Optional<String> getClientState() {
        return Optional.ofNullable(clientState);
    }

    public Subscription withClientState(String clientState) {
        Subscription _x = _copy();
        _x.changedFields = changedFields.add("clientState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscription");
        _x.clientState = clientState;
        return _x;
    }

    @Property(name="notificationUrl")
    @JsonIgnore
    public Optional<String> getNotificationUrl() {
        return Optional.ofNullable(notificationUrl);
    }

    public Subscription withNotificationUrl(String notificationUrl) {
        Subscription _x = _copy();
        _x.changedFields = changedFields.add("notificationUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscription");
        _x.notificationUrl = notificationUrl;
        return _x;
    }

    @Property(name="expirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTime() {
        return Optional.ofNullable(expirationDateTime);
    }

    public Subscription withExpirationDateTime(OffsetDateTime expirationDateTime) {
        Subscription _x = _copy();
        _x.changedFields = changedFields.add("expirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscription");
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    @Property(name="applicationId")
    @JsonIgnore
    public Optional<String> getApplicationId() {
        return Optional.ofNullable(applicationId);
    }

    public Subscription withApplicationId(String applicationId) {
        Subscription _x = _copy();
        _x.changedFields = changedFields.add("applicationId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscription");
        _x.applicationId = applicationId;
        return _x;
    }

    @Property(name="creatorId")
    @JsonIgnore
    public Optional<String> getCreatorId() {
        return Optional.ofNullable(creatorId);
    }

    public Subscription withCreatorId(String creatorId) {
        Subscription _x = _copy();
        _x.changedFields = changedFields.add("creatorId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscription");
        _x.creatorId = creatorId;
        return _x;
    }

    @Property(name="includeProperties")
    @JsonIgnore
    public Optional<Boolean> getIncludeProperties() {
        return Optional.ofNullable(includeProperties);
    }

    public Subscription withIncludeProperties(Boolean includeProperties) {
        Subscription _x = _copy();
        _x.changedFields = changedFields.add("includeProperties");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscription");
        _x.includeProperties = includeProperties;
        return _x;
    }

    @Property(name="includeResourceData")
    @JsonIgnore
    public Optional<Boolean> getIncludeResourceData() {
        return Optional.ofNullable(includeResourceData);
    }

    public Subscription withIncludeResourceData(Boolean includeResourceData) {
        Subscription _x = _copy();
        _x.changedFields = changedFields.add("includeResourceData");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscription");
        _x.includeResourceData = includeResourceData;
        return _x;
    }

    @Property(name="lifecycleNotificationUrl")
    @JsonIgnore
    public Optional<String> getLifecycleNotificationUrl() {
        return Optional.ofNullable(lifecycleNotificationUrl);
    }

    public Subscription withLifecycleNotificationUrl(String lifecycleNotificationUrl) {
        Subscription _x = _copy();
        _x.changedFields = changedFields.add("lifecycleNotificationUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscription");
        _x.lifecycleNotificationUrl = lifecycleNotificationUrl;
        return _x;
    }

    @Property(name="encryptionCertificate")
    @JsonIgnore
    public Optional<String> getEncryptionCertificate() {
        return Optional.ofNullable(encryptionCertificate);
    }

    public Subscription withEncryptionCertificate(String encryptionCertificate) {
        Subscription _x = _copy();
        _x.changedFields = changedFields.add("encryptionCertificate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscription");
        _x.encryptionCertificate = encryptionCertificate;
        return _x;
    }

    @Property(name="encryptionCertificateId")
    @JsonIgnore
    public Optional<String> getEncryptionCertificateId() {
        return Optional.ofNullable(encryptionCertificateId);
    }

    public Subscription withEncryptionCertificateId(String encryptionCertificateId) {
        Subscription _x = _copy();
        _x.changedFields = changedFields.add("encryptionCertificateId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscription");
        _x.encryptionCertificateId = encryptionCertificateId;
        return _x;
    }

    @Property(name="latestSupportedTlsVersion")
    @JsonIgnore
    public Optional<String> getLatestSupportedTlsVersion() {
        return Optional.ofNullable(latestSupportedTlsVersion);
    }

    public Subscription withLatestSupportedTlsVersion(String latestSupportedTlsVersion) {
        Subscription _x = _copy();
        _x.changedFields = changedFields.add("latestSupportedTlsVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscription");
        _x.latestSupportedTlsVersion = latestSupportedTlsVersion;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Subscription patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Subscription _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Subscription put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Subscription _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Subscription _copy() {
        Subscription _x = new Subscription();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.resource = resource;
        _x.changeType = changeType;
        _x.clientState = clientState;
        _x.notificationUrl = notificationUrl;
        _x.expirationDateTime = expirationDateTime;
        _x.applicationId = applicationId;
        _x.creatorId = creatorId;
        _x.includeProperties = includeProperties;
        _x.includeResourceData = includeResourceData;
        _x.lifecycleNotificationUrl = lifecycleNotificationUrl;
        _x.encryptionCertificate = encryptionCertificate;
        _x.encryptionCertificateId = encryptionCertificateId;
        _x.latestSupportedTlsVersion = latestSupportedTlsVersion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Subscription[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("resource=");
        b.append(this.resource);
        b.append(", ");
        b.append("changeType=");
        b.append(this.changeType);
        b.append(", ");
        b.append("clientState=");
        b.append(this.clientState);
        b.append(", ");
        b.append("notificationUrl=");
        b.append(this.notificationUrl);
        b.append(", ");
        b.append("expirationDateTime=");
        b.append(this.expirationDateTime);
        b.append(", ");
        b.append("applicationId=");
        b.append(this.applicationId);
        b.append(", ");
        b.append("creatorId=");
        b.append(this.creatorId);
        b.append(", ");
        b.append("includeProperties=");
        b.append(this.includeProperties);
        b.append(", ");
        b.append("includeResourceData=");
        b.append(this.includeResourceData);
        b.append(", ");
        b.append("lifecycleNotificationUrl=");
        b.append(this.lifecycleNotificationUrl);
        b.append(", ");
        b.append("encryptionCertificate=");
        b.append(this.encryptionCertificate);
        b.append(", ");
        b.append("encryptionCertificateId=");
        b.append(this.encryptionCertificateId);
        b.append(", ");
        b.append("latestSupportedTlsVersion=");
        b.append(this.latestSupportedTlsVersion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
