package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.LicenseUnitsDetail;
import odata.msgraph.client.beta.complex.ServicePlanInfo;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
 * <p>
 * Expandable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
 * <p>
 * Referenceable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * false
 */@JsonPropertyOrder({
    "@odata.type", 
    "capabilityStatus", 
    "consumedUnits", 
    "prepaidUnits", 
    "servicePlans", 
    "skuId", 
    "skuPartNumber", 
    "appliesTo"})
@JsonInclude(Include.NON_NULL)
public class SubscribedSku extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.subscribedSku";
    }

    @JsonProperty("capabilityStatus")
    protected String capabilityStatus;

    @JsonProperty("consumedUnits")
    protected Integer consumedUnits;

    @JsonProperty("prepaidUnits")
    protected LicenseUnitsDetail prepaidUnits;

    @JsonProperty("servicePlans")
    protected List<ServicePlanInfo> servicePlans;

    @JsonProperty("servicePlans@nextLink")
    protected String servicePlansNextLink;

    @JsonProperty("skuId")
    protected String skuId;

    @JsonProperty("skuPartNumber")
    protected String skuPartNumber;

    @JsonProperty("appliesTo")
    protected String appliesTo;

    protected SubscribedSku() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSubscribedSku() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String capabilityStatus;
        private Integer consumedUnits;
        private LicenseUnitsDetail prepaidUnits;
        private List<ServicePlanInfo> servicePlans;
        private String servicePlansNextLink;
        private String skuId;
        private String skuPartNumber;
        private String appliesTo;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder capabilityStatus(String capabilityStatus) {
            this.capabilityStatus = capabilityStatus;
            this.changedFields = changedFields.add("capabilityStatus");
            return this;
        }

        public Builder consumedUnits(Integer consumedUnits) {
            this.consumedUnits = consumedUnits;
            this.changedFields = changedFields.add("consumedUnits");
            return this;
        }

        public Builder prepaidUnits(LicenseUnitsDetail prepaidUnits) {
            this.prepaidUnits = prepaidUnits;
            this.changedFields = changedFields.add("prepaidUnits");
            return this;
        }

        public Builder servicePlans(List<ServicePlanInfo> servicePlans) {
            this.servicePlans = servicePlans;
            this.changedFields = changedFields.add("servicePlans");
            return this;
        }

        public Builder servicePlans(ServicePlanInfo... servicePlans) {
            return servicePlans(Arrays.asList(servicePlans));
        }

        public Builder servicePlansNextLink(String servicePlansNextLink) {
            this.servicePlansNextLink = servicePlansNextLink;
            this.changedFields = changedFields.add("servicePlans");
            return this;
        }

        public Builder skuId(String skuId) {
            this.skuId = skuId;
            this.changedFields = changedFields.add("skuId");
            return this;
        }

        public Builder skuPartNumber(String skuPartNumber) {
            this.skuPartNumber = skuPartNumber;
            this.changedFields = changedFields.add("skuPartNumber");
            return this;
        }

        public Builder appliesTo(String appliesTo) {
            this.appliesTo = appliesTo;
            this.changedFields = changedFields.add("appliesTo");
            return this;
        }

        public SubscribedSku build() {
            SubscribedSku _x = new SubscribedSku();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.subscribedSku";
            _x.id = id;
            _x.capabilityStatus = capabilityStatus;
            _x.consumedUnits = consumedUnits;
            _x.prepaidUnits = prepaidUnits;
            _x.servicePlans = servicePlans;
            _x.servicePlansNextLink = servicePlansNextLink;
            _x.skuId = skuId;
            _x.skuPartNumber = skuPartNumber;
            _x.appliesTo = appliesTo;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="capabilityStatus")
    @JsonIgnore
    public Optional<String> getCapabilityStatus() {
        return Optional.ofNullable(capabilityStatus);
    }

    public SubscribedSku withCapabilityStatus(String capabilityStatus) {
        SubscribedSku _x = _copy();
        _x.changedFields = changedFields.add("capabilityStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscribedSku");
        _x.capabilityStatus = capabilityStatus;
        return _x;
    }

    @Property(name="consumedUnits")
    @JsonIgnore
    public Optional<Integer> getConsumedUnits() {
        return Optional.ofNullable(consumedUnits);
    }

    public SubscribedSku withConsumedUnits(Integer consumedUnits) {
        SubscribedSku _x = _copy();
        _x.changedFields = changedFields.add("consumedUnits");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscribedSku");
        _x.consumedUnits = consumedUnits;
        return _x;
    }

    @Property(name="prepaidUnits")
    @JsonIgnore
    public Optional<LicenseUnitsDetail> getPrepaidUnits() {
        return Optional.ofNullable(prepaidUnits);
    }

    public SubscribedSku withPrepaidUnits(LicenseUnitsDetail prepaidUnits) {
        SubscribedSku _x = _copy();
        _x.changedFields = changedFields.add("prepaidUnits");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscribedSku");
        _x.prepaidUnits = prepaidUnits;
        return _x;
    }

    @Property(name="servicePlans")
    @JsonIgnore
    public CollectionPage<ServicePlanInfo> getServicePlans() {
        return new CollectionPage<ServicePlanInfo>(contextPath, ServicePlanInfo.class, servicePlans, Optional.ofNullable(servicePlansNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="servicePlans")
    @JsonIgnore
    public CollectionPage<ServicePlanInfo> getServicePlans(HttpRequestOptions options) {
        return new CollectionPage<ServicePlanInfo>(contextPath, ServicePlanInfo.class, servicePlans, Optional.ofNullable(servicePlansNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="skuId")
    @JsonIgnore
    public Optional<String> getSkuId() {
        return Optional.ofNullable(skuId);
    }

    public SubscribedSku withSkuId(String skuId) {
        SubscribedSku _x = _copy();
        _x.changedFields = changedFields.add("skuId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscribedSku");
        _x.skuId = skuId;
        return _x;
    }

    @Property(name="skuPartNumber")
    @JsonIgnore
    public Optional<String> getSkuPartNumber() {
        return Optional.ofNullable(skuPartNumber);
    }

    public SubscribedSku withSkuPartNumber(String skuPartNumber) {
        SubscribedSku _x = _copy();
        _x.changedFields = changedFields.add("skuPartNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscribedSku");
        _x.skuPartNumber = skuPartNumber;
        return _x;
    }

    @Property(name="appliesTo")
    @JsonIgnore
    public Optional<String> getAppliesTo() {
        return Optional.ofNullable(appliesTo);
    }

    public SubscribedSku withAppliesTo(String appliesTo) {
        SubscribedSku _x = _copy();
        _x.changedFields = changedFields.add("appliesTo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.subscribedSku");
        _x.appliesTo = appliesTo;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SubscribedSku patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SubscribedSku _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SubscribedSku put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SubscribedSku _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SubscribedSku _copy() {
        SubscribedSku _x = new SubscribedSku();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.capabilityStatus = capabilityStatus;
        _x.consumedUnits = consumedUnits;
        _x.prepaidUnits = prepaidUnits;
        _x.servicePlans = servicePlans;
        _x.skuId = skuId;
        _x.skuPartNumber = skuPartNumber;
        _x.appliesTo = appliesTo;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SubscribedSku[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("capabilityStatus=");
        b.append(this.capabilityStatus);
        b.append(", ");
        b.append("consumedUnits=");
        b.append(this.consumedUnits);
        b.append(", ");
        b.append("prepaidUnits=");
        b.append(this.prepaidUnits);
        b.append(", ");
        b.append("servicePlans=");
        b.append(this.servicePlans);
        b.append(", ");
        b.append("skuId=");
        b.append(this.skuId);
        b.append(", ");
        b.append("skuPartNumber=");
        b.append(this.skuPartNumber);
        b.append(", ");
        b.append("appliesTo=");
        b.append(this.appliesTo);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
