package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "definition", 
    "isOrganizationDefault"})
@JsonInclude(Include.NON_NULL)
public class StsPolicy extends PolicyBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.stsPolicy";
    }

    @JsonProperty("definition")
    protected List<String> definition;

    @JsonProperty("definition@nextLink")
    protected String definitionNextLink;

    @JsonProperty("isOrganizationDefault")
    protected Boolean isOrganizationDefault;

    protected StsPolicy() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="definition")
    @JsonIgnore
    public CollectionPage<String> getDefinition() {
        return new CollectionPage<String>(contextPath, String.class, definition, Optional.ofNullable(definitionNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="definition")
    @JsonIgnore
    public CollectionPage<String> getDefinition(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, definition, Optional.ofNullable(definitionNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="isOrganizationDefault")
    @JsonIgnore
    public Optional<Boolean> getIsOrganizationDefault() {
        return Optional.ofNullable(isOrganizationDefault);
    }

    public StsPolicy withIsOrganizationDefault(Boolean isOrganizationDefault) {
        StsPolicy _x = _copy();
        _x.changedFields = changedFields.add("isOrganizationDefault");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.stsPolicy");
        _x.isOrganizationDefault = isOrganizationDefault;
        return _x;
    }

    @NavigationProperty(name="appliesTo")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getAppliesTo() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("appliesTo"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public StsPolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        StsPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public StsPolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        StsPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private StsPolicy _copy() {
        StsPolicy _x = new StsPolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.deletedDateTime = deletedDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.definition = definition;
        _x.isOrganizationDefault = isOrganizationDefault;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("StsPolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deletedDateTime=");
        b.append(this.deletedDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("definition=");
        b.append(this.definition);
        b.append(", ");
        b.append("isOrganizationDefault=");
        b.append(this.isOrganizationDefault);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
