package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "im", 
    "audio", 
    "video", 
    "appSharing", 
    "fileTransfer", 
    "reportRefreshDate", 
    "reportDate", 
    "reportPeriod"})
@JsonInclude(Include.NON_NULL)
public class SkypeForBusinessPeerToPeerActivityCounts extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.skypeForBusinessPeerToPeerActivityCounts";
    }

    @JsonProperty("im")
    protected Long im;

    @JsonProperty("audio")
    protected Long audio;

    @JsonProperty("video")
    protected Long video;

    @JsonProperty("appSharing")
    protected Long appSharing;

    @JsonProperty("fileTransfer")
    protected Long fileTransfer;

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("reportDate")
    protected LocalDate reportDate;

    @JsonProperty("reportPeriod")
    protected String reportPeriod;

    protected SkypeForBusinessPeerToPeerActivityCounts() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSkypeForBusinessPeerToPeerActivityCounts() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Long im;
        private Long audio;
        private Long video;
        private Long appSharing;
        private Long fileTransfer;
        private LocalDate reportRefreshDate;
        private LocalDate reportDate;
        private String reportPeriod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder im(Long im) {
            this.im = im;
            this.changedFields = changedFields.add("im");
            return this;
        }

        public Builder audio(Long audio) {
            this.audio = audio;
            this.changedFields = changedFields.add("audio");
            return this;
        }

        public Builder video(Long video) {
            this.video = video;
            this.changedFields = changedFields.add("video");
            return this;
        }

        public Builder appSharing(Long appSharing) {
            this.appSharing = appSharing;
            this.changedFields = changedFields.add("appSharing");
            return this;
        }

        public Builder fileTransfer(Long fileTransfer) {
            this.fileTransfer = fileTransfer;
            this.changedFields = changedFields.add("fileTransfer");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder reportDate(LocalDate reportDate) {
            this.reportDate = reportDate;
            this.changedFields = changedFields.add("reportDate");
            return this;
        }

        public Builder reportPeriod(String reportPeriod) {
            this.reportPeriod = reportPeriod;
            this.changedFields = changedFields.add("reportPeriod");
            return this;
        }

        public SkypeForBusinessPeerToPeerActivityCounts build() {
            SkypeForBusinessPeerToPeerActivityCounts _x = new SkypeForBusinessPeerToPeerActivityCounts();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.skypeForBusinessPeerToPeerActivityCounts";
            _x.id = id;
            _x.im = im;
            _x.audio = audio;
            _x.video = video;
            _x.appSharing = appSharing;
            _x.fileTransfer = fileTransfer;
            _x.reportRefreshDate = reportRefreshDate;
            _x.reportDate = reportDate;
            _x.reportPeriod = reportPeriod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="im")
    @JsonIgnore
    public Optional<Long> getIm() {
        return Optional.ofNullable(im);
    }

    public SkypeForBusinessPeerToPeerActivityCounts withIm(Long im) {
        SkypeForBusinessPeerToPeerActivityCounts _x = _copy();
        _x.changedFields = changedFields.add("im");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessPeerToPeerActivityCounts");
        _x.im = im;
        return _x;
    }

    @Property(name="audio")
    @JsonIgnore
    public Optional<Long> getAudio() {
        return Optional.ofNullable(audio);
    }

    public SkypeForBusinessPeerToPeerActivityCounts withAudio(Long audio) {
        SkypeForBusinessPeerToPeerActivityCounts _x = _copy();
        _x.changedFields = changedFields.add("audio");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessPeerToPeerActivityCounts");
        _x.audio = audio;
        return _x;
    }

    @Property(name="video")
    @JsonIgnore
    public Optional<Long> getVideo() {
        return Optional.ofNullable(video);
    }

    public SkypeForBusinessPeerToPeerActivityCounts withVideo(Long video) {
        SkypeForBusinessPeerToPeerActivityCounts _x = _copy();
        _x.changedFields = changedFields.add("video");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessPeerToPeerActivityCounts");
        _x.video = video;
        return _x;
    }

    @Property(name="appSharing")
    @JsonIgnore
    public Optional<Long> getAppSharing() {
        return Optional.ofNullable(appSharing);
    }

    public SkypeForBusinessPeerToPeerActivityCounts withAppSharing(Long appSharing) {
        SkypeForBusinessPeerToPeerActivityCounts _x = _copy();
        _x.changedFields = changedFields.add("appSharing");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessPeerToPeerActivityCounts");
        _x.appSharing = appSharing;
        return _x;
    }

    @Property(name="fileTransfer")
    @JsonIgnore
    public Optional<Long> getFileTransfer() {
        return Optional.ofNullable(fileTransfer);
    }

    public SkypeForBusinessPeerToPeerActivityCounts withFileTransfer(Long fileTransfer) {
        SkypeForBusinessPeerToPeerActivityCounts _x = _copy();
        _x.changedFields = changedFields.add("fileTransfer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessPeerToPeerActivityCounts");
        _x.fileTransfer = fileTransfer;
        return _x;
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public SkypeForBusinessPeerToPeerActivityCounts withReportRefreshDate(LocalDate reportRefreshDate) {
        SkypeForBusinessPeerToPeerActivityCounts _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessPeerToPeerActivityCounts");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="reportDate")
    @JsonIgnore
    public Optional<LocalDate> getReportDate() {
        return Optional.ofNullable(reportDate);
    }

    public SkypeForBusinessPeerToPeerActivityCounts withReportDate(LocalDate reportDate) {
        SkypeForBusinessPeerToPeerActivityCounts _x = _copy();
        _x.changedFields = changedFields.add("reportDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessPeerToPeerActivityCounts");
        _x.reportDate = reportDate;
        return _x;
    }

    @Property(name="reportPeriod")
    @JsonIgnore
    public Optional<String> getReportPeriod() {
        return Optional.ofNullable(reportPeriod);
    }

    public SkypeForBusinessPeerToPeerActivityCounts withReportPeriod(String reportPeriod) {
        SkypeForBusinessPeerToPeerActivityCounts _x = _copy();
        _x.changedFields = changedFields.add("reportPeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessPeerToPeerActivityCounts");
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SkypeForBusinessPeerToPeerActivityCounts patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SkypeForBusinessPeerToPeerActivityCounts _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SkypeForBusinessPeerToPeerActivityCounts put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SkypeForBusinessPeerToPeerActivityCounts _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SkypeForBusinessPeerToPeerActivityCounts _copy() {
        SkypeForBusinessPeerToPeerActivityCounts _x = new SkypeForBusinessPeerToPeerActivityCounts();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.im = im;
        _x.audio = audio;
        _x.video = video;
        _x.appSharing = appSharing;
        _x.fileTransfer = fileTransfer;
        _x.reportRefreshDate = reportRefreshDate;
        _x.reportDate = reportDate;
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SkypeForBusinessPeerToPeerActivityCounts[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("im=");
        b.append(this.im);
        b.append(", ");
        b.append("audio=");
        b.append(this.audio);
        b.append(", ");
        b.append("video=");
        b.append(this.video);
        b.append(", ");
        b.append("appSharing=");
        b.append(this.appSharing);
        b.append(", ");
        b.append("fileTransfer=");
        b.append(this.fileTransfer);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("reportDate=");
        b.append(this.reportDate);
        b.append(", ");
        b.append("reportPeriod=");
        b.append(this.reportPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
