package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "im", 
    "audioVideo", 
    "appSharing", 
    "web", 
    "dialInOut3rdParty", 
    "dialInOutMicrosoft", 
    "reportRefreshDate", 
    "reportDate", 
    "reportPeriod"})
@JsonInclude(Include.NON_NULL)
public class SkypeForBusinessOrganizerActivityUserCounts extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.skypeForBusinessOrganizerActivityUserCounts";
    }

    @JsonProperty("im")
    protected Long im;

    @JsonProperty("audioVideo")
    protected Long audioVideo;

    @JsonProperty("appSharing")
    protected Long appSharing;

    @JsonProperty("web")
    protected Long web;

    @JsonProperty("dialInOut3rdParty")
    protected Long dialInOut3rdParty;

    @JsonProperty("dialInOutMicrosoft")
    protected Long dialInOutMicrosoft;

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("reportDate")
    protected LocalDate reportDate;

    @JsonProperty("reportPeriod")
    protected String reportPeriod;

    protected SkypeForBusinessOrganizerActivityUserCounts() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSkypeForBusinessOrganizerActivityUserCounts() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Long im;
        private Long audioVideo;
        private Long appSharing;
        private Long web;
        private Long dialInOut3rdParty;
        private Long dialInOutMicrosoft;
        private LocalDate reportRefreshDate;
        private LocalDate reportDate;
        private String reportPeriod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder im(Long im) {
            this.im = im;
            this.changedFields = changedFields.add("im");
            return this;
        }

        public Builder audioVideo(Long audioVideo) {
            this.audioVideo = audioVideo;
            this.changedFields = changedFields.add("audioVideo");
            return this;
        }

        public Builder appSharing(Long appSharing) {
            this.appSharing = appSharing;
            this.changedFields = changedFields.add("appSharing");
            return this;
        }

        public Builder web(Long web) {
            this.web = web;
            this.changedFields = changedFields.add("web");
            return this;
        }

        public Builder dialInOut3rdParty(Long dialInOut3rdParty) {
            this.dialInOut3rdParty = dialInOut3rdParty;
            this.changedFields = changedFields.add("dialInOut3rdParty");
            return this;
        }

        public Builder dialInOutMicrosoft(Long dialInOutMicrosoft) {
            this.dialInOutMicrosoft = dialInOutMicrosoft;
            this.changedFields = changedFields.add("dialInOutMicrosoft");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder reportDate(LocalDate reportDate) {
            this.reportDate = reportDate;
            this.changedFields = changedFields.add("reportDate");
            return this;
        }

        public Builder reportPeriod(String reportPeriod) {
            this.reportPeriod = reportPeriod;
            this.changedFields = changedFields.add("reportPeriod");
            return this;
        }

        public SkypeForBusinessOrganizerActivityUserCounts build() {
            SkypeForBusinessOrganizerActivityUserCounts _x = new SkypeForBusinessOrganizerActivityUserCounts();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.skypeForBusinessOrganizerActivityUserCounts";
            _x.id = id;
            _x.im = im;
            _x.audioVideo = audioVideo;
            _x.appSharing = appSharing;
            _x.web = web;
            _x.dialInOut3rdParty = dialInOut3rdParty;
            _x.dialInOutMicrosoft = dialInOutMicrosoft;
            _x.reportRefreshDate = reportRefreshDate;
            _x.reportDate = reportDate;
            _x.reportPeriod = reportPeriod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="im")
    @JsonIgnore
    public Optional<Long> getIm() {
        return Optional.ofNullable(im);
    }

    public SkypeForBusinessOrganizerActivityUserCounts withIm(Long im) {
        SkypeForBusinessOrganizerActivityUserCounts _x = _copy();
        _x.changedFields = changedFields.add("im");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessOrganizerActivityUserCounts");
        _x.im = im;
        return _x;
    }

    @Property(name="audioVideo")
    @JsonIgnore
    public Optional<Long> getAudioVideo() {
        return Optional.ofNullable(audioVideo);
    }

    public SkypeForBusinessOrganizerActivityUserCounts withAudioVideo(Long audioVideo) {
        SkypeForBusinessOrganizerActivityUserCounts _x = _copy();
        _x.changedFields = changedFields.add("audioVideo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessOrganizerActivityUserCounts");
        _x.audioVideo = audioVideo;
        return _x;
    }

    @Property(name="appSharing")
    @JsonIgnore
    public Optional<Long> getAppSharing() {
        return Optional.ofNullable(appSharing);
    }

    public SkypeForBusinessOrganizerActivityUserCounts withAppSharing(Long appSharing) {
        SkypeForBusinessOrganizerActivityUserCounts _x = _copy();
        _x.changedFields = changedFields.add("appSharing");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessOrganizerActivityUserCounts");
        _x.appSharing = appSharing;
        return _x;
    }

    @Property(name="web")
    @JsonIgnore
    public Optional<Long> getWeb() {
        return Optional.ofNullable(web);
    }

    public SkypeForBusinessOrganizerActivityUserCounts withWeb(Long web) {
        SkypeForBusinessOrganizerActivityUserCounts _x = _copy();
        _x.changedFields = changedFields.add("web");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessOrganizerActivityUserCounts");
        _x.web = web;
        return _x;
    }

    @Property(name="dialInOut3rdParty")
    @JsonIgnore
    public Optional<Long> getDialInOut3rdParty() {
        return Optional.ofNullable(dialInOut3rdParty);
    }

    public SkypeForBusinessOrganizerActivityUserCounts withDialInOut3rdParty(Long dialInOut3rdParty) {
        SkypeForBusinessOrganizerActivityUserCounts _x = _copy();
        _x.changedFields = changedFields.add("dialInOut3rdParty");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessOrganizerActivityUserCounts");
        _x.dialInOut3rdParty = dialInOut3rdParty;
        return _x;
    }

    @Property(name="dialInOutMicrosoft")
    @JsonIgnore
    public Optional<Long> getDialInOutMicrosoft() {
        return Optional.ofNullable(dialInOutMicrosoft);
    }

    public SkypeForBusinessOrganizerActivityUserCounts withDialInOutMicrosoft(Long dialInOutMicrosoft) {
        SkypeForBusinessOrganizerActivityUserCounts _x = _copy();
        _x.changedFields = changedFields.add("dialInOutMicrosoft");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessOrganizerActivityUserCounts");
        _x.dialInOutMicrosoft = dialInOutMicrosoft;
        return _x;
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public SkypeForBusinessOrganizerActivityUserCounts withReportRefreshDate(LocalDate reportRefreshDate) {
        SkypeForBusinessOrganizerActivityUserCounts _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessOrganizerActivityUserCounts");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="reportDate")
    @JsonIgnore
    public Optional<LocalDate> getReportDate() {
        return Optional.ofNullable(reportDate);
    }

    public SkypeForBusinessOrganizerActivityUserCounts withReportDate(LocalDate reportDate) {
        SkypeForBusinessOrganizerActivityUserCounts _x = _copy();
        _x.changedFields = changedFields.add("reportDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessOrganizerActivityUserCounts");
        _x.reportDate = reportDate;
        return _x;
    }

    @Property(name="reportPeriod")
    @JsonIgnore
    public Optional<String> getReportPeriod() {
        return Optional.ofNullable(reportPeriod);
    }

    public SkypeForBusinessOrganizerActivityUserCounts withReportPeriod(String reportPeriod) {
        SkypeForBusinessOrganizerActivityUserCounts _x = _copy();
        _x.changedFields = changedFields.add("reportPeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessOrganizerActivityUserCounts");
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SkypeForBusinessOrganizerActivityUserCounts patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SkypeForBusinessOrganizerActivityUserCounts _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SkypeForBusinessOrganizerActivityUserCounts put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SkypeForBusinessOrganizerActivityUserCounts _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SkypeForBusinessOrganizerActivityUserCounts _copy() {
        SkypeForBusinessOrganizerActivityUserCounts _x = new SkypeForBusinessOrganizerActivityUserCounts();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.im = im;
        _x.audioVideo = audioVideo;
        _x.appSharing = appSharing;
        _x.web = web;
        _x.dialInOut3rdParty = dialInOut3rdParty;
        _x.dialInOutMicrosoft = dialInOutMicrosoft;
        _x.reportRefreshDate = reportRefreshDate;
        _x.reportDate = reportDate;
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SkypeForBusinessOrganizerActivityUserCounts[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("im=");
        b.append(this.im);
        b.append(", ");
        b.append("audioVideo=");
        b.append(this.audioVideo);
        b.append(", ");
        b.append("appSharing=");
        b.append(this.appSharing);
        b.append(", ");
        b.append("web=");
        b.append(this.web);
        b.append(", ");
        b.append("dialInOut3rdParty=");
        b.append(this.dialInOut3rdParty);
        b.append(", ");
        b.append("dialInOutMicrosoft=");
        b.append(this.dialInOutMicrosoft);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("reportDate=");
        b.append(this.reportDate);
        b.append(", ");
        b.append("reportPeriod=");
        b.append(this.reportPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
