package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "reportRefreshDate", 
    "userPrincipalName", 
    "lastActivityDate", 
    "usedWindows", 
    "usedWindowsPhone", 
    "usedAndroidPhone", 
    "usediPhone", 
    "usediPad", 
    "reportPeriod"})
@JsonInclude(Include.NON_NULL)
public class SkypeForBusinessDeviceUsageUserDetail extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.skypeForBusinessDeviceUsageUserDetail";
    }

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("lastActivityDate")
    protected LocalDate lastActivityDate;

    @JsonProperty("usedWindows")
    protected Boolean usedWindows;

    @JsonProperty("usedWindowsPhone")
    protected Boolean usedWindowsPhone;

    @JsonProperty("usedAndroidPhone")
    protected Boolean usedAndroidPhone;

    @JsonProperty("usediPhone")
    protected Boolean usediPhone;

    @JsonProperty("usediPad")
    protected Boolean usediPad;

    @JsonProperty("reportPeriod")
    protected String reportPeriod;

    protected SkypeForBusinessDeviceUsageUserDetail() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSkypeForBusinessDeviceUsageUserDetail() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private LocalDate reportRefreshDate;
        private String userPrincipalName;
        private LocalDate lastActivityDate;
        private Boolean usedWindows;
        private Boolean usedWindowsPhone;
        private Boolean usedAndroidPhone;
        private Boolean usediPhone;
        private Boolean usediPad;
        private String reportPeriod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public Builder lastActivityDate(LocalDate lastActivityDate) {
            this.lastActivityDate = lastActivityDate;
            this.changedFields = changedFields.add("lastActivityDate");
            return this;
        }

        public Builder usedWindows(Boolean usedWindows) {
            this.usedWindows = usedWindows;
            this.changedFields = changedFields.add("usedWindows");
            return this;
        }

        public Builder usedWindowsPhone(Boolean usedWindowsPhone) {
            this.usedWindowsPhone = usedWindowsPhone;
            this.changedFields = changedFields.add("usedWindowsPhone");
            return this;
        }

        public Builder usedAndroidPhone(Boolean usedAndroidPhone) {
            this.usedAndroidPhone = usedAndroidPhone;
            this.changedFields = changedFields.add("usedAndroidPhone");
            return this;
        }

        public Builder usediPhone(Boolean usediPhone) {
            this.usediPhone = usediPhone;
            this.changedFields = changedFields.add("usediPhone");
            return this;
        }

        public Builder usediPad(Boolean usediPad) {
            this.usediPad = usediPad;
            this.changedFields = changedFields.add("usediPad");
            return this;
        }

        public Builder reportPeriod(String reportPeriod) {
            this.reportPeriod = reportPeriod;
            this.changedFields = changedFields.add("reportPeriod");
            return this;
        }

        public SkypeForBusinessDeviceUsageUserDetail build() {
            SkypeForBusinessDeviceUsageUserDetail _x = new SkypeForBusinessDeviceUsageUserDetail();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.skypeForBusinessDeviceUsageUserDetail";
            _x.id = id;
            _x.reportRefreshDate = reportRefreshDate;
            _x.userPrincipalName = userPrincipalName;
            _x.lastActivityDate = lastActivityDate;
            _x.usedWindows = usedWindows;
            _x.usedWindowsPhone = usedWindowsPhone;
            _x.usedAndroidPhone = usedAndroidPhone;
            _x.usediPhone = usediPhone;
            _x.usediPad = usediPad;
            _x.reportPeriod = reportPeriod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public SkypeForBusinessDeviceUsageUserDetail withReportRefreshDate(LocalDate reportRefreshDate) {
        SkypeForBusinessDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessDeviceUsageUserDetail");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public SkypeForBusinessDeviceUsageUserDetail withUserPrincipalName(String userPrincipalName) {
        SkypeForBusinessDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessDeviceUsageUserDetail");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Property(name="lastActivityDate")
    @JsonIgnore
    public Optional<LocalDate> getLastActivityDate() {
        return Optional.ofNullable(lastActivityDate);
    }

    public SkypeForBusinessDeviceUsageUserDetail withLastActivityDate(LocalDate lastActivityDate) {
        SkypeForBusinessDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("lastActivityDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessDeviceUsageUserDetail");
        _x.lastActivityDate = lastActivityDate;
        return _x;
    }

    @Property(name="usedWindows")
    @JsonIgnore
    public Optional<Boolean> getUsedWindows() {
        return Optional.ofNullable(usedWindows);
    }

    public SkypeForBusinessDeviceUsageUserDetail withUsedWindows(Boolean usedWindows) {
        SkypeForBusinessDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("usedWindows");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessDeviceUsageUserDetail");
        _x.usedWindows = usedWindows;
        return _x;
    }

    @Property(name="usedWindowsPhone")
    @JsonIgnore
    public Optional<Boolean> getUsedWindowsPhone() {
        return Optional.ofNullable(usedWindowsPhone);
    }

    public SkypeForBusinessDeviceUsageUserDetail withUsedWindowsPhone(Boolean usedWindowsPhone) {
        SkypeForBusinessDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("usedWindowsPhone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessDeviceUsageUserDetail");
        _x.usedWindowsPhone = usedWindowsPhone;
        return _x;
    }

    @Property(name="usedAndroidPhone")
    @JsonIgnore
    public Optional<Boolean> getUsedAndroidPhone() {
        return Optional.ofNullable(usedAndroidPhone);
    }

    public SkypeForBusinessDeviceUsageUserDetail withUsedAndroidPhone(Boolean usedAndroidPhone) {
        SkypeForBusinessDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("usedAndroidPhone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessDeviceUsageUserDetail");
        _x.usedAndroidPhone = usedAndroidPhone;
        return _x;
    }

    @Property(name="usediPhone")
    @JsonIgnore
    public Optional<Boolean> getUsediPhone() {
        return Optional.ofNullable(usediPhone);
    }

    public SkypeForBusinessDeviceUsageUserDetail withUsediPhone(Boolean usediPhone) {
        SkypeForBusinessDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("usediPhone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessDeviceUsageUserDetail");
        _x.usediPhone = usediPhone;
        return _x;
    }

    @Property(name="usediPad")
    @JsonIgnore
    public Optional<Boolean> getUsediPad() {
        return Optional.ofNullable(usediPad);
    }

    public SkypeForBusinessDeviceUsageUserDetail withUsediPad(Boolean usediPad) {
        SkypeForBusinessDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("usediPad");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessDeviceUsageUserDetail");
        _x.usediPad = usediPad;
        return _x;
    }

    @Property(name="reportPeriod")
    @JsonIgnore
    public Optional<String> getReportPeriod() {
        return Optional.ofNullable(reportPeriod);
    }

    public SkypeForBusinessDeviceUsageUserDetail withReportPeriod(String reportPeriod) {
        SkypeForBusinessDeviceUsageUserDetail _x = _copy();
        _x.changedFields = changedFields.add("reportPeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessDeviceUsageUserDetail");
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SkypeForBusinessDeviceUsageUserDetail patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SkypeForBusinessDeviceUsageUserDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SkypeForBusinessDeviceUsageUserDetail put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SkypeForBusinessDeviceUsageUserDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SkypeForBusinessDeviceUsageUserDetail _copy() {
        SkypeForBusinessDeviceUsageUserDetail _x = new SkypeForBusinessDeviceUsageUserDetail();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reportRefreshDate = reportRefreshDate;
        _x.userPrincipalName = userPrincipalName;
        _x.lastActivityDate = lastActivityDate;
        _x.usedWindows = usedWindows;
        _x.usedWindowsPhone = usedWindowsPhone;
        _x.usedAndroidPhone = usedAndroidPhone;
        _x.usediPhone = usediPhone;
        _x.usediPad = usediPad;
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SkypeForBusinessDeviceUsageUserDetail[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("lastActivityDate=");
        b.append(this.lastActivityDate);
        b.append(", ");
        b.append("usedWindows=");
        b.append(this.usedWindows);
        b.append(", ");
        b.append("usedWindowsPhone=");
        b.append(this.usedWindowsPhone);
        b.append(", ");
        b.append("usedAndroidPhone=");
        b.append(this.usedAndroidPhone);
        b.append(", ");
        b.append("usediPhone=");
        b.append(this.usediPhone);
        b.append(", ");
        b.append("usediPad=");
        b.append(this.usediPad);
        b.append(", ");
        b.append("reportPeriod=");
        b.append(this.reportPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
