package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "reportRefreshDate", 
    "windows", 
    "windowsPhone", 
    "androidPhone", 
    "iPhone", 
    "iPad", 
    "reportDate", 
    "reportPeriod"})
@JsonInclude(Include.NON_NULL)
public class SkypeForBusinessDeviceUsageUserCounts extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.skypeForBusinessDeviceUsageUserCounts";
    }

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("windows")
    protected Integer windows;

    @JsonProperty("windowsPhone")
    protected Integer windowsPhone;

    @JsonProperty("androidPhone")
    protected Integer androidPhone;

    @JsonProperty("iPhone")
    protected Integer iPhone;

    @JsonProperty("iPad")
    protected Integer iPad;

    @JsonProperty("reportDate")
    protected LocalDate reportDate;

    @JsonProperty("reportPeriod")
    protected String reportPeriod;

    protected SkypeForBusinessDeviceUsageUserCounts() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSkypeForBusinessDeviceUsageUserCounts() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private LocalDate reportRefreshDate;
        private Integer windows;
        private Integer windowsPhone;
        private Integer androidPhone;
        private Integer iPhone;
        private Integer iPad;
        private LocalDate reportDate;
        private String reportPeriod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder windows(Integer windows) {
            this.windows = windows;
            this.changedFields = changedFields.add("windows");
            return this;
        }

        public Builder windowsPhone(Integer windowsPhone) {
            this.windowsPhone = windowsPhone;
            this.changedFields = changedFields.add("windowsPhone");
            return this;
        }

        public Builder androidPhone(Integer androidPhone) {
            this.androidPhone = androidPhone;
            this.changedFields = changedFields.add("androidPhone");
            return this;
        }

        public Builder iPhone(Integer iPhone) {
            this.iPhone = iPhone;
            this.changedFields = changedFields.add("iPhone");
            return this;
        }

        public Builder iPad(Integer iPad) {
            this.iPad = iPad;
            this.changedFields = changedFields.add("iPad");
            return this;
        }

        public Builder reportDate(LocalDate reportDate) {
            this.reportDate = reportDate;
            this.changedFields = changedFields.add("reportDate");
            return this;
        }

        public Builder reportPeriod(String reportPeriod) {
            this.reportPeriod = reportPeriod;
            this.changedFields = changedFields.add("reportPeriod");
            return this;
        }

        public SkypeForBusinessDeviceUsageUserCounts build() {
            SkypeForBusinessDeviceUsageUserCounts _x = new SkypeForBusinessDeviceUsageUserCounts();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.skypeForBusinessDeviceUsageUserCounts";
            _x.id = id;
            _x.reportRefreshDate = reportRefreshDate;
            _x.windows = windows;
            _x.windowsPhone = windowsPhone;
            _x.androidPhone = androidPhone;
            _x.iPhone = iPhone;
            _x.iPad = iPad;
            _x.reportDate = reportDate;
            _x.reportPeriod = reportPeriod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public SkypeForBusinessDeviceUsageUserCounts withReportRefreshDate(LocalDate reportRefreshDate) {
        SkypeForBusinessDeviceUsageUserCounts _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessDeviceUsageUserCounts");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="windows")
    @JsonIgnore
    public Optional<Integer> getWindows() {
        return Optional.ofNullable(windows);
    }

    public SkypeForBusinessDeviceUsageUserCounts withWindows(Integer windows) {
        SkypeForBusinessDeviceUsageUserCounts _x = _copy();
        _x.changedFields = changedFields.add("windows");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessDeviceUsageUserCounts");
        _x.windows = windows;
        return _x;
    }

    @Property(name="windowsPhone")
    @JsonIgnore
    public Optional<Integer> getWindowsPhone() {
        return Optional.ofNullable(windowsPhone);
    }

    public SkypeForBusinessDeviceUsageUserCounts withWindowsPhone(Integer windowsPhone) {
        SkypeForBusinessDeviceUsageUserCounts _x = _copy();
        _x.changedFields = changedFields.add("windowsPhone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessDeviceUsageUserCounts");
        _x.windowsPhone = windowsPhone;
        return _x;
    }

    @Property(name="androidPhone")
    @JsonIgnore
    public Optional<Integer> getAndroidPhone() {
        return Optional.ofNullable(androidPhone);
    }

    public SkypeForBusinessDeviceUsageUserCounts withAndroidPhone(Integer androidPhone) {
        SkypeForBusinessDeviceUsageUserCounts _x = _copy();
        _x.changedFields = changedFields.add("androidPhone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessDeviceUsageUserCounts");
        _x.androidPhone = androidPhone;
        return _x;
    }

    @Property(name="iPhone")
    @JsonIgnore
    public Optional<Integer> getIPhone() {
        return Optional.ofNullable(iPhone);
    }

    public SkypeForBusinessDeviceUsageUserCounts withIPhone(Integer iPhone) {
        SkypeForBusinessDeviceUsageUserCounts _x = _copy();
        _x.changedFields = changedFields.add("iPhone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessDeviceUsageUserCounts");
        _x.iPhone = iPhone;
        return _x;
    }

    @Property(name="iPad")
    @JsonIgnore
    public Optional<Integer> getIPad() {
        return Optional.ofNullable(iPad);
    }

    public SkypeForBusinessDeviceUsageUserCounts withIPad(Integer iPad) {
        SkypeForBusinessDeviceUsageUserCounts _x = _copy();
        _x.changedFields = changedFields.add("iPad");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessDeviceUsageUserCounts");
        _x.iPad = iPad;
        return _x;
    }

    @Property(name="reportDate")
    @JsonIgnore
    public Optional<LocalDate> getReportDate() {
        return Optional.ofNullable(reportDate);
    }

    public SkypeForBusinessDeviceUsageUserCounts withReportDate(LocalDate reportDate) {
        SkypeForBusinessDeviceUsageUserCounts _x = _copy();
        _x.changedFields = changedFields.add("reportDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessDeviceUsageUserCounts");
        _x.reportDate = reportDate;
        return _x;
    }

    @Property(name="reportPeriod")
    @JsonIgnore
    public Optional<String> getReportPeriod() {
        return Optional.ofNullable(reportPeriod);
    }

    public SkypeForBusinessDeviceUsageUserCounts withReportPeriod(String reportPeriod) {
        SkypeForBusinessDeviceUsageUserCounts _x = _copy();
        _x.changedFields = changedFields.add("reportPeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessDeviceUsageUserCounts");
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SkypeForBusinessDeviceUsageUserCounts patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SkypeForBusinessDeviceUsageUserCounts _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SkypeForBusinessDeviceUsageUserCounts put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SkypeForBusinessDeviceUsageUserCounts _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SkypeForBusinessDeviceUsageUserCounts _copy() {
        SkypeForBusinessDeviceUsageUserCounts _x = new SkypeForBusinessDeviceUsageUserCounts();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reportRefreshDate = reportRefreshDate;
        _x.windows = windows;
        _x.windowsPhone = windowsPhone;
        _x.androidPhone = androidPhone;
        _x.iPhone = iPhone;
        _x.iPad = iPad;
        _x.reportDate = reportDate;
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SkypeForBusinessDeviceUsageUserCounts[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("windows=");
        b.append(this.windows);
        b.append(", ");
        b.append("windowsPhone=");
        b.append(this.windowsPhone);
        b.append(", ");
        b.append("androidPhone=");
        b.append(this.androidPhone);
        b.append(", ");
        b.append("iPhone=");
        b.append(this.iPhone);
        b.append(", ");
        b.append("iPad=");
        b.append(this.iPad);
        b.append(", ");
        b.append("reportDate=");
        b.append(this.reportDate);
        b.append(", ");
        b.append("reportPeriod=");
        b.append(this.reportPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
