package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "totalPeerToPeerSessionCount", 
    "totalOrganizedConferenceCount", 
    "totalParticipatedConferenceCount", 
    "peerToPeerLastActivityDate", 
    "organizedConferenceLastActivityDate", 
    "participatedConferenceLastActivityDate", 
    "peerToPeerIMCount", 
    "peerToPeerAudioCount", 
    "peerToPeerAudioMinutes", 
    "peerToPeerVideoCount", 
    "peerToPeerVideoMinutes", 
    "peerToPeerAppSharingCount", 
    "peerToPeerFileTransferCount", 
    "organizedConferenceIMCount", 
    "organizedConferenceAudioVideoCount", 
    "organizedConferenceAudioVideoMinutes", 
    "organizedConferenceAppSharingCount", 
    "organizedConferenceWebCount", 
    "organizedConferenceDialInOut3rdPartyCount", 
    "organizedConferenceCloudDialInOutMicrosoftCount", 
    "organizedConferenceCloudDialInMicrosoftMinutes", 
    "organizedConferenceCloudDialOutMicrosoftMinutes", 
    "participatedConferenceIMCount", 
    "participatedConferenceAudioVideoCount", 
    "participatedConferenceAudioVideoMinutes", 
    "participatedConferenceAppSharingCount", 
    "participatedConferenceWebCount", 
    "participatedConferenceDialInOut3rdPartyCount", 
    "reportRefreshDate", 
    "userPrincipalName", 
    "isDeleted", 
    "deletedDate", 
    "lastActivityDate", 
    "assignedProducts", 
    "reportPeriod"})
@JsonInclude(Include.NON_NULL)
public class SkypeForBusinessActivityUserDetail extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.skypeForBusinessActivityUserDetail";
    }

    @JsonProperty("totalPeerToPeerSessionCount")
    protected Long totalPeerToPeerSessionCount;

    @JsonProperty("totalOrganizedConferenceCount")
    protected Long totalOrganizedConferenceCount;

    @JsonProperty("totalParticipatedConferenceCount")
    protected Long totalParticipatedConferenceCount;

    @JsonProperty("peerToPeerLastActivityDate")
    protected LocalDate peerToPeerLastActivityDate;

    @JsonProperty("organizedConferenceLastActivityDate")
    protected LocalDate organizedConferenceLastActivityDate;

    @JsonProperty("participatedConferenceLastActivityDate")
    protected LocalDate participatedConferenceLastActivityDate;

    @JsonProperty("peerToPeerIMCount")
    protected Long peerToPeerIMCount;

    @JsonProperty("peerToPeerAudioCount")
    protected Long peerToPeerAudioCount;

    @JsonProperty("peerToPeerAudioMinutes")
    protected Long peerToPeerAudioMinutes;

    @JsonProperty("peerToPeerVideoCount")
    protected Long peerToPeerVideoCount;

    @JsonProperty("peerToPeerVideoMinutes")
    protected Long peerToPeerVideoMinutes;

    @JsonProperty("peerToPeerAppSharingCount")
    protected Long peerToPeerAppSharingCount;

    @JsonProperty("peerToPeerFileTransferCount")
    protected Long peerToPeerFileTransferCount;

    @JsonProperty("organizedConferenceIMCount")
    protected Long organizedConferenceIMCount;

    @JsonProperty("organizedConferenceAudioVideoCount")
    protected Long organizedConferenceAudioVideoCount;

    @JsonProperty("organizedConferenceAudioVideoMinutes")
    protected Long organizedConferenceAudioVideoMinutes;

    @JsonProperty("organizedConferenceAppSharingCount")
    protected Long organizedConferenceAppSharingCount;

    @JsonProperty("organizedConferenceWebCount")
    protected Long organizedConferenceWebCount;

    @JsonProperty("organizedConferenceDialInOut3rdPartyCount")
    protected Long organizedConferenceDialInOut3rdPartyCount;

    @JsonProperty("organizedConferenceCloudDialInOutMicrosoftCount")
    protected Long organizedConferenceCloudDialInOutMicrosoftCount;

    @JsonProperty("organizedConferenceCloudDialInMicrosoftMinutes")
    protected Long organizedConferenceCloudDialInMicrosoftMinutes;

    @JsonProperty("organizedConferenceCloudDialOutMicrosoftMinutes")
    protected Long organizedConferenceCloudDialOutMicrosoftMinutes;

    @JsonProperty("participatedConferenceIMCount")
    protected Long participatedConferenceIMCount;

    @JsonProperty("participatedConferenceAudioVideoCount")
    protected Long participatedConferenceAudioVideoCount;

    @JsonProperty("participatedConferenceAudioVideoMinutes")
    protected Long participatedConferenceAudioVideoMinutes;

    @JsonProperty("participatedConferenceAppSharingCount")
    protected Long participatedConferenceAppSharingCount;

    @JsonProperty("participatedConferenceWebCount")
    protected Long participatedConferenceWebCount;

    @JsonProperty("participatedConferenceDialInOut3rdPartyCount")
    protected Long participatedConferenceDialInOut3rdPartyCount;

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("isDeleted")
    protected Boolean isDeleted;

    @JsonProperty("deletedDate")
    protected LocalDate deletedDate;

    @JsonProperty("lastActivityDate")
    protected LocalDate lastActivityDate;

    @JsonProperty("assignedProducts")
    protected List<String> assignedProducts;

    @JsonProperty("assignedProducts@nextLink")
    protected String assignedProductsNextLink;

    @JsonProperty("reportPeriod")
    protected String reportPeriod;

    protected SkypeForBusinessActivityUserDetail() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSkypeForBusinessActivityUserDetail() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Long totalPeerToPeerSessionCount;
        private Long totalOrganizedConferenceCount;
        private Long totalParticipatedConferenceCount;
        private LocalDate peerToPeerLastActivityDate;
        private LocalDate organizedConferenceLastActivityDate;
        private LocalDate participatedConferenceLastActivityDate;
        private Long peerToPeerIMCount;
        private Long peerToPeerAudioCount;
        private Long peerToPeerAudioMinutes;
        private Long peerToPeerVideoCount;
        private Long peerToPeerVideoMinutes;
        private Long peerToPeerAppSharingCount;
        private Long peerToPeerFileTransferCount;
        private Long organizedConferenceIMCount;
        private Long organizedConferenceAudioVideoCount;
        private Long organizedConferenceAudioVideoMinutes;
        private Long organizedConferenceAppSharingCount;
        private Long organizedConferenceWebCount;
        private Long organizedConferenceDialInOut3rdPartyCount;
        private Long organizedConferenceCloudDialInOutMicrosoftCount;
        private Long organizedConferenceCloudDialInMicrosoftMinutes;
        private Long organizedConferenceCloudDialOutMicrosoftMinutes;
        private Long participatedConferenceIMCount;
        private Long participatedConferenceAudioVideoCount;
        private Long participatedConferenceAudioVideoMinutes;
        private Long participatedConferenceAppSharingCount;
        private Long participatedConferenceWebCount;
        private Long participatedConferenceDialInOut3rdPartyCount;
        private LocalDate reportRefreshDate;
        private String userPrincipalName;
        private Boolean isDeleted;
        private LocalDate deletedDate;
        private LocalDate lastActivityDate;
        private List<String> assignedProducts;
        private String assignedProductsNextLink;
        private String reportPeriod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder totalPeerToPeerSessionCount(Long totalPeerToPeerSessionCount) {
            this.totalPeerToPeerSessionCount = totalPeerToPeerSessionCount;
            this.changedFields = changedFields.add("totalPeerToPeerSessionCount");
            return this;
        }

        public Builder totalOrganizedConferenceCount(Long totalOrganizedConferenceCount) {
            this.totalOrganizedConferenceCount = totalOrganizedConferenceCount;
            this.changedFields = changedFields.add("totalOrganizedConferenceCount");
            return this;
        }

        public Builder totalParticipatedConferenceCount(Long totalParticipatedConferenceCount) {
            this.totalParticipatedConferenceCount = totalParticipatedConferenceCount;
            this.changedFields = changedFields.add("totalParticipatedConferenceCount");
            return this;
        }

        public Builder peerToPeerLastActivityDate(LocalDate peerToPeerLastActivityDate) {
            this.peerToPeerLastActivityDate = peerToPeerLastActivityDate;
            this.changedFields = changedFields.add("peerToPeerLastActivityDate");
            return this;
        }

        public Builder organizedConferenceLastActivityDate(LocalDate organizedConferenceLastActivityDate) {
            this.organizedConferenceLastActivityDate = organizedConferenceLastActivityDate;
            this.changedFields = changedFields.add("organizedConferenceLastActivityDate");
            return this;
        }

        public Builder participatedConferenceLastActivityDate(LocalDate participatedConferenceLastActivityDate) {
            this.participatedConferenceLastActivityDate = participatedConferenceLastActivityDate;
            this.changedFields = changedFields.add("participatedConferenceLastActivityDate");
            return this;
        }

        public Builder peerToPeerIMCount(Long peerToPeerIMCount) {
            this.peerToPeerIMCount = peerToPeerIMCount;
            this.changedFields = changedFields.add("peerToPeerIMCount");
            return this;
        }

        public Builder peerToPeerAudioCount(Long peerToPeerAudioCount) {
            this.peerToPeerAudioCount = peerToPeerAudioCount;
            this.changedFields = changedFields.add("peerToPeerAudioCount");
            return this;
        }

        public Builder peerToPeerAudioMinutes(Long peerToPeerAudioMinutes) {
            this.peerToPeerAudioMinutes = peerToPeerAudioMinutes;
            this.changedFields = changedFields.add("peerToPeerAudioMinutes");
            return this;
        }

        public Builder peerToPeerVideoCount(Long peerToPeerVideoCount) {
            this.peerToPeerVideoCount = peerToPeerVideoCount;
            this.changedFields = changedFields.add("peerToPeerVideoCount");
            return this;
        }

        public Builder peerToPeerVideoMinutes(Long peerToPeerVideoMinutes) {
            this.peerToPeerVideoMinutes = peerToPeerVideoMinutes;
            this.changedFields = changedFields.add("peerToPeerVideoMinutes");
            return this;
        }

        public Builder peerToPeerAppSharingCount(Long peerToPeerAppSharingCount) {
            this.peerToPeerAppSharingCount = peerToPeerAppSharingCount;
            this.changedFields = changedFields.add("peerToPeerAppSharingCount");
            return this;
        }

        public Builder peerToPeerFileTransferCount(Long peerToPeerFileTransferCount) {
            this.peerToPeerFileTransferCount = peerToPeerFileTransferCount;
            this.changedFields = changedFields.add("peerToPeerFileTransferCount");
            return this;
        }

        public Builder organizedConferenceIMCount(Long organizedConferenceIMCount) {
            this.organizedConferenceIMCount = organizedConferenceIMCount;
            this.changedFields = changedFields.add("organizedConferenceIMCount");
            return this;
        }

        public Builder organizedConferenceAudioVideoCount(Long organizedConferenceAudioVideoCount) {
            this.organizedConferenceAudioVideoCount = organizedConferenceAudioVideoCount;
            this.changedFields = changedFields.add("organizedConferenceAudioVideoCount");
            return this;
        }

        public Builder organizedConferenceAudioVideoMinutes(Long organizedConferenceAudioVideoMinutes) {
            this.organizedConferenceAudioVideoMinutes = organizedConferenceAudioVideoMinutes;
            this.changedFields = changedFields.add("organizedConferenceAudioVideoMinutes");
            return this;
        }

        public Builder organizedConferenceAppSharingCount(Long organizedConferenceAppSharingCount) {
            this.organizedConferenceAppSharingCount = organizedConferenceAppSharingCount;
            this.changedFields = changedFields.add("organizedConferenceAppSharingCount");
            return this;
        }

        public Builder organizedConferenceWebCount(Long organizedConferenceWebCount) {
            this.organizedConferenceWebCount = organizedConferenceWebCount;
            this.changedFields = changedFields.add("organizedConferenceWebCount");
            return this;
        }

        public Builder organizedConferenceDialInOut3rdPartyCount(Long organizedConferenceDialInOut3rdPartyCount) {
            this.organizedConferenceDialInOut3rdPartyCount = organizedConferenceDialInOut3rdPartyCount;
            this.changedFields = changedFields.add("organizedConferenceDialInOut3rdPartyCount");
            return this;
        }

        public Builder organizedConferenceCloudDialInOutMicrosoftCount(Long organizedConferenceCloudDialInOutMicrosoftCount) {
            this.organizedConferenceCloudDialInOutMicrosoftCount = organizedConferenceCloudDialInOutMicrosoftCount;
            this.changedFields = changedFields.add("organizedConferenceCloudDialInOutMicrosoftCount");
            return this;
        }

        public Builder organizedConferenceCloudDialInMicrosoftMinutes(Long organizedConferenceCloudDialInMicrosoftMinutes) {
            this.organizedConferenceCloudDialInMicrosoftMinutes = organizedConferenceCloudDialInMicrosoftMinutes;
            this.changedFields = changedFields.add("organizedConferenceCloudDialInMicrosoftMinutes");
            return this;
        }

        public Builder organizedConferenceCloudDialOutMicrosoftMinutes(Long organizedConferenceCloudDialOutMicrosoftMinutes) {
            this.organizedConferenceCloudDialOutMicrosoftMinutes = organizedConferenceCloudDialOutMicrosoftMinutes;
            this.changedFields = changedFields.add("organizedConferenceCloudDialOutMicrosoftMinutes");
            return this;
        }

        public Builder participatedConferenceIMCount(Long participatedConferenceIMCount) {
            this.participatedConferenceIMCount = participatedConferenceIMCount;
            this.changedFields = changedFields.add("participatedConferenceIMCount");
            return this;
        }

        public Builder participatedConferenceAudioVideoCount(Long participatedConferenceAudioVideoCount) {
            this.participatedConferenceAudioVideoCount = participatedConferenceAudioVideoCount;
            this.changedFields = changedFields.add("participatedConferenceAudioVideoCount");
            return this;
        }

        public Builder participatedConferenceAudioVideoMinutes(Long participatedConferenceAudioVideoMinutes) {
            this.participatedConferenceAudioVideoMinutes = participatedConferenceAudioVideoMinutes;
            this.changedFields = changedFields.add("participatedConferenceAudioVideoMinutes");
            return this;
        }

        public Builder participatedConferenceAppSharingCount(Long participatedConferenceAppSharingCount) {
            this.participatedConferenceAppSharingCount = participatedConferenceAppSharingCount;
            this.changedFields = changedFields.add("participatedConferenceAppSharingCount");
            return this;
        }

        public Builder participatedConferenceWebCount(Long participatedConferenceWebCount) {
            this.participatedConferenceWebCount = participatedConferenceWebCount;
            this.changedFields = changedFields.add("participatedConferenceWebCount");
            return this;
        }

        public Builder participatedConferenceDialInOut3rdPartyCount(Long participatedConferenceDialInOut3rdPartyCount) {
            this.participatedConferenceDialInOut3rdPartyCount = participatedConferenceDialInOut3rdPartyCount;
            this.changedFields = changedFields.add("participatedConferenceDialInOut3rdPartyCount");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public Builder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            this.changedFields = changedFields.add("isDeleted");
            return this;
        }

        public Builder deletedDate(LocalDate deletedDate) {
            this.deletedDate = deletedDate;
            this.changedFields = changedFields.add("deletedDate");
            return this;
        }

        public Builder lastActivityDate(LocalDate lastActivityDate) {
            this.lastActivityDate = lastActivityDate;
            this.changedFields = changedFields.add("lastActivityDate");
            return this;
        }

        public Builder assignedProducts(List<String> assignedProducts) {
            this.assignedProducts = assignedProducts;
            this.changedFields = changedFields.add("assignedProducts");
            return this;
        }

        public Builder assignedProducts(String... assignedProducts) {
            return assignedProducts(Arrays.asList(assignedProducts));
        }

        public Builder assignedProductsNextLink(String assignedProductsNextLink) {
            this.assignedProductsNextLink = assignedProductsNextLink;
            this.changedFields = changedFields.add("assignedProducts");
            return this;
        }

        public Builder reportPeriod(String reportPeriod) {
            this.reportPeriod = reportPeriod;
            this.changedFields = changedFields.add("reportPeriod");
            return this;
        }

        public SkypeForBusinessActivityUserDetail build() {
            SkypeForBusinessActivityUserDetail _x = new SkypeForBusinessActivityUserDetail();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.skypeForBusinessActivityUserDetail";
            _x.id = id;
            _x.totalPeerToPeerSessionCount = totalPeerToPeerSessionCount;
            _x.totalOrganizedConferenceCount = totalOrganizedConferenceCount;
            _x.totalParticipatedConferenceCount = totalParticipatedConferenceCount;
            _x.peerToPeerLastActivityDate = peerToPeerLastActivityDate;
            _x.organizedConferenceLastActivityDate = organizedConferenceLastActivityDate;
            _x.participatedConferenceLastActivityDate = participatedConferenceLastActivityDate;
            _x.peerToPeerIMCount = peerToPeerIMCount;
            _x.peerToPeerAudioCount = peerToPeerAudioCount;
            _x.peerToPeerAudioMinutes = peerToPeerAudioMinutes;
            _x.peerToPeerVideoCount = peerToPeerVideoCount;
            _x.peerToPeerVideoMinutes = peerToPeerVideoMinutes;
            _x.peerToPeerAppSharingCount = peerToPeerAppSharingCount;
            _x.peerToPeerFileTransferCount = peerToPeerFileTransferCount;
            _x.organizedConferenceIMCount = organizedConferenceIMCount;
            _x.organizedConferenceAudioVideoCount = organizedConferenceAudioVideoCount;
            _x.organizedConferenceAudioVideoMinutes = organizedConferenceAudioVideoMinutes;
            _x.organizedConferenceAppSharingCount = organizedConferenceAppSharingCount;
            _x.organizedConferenceWebCount = organizedConferenceWebCount;
            _x.organizedConferenceDialInOut3rdPartyCount = organizedConferenceDialInOut3rdPartyCount;
            _x.organizedConferenceCloudDialInOutMicrosoftCount = organizedConferenceCloudDialInOutMicrosoftCount;
            _x.organizedConferenceCloudDialInMicrosoftMinutes = organizedConferenceCloudDialInMicrosoftMinutes;
            _x.organizedConferenceCloudDialOutMicrosoftMinutes = organizedConferenceCloudDialOutMicrosoftMinutes;
            _x.participatedConferenceIMCount = participatedConferenceIMCount;
            _x.participatedConferenceAudioVideoCount = participatedConferenceAudioVideoCount;
            _x.participatedConferenceAudioVideoMinutes = participatedConferenceAudioVideoMinutes;
            _x.participatedConferenceAppSharingCount = participatedConferenceAppSharingCount;
            _x.participatedConferenceWebCount = participatedConferenceWebCount;
            _x.participatedConferenceDialInOut3rdPartyCount = participatedConferenceDialInOut3rdPartyCount;
            _x.reportRefreshDate = reportRefreshDate;
            _x.userPrincipalName = userPrincipalName;
            _x.isDeleted = isDeleted;
            _x.deletedDate = deletedDate;
            _x.lastActivityDate = lastActivityDate;
            _x.assignedProducts = assignedProducts;
            _x.assignedProductsNextLink = assignedProductsNextLink;
            _x.reportPeriod = reportPeriod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="totalPeerToPeerSessionCount")
    @JsonIgnore
    public Optional<Long> getTotalPeerToPeerSessionCount() {
        return Optional.ofNullable(totalPeerToPeerSessionCount);
    }

    public SkypeForBusinessActivityUserDetail withTotalPeerToPeerSessionCount(Long totalPeerToPeerSessionCount) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("totalPeerToPeerSessionCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.totalPeerToPeerSessionCount = totalPeerToPeerSessionCount;
        return _x;
    }

    @Property(name="totalOrganizedConferenceCount")
    @JsonIgnore
    public Optional<Long> getTotalOrganizedConferenceCount() {
        return Optional.ofNullable(totalOrganizedConferenceCount);
    }

    public SkypeForBusinessActivityUserDetail withTotalOrganizedConferenceCount(Long totalOrganizedConferenceCount) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("totalOrganizedConferenceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.totalOrganizedConferenceCount = totalOrganizedConferenceCount;
        return _x;
    }

    @Property(name="totalParticipatedConferenceCount")
    @JsonIgnore
    public Optional<Long> getTotalParticipatedConferenceCount() {
        return Optional.ofNullable(totalParticipatedConferenceCount);
    }

    public SkypeForBusinessActivityUserDetail withTotalParticipatedConferenceCount(Long totalParticipatedConferenceCount) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("totalParticipatedConferenceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.totalParticipatedConferenceCount = totalParticipatedConferenceCount;
        return _x;
    }

    @Property(name="peerToPeerLastActivityDate")
    @JsonIgnore
    public Optional<LocalDate> getPeerToPeerLastActivityDate() {
        return Optional.ofNullable(peerToPeerLastActivityDate);
    }

    public SkypeForBusinessActivityUserDetail withPeerToPeerLastActivityDate(LocalDate peerToPeerLastActivityDate) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("peerToPeerLastActivityDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.peerToPeerLastActivityDate = peerToPeerLastActivityDate;
        return _x;
    }

    @Property(name="organizedConferenceLastActivityDate")
    @JsonIgnore
    public Optional<LocalDate> getOrganizedConferenceLastActivityDate() {
        return Optional.ofNullable(organizedConferenceLastActivityDate);
    }

    public SkypeForBusinessActivityUserDetail withOrganizedConferenceLastActivityDate(LocalDate organizedConferenceLastActivityDate) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("organizedConferenceLastActivityDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.organizedConferenceLastActivityDate = organizedConferenceLastActivityDate;
        return _x;
    }

    @Property(name="participatedConferenceLastActivityDate")
    @JsonIgnore
    public Optional<LocalDate> getParticipatedConferenceLastActivityDate() {
        return Optional.ofNullable(participatedConferenceLastActivityDate);
    }

    public SkypeForBusinessActivityUserDetail withParticipatedConferenceLastActivityDate(LocalDate participatedConferenceLastActivityDate) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("participatedConferenceLastActivityDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.participatedConferenceLastActivityDate = participatedConferenceLastActivityDate;
        return _x;
    }

    @Property(name="peerToPeerIMCount")
    @JsonIgnore
    public Optional<Long> getPeerToPeerIMCount() {
        return Optional.ofNullable(peerToPeerIMCount);
    }

    public SkypeForBusinessActivityUserDetail withPeerToPeerIMCount(Long peerToPeerIMCount) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("peerToPeerIMCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.peerToPeerIMCount = peerToPeerIMCount;
        return _x;
    }

    @Property(name="peerToPeerAudioCount")
    @JsonIgnore
    public Optional<Long> getPeerToPeerAudioCount() {
        return Optional.ofNullable(peerToPeerAudioCount);
    }

    public SkypeForBusinessActivityUserDetail withPeerToPeerAudioCount(Long peerToPeerAudioCount) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("peerToPeerAudioCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.peerToPeerAudioCount = peerToPeerAudioCount;
        return _x;
    }

    @Property(name="peerToPeerAudioMinutes")
    @JsonIgnore
    public Optional<Long> getPeerToPeerAudioMinutes() {
        return Optional.ofNullable(peerToPeerAudioMinutes);
    }

    public SkypeForBusinessActivityUserDetail withPeerToPeerAudioMinutes(Long peerToPeerAudioMinutes) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("peerToPeerAudioMinutes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.peerToPeerAudioMinutes = peerToPeerAudioMinutes;
        return _x;
    }

    @Property(name="peerToPeerVideoCount")
    @JsonIgnore
    public Optional<Long> getPeerToPeerVideoCount() {
        return Optional.ofNullable(peerToPeerVideoCount);
    }

    public SkypeForBusinessActivityUserDetail withPeerToPeerVideoCount(Long peerToPeerVideoCount) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("peerToPeerVideoCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.peerToPeerVideoCount = peerToPeerVideoCount;
        return _x;
    }

    @Property(name="peerToPeerVideoMinutes")
    @JsonIgnore
    public Optional<Long> getPeerToPeerVideoMinutes() {
        return Optional.ofNullable(peerToPeerVideoMinutes);
    }

    public SkypeForBusinessActivityUserDetail withPeerToPeerVideoMinutes(Long peerToPeerVideoMinutes) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("peerToPeerVideoMinutes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.peerToPeerVideoMinutes = peerToPeerVideoMinutes;
        return _x;
    }

    @Property(name="peerToPeerAppSharingCount")
    @JsonIgnore
    public Optional<Long> getPeerToPeerAppSharingCount() {
        return Optional.ofNullable(peerToPeerAppSharingCount);
    }

    public SkypeForBusinessActivityUserDetail withPeerToPeerAppSharingCount(Long peerToPeerAppSharingCount) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("peerToPeerAppSharingCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.peerToPeerAppSharingCount = peerToPeerAppSharingCount;
        return _x;
    }

    @Property(name="peerToPeerFileTransferCount")
    @JsonIgnore
    public Optional<Long> getPeerToPeerFileTransferCount() {
        return Optional.ofNullable(peerToPeerFileTransferCount);
    }

    public SkypeForBusinessActivityUserDetail withPeerToPeerFileTransferCount(Long peerToPeerFileTransferCount) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("peerToPeerFileTransferCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.peerToPeerFileTransferCount = peerToPeerFileTransferCount;
        return _x;
    }

    @Property(name="organizedConferenceIMCount")
    @JsonIgnore
    public Optional<Long> getOrganizedConferenceIMCount() {
        return Optional.ofNullable(organizedConferenceIMCount);
    }

    public SkypeForBusinessActivityUserDetail withOrganizedConferenceIMCount(Long organizedConferenceIMCount) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("organizedConferenceIMCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.organizedConferenceIMCount = organizedConferenceIMCount;
        return _x;
    }

    @Property(name="organizedConferenceAudioVideoCount")
    @JsonIgnore
    public Optional<Long> getOrganizedConferenceAudioVideoCount() {
        return Optional.ofNullable(organizedConferenceAudioVideoCount);
    }

    public SkypeForBusinessActivityUserDetail withOrganizedConferenceAudioVideoCount(Long organizedConferenceAudioVideoCount) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("organizedConferenceAudioVideoCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.organizedConferenceAudioVideoCount = organizedConferenceAudioVideoCount;
        return _x;
    }

    @Property(name="organizedConferenceAudioVideoMinutes")
    @JsonIgnore
    public Optional<Long> getOrganizedConferenceAudioVideoMinutes() {
        return Optional.ofNullable(organizedConferenceAudioVideoMinutes);
    }

    public SkypeForBusinessActivityUserDetail withOrganizedConferenceAudioVideoMinutes(Long organizedConferenceAudioVideoMinutes) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("organizedConferenceAudioVideoMinutes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.organizedConferenceAudioVideoMinutes = organizedConferenceAudioVideoMinutes;
        return _x;
    }

    @Property(name="organizedConferenceAppSharingCount")
    @JsonIgnore
    public Optional<Long> getOrganizedConferenceAppSharingCount() {
        return Optional.ofNullable(organizedConferenceAppSharingCount);
    }

    public SkypeForBusinessActivityUserDetail withOrganizedConferenceAppSharingCount(Long organizedConferenceAppSharingCount) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("organizedConferenceAppSharingCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.organizedConferenceAppSharingCount = organizedConferenceAppSharingCount;
        return _x;
    }

    @Property(name="organizedConferenceWebCount")
    @JsonIgnore
    public Optional<Long> getOrganizedConferenceWebCount() {
        return Optional.ofNullable(organizedConferenceWebCount);
    }

    public SkypeForBusinessActivityUserDetail withOrganizedConferenceWebCount(Long organizedConferenceWebCount) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("organizedConferenceWebCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.organizedConferenceWebCount = organizedConferenceWebCount;
        return _x;
    }

    @Property(name="organizedConferenceDialInOut3rdPartyCount")
    @JsonIgnore
    public Optional<Long> getOrganizedConferenceDialInOut3rdPartyCount() {
        return Optional.ofNullable(organizedConferenceDialInOut3rdPartyCount);
    }

    public SkypeForBusinessActivityUserDetail withOrganizedConferenceDialInOut3rdPartyCount(Long organizedConferenceDialInOut3rdPartyCount) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("organizedConferenceDialInOut3rdPartyCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.organizedConferenceDialInOut3rdPartyCount = organizedConferenceDialInOut3rdPartyCount;
        return _x;
    }

    @Property(name="organizedConferenceCloudDialInOutMicrosoftCount")
    @JsonIgnore
    public Optional<Long> getOrganizedConferenceCloudDialInOutMicrosoftCount() {
        return Optional.ofNullable(organizedConferenceCloudDialInOutMicrosoftCount);
    }

    public SkypeForBusinessActivityUserDetail withOrganizedConferenceCloudDialInOutMicrosoftCount(Long organizedConferenceCloudDialInOutMicrosoftCount) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("organizedConferenceCloudDialInOutMicrosoftCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.organizedConferenceCloudDialInOutMicrosoftCount = organizedConferenceCloudDialInOutMicrosoftCount;
        return _x;
    }

    @Property(name="organizedConferenceCloudDialInMicrosoftMinutes")
    @JsonIgnore
    public Optional<Long> getOrganizedConferenceCloudDialInMicrosoftMinutes() {
        return Optional.ofNullable(organizedConferenceCloudDialInMicrosoftMinutes);
    }

    public SkypeForBusinessActivityUserDetail withOrganizedConferenceCloudDialInMicrosoftMinutes(Long organizedConferenceCloudDialInMicrosoftMinutes) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("organizedConferenceCloudDialInMicrosoftMinutes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.organizedConferenceCloudDialInMicrosoftMinutes = organizedConferenceCloudDialInMicrosoftMinutes;
        return _x;
    }

    @Property(name="organizedConferenceCloudDialOutMicrosoftMinutes")
    @JsonIgnore
    public Optional<Long> getOrganizedConferenceCloudDialOutMicrosoftMinutes() {
        return Optional.ofNullable(organizedConferenceCloudDialOutMicrosoftMinutes);
    }

    public SkypeForBusinessActivityUserDetail withOrganizedConferenceCloudDialOutMicrosoftMinutes(Long organizedConferenceCloudDialOutMicrosoftMinutes) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("organizedConferenceCloudDialOutMicrosoftMinutes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.organizedConferenceCloudDialOutMicrosoftMinutes = organizedConferenceCloudDialOutMicrosoftMinutes;
        return _x;
    }

    @Property(name="participatedConferenceIMCount")
    @JsonIgnore
    public Optional<Long> getParticipatedConferenceIMCount() {
        return Optional.ofNullable(participatedConferenceIMCount);
    }

    public SkypeForBusinessActivityUserDetail withParticipatedConferenceIMCount(Long participatedConferenceIMCount) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("participatedConferenceIMCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.participatedConferenceIMCount = participatedConferenceIMCount;
        return _x;
    }

    @Property(name="participatedConferenceAudioVideoCount")
    @JsonIgnore
    public Optional<Long> getParticipatedConferenceAudioVideoCount() {
        return Optional.ofNullable(participatedConferenceAudioVideoCount);
    }

    public SkypeForBusinessActivityUserDetail withParticipatedConferenceAudioVideoCount(Long participatedConferenceAudioVideoCount) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("participatedConferenceAudioVideoCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.participatedConferenceAudioVideoCount = participatedConferenceAudioVideoCount;
        return _x;
    }

    @Property(name="participatedConferenceAudioVideoMinutes")
    @JsonIgnore
    public Optional<Long> getParticipatedConferenceAudioVideoMinutes() {
        return Optional.ofNullable(participatedConferenceAudioVideoMinutes);
    }

    public SkypeForBusinessActivityUserDetail withParticipatedConferenceAudioVideoMinutes(Long participatedConferenceAudioVideoMinutes) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("participatedConferenceAudioVideoMinutes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.participatedConferenceAudioVideoMinutes = participatedConferenceAudioVideoMinutes;
        return _x;
    }

    @Property(name="participatedConferenceAppSharingCount")
    @JsonIgnore
    public Optional<Long> getParticipatedConferenceAppSharingCount() {
        return Optional.ofNullable(participatedConferenceAppSharingCount);
    }

    public SkypeForBusinessActivityUserDetail withParticipatedConferenceAppSharingCount(Long participatedConferenceAppSharingCount) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("participatedConferenceAppSharingCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.participatedConferenceAppSharingCount = participatedConferenceAppSharingCount;
        return _x;
    }

    @Property(name="participatedConferenceWebCount")
    @JsonIgnore
    public Optional<Long> getParticipatedConferenceWebCount() {
        return Optional.ofNullable(participatedConferenceWebCount);
    }

    public SkypeForBusinessActivityUserDetail withParticipatedConferenceWebCount(Long participatedConferenceWebCount) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("participatedConferenceWebCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.participatedConferenceWebCount = participatedConferenceWebCount;
        return _x;
    }

    @Property(name="participatedConferenceDialInOut3rdPartyCount")
    @JsonIgnore
    public Optional<Long> getParticipatedConferenceDialInOut3rdPartyCount() {
        return Optional.ofNullable(participatedConferenceDialInOut3rdPartyCount);
    }

    public SkypeForBusinessActivityUserDetail withParticipatedConferenceDialInOut3rdPartyCount(Long participatedConferenceDialInOut3rdPartyCount) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("participatedConferenceDialInOut3rdPartyCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.participatedConferenceDialInOut3rdPartyCount = participatedConferenceDialInOut3rdPartyCount;
        return _x;
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public SkypeForBusinessActivityUserDetail withReportRefreshDate(LocalDate reportRefreshDate) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public SkypeForBusinessActivityUserDetail withUserPrincipalName(String userPrincipalName) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Property(name="isDeleted")
    @JsonIgnore
    public Optional<Boolean> getIsDeleted() {
        return Optional.ofNullable(isDeleted);
    }

    public SkypeForBusinessActivityUserDetail withIsDeleted(Boolean isDeleted) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("isDeleted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.isDeleted = isDeleted;
        return _x;
    }

    @Property(name="deletedDate")
    @JsonIgnore
    public Optional<LocalDate> getDeletedDate() {
        return Optional.ofNullable(deletedDate);
    }

    public SkypeForBusinessActivityUserDetail withDeletedDate(LocalDate deletedDate) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("deletedDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.deletedDate = deletedDate;
        return _x;
    }

    @Property(name="lastActivityDate")
    @JsonIgnore
    public Optional<LocalDate> getLastActivityDate() {
        return Optional.ofNullable(lastActivityDate);
    }

    public SkypeForBusinessActivityUserDetail withLastActivityDate(LocalDate lastActivityDate) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("lastActivityDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.lastActivityDate = lastActivityDate;
        return _x;
    }

    @Property(name="assignedProducts")
    @JsonIgnore
    public CollectionPage<String> getAssignedProducts() {
        return new CollectionPage<String>(contextPath, String.class, assignedProducts, Optional.ofNullable(assignedProductsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="assignedProducts")
    @JsonIgnore
    public CollectionPage<String> getAssignedProducts(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, assignedProducts, Optional.ofNullable(assignedProductsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="reportPeriod")
    @JsonIgnore
    public Optional<String> getReportPeriod() {
        return Optional.ofNullable(reportPeriod);
    }

    public SkypeForBusinessActivityUserDetail withReportPeriod(String reportPeriod) {
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("reportPeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserDetail");
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SkypeForBusinessActivityUserDetail patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SkypeForBusinessActivityUserDetail put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SkypeForBusinessActivityUserDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SkypeForBusinessActivityUserDetail _copy() {
        SkypeForBusinessActivityUserDetail _x = new SkypeForBusinessActivityUserDetail();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.totalPeerToPeerSessionCount = totalPeerToPeerSessionCount;
        _x.totalOrganizedConferenceCount = totalOrganizedConferenceCount;
        _x.totalParticipatedConferenceCount = totalParticipatedConferenceCount;
        _x.peerToPeerLastActivityDate = peerToPeerLastActivityDate;
        _x.organizedConferenceLastActivityDate = organizedConferenceLastActivityDate;
        _x.participatedConferenceLastActivityDate = participatedConferenceLastActivityDate;
        _x.peerToPeerIMCount = peerToPeerIMCount;
        _x.peerToPeerAudioCount = peerToPeerAudioCount;
        _x.peerToPeerAudioMinutes = peerToPeerAudioMinutes;
        _x.peerToPeerVideoCount = peerToPeerVideoCount;
        _x.peerToPeerVideoMinutes = peerToPeerVideoMinutes;
        _x.peerToPeerAppSharingCount = peerToPeerAppSharingCount;
        _x.peerToPeerFileTransferCount = peerToPeerFileTransferCount;
        _x.organizedConferenceIMCount = organizedConferenceIMCount;
        _x.organizedConferenceAudioVideoCount = organizedConferenceAudioVideoCount;
        _x.organizedConferenceAudioVideoMinutes = organizedConferenceAudioVideoMinutes;
        _x.organizedConferenceAppSharingCount = organizedConferenceAppSharingCount;
        _x.organizedConferenceWebCount = organizedConferenceWebCount;
        _x.organizedConferenceDialInOut3rdPartyCount = organizedConferenceDialInOut3rdPartyCount;
        _x.organizedConferenceCloudDialInOutMicrosoftCount = organizedConferenceCloudDialInOutMicrosoftCount;
        _x.organizedConferenceCloudDialInMicrosoftMinutes = organizedConferenceCloudDialInMicrosoftMinutes;
        _x.organizedConferenceCloudDialOutMicrosoftMinutes = organizedConferenceCloudDialOutMicrosoftMinutes;
        _x.participatedConferenceIMCount = participatedConferenceIMCount;
        _x.participatedConferenceAudioVideoCount = participatedConferenceAudioVideoCount;
        _x.participatedConferenceAudioVideoMinutes = participatedConferenceAudioVideoMinutes;
        _x.participatedConferenceAppSharingCount = participatedConferenceAppSharingCount;
        _x.participatedConferenceWebCount = participatedConferenceWebCount;
        _x.participatedConferenceDialInOut3rdPartyCount = participatedConferenceDialInOut3rdPartyCount;
        _x.reportRefreshDate = reportRefreshDate;
        _x.userPrincipalName = userPrincipalName;
        _x.isDeleted = isDeleted;
        _x.deletedDate = deletedDate;
        _x.lastActivityDate = lastActivityDate;
        _x.assignedProducts = assignedProducts;
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SkypeForBusinessActivityUserDetail[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("totalPeerToPeerSessionCount=");
        b.append(this.totalPeerToPeerSessionCount);
        b.append(", ");
        b.append("totalOrganizedConferenceCount=");
        b.append(this.totalOrganizedConferenceCount);
        b.append(", ");
        b.append("totalParticipatedConferenceCount=");
        b.append(this.totalParticipatedConferenceCount);
        b.append(", ");
        b.append("peerToPeerLastActivityDate=");
        b.append(this.peerToPeerLastActivityDate);
        b.append(", ");
        b.append("organizedConferenceLastActivityDate=");
        b.append(this.organizedConferenceLastActivityDate);
        b.append(", ");
        b.append("participatedConferenceLastActivityDate=");
        b.append(this.participatedConferenceLastActivityDate);
        b.append(", ");
        b.append("peerToPeerIMCount=");
        b.append(this.peerToPeerIMCount);
        b.append(", ");
        b.append("peerToPeerAudioCount=");
        b.append(this.peerToPeerAudioCount);
        b.append(", ");
        b.append("peerToPeerAudioMinutes=");
        b.append(this.peerToPeerAudioMinutes);
        b.append(", ");
        b.append("peerToPeerVideoCount=");
        b.append(this.peerToPeerVideoCount);
        b.append(", ");
        b.append("peerToPeerVideoMinutes=");
        b.append(this.peerToPeerVideoMinutes);
        b.append(", ");
        b.append("peerToPeerAppSharingCount=");
        b.append(this.peerToPeerAppSharingCount);
        b.append(", ");
        b.append("peerToPeerFileTransferCount=");
        b.append(this.peerToPeerFileTransferCount);
        b.append(", ");
        b.append("organizedConferenceIMCount=");
        b.append(this.organizedConferenceIMCount);
        b.append(", ");
        b.append("organizedConferenceAudioVideoCount=");
        b.append(this.organizedConferenceAudioVideoCount);
        b.append(", ");
        b.append("organizedConferenceAudioVideoMinutes=");
        b.append(this.organizedConferenceAudioVideoMinutes);
        b.append(", ");
        b.append("organizedConferenceAppSharingCount=");
        b.append(this.organizedConferenceAppSharingCount);
        b.append(", ");
        b.append("organizedConferenceWebCount=");
        b.append(this.organizedConferenceWebCount);
        b.append(", ");
        b.append("organizedConferenceDialInOut3rdPartyCount=");
        b.append(this.organizedConferenceDialInOut3rdPartyCount);
        b.append(", ");
        b.append("organizedConferenceCloudDialInOutMicrosoftCount=");
        b.append(this.organizedConferenceCloudDialInOutMicrosoftCount);
        b.append(", ");
        b.append("organizedConferenceCloudDialInMicrosoftMinutes=");
        b.append(this.organizedConferenceCloudDialInMicrosoftMinutes);
        b.append(", ");
        b.append("organizedConferenceCloudDialOutMicrosoftMinutes=");
        b.append(this.organizedConferenceCloudDialOutMicrosoftMinutes);
        b.append(", ");
        b.append("participatedConferenceIMCount=");
        b.append(this.participatedConferenceIMCount);
        b.append(", ");
        b.append("participatedConferenceAudioVideoCount=");
        b.append(this.participatedConferenceAudioVideoCount);
        b.append(", ");
        b.append("participatedConferenceAudioVideoMinutes=");
        b.append(this.participatedConferenceAudioVideoMinutes);
        b.append(", ");
        b.append("participatedConferenceAppSharingCount=");
        b.append(this.participatedConferenceAppSharingCount);
        b.append(", ");
        b.append("participatedConferenceWebCount=");
        b.append(this.participatedConferenceWebCount);
        b.append(", ");
        b.append("participatedConferenceDialInOut3rdPartyCount=");
        b.append(this.participatedConferenceDialInOut3rdPartyCount);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("isDeleted=");
        b.append(this.isDeleted);
        b.append(", ");
        b.append("deletedDate=");
        b.append(this.deletedDate);
        b.append(", ");
        b.append("lastActivityDate=");
        b.append(this.lastActivityDate);
        b.append(", ");
        b.append("assignedProducts=");
        b.append(this.assignedProducts);
        b.append(", ");
        b.append("reportPeriod=");
        b.append(this.reportPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
