package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "peerToPeer", 
    "organized", 
    "participated", 
    "reportRefreshDate", 
    "reportDate", 
    "reportPeriod"})
@JsonInclude(Include.NON_NULL)
public class SkypeForBusinessActivityUserCounts extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.skypeForBusinessActivityUserCounts";
    }

    @JsonProperty("peerToPeer")
    protected Long peerToPeer;

    @JsonProperty("organized")
    protected Long organized;

    @JsonProperty("participated")
    protected Long participated;

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("reportDate")
    protected LocalDate reportDate;

    @JsonProperty("reportPeriod")
    protected String reportPeriod;

    protected SkypeForBusinessActivityUserCounts() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSkypeForBusinessActivityUserCounts() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Long peerToPeer;
        private Long organized;
        private Long participated;
        private LocalDate reportRefreshDate;
        private LocalDate reportDate;
        private String reportPeriod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder peerToPeer(Long peerToPeer) {
            this.peerToPeer = peerToPeer;
            this.changedFields = changedFields.add("peerToPeer");
            return this;
        }

        public Builder organized(Long organized) {
            this.organized = organized;
            this.changedFields = changedFields.add("organized");
            return this;
        }

        public Builder participated(Long participated) {
            this.participated = participated;
            this.changedFields = changedFields.add("participated");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder reportDate(LocalDate reportDate) {
            this.reportDate = reportDate;
            this.changedFields = changedFields.add("reportDate");
            return this;
        }

        public Builder reportPeriod(String reportPeriod) {
            this.reportPeriod = reportPeriod;
            this.changedFields = changedFields.add("reportPeriod");
            return this;
        }

        public SkypeForBusinessActivityUserCounts build() {
            SkypeForBusinessActivityUserCounts _x = new SkypeForBusinessActivityUserCounts();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.skypeForBusinessActivityUserCounts";
            _x.id = id;
            _x.peerToPeer = peerToPeer;
            _x.organized = organized;
            _x.participated = participated;
            _x.reportRefreshDate = reportRefreshDate;
            _x.reportDate = reportDate;
            _x.reportPeriod = reportPeriod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="peerToPeer")
    @JsonIgnore
    public Optional<Long> getPeerToPeer() {
        return Optional.ofNullable(peerToPeer);
    }

    public SkypeForBusinessActivityUserCounts withPeerToPeer(Long peerToPeer) {
        SkypeForBusinessActivityUserCounts _x = _copy();
        _x.changedFields = changedFields.add("peerToPeer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserCounts");
        _x.peerToPeer = peerToPeer;
        return _x;
    }

    @Property(name="organized")
    @JsonIgnore
    public Optional<Long> getOrganized() {
        return Optional.ofNullable(organized);
    }

    public SkypeForBusinessActivityUserCounts withOrganized(Long organized) {
        SkypeForBusinessActivityUserCounts _x = _copy();
        _x.changedFields = changedFields.add("organized");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserCounts");
        _x.organized = organized;
        return _x;
    }

    @Property(name="participated")
    @JsonIgnore
    public Optional<Long> getParticipated() {
        return Optional.ofNullable(participated);
    }

    public SkypeForBusinessActivityUserCounts withParticipated(Long participated) {
        SkypeForBusinessActivityUserCounts _x = _copy();
        _x.changedFields = changedFields.add("participated");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserCounts");
        _x.participated = participated;
        return _x;
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public SkypeForBusinessActivityUserCounts withReportRefreshDate(LocalDate reportRefreshDate) {
        SkypeForBusinessActivityUserCounts _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserCounts");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="reportDate")
    @JsonIgnore
    public Optional<LocalDate> getReportDate() {
        return Optional.ofNullable(reportDate);
    }

    public SkypeForBusinessActivityUserCounts withReportDate(LocalDate reportDate) {
        SkypeForBusinessActivityUserCounts _x = _copy();
        _x.changedFields = changedFields.add("reportDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserCounts");
        _x.reportDate = reportDate;
        return _x;
    }

    @Property(name="reportPeriod")
    @JsonIgnore
    public Optional<String> getReportPeriod() {
        return Optional.ofNullable(reportPeriod);
    }

    public SkypeForBusinessActivityUserCounts withReportPeriod(String reportPeriod) {
        SkypeForBusinessActivityUserCounts _x = _copy();
        _x.changedFields = changedFields.add("reportPeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.skypeForBusinessActivityUserCounts");
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SkypeForBusinessActivityUserCounts patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SkypeForBusinessActivityUserCounts _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SkypeForBusinessActivityUserCounts put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SkypeForBusinessActivityUserCounts _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SkypeForBusinessActivityUserCounts _copy() {
        SkypeForBusinessActivityUserCounts _x = new SkypeForBusinessActivityUserCounts();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.peerToPeer = peerToPeer;
        _x.organized = organized;
        _x.participated = participated;
        _x.reportRefreshDate = reportRefreshDate;
        _x.reportDate = reportDate;
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SkypeForBusinessActivityUserCounts[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("peerToPeer=");
        b.append(this.peerToPeer);
        b.append(", ");
        b.append("organized=");
        b.append(this.organized);
        b.append(", ");
        b.append("participated=");
        b.append(this.participated);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("reportDate=");
        b.append(this.reportDate);
        b.append(", ");
        b.append("reportPeriod=");
        b.append(this.reportPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
