package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“SideLoadingKey entity is required for Windows 8 and 8.1 devices to intall Line
 * Of Business Apps for a tenant.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "value", 
    "displayName", 
    "description", 
    "totalActivation", 
    "lastUpdatedDateTime"})
@JsonInclude(Include.NON_NULL)
public class SideLoadingKey extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.sideLoadingKey";
    }

    @JsonProperty("value")
    protected String value;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("totalActivation")
    protected Integer totalActivation;

    @JsonProperty("lastUpdatedDateTime")
    protected String lastUpdatedDateTime;

    protected SideLoadingKey() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSideLoadingKey() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String value;
        private String displayName;
        private String description;
        private Integer totalActivation;
        private String lastUpdatedDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Side Loading Key Value, it is 5x5 value, seperated by hiphens.”</i>
         * 
         * @param value
         *            value of {@code value} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder value(String value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        /**
         * <i>“Side Loading Key Name displayed to the ITPro Admins.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Side Loading Key description displayed to the ITPro Admins..”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“Side Loading Key Total Activation displayed to the ITPro Admins.”</i>
         * 
         * @param totalActivation
         *            value of {@code totalActivation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder totalActivation(Integer totalActivation) {
            this.totalActivation = totalActivation;
            this.changedFields = changedFields.add("totalActivation");
            return this;
        }

        /**
         * <i>“Side Loading Key Last Updated Date displayed to the ITPro Admins.”</i>
         * 
         * @param lastUpdatedDateTime
         *            value of {@code lastUpdatedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastUpdatedDateTime(String lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            this.changedFields = changedFields.add("lastUpdatedDateTime");
            return this;
        }

        public SideLoadingKey build() {
            SideLoadingKey _x = new SideLoadingKey();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.sideLoadingKey";
            _x.id = id;
            _x.value = value;
            _x.displayName = displayName;
            _x.description = description;
            _x.totalActivation = totalActivation;
            _x.lastUpdatedDateTime = lastUpdatedDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Side Loading Key Value, it is 5x5 value, seperated by hiphens.”</i>
     * 
     * @return property value
     */
    @Property(name="value")
    @JsonIgnore
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code value} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Side Loading Key Value, it is 5x5 value, seperated by hiphens.”</i>
     * 
     * @param value
     *            new value of {@code value} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code value} field changed
     */
    public SideLoadingKey withValue(String value) {
        SideLoadingKey _x = _copy();
        _x.changedFields = changedFields.add("value");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sideLoadingKey");
        _x.value = value;
        return _x;
    }

    /**
     * <i>“Side Loading Key Name displayed to the ITPro Admins.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Side Loading Key Name displayed to the ITPro Admins.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public SideLoadingKey withDisplayName(String displayName) {
        SideLoadingKey _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sideLoadingKey");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Side Loading Key description displayed to the ITPro Admins..”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Side Loading Key description displayed to the ITPro Admins..”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public SideLoadingKey withDescription(String description) {
        SideLoadingKey _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sideLoadingKey");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Side Loading Key Total Activation displayed to the ITPro Admins.”</i>
     * 
     * @return property totalActivation
     */
    @Property(name="totalActivation")
    @JsonIgnore
    public Optional<Integer> getTotalActivation() {
        return Optional.ofNullable(totalActivation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code totalActivation}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Side Loading Key Total Activation displayed to the ITPro Admins.”</i>
     * 
     * @param totalActivation
     *            new value of {@code totalActivation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code totalActivation} field changed
     */
    public SideLoadingKey withTotalActivation(Integer totalActivation) {
        SideLoadingKey _x = _copy();
        _x.changedFields = changedFields.add("totalActivation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sideLoadingKey");
        _x.totalActivation = totalActivation;
        return _x;
    }

    /**
     * <i>“Side Loading Key Last Updated Date displayed to the ITPro Admins.”</i>
     * 
     * @return property lastUpdatedDateTime
     */
    @Property(name="lastUpdatedDateTime")
    @JsonIgnore
    public Optional<String> getLastUpdatedDateTime() {
        return Optional.ofNullable(lastUpdatedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastUpdatedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Side Loading Key Last Updated Date displayed to the ITPro Admins.”</i>
     * 
     * @param lastUpdatedDateTime
     *            new value of {@code lastUpdatedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastUpdatedDateTime} field changed
     */
    public SideLoadingKey withLastUpdatedDateTime(String lastUpdatedDateTime) {
        SideLoadingKey _x = _copy();
        _x.changedFields = changedFields.add("lastUpdatedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sideLoadingKey");
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SideLoadingKey patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SideLoadingKey _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SideLoadingKey put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SideLoadingKey _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SideLoadingKey _copy() {
        SideLoadingKey _x = new SideLoadingKey();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.value = value;
        _x.displayName = displayName;
        _x.description = description;
        _x.totalActivation = totalActivation;
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SideLoadingKey[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("value=");
        b.append(this.value);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("totalActivation=");
        b.append(this.totalActivation);
        b.append(", ");
        b.append("lastUpdatedDateTime=");
        b.append(this.lastUpdatedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
