package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.ShiftAvailability;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "availability"})
@JsonInclude(Include.NON_NULL)
public class ShiftPreferences extends ChangeTrackedEntity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.shiftPreferences";
    }

    @JsonProperty("availability")
    protected List<ShiftAvailability> availability;

    @JsonProperty("availability@nextLink")
    protected String availabilityNextLink;

    protected ShiftPreferences() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderShiftPreferences() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private IdentitySet lastModifiedBy;
        private List<ShiftAvailability> availability;
        private String availabilityNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder availability(List<ShiftAvailability> availability) {
            this.availability = availability;
            this.changedFields = changedFields.add("availability");
            return this;
        }

        public Builder availability(ShiftAvailability... availability) {
            return availability(Arrays.asList(availability));
        }

        public Builder availabilityNextLink(String availabilityNextLink) {
            this.availabilityNextLink = availabilityNextLink;
            this.changedFields = changedFields.add("availability");
            return this;
        }

        public ShiftPreferences build() {
            ShiftPreferences _x = new ShiftPreferences();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.shiftPreferences";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.lastModifiedBy = lastModifiedBy;
            _x.availability = availability;
            _x.availabilityNextLink = availabilityNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="availability")
    @JsonIgnore
    public CollectionPage<ShiftAvailability> getAvailability() {
        return new CollectionPage<ShiftAvailability>(contextPath, ShiftAvailability.class, availability, Optional.ofNullable(availabilityNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="availability")
    @JsonIgnore
    public CollectionPage<ShiftAvailability> getAvailability(HttpRequestOptions options) {
        return new CollectionPage<ShiftAvailability>(contextPath, ShiftAvailability.class, availability, Optional.ofNullable(availabilityNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ShiftPreferences patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ShiftPreferences _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ShiftPreferences put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ShiftPreferences _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ShiftPreferences _copy() {
        ShiftPreferences _x = new ShiftPreferences();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.lastModifiedBy = lastModifiedBy;
        _x.availability = availability;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ShiftPreferences[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("availability=");
        b.append(this.availability);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
