package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;
import odata.msgraph.client.beta.complex.ShiftItem;

@JsonPropertyOrder({
    "@odata.type", 
    "sharedShift", 
    "draftShift", 
    "userId", 
    "schedulingGroupId", 
    "isStagedForDeletion"})
@JsonInclude(Include.NON_NULL)
public class Shift extends ChangeTrackedEntity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.shift";
    }

    @JsonProperty("sharedShift")
    protected ShiftItem sharedShift;

    @JsonProperty("draftShift")
    protected ShiftItem draftShift;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("schedulingGroupId")
    protected String schedulingGroupId;

    @JsonProperty("isStagedForDeletion")
    protected Boolean isStagedForDeletion;

    protected Shift() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderShift() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private IdentitySet lastModifiedBy;
        private ShiftItem sharedShift;
        private ShiftItem draftShift;
        private String userId;
        private String schedulingGroupId;
        private Boolean isStagedForDeletion;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder sharedShift(ShiftItem sharedShift) {
            this.sharedShift = sharedShift;
            this.changedFields = changedFields.add("sharedShift");
            return this;
        }

        public Builder draftShift(ShiftItem draftShift) {
            this.draftShift = draftShift;
            this.changedFields = changedFields.add("draftShift");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        public Builder schedulingGroupId(String schedulingGroupId) {
            this.schedulingGroupId = schedulingGroupId;
            this.changedFields = changedFields.add("schedulingGroupId");
            return this;
        }

        public Builder isStagedForDeletion(Boolean isStagedForDeletion) {
            this.isStagedForDeletion = isStagedForDeletion;
            this.changedFields = changedFields.add("isStagedForDeletion");
            return this;
        }

        public Shift build() {
            Shift _x = new Shift();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.shift";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.lastModifiedBy = lastModifiedBy;
            _x.sharedShift = sharedShift;
            _x.draftShift = draftShift;
            _x.userId = userId;
            _x.schedulingGroupId = schedulingGroupId;
            _x.isStagedForDeletion = isStagedForDeletion;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="sharedShift")
    @JsonIgnore
    public Optional<ShiftItem> getSharedShift() {
        return Optional.ofNullable(sharedShift);
    }

    public Shift withSharedShift(ShiftItem sharedShift) {
        Shift _x = _copy();
        _x.changedFields = changedFields.add("sharedShift");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.shift");
        _x.sharedShift = sharedShift;
        return _x;
    }

    @Property(name="draftShift")
    @JsonIgnore
    public Optional<ShiftItem> getDraftShift() {
        return Optional.ofNullable(draftShift);
    }

    public Shift withDraftShift(ShiftItem draftShift) {
        Shift _x = _copy();
        _x.changedFields = changedFields.add("draftShift");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.shift");
        _x.draftShift = draftShift;
        return _x;
    }

    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    public Shift withUserId(String userId) {
        Shift _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.shift");
        _x.userId = userId;
        return _x;
    }

    @Property(name="schedulingGroupId")
    @JsonIgnore
    public Optional<String> getSchedulingGroupId() {
        return Optional.ofNullable(schedulingGroupId);
    }

    public Shift withSchedulingGroupId(String schedulingGroupId) {
        Shift _x = _copy();
        _x.changedFields = changedFields.add("schedulingGroupId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.shift");
        _x.schedulingGroupId = schedulingGroupId;
        return _x;
    }

    @Property(name="isStagedForDeletion")
    @JsonIgnore
    public Optional<Boolean> getIsStagedForDeletion() {
        return Optional.ofNullable(isStagedForDeletion);
    }

    public Shift withIsStagedForDeletion(Boolean isStagedForDeletion) {
        Shift _x = _copy();
        _x.changedFields = changedFields.add("isStagedForDeletion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.shift");
        _x.isStagedForDeletion = isStagedForDeletion;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Shift patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Shift _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Shift put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Shift _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Shift _copy() {
        Shift _x = new Shift();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.lastModifiedBy = lastModifiedBy;
        _x.sharedShift = sharedShift;
        _x.draftShift = draftShift;
        _x.userId = userId;
        _x.schedulingGroupId = schedulingGroupId;
        _x.isStagedForDeletion = isStagedForDeletion;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Shift[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("sharedShift=");
        b.append(this.sharedShift);
        b.append(", ");
        b.append("draftShift=");
        b.append(this.draftShift);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("schedulingGroupId=");
        b.append(this.schedulingGroupId);
        b.append(", ");
        b.append("isStagedForDeletion=");
        b.append(this.isStagedForDeletion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
