package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "reportRefreshDate", 
    "siteType", 
    "pageViewCount", 
    "reportDate", 
    "reportPeriod"})
@JsonInclude(Include.NON_NULL)
public class SharePointSiteUsagePages extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.sharePointSiteUsagePages";
    }

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("siteType")
    protected String siteType;

    @JsonProperty("pageViewCount")
    protected Long pageViewCount;

    @JsonProperty("reportDate")
    protected LocalDate reportDate;

    @JsonProperty("reportPeriod")
    protected String reportPeriod;

    protected SharePointSiteUsagePages() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSharePointSiteUsagePages() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private LocalDate reportRefreshDate;
        private String siteType;
        private Long pageViewCount;
        private LocalDate reportDate;
        private String reportPeriod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder siteType(String siteType) {
            this.siteType = siteType;
            this.changedFields = changedFields.add("siteType");
            return this;
        }

        public Builder pageViewCount(Long pageViewCount) {
            this.pageViewCount = pageViewCount;
            this.changedFields = changedFields.add("pageViewCount");
            return this;
        }

        public Builder reportDate(LocalDate reportDate) {
            this.reportDate = reportDate;
            this.changedFields = changedFields.add("reportDate");
            return this;
        }

        public Builder reportPeriod(String reportPeriod) {
            this.reportPeriod = reportPeriod;
            this.changedFields = changedFields.add("reportPeriod");
            return this;
        }

        public SharePointSiteUsagePages build() {
            SharePointSiteUsagePages _x = new SharePointSiteUsagePages();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.sharePointSiteUsagePages";
            _x.id = id;
            _x.reportRefreshDate = reportRefreshDate;
            _x.siteType = siteType;
            _x.pageViewCount = pageViewCount;
            _x.reportDate = reportDate;
            _x.reportPeriod = reportPeriod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public SharePointSiteUsagePages withReportRefreshDate(LocalDate reportRefreshDate) {
        SharePointSiteUsagePages _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointSiteUsagePages");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="siteType")
    @JsonIgnore
    public Optional<String> getSiteType() {
        return Optional.ofNullable(siteType);
    }

    public SharePointSiteUsagePages withSiteType(String siteType) {
        SharePointSiteUsagePages _x = _copy();
        _x.changedFields = changedFields.add("siteType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointSiteUsagePages");
        _x.siteType = siteType;
        return _x;
    }

    @Property(name="pageViewCount")
    @JsonIgnore
    public Optional<Long> getPageViewCount() {
        return Optional.ofNullable(pageViewCount);
    }

    public SharePointSiteUsagePages withPageViewCount(Long pageViewCount) {
        SharePointSiteUsagePages _x = _copy();
        _x.changedFields = changedFields.add("pageViewCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointSiteUsagePages");
        _x.pageViewCount = pageViewCount;
        return _x;
    }

    @Property(name="reportDate")
    @JsonIgnore
    public Optional<LocalDate> getReportDate() {
        return Optional.ofNullable(reportDate);
    }

    public SharePointSiteUsagePages withReportDate(LocalDate reportDate) {
        SharePointSiteUsagePages _x = _copy();
        _x.changedFields = changedFields.add("reportDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointSiteUsagePages");
        _x.reportDate = reportDate;
        return _x;
    }

    @Property(name="reportPeriod")
    @JsonIgnore
    public Optional<String> getReportPeriod() {
        return Optional.ofNullable(reportPeriod);
    }

    public SharePointSiteUsagePages withReportPeriod(String reportPeriod) {
        SharePointSiteUsagePages _x = _copy();
        _x.changedFields = changedFields.add("reportPeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointSiteUsagePages");
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SharePointSiteUsagePages patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SharePointSiteUsagePages _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SharePointSiteUsagePages put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SharePointSiteUsagePages _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SharePointSiteUsagePages _copy() {
        SharePointSiteUsagePages _x = new SharePointSiteUsagePages();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reportRefreshDate = reportRefreshDate;
        _x.siteType = siteType;
        _x.pageViewCount = pageViewCount;
        _x.reportDate = reportDate;
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SharePointSiteUsagePages[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("siteType=");
        b.append(this.siteType);
        b.append(", ");
        b.append("pageViewCount=");
        b.append(this.pageViewCount);
        b.append(", ");
        b.append("reportDate=");
        b.append(this.reportDate);
        b.append(", ");
        b.append("reportPeriod=");
        b.append(this.reportPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
