package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "reportRefreshDate", 
    "siteId", 
    "siteUrl", 
    "ownerDisplayName", 
    "ownerPrincipalName", 
    "isDeleted", 
    "lastActivityDate", 
    "fileCount", 
    "activeFileCount", 
    "pageViewCount", 
    "visitedPageCount", 
    "storageUsedInBytes", 
    "storageAllocatedInBytes", 
    "rootWebTemplate", 
    "reportPeriod"})
@JsonInclude(Include.NON_NULL)
public class SharePointSiteUsageDetail extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.sharePointSiteUsageDetail";
    }

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("siteId")
    protected String siteId;

    @JsonProperty("siteUrl")
    protected String siteUrl;

    @JsonProperty("ownerDisplayName")
    protected String ownerDisplayName;

    @JsonProperty("ownerPrincipalName")
    protected String ownerPrincipalName;

    @JsonProperty("isDeleted")
    protected Boolean isDeleted;

    @JsonProperty("lastActivityDate")
    protected LocalDate lastActivityDate;

    @JsonProperty("fileCount")
    protected Long fileCount;

    @JsonProperty("activeFileCount")
    protected Long activeFileCount;

    @JsonProperty("pageViewCount")
    protected Long pageViewCount;

    @JsonProperty("visitedPageCount")
    protected Long visitedPageCount;

    @JsonProperty("storageUsedInBytes")
    protected Long storageUsedInBytes;

    @JsonProperty("storageAllocatedInBytes")
    protected Long storageAllocatedInBytes;

    @JsonProperty("rootWebTemplate")
    protected String rootWebTemplate;

    @JsonProperty("reportPeriod")
    protected String reportPeriod;

    protected SharePointSiteUsageDetail() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSharePointSiteUsageDetail() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private LocalDate reportRefreshDate;
        private String siteId;
        private String siteUrl;
        private String ownerDisplayName;
        private String ownerPrincipalName;
        private Boolean isDeleted;
        private LocalDate lastActivityDate;
        private Long fileCount;
        private Long activeFileCount;
        private Long pageViewCount;
        private Long visitedPageCount;
        private Long storageUsedInBytes;
        private Long storageAllocatedInBytes;
        private String rootWebTemplate;
        private String reportPeriod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder siteId(String siteId) {
            this.siteId = siteId;
            this.changedFields = changedFields.add("siteId");
            return this;
        }

        public Builder siteUrl(String siteUrl) {
            this.siteUrl = siteUrl;
            this.changedFields = changedFields.add("siteUrl");
            return this;
        }

        public Builder ownerDisplayName(String ownerDisplayName) {
            this.ownerDisplayName = ownerDisplayName;
            this.changedFields = changedFields.add("ownerDisplayName");
            return this;
        }

        public Builder ownerPrincipalName(String ownerPrincipalName) {
            this.ownerPrincipalName = ownerPrincipalName;
            this.changedFields = changedFields.add("ownerPrincipalName");
            return this;
        }

        public Builder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            this.changedFields = changedFields.add("isDeleted");
            return this;
        }

        public Builder lastActivityDate(LocalDate lastActivityDate) {
            this.lastActivityDate = lastActivityDate;
            this.changedFields = changedFields.add("lastActivityDate");
            return this;
        }

        public Builder fileCount(Long fileCount) {
            this.fileCount = fileCount;
            this.changedFields = changedFields.add("fileCount");
            return this;
        }

        public Builder activeFileCount(Long activeFileCount) {
            this.activeFileCount = activeFileCount;
            this.changedFields = changedFields.add("activeFileCount");
            return this;
        }

        public Builder pageViewCount(Long pageViewCount) {
            this.pageViewCount = pageViewCount;
            this.changedFields = changedFields.add("pageViewCount");
            return this;
        }

        public Builder visitedPageCount(Long visitedPageCount) {
            this.visitedPageCount = visitedPageCount;
            this.changedFields = changedFields.add("visitedPageCount");
            return this;
        }

        public Builder storageUsedInBytes(Long storageUsedInBytes) {
            this.storageUsedInBytes = storageUsedInBytes;
            this.changedFields = changedFields.add("storageUsedInBytes");
            return this;
        }

        public Builder storageAllocatedInBytes(Long storageAllocatedInBytes) {
            this.storageAllocatedInBytes = storageAllocatedInBytes;
            this.changedFields = changedFields.add("storageAllocatedInBytes");
            return this;
        }

        public Builder rootWebTemplate(String rootWebTemplate) {
            this.rootWebTemplate = rootWebTemplate;
            this.changedFields = changedFields.add("rootWebTemplate");
            return this;
        }

        public Builder reportPeriod(String reportPeriod) {
            this.reportPeriod = reportPeriod;
            this.changedFields = changedFields.add("reportPeriod");
            return this;
        }

        public SharePointSiteUsageDetail build() {
            SharePointSiteUsageDetail _x = new SharePointSiteUsageDetail();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.sharePointSiteUsageDetail";
            _x.id = id;
            _x.reportRefreshDate = reportRefreshDate;
            _x.siteId = siteId;
            _x.siteUrl = siteUrl;
            _x.ownerDisplayName = ownerDisplayName;
            _x.ownerPrincipalName = ownerPrincipalName;
            _x.isDeleted = isDeleted;
            _x.lastActivityDate = lastActivityDate;
            _x.fileCount = fileCount;
            _x.activeFileCount = activeFileCount;
            _x.pageViewCount = pageViewCount;
            _x.visitedPageCount = visitedPageCount;
            _x.storageUsedInBytes = storageUsedInBytes;
            _x.storageAllocatedInBytes = storageAllocatedInBytes;
            _x.rootWebTemplate = rootWebTemplate;
            _x.reportPeriod = reportPeriod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public SharePointSiteUsageDetail withReportRefreshDate(LocalDate reportRefreshDate) {
        SharePointSiteUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointSiteUsageDetail");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="siteId")
    @JsonIgnore
    public Optional<String> getSiteId() {
        return Optional.ofNullable(siteId);
    }

    public SharePointSiteUsageDetail withSiteId(String siteId) {
        SharePointSiteUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("siteId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointSiteUsageDetail");
        _x.siteId = siteId;
        return _x;
    }

    @Property(name="siteUrl")
    @JsonIgnore
    public Optional<String> getSiteUrl() {
        return Optional.ofNullable(siteUrl);
    }

    public SharePointSiteUsageDetail withSiteUrl(String siteUrl) {
        SharePointSiteUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("siteUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointSiteUsageDetail");
        _x.siteUrl = siteUrl;
        return _x;
    }

    @Property(name="ownerDisplayName")
    @JsonIgnore
    public Optional<String> getOwnerDisplayName() {
        return Optional.ofNullable(ownerDisplayName);
    }

    public SharePointSiteUsageDetail withOwnerDisplayName(String ownerDisplayName) {
        SharePointSiteUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("ownerDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointSiteUsageDetail");
        _x.ownerDisplayName = ownerDisplayName;
        return _x;
    }

    @Property(name="ownerPrincipalName")
    @JsonIgnore
    public Optional<String> getOwnerPrincipalName() {
        return Optional.ofNullable(ownerPrincipalName);
    }

    public SharePointSiteUsageDetail withOwnerPrincipalName(String ownerPrincipalName) {
        SharePointSiteUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("ownerPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointSiteUsageDetail");
        _x.ownerPrincipalName = ownerPrincipalName;
        return _x;
    }

    @Property(name="isDeleted")
    @JsonIgnore
    public Optional<Boolean> getIsDeleted() {
        return Optional.ofNullable(isDeleted);
    }

    public SharePointSiteUsageDetail withIsDeleted(Boolean isDeleted) {
        SharePointSiteUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("isDeleted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointSiteUsageDetail");
        _x.isDeleted = isDeleted;
        return _x;
    }

    @Property(name="lastActivityDate")
    @JsonIgnore
    public Optional<LocalDate> getLastActivityDate() {
        return Optional.ofNullable(lastActivityDate);
    }

    public SharePointSiteUsageDetail withLastActivityDate(LocalDate lastActivityDate) {
        SharePointSiteUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("lastActivityDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointSiteUsageDetail");
        _x.lastActivityDate = lastActivityDate;
        return _x;
    }

    @Property(name="fileCount")
    @JsonIgnore
    public Optional<Long> getFileCount() {
        return Optional.ofNullable(fileCount);
    }

    public SharePointSiteUsageDetail withFileCount(Long fileCount) {
        SharePointSiteUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("fileCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointSiteUsageDetail");
        _x.fileCount = fileCount;
        return _x;
    }

    @Property(name="activeFileCount")
    @JsonIgnore
    public Optional<Long> getActiveFileCount() {
        return Optional.ofNullable(activeFileCount);
    }

    public SharePointSiteUsageDetail withActiveFileCount(Long activeFileCount) {
        SharePointSiteUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("activeFileCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointSiteUsageDetail");
        _x.activeFileCount = activeFileCount;
        return _x;
    }

    @Property(name="pageViewCount")
    @JsonIgnore
    public Optional<Long> getPageViewCount() {
        return Optional.ofNullable(pageViewCount);
    }

    public SharePointSiteUsageDetail withPageViewCount(Long pageViewCount) {
        SharePointSiteUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("pageViewCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointSiteUsageDetail");
        _x.pageViewCount = pageViewCount;
        return _x;
    }

    @Property(name="visitedPageCount")
    @JsonIgnore
    public Optional<Long> getVisitedPageCount() {
        return Optional.ofNullable(visitedPageCount);
    }

    public SharePointSiteUsageDetail withVisitedPageCount(Long visitedPageCount) {
        SharePointSiteUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("visitedPageCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointSiteUsageDetail");
        _x.visitedPageCount = visitedPageCount;
        return _x;
    }

    @Property(name="storageUsedInBytes")
    @JsonIgnore
    public Optional<Long> getStorageUsedInBytes() {
        return Optional.ofNullable(storageUsedInBytes);
    }

    public SharePointSiteUsageDetail withStorageUsedInBytes(Long storageUsedInBytes) {
        SharePointSiteUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("storageUsedInBytes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointSiteUsageDetail");
        _x.storageUsedInBytes = storageUsedInBytes;
        return _x;
    }

    @Property(name="storageAllocatedInBytes")
    @JsonIgnore
    public Optional<Long> getStorageAllocatedInBytes() {
        return Optional.ofNullable(storageAllocatedInBytes);
    }

    public SharePointSiteUsageDetail withStorageAllocatedInBytes(Long storageAllocatedInBytes) {
        SharePointSiteUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("storageAllocatedInBytes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointSiteUsageDetail");
        _x.storageAllocatedInBytes = storageAllocatedInBytes;
        return _x;
    }

    @Property(name="rootWebTemplate")
    @JsonIgnore
    public Optional<String> getRootWebTemplate() {
        return Optional.ofNullable(rootWebTemplate);
    }

    public SharePointSiteUsageDetail withRootWebTemplate(String rootWebTemplate) {
        SharePointSiteUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("rootWebTemplate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointSiteUsageDetail");
        _x.rootWebTemplate = rootWebTemplate;
        return _x;
    }

    @Property(name="reportPeriod")
    @JsonIgnore
    public Optional<String> getReportPeriod() {
        return Optional.ofNullable(reportPeriod);
    }

    public SharePointSiteUsageDetail withReportPeriod(String reportPeriod) {
        SharePointSiteUsageDetail _x = _copy();
        _x.changedFields = changedFields.add("reportPeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointSiteUsageDetail");
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SharePointSiteUsageDetail patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SharePointSiteUsageDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SharePointSiteUsageDetail put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SharePointSiteUsageDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SharePointSiteUsageDetail _copy() {
        SharePointSiteUsageDetail _x = new SharePointSiteUsageDetail();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reportRefreshDate = reportRefreshDate;
        _x.siteId = siteId;
        _x.siteUrl = siteUrl;
        _x.ownerDisplayName = ownerDisplayName;
        _x.ownerPrincipalName = ownerPrincipalName;
        _x.isDeleted = isDeleted;
        _x.lastActivityDate = lastActivityDate;
        _x.fileCount = fileCount;
        _x.activeFileCount = activeFileCount;
        _x.pageViewCount = pageViewCount;
        _x.visitedPageCount = visitedPageCount;
        _x.storageUsedInBytes = storageUsedInBytes;
        _x.storageAllocatedInBytes = storageAllocatedInBytes;
        _x.rootWebTemplate = rootWebTemplate;
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SharePointSiteUsageDetail[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("siteId=");
        b.append(this.siteId);
        b.append(", ");
        b.append("siteUrl=");
        b.append(this.siteUrl);
        b.append(", ");
        b.append("ownerDisplayName=");
        b.append(this.ownerDisplayName);
        b.append(", ");
        b.append("ownerPrincipalName=");
        b.append(this.ownerPrincipalName);
        b.append(", ");
        b.append("isDeleted=");
        b.append(this.isDeleted);
        b.append(", ");
        b.append("lastActivityDate=");
        b.append(this.lastActivityDate);
        b.append(", ");
        b.append("fileCount=");
        b.append(this.fileCount);
        b.append(", ");
        b.append("activeFileCount=");
        b.append(this.activeFileCount);
        b.append(", ");
        b.append("pageViewCount=");
        b.append(this.pageViewCount);
        b.append(", ");
        b.append("visitedPageCount=");
        b.append(this.visitedPageCount);
        b.append(", ");
        b.append("storageUsedInBytes=");
        b.append(this.storageUsedInBytes);
        b.append(", ");
        b.append("storageAllocatedInBytes=");
        b.append(this.storageAllocatedInBytes);
        b.append(", ");
        b.append("rootWebTemplate=");
        b.append(this.rootWebTemplate);
        b.append(", ");
        b.append("reportPeriod=");
        b.append(this.reportPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
