package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "reportRefreshDate", 
    "userPrincipalName", 
    "isDeleted", 
    "deletedDate", 
    "lastActivityDate", 
    "viewedOrEditedFileCount", 
    "syncedFileCount", 
    "sharedInternallyFileCount", 
    "sharedExternallyFileCount", 
    "visitedPageCount", 
    "assignedProducts", 
    "reportPeriod"})
@JsonInclude(Include.NON_NULL)
public class SharePointActivityUserDetail extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.sharePointActivityUserDetail";
    }

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("isDeleted")
    protected Boolean isDeleted;

    @JsonProperty("deletedDate")
    protected LocalDate deletedDate;

    @JsonProperty("lastActivityDate")
    protected LocalDate lastActivityDate;

    @JsonProperty("viewedOrEditedFileCount")
    protected Long viewedOrEditedFileCount;

    @JsonProperty("syncedFileCount")
    protected Long syncedFileCount;

    @JsonProperty("sharedInternallyFileCount")
    protected Long sharedInternallyFileCount;

    @JsonProperty("sharedExternallyFileCount")
    protected Long sharedExternallyFileCount;

    @JsonProperty("visitedPageCount")
    protected Long visitedPageCount;

    @JsonProperty("assignedProducts")
    protected List<String> assignedProducts;

    @JsonProperty("assignedProducts@nextLink")
    protected String assignedProductsNextLink;

    @JsonProperty("reportPeriod")
    protected String reportPeriod;

    protected SharePointActivityUserDetail() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSharePointActivityUserDetail() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private LocalDate reportRefreshDate;
        private String userPrincipalName;
        private Boolean isDeleted;
        private LocalDate deletedDate;
        private LocalDate lastActivityDate;
        private Long viewedOrEditedFileCount;
        private Long syncedFileCount;
        private Long sharedInternallyFileCount;
        private Long sharedExternallyFileCount;
        private Long visitedPageCount;
        private List<String> assignedProducts;
        private String assignedProductsNextLink;
        private String reportPeriod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public Builder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            this.changedFields = changedFields.add("isDeleted");
            return this;
        }

        public Builder deletedDate(LocalDate deletedDate) {
            this.deletedDate = deletedDate;
            this.changedFields = changedFields.add("deletedDate");
            return this;
        }

        public Builder lastActivityDate(LocalDate lastActivityDate) {
            this.lastActivityDate = lastActivityDate;
            this.changedFields = changedFields.add("lastActivityDate");
            return this;
        }

        public Builder viewedOrEditedFileCount(Long viewedOrEditedFileCount) {
            this.viewedOrEditedFileCount = viewedOrEditedFileCount;
            this.changedFields = changedFields.add("viewedOrEditedFileCount");
            return this;
        }

        public Builder syncedFileCount(Long syncedFileCount) {
            this.syncedFileCount = syncedFileCount;
            this.changedFields = changedFields.add("syncedFileCount");
            return this;
        }

        public Builder sharedInternallyFileCount(Long sharedInternallyFileCount) {
            this.sharedInternallyFileCount = sharedInternallyFileCount;
            this.changedFields = changedFields.add("sharedInternallyFileCount");
            return this;
        }

        public Builder sharedExternallyFileCount(Long sharedExternallyFileCount) {
            this.sharedExternallyFileCount = sharedExternallyFileCount;
            this.changedFields = changedFields.add("sharedExternallyFileCount");
            return this;
        }

        public Builder visitedPageCount(Long visitedPageCount) {
            this.visitedPageCount = visitedPageCount;
            this.changedFields = changedFields.add("visitedPageCount");
            return this;
        }

        public Builder assignedProducts(List<String> assignedProducts) {
            this.assignedProducts = assignedProducts;
            this.changedFields = changedFields.add("assignedProducts");
            return this;
        }

        public Builder assignedProducts(String... assignedProducts) {
            return assignedProducts(Arrays.asList(assignedProducts));
        }

        public Builder assignedProductsNextLink(String assignedProductsNextLink) {
            this.assignedProductsNextLink = assignedProductsNextLink;
            this.changedFields = changedFields.add("assignedProducts");
            return this;
        }

        public Builder reportPeriod(String reportPeriod) {
            this.reportPeriod = reportPeriod;
            this.changedFields = changedFields.add("reportPeriod");
            return this;
        }

        public SharePointActivityUserDetail build() {
            SharePointActivityUserDetail _x = new SharePointActivityUserDetail();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.sharePointActivityUserDetail";
            _x.id = id;
            _x.reportRefreshDate = reportRefreshDate;
            _x.userPrincipalName = userPrincipalName;
            _x.isDeleted = isDeleted;
            _x.deletedDate = deletedDate;
            _x.lastActivityDate = lastActivityDate;
            _x.viewedOrEditedFileCount = viewedOrEditedFileCount;
            _x.syncedFileCount = syncedFileCount;
            _x.sharedInternallyFileCount = sharedInternallyFileCount;
            _x.sharedExternallyFileCount = sharedExternallyFileCount;
            _x.visitedPageCount = visitedPageCount;
            _x.assignedProducts = assignedProducts;
            _x.assignedProductsNextLink = assignedProductsNextLink;
            _x.reportPeriod = reportPeriod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public SharePointActivityUserDetail withReportRefreshDate(LocalDate reportRefreshDate) {
        SharePointActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointActivityUserDetail");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public SharePointActivityUserDetail withUserPrincipalName(String userPrincipalName) {
        SharePointActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointActivityUserDetail");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Property(name="isDeleted")
    @JsonIgnore
    public Optional<Boolean> getIsDeleted() {
        return Optional.ofNullable(isDeleted);
    }

    public SharePointActivityUserDetail withIsDeleted(Boolean isDeleted) {
        SharePointActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("isDeleted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointActivityUserDetail");
        _x.isDeleted = isDeleted;
        return _x;
    }

    @Property(name="deletedDate")
    @JsonIgnore
    public Optional<LocalDate> getDeletedDate() {
        return Optional.ofNullable(deletedDate);
    }

    public SharePointActivityUserDetail withDeletedDate(LocalDate deletedDate) {
        SharePointActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("deletedDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointActivityUserDetail");
        _x.deletedDate = deletedDate;
        return _x;
    }

    @Property(name="lastActivityDate")
    @JsonIgnore
    public Optional<LocalDate> getLastActivityDate() {
        return Optional.ofNullable(lastActivityDate);
    }

    public SharePointActivityUserDetail withLastActivityDate(LocalDate lastActivityDate) {
        SharePointActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("lastActivityDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointActivityUserDetail");
        _x.lastActivityDate = lastActivityDate;
        return _x;
    }

    @Property(name="viewedOrEditedFileCount")
    @JsonIgnore
    public Optional<Long> getViewedOrEditedFileCount() {
        return Optional.ofNullable(viewedOrEditedFileCount);
    }

    public SharePointActivityUserDetail withViewedOrEditedFileCount(Long viewedOrEditedFileCount) {
        SharePointActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("viewedOrEditedFileCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointActivityUserDetail");
        _x.viewedOrEditedFileCount = viewedOrEditedFileCount;
        return _x;
    }

    @Property(name="syncedFileCount")
    @JsonIgnore
    public Optional<Long> getSyncedFileCount() {
        return Optional.ofNullable(syncedFileCount);
    }

    public SharePointActivityUserDetail withSyncedFileCount(Long syncedFileCount) {
        SharePointActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("syncedFileCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointActivityUserDetail");
        _x.syncedFileCount = syncedFileCount;
        return _x;
    }

    @Property(name="sharedInternallyFileCount")
    @JsonIgnore
    public Optional<Long> getSharedInternallyFileCount() {
        return Optional.ofNullable(sharedInternallyFileCount);
    }

    public SharePointActivityUserDetail withSharedInternallyFileCount(Long sharedInternallyFileCount) {
        SharePointActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("sharedInternallyFileCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointActivityUserDetail");
        _x.sharedInternallyFileCount = sharedInternallyFileCount;
        return _x;
    }

    @Property(name="sharedExternallyFileCount")
    @JsonIgnore
    public Optional<Long> getSharedExternallyFileCount() {
        return Optional.ofNullable(sharedExternallyFileCount);
    }

    public SharePointActivityUserDetail withSharedExternallyFileCount(Long sharedExternallyFileCount) {
        SharePointActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("sharedExternallyFileCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointActivityUserDetail");
        _x.sharedExternallyFileCount = sharedExternallyFileCount;
        return _x;
    }

    @Property(name="visitedPageCount")
    @JsonIgnore
    public Optional<Long> getVisitedPageCount() {
        return Optional.ofNullable(visitedPageCount);
    }

    public SharePointActivityUserDetail withVisitedPageCount(Long visitedPageCount) {
        SharePointActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("visitedPageCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointActivityUserDetail");
        _x.visitedPageCount = visitedPageCount;
        return _x;
    }

    @Property(name="assignedProducts")
    @JsonIgnore
    public CollectionPage<String> getAssignedProducts() {
        return new CollectionPage<String>(contextPath, String.class, assignedProducts, Optional.ofNullable(assignedProductsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="assignedProducts")
    @JsonIgnore
    public CollectionPage<String> getAssignedProducts(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, assignedProducts, Optional.ofNullable(assignedProductsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="reportPeriod")
    @JsonIgnore
    public Optional<String> getReportPeriod() {
        return Optional.ofNullable(reportPeriod);
    }

    public SharePointActivityUserDetail withReportPeriod(String reportPeriod) {
        SharePointActivityUserDetail _x = _copy();
        _x.changedFields = changedFields.add("reportPeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointActivityUserDetail");
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SharePointActivityUserDetail patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SharePointActivityUserDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SharePointActivityUserDetail put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SharePointActivityUserDetail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SharePointActivityUserDetail _copy() {
        SharePointActivityUserDetail _x = new SharePointActivityUserDetail();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reportRefreshDate = reportRefreshDate;
        _x.userPrincipalName = userPrincipalName;
        _x.isDeleted = isDeleted;
        _x.deletedDate = deletedDate;
        _x.lastActivityDate = lastActivityDate;
        _x.viewedOrEditedFileCount = viewedOrEditedFileCount;
        _x.syncedFileCount = syncedFileCount;
        _x.sharedInternallyFileCount = sharedInternallyFileCount;
        _x.sharedExternallyFileCount = sharedExternallyFileCount;
        _x.visitedPageCount = visitedPageCount;
        _x.assignedProducts = assignedProducts;
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SharePointActivityUserDetail[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("isDeleted=");
        b.append(this.isDeleted);
        b.append(", ");
        b.append("deletedDate=");
        b.append(this.deletedDate);
        b.append(", ");
        b.append("lastActivityDate=");
        b.append(this.lastActivityDate);
        b.append(", ");
        b.append("viewedOrEditedFileCount=");
        b.append(this.viewedOrEditedFileCount);
        b.append(", ");
        b.append("syncedFileCount=");
        b.append(this.syncedFileCount);
        b.append(", ");
        b.append("sharedInternallyFileCount=");
        b.append(this.sharedInternallyFileCount);
        b.append(", ");
        b.append("sharedExternallyFileCount=");
        b.append(this.sharedExternallyFileCount);
        b.append(", ");
        b.append("visitedPageCount=");
        b.append(this.visitedPageCount);
        b.append(", ");
        b.append("assignedProducts=");
        b.append(this.assignedProducts);
        b.append(", ");
        b.append("reportPeriod=");
        b.append(this.reportPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
