package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "reportRefreshDate", 
    "visitedPage", 
    "viewedOrEdited", 
    "synced", 
    "sharedInternally", 
    "sharedExternally", 
    "reportDate", 
    "reportPeriod"})
@JsonInclude(Include.NON_NULL)
public class SharePointActivityUserCounts extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.sharePointActivityUserCounts";
    }

    @JsonProperty("reportRefreshDate")
    protected LocalDate reportRefreshDate;

    @JsonProperty("visitedPage")
    protected Long visitedPage;

    @JsonProperty("viewedOrEdited")
    protected Long viewedOrEdited;

    @JsonProperty("synced")
    protected Long synced;

    @JsonProperty("sharedInternally")
    protected Long sharedInternally;

    @JsonProperty("sharedExternally")
    protected Long sharedExternally;

    @JsonProperty("reportDate")
    protected LocalDate reportDate;

    @JsonProperty("reportPeriod")
    protected String reportPeriod;

    protected SharePointActivityUserCounts() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSharePointActivityUserCounts() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private LocalDate reportRefreshDate;
        private Long visitedPage;
        private Long viewedOrEdited;
        private Long synced;
        private Long sharedInternally;
        private Long sharedExternally;
        private LocalDate reportDate;
        private String reportPeriod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder reportRefreshDate(LocalDate reportRefreshDate) {
            this.reportRefreshDate = reportRefreshDate;
            this.changedFields = changedFields.add("reportRefreshDate");
            return this;
        }

        public Builder visitedPage(Long visitedPage) {
            this.visitedPage = visitedPage;
            this.changedFields = changedFields.add("visitedPage");
            return this;
        }

        public Builder viewedOrEdited(Long viewedOrEdited) {
            this.viewedOrEdited = viewedOrEdited;
            this.changedFields = changedFields.add("viewedOrEdited");
            return this;
        }

        public Builder synced(Long synced) {
            this.synced = synced;
            this.changedFields = changedFields.add("synced");
            return this;
        }

        public Builder sharedInternally(Long sharedInternally) {
            this.sharedInternally = sharedInternally;
            this.changedFields = changedFields.add("sharedInternally");
            return this;
        }

        public Builder sharedExternally(Long sharedExternally) {
            this.sharedExternally = sharedExternally;
            this.changedFields = changedFields.add("sharedExternally");
            return this;
        }

        public Builder reportDate(LocalDate reportDate) {
            this.reportDate = reportDate;
            this.changedFields = changedFields.add("reportDate");
            return this;
        }

        public Builder reportPeriod(String reportPeriod) {
            this.reportPeriod = reportPeriod;
            this.changedFields = changedFields.add("reportPeriod");
            return this;
        }

        public SharePointActivityUserCounts build() {
            SharePointActivityUserCounts _x = new SharePointActivityUserCounts();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.sharePointActivityUserCounts";
            _x.id = id;
            _x.reportRefreshDate = reportRefreshDate;
            _x.visitedPage = visitedPage;
            _x.viewedOrEdited = viewedOrEdited;
            _x.synced = synced;
            _x.sharedInternally = sharedInternally;
            _x.sharedExternally = sharedExternally;
            _x.reportDate = reportDate;
            _x.reportPeriod = reportPeriod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="reportRefreshDate")
    @JsonIgnore
    public Optional<LocalDate> getReportRefreshDate() {
        return Optional.ofNullable(reportRefreshDate);
    }

    public SharePointActivityUserCounts withReportRefreshDate(LocalDate reportRefreshDate) {
        SharePointActivityUserCounts _x = _copy();
        _x.changedFields = changedFields.add("reportRefreshDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointActivityUserCounts");
        _x.reportRefreshDate = reportRefreshDate;
        return _x;
    }

    @Property(name="visitedPage")
    @JsonIgnore
    public Optional<Long> getVisitedPage() {
        return Optional.ofNullable(visitedPage);
    }

    public SharePointActivityUserCounts withVisitedPage(Long visitedPage) {
        SharePointActivityUserCounts _x = _copy();
        _x.changedFields = changedFields.add("visitedPage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointActivityUserCounts");
        _x.visitedPage = visitedPage;
        return _x;
    }

    @Property(name="viewedOrEdited")
    @JsonIgnore
    public Optional<Long> getViewedOrEdited() {
        return Optional.ofNullable(viewedOrEdited);
    }

    public SharePointActivityUserCounts withViewedOrEdited(Long viewedOrEdited) {
        SharePointActivityUserCounts _x = _copy();
        _x.changedFields = changedFields.add("viewedOrEdited");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointActivityUserCounts");
        _x.viewedOrEdited = viewedOrEdited;
        return _x;
    }

    @Property(name="synced")
    @JsonIgnore
    public Optional<Long> getSynced() {
        return Optional.ofNullable(synced);
    }

    public SharePointActivityUserCounts withSynced(Long synced) {
        SharePointActivityUserCounts _x = _copy();
        _x.changedFields = changedFields.add("synced");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointActivityUserCounts");
        _x.synced = synced;
        return _x;
    }

    @Property(name="sharedInternally")
    @JsonIgnore
    public Optional<Long> getSharedInternally() {
        return Optional.ofNullable(sharedInternally);
    }

    public SharePointActivityUserCounts withSharedInternally(Long sharedInternally) {
        SharePointActivityUserCounts _x = _copy();
        _x.changedFields = changedFields.add("sharedInternally");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointActivityUserCounts");
        _x.sharedInternally = sharedInternally;
        return _x;
    }

    @Property(name="sharedExternally")
    @JsonIgnore
    public Optional<Long> getSharedExternally() {
        return Optional.ofNullable(sharedExternally);
    }

    public SharePointActivityUserCounts withSharedExternally(Long sharedExternally) {
        SharePointActivityUserCounts _x = _copy();
        _x.changedFields = changedFields.add("sharedExternally");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointActivityUserCounts");
        _x.sharedExternally = sharedExternally;
        return _x;
    }

    @Property(name="reportDate")
    @JsonIgnore
    public Optional<LocalDate> getReportDate() {
        return Optional.ofNullable(reportDate);
    }

    public SharePointActivityUserCounts withReportDate(LocalDate reportDate) {
        SharePointActivityUserCounts _x = _copy();
        _x.changedFields = changedFields.add("reportDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointActivityUserCounts");
        _x.reportDate = reportDate;
        return _x;
    }

    @Property(name="reportPeriod")
    @JsonIgnore
    public Optional<String> getReportPeriod() {
        return Optional.ofNullable(reportPeriod);
    }

    public SharePointActivityUserCounts withReportPeriod(String reportPeriod) {
        SharePointActivityUserCounts _x = _copy();
        _x.changedFields = changedFields.add("reportPeriod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sharePointActivityUserCounts");
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SharePointActivityUserCounts patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SharePointActivityUserCounts _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SharePointActivityUserCounts put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SharePointActivityUserCounts _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SharePointActivityUserCounts _copy() {
        SharePointActivityUserCounts _x = new SharePointActivityUserCounts();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.reportRefreshDate = reportRefreshDate;
        _x.visitedPage = visitedPage;
        _x.viewedOrEdited = viewedOrEdited;
        _x.synced = synced;
        _x.sharedInternally = sharedInternally;
        _x.sharedExternally = sharedExternally;
        _x.reportDate = reportDate;
        _x.reportPeriod = reportPeriod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SharePointActivityUserCounts[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("reportRefreshDate=");
        b.append(this.reportRefreshDate);
        b.append(", ");
        b.append("visitedPage=");
        b.append(this.visitedPage);
        b.append(", ");
        b.append("viewedOrEdited=");
        b.append(this.viewedOrEdited);
        b.append(", ");
        b.append("synced=");
        b.append(this.synced);
        b.append(", ");
        b.append("sharedInternally=");
        b.append(this.sharedInternally);
        b.append(", ");
        b.append("sharedExternally=");
        b.append(this.sharedExternally);
        b.append(", ");
        b.append("reportDate=");
        b.append(this.reportDate);
        b.append(", ");
        b.append("reportPeriod=");
        b.append(this.reportPeriod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
