package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AddIn;
import odata.msgraph.client.beta.complex.AppRole;
import odata.msgraph.client.beta.complex.Credential;
import odata.msgraph.client.beta.complex.InformationalUrl;
import odata.msgraph.client.beta.complex.KeyCredential;
import odata.msgraph.client.beta.complex.PasswordCredential;
import odata.msgraph.client.beta.complex.PasswordSingleSignOnCredentialSet;
import odata.msgraph.client.beta.complex.PermissionScope;
import odata.msgraph.client.beta.complex.SamlSingleSignOnSettings;
import odata.msgraph.client.beta.entity.collection.request.AppRoleAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ClaimsMappingPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EndpointCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.HomeRealmDiscoveryPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.LicenseDetailsCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OAuth2PermissionGrantCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TokenIssuancePolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TokenLifetimePolicyCollectionRequest;
import odata.msgraph.client.beta.entity.request.SynchronizationRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
 * <p>
 * Supported = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "accountEnabled", 
    "addIns", 
    "alternativeNames", 
    "appDescription", 
    "appDisplayName", 
    "appId", 
    "applicationTemplateId", 
    "appOwnerOrganizationId", 
    "appRoleAssignmentRequired", 
    "appRoles", 
    "description", 
    "displayName", 
    "errorUrl", 
    "homepage", 
    "info", 
    "keyCredentials", 
    "loginUrl", 
    "logoutUrl", 
    "notes", 
    "notificationEmailAddresses", 
    "publishedPermissionScopes", 
    "passwordCredentials", 
    "preferredTokenSigningKeyEndDateTime", 
    "preferredTokenSigningKeyThumbprint", 
    "preferredSingleSignOnMode", 
    "publisherName", 
    "replyUrls", 
    "samlMetadataUrl", 
    "samlSingleSignOnSettings", 
    "servicePrincipalNames", 
    "servicePrincipalType", 
    "signInAudience", 
    "tags", 
    "tokenEncryptionKeyId"})
@JsonInclude(Include.NON_NULL)
public class ServicePrincipal extends DirectoryObject implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.servicePrincipal";
    }

    @JsonProperty("accountEnabled")
    protected Boolean accountEnabled;

    @JsonProperty("addIns")
    protected List<AddIn> addIns;

    @JsonProperty("addIns@nextLink")
    protected String addInsNextLink;

    @JsonProperty("alternativeNames")
    protected List<String> alternativeNames;

    @JsonProperty("alternativeNames@nextLink")
    protected String alternativeNamesNextLink;

    @JsonProperty("appDescription")
    protected String appDescription;

    @JsonProperty("appDisplayName")
    protected String appDisplayName;

    @JsonProperty("appId")
    protected String appId;

    @JsonProperty("applicationTemplateId")
    protected String applicationTemplateId;

    @JsonProperty("appOwnerOrganizationId")
    protected String appOwnerOrganizationId;

    @JsonProperty("appRoleAssignmentRequired")
    protected Boolean appRoleAssignmentRequired;

    @JsonProperty("appRoles")
    protected List<AppRole> appRoles;

    @JsonProperty("appRoles@nextLink")
    protected String appRolesNextLink;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("errorUrl")
    protected String errorUrl;

    @JsonProperty("homepage")
    protected String homepage;

    @JsonProperty("info")
    protected InformationalUrl info;

    @JsonProperty("keyCredentials")
    protected List<KeyCredential> keyCredentials;

    @JsonProperty("keyCredentials@nextLink")
    protected String keyCredentialsNextLink;

    @JsonProperty("loginUrl")
    protected String loginUrl;

    @JsonProperty("logoutUrl")
    protected String logoutUrl;

    @JsonProperty("notes")
    protected String notes;

    @JsonProperty("notificationEmailAddresses")
    protected List<String> notificationEmailAddresses;

    @JsonProperty("notificationEmailAddresses@nextLink")
    protected String notificationEmailAddressesNextLink;

    @JsonProperty("publishedPermissionScopes")
    protected List<PermissionScope> publishedPermissionScopes;

    @JsonProperty("publishedPermissionScopes@nextLink")
    protected String publishedPermissionScopesNextLink;

    @JsonProperty("passwordCredentials")
    protected List<PasswordCredential> passwordCredentials;

    @JsonProperty("passwordCredentials@nextLink")
    protected String passwordCredentialsNextLink;

    @JsonProperty("preferredTokenSigningKeyEndDateTime")
    protected OffsetDateTime preferredTokenSigningKeyEndDateTime;

    @JsonProperty("preferredTokenSigningKeyThumbprint")
    protected String preferredTokenSigningKeyThumbprint;

    @JsonProperty("preferredSingleSignOnMode")
    protected String preferredSingleSignOnMode;

    @JsonProperty("publisherName")
    protected String publisherName;

    @JsonProperty("replyUrls")
    protected List<String> replyUrls;

    @JsonProperty("replyUrls@nextLink")
    protected String replyUrlsNextLink;

    @JsonProperty("samlMetadataUrl")
    protected String samlMetadataUrl;

    @JsonProperty("samlSingleSignOnSettings")
    protected SamlSingleSignOnSettings samlSingleSignOnSettings;

    @JsonProperty("servicePrincipalNames")
    protected List<String> servicePrincipalNames;

    @JsonProperty("servicePrincipalNames@nextLink")
    protected String servicePrincipalNamesNextLink;

    @JsonProperty("servicePrincipalType")
    protected String servicePrincipalType;

    @JsonProperty("signInAudience")
    protected String signInAudience;

    @JsonProperty("tags")
    protected List<String> tags;

    @JsonProperty("tags@nextLink")
    protected String tagsNextLink;

    @JsonProperty("tokenEncryptionKeyId")
    protected String tokenEncryptionKeyId;

    protected ServicePrincipal() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderServicePrincipal() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime deletedDateTime;
        private Boolean accountEnabled;
        private List<AddIn> addIns;
        private String addInsNextLink;
        private List<String> alternativeNames;
        private String alternativeNamesNextLink;
        private String appDescription;
        private String appDisplayName;
        private String appId;
        private String applicationTemplateId;
        private String appOwnerOrganizationId;
        private Boolean appRoleAssignmentRequired;
        private List<AppRole> appRoles;
        private String appRolesNextLink;
        private String description;
        private String displayName;
        private String errorUrl;
        private String homepage;
        private InformationalUrl info;
        private List<KeyCredential> keyCredentials;
        private String keyCredentialsNextLink;
        private String loginUrl;
        private String logoutUrl;
        private String notes;
        private List<String> notificationEmailAddresses;
        private String notificationEmailAddressesNextLink;
        private List<PermissionScope> publishedPermissionScopes;
        private String publishedPermissionScopesNextLink;
        private List<PasswordCredential> passwordCredentials;
        private String passwordCredentialsNextLink;
        private OffsetDateTime preferredTokenSigningKeyEndDateTime;
        private String preferredTokenSigningKeyThumbprint;
        private String preferredSingleSignOnMode;
        private String publisherName;
        private List<String> replyUrls;
        private String replyUrlsNextLink;
        private String samlMetadataUrl;
        private SamlSingleSignOnSettings samlSingleSignOnSettings;
        private List<String> servicePrincipalNames;
        private String servicePrincipalNamesNextLink;
        private String servicePrincipalType;
        private String signInAudience;
        private List<String> tags;
        private String tagsNextLink;
        private String tokenEncryptionKeyId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder deletedDateTime(OffsetDateTime deletedDateTime) {
            this.deletedDateTime = deletedDateTime;
            this.changedFields = changedFields.add("deletedDateTime");
            return this;
        }

        public Builder accountEnabled(Boolean accountEnabled) {
            this.accountEnabled = accountEnabled;
            this.changedFields = changedFields.add("accountEnabled");
            return this;
        }

        public Builder addIns(List<AddIn> addIns) {
            this.addIns = addIns;
            this.changedFields = changedFields.add("addIns");
            return this;
        }

        public Builder addIns(AddIn... addIns) {
            return addIns(Arrays.asList(addIns));
        }

        public Builder addInsNextLink(String addInsNextLink) {
            this.addInsNextLink = addInsNextLink;
            this.changedFields = changedFields.add("addIns");
            return this;
        }

        public Builder alternativeNames(List<String> alternativeNames) {
            this.alternativeNames = alternativeNames;
            this.changedFields = changedFields.add("alternativeNames");
            return this;
        }

        public Builder alternativeNames(String... alternativeNames) {
            return alternativeNames(Arrays.asList(alternativeNames));
        }

        public Builder alternativeNamesNextLink(String alternativeNamesNextLink) {
            this.alternativeNamesNextLink = alternativeNamesNextLink;
            this.changedFields = changedFields.add("alternativeNames");
            return this;
        }

        public Builder appDescription(String appDescription) {
            this.appDescription = appDescription;
            this.changedFields = changedFields.add("appDescription");
            return this;
        }

        public Builder appDisplayName(String appDisplayName) {
            this.appDisplayName = appDisplayName;
            this.changedFields = changedFields.add("appDisplayName");
            return this;
        }

        public Builder appId(String appId) {
            this.appId = appId;
            this.changedFields = changedFields.add("appId");
            return this;
        }

        public Builder applicationTemplateId(String applicationTemplateId) {
            this.applicationTemplateId = applicationTemplateId;
            this.changedFields = changedFields.add("applicationTemplateId");
            return this;
        }

        public Builder appOwnerOrganizationId(String appOwnerOrganizationId) {
            this.appOwnerOrganizationId = appOwnerOrganizationId;
            this.changedFields = changedFields.add("appOwnerOrganizationId");
            return this;
        }

        public Builder appRoleAssignmentRequired(Boolean appRoleAssignmentRequired) {
            this.appRoleAssignmentRequired = appRoleAssignmentRequired;
            this.changedFields = changedFields.add("appRoleAssignmentRequired");
            return this;
        }

        public Builder appRoles(List<AppRole> appRoles) {
            this.appRoles = appRoles;
            this.changedFields = changedFields.add("appRoles");
            return this;
        }

        public Builder appRoles(AppRole... appRoles) {
            return appRoles(Arrays.asList(appRoles));
        }

        public Builder appRolesNextLink(String appRolesNextLink) {
            this.appRolesNextLink = appRolesNextLink;
            this.changedFields = changedFields.add("appRoles");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder errorUrl(String errorUrl) {
            this.errorUrl = errorUrl;
            this.changedFields = changedFields.add("errorUrl");
            return this;
        }

        public Builder homepage(String homepage) {
            this.homepage = homepage;
            this.changedFields = changedFields.add("homepage");
            return this;
        }

        public Builder info(InformationalUrl info) {
            this.info = info;
            this.changedFields = changedFields.add("info");
            return this;
        }

        public Builder keyCredentials(List<KeyCredential> keyCredentials) {
            this.keyCredentials = keyCredentials;
            this.changedFields = changedFields.add("keyCredentials");
            return this;
        }

        public Builder keyCredentials(KeyCredential... keyCredentials) {
            return keyCredentials(Arrays.asList(keyCredentials));
        }

        public Builder keyCredentialsNextLink(String keyCredentialsNextLink) {
            this.keyCredentialsNextLink = keyCredentialsNextLink;
            this.changedFields = changedFields.add("keyCredentials");
            return this;
        }

        public Builder loginUrl(String loginUrl) {
            this.loginUrl = loginUrl;
            this.changedFields = changedFields.add("loginUrl");
            return this;
        }

        public Builder logoutUrl(String logoutUrl) {
            this.logoutUrl = logoutUrl;
            this.changedFields = changedFields.add("logoutUrl");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder notificationEmailAddresses(List<String> notificationEmailAddresses) {
            this.notificationEmailAddresses = notificationEmailAddresses;
            this.changedFields = changedFields.add("notificationEmailAddresses");
            return this;
        }

        public Builder notificationEmailAddresses(String... notificationEmailAddresses) {
            return notificationEmailAddresses(Arrays.asList(notificationEmailAddresses));
        }

        public Builder notificationEmailAddressesNextLink(String notificationEmailAddressesNextLink) {
            this.notificationEmailAddressesNextLink = notificationEmailAddressesNextLink;
            this.changedFields = changedFields.add("notificationEmailAddresses");
            return this;
        }

        public Builder publishedPermissionScopes(List<PermissionScope> publishedPermissionScopes) {
            this.publishedPermissionScopes = publishedPermissionScopes;
            this.changedFields = changedFields.add("publishedPermissionScopes");
            return this;
        }

        public Builder publishedPermissionScopes(PermissionScope... publishedPermissionScopes) {
            return publishedPermissionScopes(Arrays.asList(publishedPermissionScopes));
        }

        public Builder publishedPermissionScopesNextLink(String publishedPermissionScopesNextLink) {
            this.publishedPermissionScopesNextLink = publishedPermissionScopesNextLink;
            this.changedFields = changedFields.add("publishedPermissionScopes");
            return this;
        }

        public Builder passwordCredentials(List<PasswordCredential> passwordCredentials) {
            this.passwordCredentials = passwordCredentials;
            this.changedFields = changedFields.add("passwordCredentials");
            return this;
        }

        public Builder passwordCredentials(PasswordCredential... passwordCredentials) {
            return passwordCredentials(Arrays.asList(passwordCredentials));
        }

        public Builder passwordCredentialsNextLink(String passwordCredentialsNextLink) {
            this.passwordCredentialsNextLink = passwordCredentialsNextLink;
            this.changedFields = changedFields.add("passwordCredentials");
            return this;
        }

        public Builder preferredTokenSigningKeyEndDateTime(OffsetDateTime preferredTokenSigningKeyEndDateTime) {
            this.preferredTokenSigningKeyEndDateTime = preferredTokenSigningKeyEndDateTime;
            this.changedFields = changedFields.add("preferredTokenSigningKeyEndDateTime");
            return this;
        }

        public Builder preferredTokenSigningKeyThumbprint(String preferredTokenSigningKeyThumbprint) {
            this.preferredTokenSigningKeyThumbprint = preferredTokenSigningKeyThumbprint;
            this.changedFields = changedFields.add("preferredTokenSigningKeyThumbprint");
            return this;
        }

        public Builder preferredSingleSignOnMode(String preferredSingleSignOnMode) {
            this.preferredSingleSignOnMode = preferredSingleSignOnMode;
            this.changedFields = changedFields.add("preferredSingleSignOnMode");
            return this;
        }

        public Builder publisherName(String publisherName) {
            this.publisherName = publisherName;
            this.changedFields = changedFields.add("publisherName");
            return this;
        }

        public Builder replyUrls(List<String> replyUrls) {
            this.replyUrls = replyUrls;
            this.changedFields = changedFields.add("replyUrls");
            return this;
        }

        public Builder replyUrls(String... replyUrls) {
            return replyUrls(Arrays.asList(replyUrls));
        }

        public Builder replyUrlsNextLink(String replyUrlsNextLink) {
            this.replyUrlsNextLink = replyUrlsNextLink;
            this.changedFields = changedFields.add("replyUrls");
            return this;
        }

        public Builder samlMetadataUrl(String samlMetadataUrl) {
            this.samlMetadataUrl = samlMetadataUrl;
            this.changedFields = changedFields.add("samlMetadataUrl");
            return this;
        }

        public Builder samlSingleSignOnSettings(SamlSingleSignOnSettings samlSingleSignOnSettings) {
            this.samlSingleSignOnSettings = samlSingleSignOnSettings;
            this.changedFields = changedFields.add("samlSingleSignOnSettings");
            return this;
        }

        public Builder servicePrincipalNames(List<String> servicePrincipalNames) {
            this.servicePrincipalNames = servicePrincipalNames;
            this.changedFields = changedFields.add("servicePrincipalNames");
            return this;
        }

        public Builder servicePrincipalNames(String... servicePrincipalNames) {
            return servicePrincipalNames(Arrays.asList(servicePrincipalNames));
        }

        public Builder servicePrincipalNamesNextLink(String servicePrincipalNamesNextLink) {
            this.servicePrincipalNamesNextLink = servicePrincipalNamesNextLink;
            this.changedFields = changedFields.add("servicePrincipalNames");
            return this;
        }

        public Builder servicePrincipalType(String servicePrincipalType) {
            this.servicePrincipalType = servicePrincipalType;
            this.changedFields = changedFields.add("servicePrincipalType");
            return this;
        }

        public Builder signInAudience(String signInAudience) {
            this.signInAudience = signInAudience;
            this.changedFields = changedFields.add("signInAudience");
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags = tags;
            this.changedFields = changedFields.add("tags");
            return this;
        }

        public Builder tags(String... tags) {
            return tags(Arrays.asList(tags));
        }

        public Builder tagsNextLink(String tagsNextLink) {
            this.tagsNextLink = tagsNextLink;
            this.changedFields = changedFields.add("tags");
            return this;
        }

        public Builder tokenEncryptionKeyId(String tokenEncryptionKeyId) {
            this.tokenEncryptionKeyId = tokenEncryptionKeyId;
            this.changedFields = changedFields.add("tokenEncryptionKeyId");
            return this;
        }

        public ServicePrincipal build() {
            ServicePrincipal _x = new ServicePrincipal();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.servicePrincipal";
            _x.id = id;
            _x.deletedDateTime = deletedDateTime;
            _x.accountEnabled = accountEnabled;
            _x.addIns = addIns;
            _x.addInsNextLink = addInsNextLink;
            _x.alternativeNames = alternativeNames;
            _x.alternativeNamesNextLink = alternativeNamesNextLink;
            _x.appDescription = appDescription;
            _x.appDisplayName = appDisplayName;
            _x.appId = appId;
            _x.applicationTemplateId = applicationTemplateId;
            _x.appOwnerOrganizationId = appOwnerOrganizationId;
            _x.appRoleAssignmentRequired = appRoleAssignmentRequired;
            _x.appRoles = appRoles;
            _x.appRolesNextLink = appRolesNextLink;
            _x.description = description;
            _x.displayName = displayName;
            _x.errorUrl = errorUrl;
            _x.homepage = homepage;
            _x.info = info;
            _x.keyCredentials = keyCredentials;
            _x.keyCredentialsNextLink = keyCredentialsNextLink;
            _x.loginUrl = loginUrl;
            _x.logoutUrl = logoutUrl;
            _x.notes = notes;
            _x.notificationEmailAddresses = notificationEmailAddresses;
            _x.notificationEmailAddressesNextLink = notificationEmailAddressesNextLink;
            _x.publishedPermissionScopes = publishedPermissionScopes;
            _x.publishedPermissionScopesNextLink = publishedPermissionScopesNextLink;
            _x.passwordCredentials = passwordCredentials;
            _x.passwordCredentialsNextLink = passwordCredentialsNextLink;
            _x.preferredTokenSigningKeyEndDateTime = preferredTokenSigningKeyEndDateTime;
            _x.preferredTokenSigningKeyThumbprint = preferredTokenSigningKeyThumbprint;
            _x.preferredSingleSignOnMode = preferredSingleSignOnMode;
            _x.publisherName = publisherName;
            _x.replyUrls = replyUrls;
            _x.replyUrlsNextLink = replyUrlsNextLink;
            _x.samlMetadataUrl = samlMetadataUrl;
            _x.samlSingleSignOnSettings = samlSingleSignOnSettings;
            _x.servicePrincipalNames = servicePrincipalNames;
            _x.servicePrincipalNamesNextLink = servicePrincipalNamesNextLink;
            _x.servicePrincipalType = servicePrincipalType;
            _x.signInAudience = signInAudience;
            _x.tags = tags;
            _x.tagsNextLink = tagsNextLink;
            _x.tokenEncryptionKeyId = tokenEncryptionKeyId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="accountEnabled")
    @JsonIgnore
    public Optional<Boolean> getAccountEnabled() {
        return Optional.ofNullable(accountEnabled);
    }

    public ServicePrincipal withAccountEnabled(Boolean accountEnabled) {
        ServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("accountEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipal");
        _x.accountEnabled = accountEnabled;
        return _x;
    }

    @Property(name="addIns")
    @JsonIgnore
    public CollectionPage<AddIn> getAddIns() {
        return new CollectionPage<AddIn>(contextPath, AddIn.class, addIns, Optional.ofNullable(addInsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="addIns")
    @JsonIgnore
    public CollectionPage<AddIn> getAddIns(HttpRequestOptions options) {
        return new CollectionPage<AddIn>(contextPath, AddIn.class, addIns, Optional.ofNullable(addInsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="alternativeNames")
    @JsonIgnore
    public CollectionPage<String> getAlternativeNames() {
        return new CollectionPage<String>(contextPath, String.class, alternativeNames, Optional.ofNullable(alternativeNamesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="alternativeNames")
    @JsonIgnore
    public CollectionPage<String> getAlternativeNames(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, alternativeNames, Optional.ofNullable(alternativeNamesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="appDescription")
    @JsonIgnore
    public Optional<String> getAppDescription() {
        return Optional.ofNullable(appDescription);
    }

    public ServicePrincipal withAppDescription(String appDescription) {
        ServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("appDescription");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipal");
        _x.appDescription = appDescription;
        return _x;
    }

    @Property(name="appDisplayName")
    @JsonIgnore
    public Optional<String> getAppDisplayName() {
        return Optional.ofNullable(appDisplayName);
    }

    public ServicePrincipal withAppDisplayName(String appDisplayName) {
        ServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("appDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipal");
        _x.appDisplayName = appDisplayName;
        return _x;
    }

    @Property(name="appId")
    @JsonIgnore
    public Optional<String> getAppId() {
        return Optional.ofNullable(appId);
    }

    public ServicePrincipal withAppId(String appId) {
        ServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("appId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipal");
        _x.appId = appId;
        return _x;
    }

    @Property(name="applicationTemplateId")
    @JsonIgnore
    public Optional<String> getApplicationTemplateId() {
        return Optional.ofNullable(applicationTemplateId);
    }

    public ServicePrincipal withApplicationTemplateId(String applicationTemplateId) {
        ServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("applicationTemplateId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipal");
        _x.applicationTemplateId = applicationTemplateId;
        return _x;
    }

    @Property(name="appOwnerOrganizationId")
    @JsonIgnore
    public Optional<String> getAppOwnerOrganizationId() {
        return Optional.ofNullable(appOwnerOrganizationId);
    }

    public ServicePrincipal withAppOwnerOrganizationId(String appOwnerOrganizationId) {
        ServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("appOwnerOrganizationId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipal");
        _x.appOwnerOrganizationId = appOwnerOrganizationId;
        return _x;
    }

    @Property(name="appRoleAssignmentRequired")
    @JsonIgnore
    public Optional<Boolean> getAppRoleAssignmentRequired() {
        return Optional.ofNullable(appRoleAssignmentRequired);
    }

    public ServicePrincipal withAppRoleAssignmentRequired(Boolean appRoleAssignmentRequired) {
        ServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("appRoleAssignmentRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipal");
        _x.appRoleAssignmentRequired = appRoleAssignmentRequired;
        return _x;
    }

    @Property(name="appRoles")
    @JsonIgnore
    public CollectionPage<AppRole> getAppRoles() {
        return new CollectionPage<AppRole>(contextPath, AppRole.class, appRoles, Optional.ofNullable(appRolesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="appRoles")
    @JsonIgnore
    public CollectionPage<AppRole> getAppRoles(HttpRequestOptions options) {
        return new CollectionPage<AppRole>(contextPath, AppRole.class, appRoles, Optional.ofNullable(appRolesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public ServicePrincipal withDescription(String description) {
        ServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipal");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ServicePrincipal withDisplayName(String displayName) {
        ServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipal");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="errorUrl")
    @JsonIgnore
    public Optional<String> getErrorUrl() {
        return Optional.ofNullable(errorUrl);
    }

    public ServicePrincipal withErrorUrl(String errorUrl) {
        ServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("errorUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipal");
        _x.errorUrl = errorUrl;
        return _x;
    }

    @Property(name="homepage")
    @JsonIgnore
    public Optional<String> getHomepage() {
        return Optional.ofNullable(homepage);
    }

    public ServicePrincipal withHomepage(String homepage) {
        ServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("homepage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipal");
        _x.homepage = homepage;
        return _x;
    }

    @Property(name="info")
    @JsonIgnore
    public Optional<InformationalUrl> getInfo() {
        return Optional.ofNullable(info);
    }

    public ServicePrincipal withInfo(InformationalUrl info) {
        ServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("info");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipal");
        _x.info = info;
        return _x;
    }

    @Property(name="keyCredentials")
    @JsonIgnore
    public CollectionPage<KeyCredential> getKeyCredentials() {
        return new CollectionPage<KeyCredential>(contextPath, KeyCredential.class, keyCredentials, Optional.ofNullable(keyCredentialsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="keyCredentials")
    @JsonIgnore
    public CollectionPage<KeyCredential> getKeyCredentials(HttpRequestOptions options) {
        return new CollectionPage<KeyCredential>(contextPath, KeyCredential.class, keyCredentials, Optional.ofNullable(keyCredentialsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="loginUrl")
    @JsonIgnore
    public Optional<String> getLoginUrl() {
        return Optional.ofNullable(loginUrl);
    }

    public ServicePrincipal withLoginUrl(String loginUrl) {
        ServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("loginUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipal");
        _x.loginUrl = loginUrl;
        return _x;
    }

    @Property(name="logoutUrl")
    @JsonIgnore
    public Optional<String> getLogoutUrl() {
        return Optional.ofNullable(logoutUrl);
    }

    public ServicePrincipal withLogoutUrl(String logoutUrl) {
        ServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("logoutUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipal");
        _x.logoutUrl = logoutUrl;
        return _x;
    }

    @Property(name="notes")
    @JsonIgnore
    public Optional<String> getNotes() {
        return Optional.ofNullable(notes);
    }

    public ServicePrincipal withNotes(String notes) {
        ServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("notes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipal");
        _x.notes = notes;
        return _x;
    }

    @Property(name="notificationEmailAddresses")
    @JsonIgnore
    public CollectionPage<String> getNotificationEmailAddresses() {
        return new CollectionPage<String>(contextPath, String.class, notificationEmailAddresses, Optional.ofNullable(notificationEmailAddressesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="notificationEmailAddresses")
    @JsonIgnore
    public CollectionPage<String> getNotificationEmailAddresses(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, notificationEmailAddresses, Optional.ofNullable(notificationEmailAddressesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="publishedPermissionScopes")
    @JsonIgnore
    public CollectionPage<PermissionScope> getPublishedPermissionScopes() {
        return new CollectionPage<PermissionScope>(contextPath, PermissionScope.class, publishedPermissionScopes, Optional.ofNullable(publishedPermissionScopesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="publishedPermissionScopes")
    @JsonIgnore
    public CollectionPage<PermissionScope> getPublishedPermissionScopes(HttpRequestOptions options) {
        return new CollectionPage<PermissionScope>(contextPath, PermissionScope.class, publishedPermissionScopes, Optional.ofNullable(publishedPermissionScopesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="passwordCredentials")
    @JsonIgnore
    public CollectionPage<PasswordCredential> getPasswordCredentials() {
        return new CollectionPage<PasswordCredential>(contextPath, PasswordCredential.class, passwordCredentials, Optional.ofNullable(passwordCredentialsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="passwordCredentials")
    @JsonIgnore
    public CollectionPage<PasswordCredential> getPasswordCredentials(HttpRequestOptions options) {
        return new CollectionPage<PasswordCredential>(contextPath, PasswordCredential.class, passwordCredentials, Optional.ofNullable(passwordCredentialsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="preferredTokenSigningKeyEndDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getPreferredTokenSigningKeyEndDateTime() {
        return Optional.ofNullable(preferredTokenSigningKeyEndDateTime);
    }

    public ServicePrincipal withPreferredTokenSigningKeyEndDateTime(OffsetDateTime preferredTokenSigningKeyEndDateTime) {
        ServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("preferredTokenSigningKeyEndDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipal");
        _x.preferredTokenSigningKeyEndDateTime = preferredTokenSigningKeyEndDateTime;
        return _x;
    }

    @Property(name="preferredTokenSigningKeyThumbprint")
    @JsonIgnore
    public Optional<String> getPreferredTokenSigningKeyThumbprint() {
        return Optional.ofNullable(preferredTokenSigningKeyThumbprint);
    }

    public ServicePrincipal withPreferredTokenSigningKeyThumbprint(String preferredTokenSigningKeyThumbprint) {
        ServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("preferredTokenSigningKeyThumbprint");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipal");
        _x.preferredTokenSigningKeyThumbprint = preferredTokenSigningKeyThumbprint;
        return _x;
    }

    @Property(name="preferredSingleSignOnMode")
    @JsonIgnore
    public Optional<String> getPreferredSingleSignOnMode() {
        return Optional.ofNullable(preferredSingleSignOnMode);
    }

    public ServicePrincipal withPreferredSingleSignOnMode(String preferredSingleSignOnMode) {
        ServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("preferredSingleSignOnMode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipal");
        _x.preferredSingleSignOnMode = preferredSingleSignOnMode;
        return _x;
    }

    @Property(name="publisherName")
    @JsonIgnore
    public Optional<String> getPublisherName() {
        return Optional.ofNullable(publisherName);
    }

    public ServicePrincipal withPublisherName(String publisherName) {
        ServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("publisherName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipal");
        _x.publisherName = publisherName;
        return _x;
    }

    @Property(name="replyUrls")
    @JsonIgnore
    public CollectionPage<String> getReplyUrls() {
        return new CollectionPage<String>(contextPath, String.class, replyUrls, Optional.ofNullable(replyUrlsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="replyUrls")
    @JsonIgnore
    public CollectionPage<String> getReplyUrls(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, replyUrls, Optional.ofNullable(replyUrlsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="samlMetadataUrl")
    @JsonIgnore
    public Optional<String> getSamlMetadataUrl() {
        return Optional.ofNullable(samlMetadataUrl);
    }

    public ServicePrincipal withSamlMetadataUrl(String samlMetadataUrl) {
        ServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("samlMetadataUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipal");
        _x.samlMetadataUrl = samlMetadataUrl;
        return _x;
    }

    @Property(name="samlSingleSignOnSettings")
    @JsonIgnore
    public Optional<SamlSingleSignOnSettings> getSamlSingleSignOnSettings() {
        return Optional.ofNullable(samlSingleSignOnSettings);
    }

    public ServicePrincipal withSamlSingleSignOnSettings(SamlSingleSignOnSettings samlSingleSignOnSettings) {
        ServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("samlSingleSignOnSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipal");
        _x.samlSingleSignOnSettings = samlSingleSignOnSettings;
        return _x;
    }

    @Property(name="servicePrincipalNames")
    @JsonIgnore
    public CollectionPage<String> getServicePrincipalNames() {
        return new CollectionPage<String>(contextPath, String.class, servicePrincipalNames, Optional.ofNullable(servicePrincipalNamesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="servicePrincipalNames")
    @JsonIgnore
    public CollectionPage<String> getServicePrincipalNames(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, servicePrincipalNames, Optional.ofNullable(servicePrincipalNamesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="servicePrincipalType")
    @JsonIgnore
    public Optional<String> getServicePrincipalType() {
        return Optional.ofNullable(servicePrincipalType);
    }

    public ServicePrincipal withServicePrincipalType(String servicePrincipalType) {
        ServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("servicePrincipalType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipal");
        _x.servicePrincipalType = servicePrincipalType;
        return _x;
    }

    @Property(name="signInAudience")
    @JsonIgnore
    public Optional<String> getSignInAudience() {
        return Optional.ofNullable(signInAudience);
    }

    public ServicePrincipal withSignInAudience(String signInAudience) {
        ServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("signInAudience");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipal");
        _x.signInAudience = signInAudience;
        return _x;
    }

    @Property(name="tags")
    @JsonIgnore
    public CollectionPage<String> getTags() {
        return new CollectionPage<String>(contextPath, String.class, tags, Optional.ofNullable(tagsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="tags")
    @JsonIgnore
    public CollectionPage<String> getTags(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, tags, Optional.ofNullable(tagsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="tokenEncryptionKeyId")
    @JsonIgnore
    public Optional<String> getTokenEncryptionKeyId() {
        return Optional.ofNullable(tokenEncryptionKeyId);
    }

    public ServicePrincipal withTokenEncryptionKeyId(String tokenEncryptionKeyId) {
        ServicePrincipal _x = _copy();
        _x.changedFields = changedFields.add("tokenEncryptionKeyId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.servicePrincipal");
        _x.tokenEncryptionKeyId = tokenEncryptionKeyId;
        return _x;
    }

    @NavigationProperty(name="appRoleAssignedTo")
    @JsonIgnore
    public AppRoleAssignmentCollectionRequest getAppRoleAssignedTo() {
        return new AppRoleAssignmentCollectionRequest(
                        contextPath.addSegment("appRoleAssignedTo"));
    }

    @NavigationProperty(name="appRoleAssignments")
    @JsonIgnore
    public AppRoleAssignmentCollectionRequest getAppRoleAssignments() {
        return new AppRoleAssignmentCollectionRequest(
                        contextPath.addSegment("appRoleAssignments"));
    }

    @NavigationProperty(name="claimsMappingPolicies")
    @JsonIgnore
    public ClaimsMappingPolicyCollectionRequest getClaimsMappingPolicies() {
        return new ClaimsMappingPolicyCollectionRequest(
                        contextPath.addSegment("claimsMappingPolicies"));
    }

    @NavigationProperty(name="homeRealmDiscoveryPolicies")
    @JsonIgnore
    public HomeRealmDiscoveryPolicyCollectionRequest getHomeRealmDiscoveryPolicies() {
        return new HomeRealmDiscoveryPolicyCollectionRequest(
                        contextPath.addSegment("homeRealmDiscoveryPolicies"));
    }

    @NavigationProperty(name="endpoints")
    @JsonIgnore
    public EndpointCollectionRequest getEndpoints() {
        return new EndpointCollectionRequest(
                        contextPath.addSegment("endpoints"));
    }

    @NavigationProperty(name="oauth2PermissionGrants")
    @JsonIgnore
    public OAuth2PermissionGrantCollectionRequest getOauth2PermissionGrants() {
        return new OAuth2PermissionGrantCollectionRequest(
                        contextPath.addSegment("oauth2PermissionGrants"));
    }

    @NavigationProperty(name="memberOf")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getMemberOf() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("memberOf"));
    }

    @NavigationProperty(name="transitiveMemberOf")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getTransitiveMemberOf() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("transitiveMemberOf"));
    }

    @NavigationProperty(name="createdObjects")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getCreatedObjects() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("createdObjects"));
    }

    @NavigationProperty(name="licenseDetails")
    @JsonIgnore
    public LicenseDetailsCollectionRequest getLicenseDetails() {
        return new LicenseDetailsCollectionRequest(
                        contextPath.addSegment("licenseDetails"));
    }

    @NavigationProperty(name="owners")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getOwners() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("owners"));
    }

    @NavigationProperty(name="ownedObjects")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getOwnedObjects() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("ownedObjects"));
    }

    @NavigationProperty(name="tokenIssuancePolicies")
    @JsonIgnore
    public TokenIssuancePolicyCollectionRequest getTokenIssuancePolicies() {
        return new TokenIssuancePolicyCollectionRequest(
                        contextPath.addSegment("tokenIssuancePolicies"));
    }

    @NavigationProperty(name="tokenLifetimePolicies")
    @JsonIgnore
    public TokenLifetimePolicyCollectionRequest getTokenLifetimePolicies() {
        return new TokenLifetimePolicyCollectionRequest(
                        contextPath.addSegment("tokenLifetimePolicies"));
    }

    @NavigationProperty(name="synchronization")
    @JsonIgnore
    public SynchronizationRequest getSynchronization() {
        return new SynchronizationRequest(contextPath.addSegment("synchronization"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ServicePrincipal patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ServicePrincipal _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ServicePrincipal put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ServicePrincipal _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ServicePrincipal _copy() {
        ServicePrincipal _x = new ServicePrincipal();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.deletedDateTime = deletedDateTime;
        _x.accountEnabled = accountEnabled;
        _x.addIns = addIns;
        _x.alternativeNames = alternativeNames;
        _x.appDescription = appDescription;
        _x.appDisplayName = appDisplayName;
        _x.appId = appId;
        _x.applicationTemplateId = applicationTemplateId;
        _x.appOwnerOrganizationId = appOwnerOrganizationId;
        _x.appRoleAssignmentRequired = appRoleAssignmentRequired;
        _x.appRoles = appRoles;
        _x.description = description;
        _x.displayName = displayName;
        _x.errorUrl = errorUrl;
        _x.homepage = homepage;
        _x.info = info;
        _x.keyCredentials = keyCredentials;
        _x.loginUrl = loginUrl;
        _x.logoutUrl = logoutUrl;
        _x.notes = notes;
        _x.notificationEmailAddresses = notificationEmailAddresses;
        _x.publishedPermissionScopes = publishedPermissionScopes;
        _x.passwordCredentials = passwordCredentials;
        _x.preferredTokenSigningKeyEndDateTime = preferredTokenSigningKeyEndDateTime;
        _x.preferredTokenSigningKeyThumbprint = preferredTokenSigningKeyThumbprint;
        _x.preferredSingleSignOnMode = preferredSingleSignOnMode;
        _x.publisherName = publisherName;
        _x.replyUrls = replyUrls;
        _x.samlMetadataUrl = samlMetadataUrl;
        _x.samlSingleSignOnSettings = samlSingleSignOnSettings;
        _x.servicePrincipalNames = servicePrincipalNames;
        _x.servicePrincipalType = servicePrincipalType;
        _x.signInAudience = signInAudience;
        _x.tags = tags;
        _x.tokenEncryptionKeyId = tokenEncryptionKeyId;
        return _x;
    }

    @Action(name = "createPasswordSingleSignOnCredentials")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PasswordSingleSignOnCredentialSet> createPasswordSingleSignOnCredentials(String id, List<Credential> credentials) {
        Preconditions.checkNotNull(id, "id cannot be null");
        Preconditions.checkNotNull(credentials, "credentials cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("id", "Edm.String", Checks.checkIsAscii(id))
            .put("credentials", "Collection(microsoft.graph.credential)", credentials)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<PasswordSingleSignOnCredentialSet>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createPasswordSingleSignOnCredentials"), PasswordSingleSignOnCredentialSet.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "getPasswordSingleSignOnCredentials")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PasswordSingleSignOnCredentialSet> getPasswordSingleSignOnCredentials(String id) {
        Preconditions.checkNotNull(id, "id cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("id", "Edm.String", Checks.checkIsAscii(id))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<PasswordSingleSignOnCredentialSet>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getPasswordSingleSignOnCredentials"), PasswordSingleSignOnCredentialSet.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "deletePasswordSingleSignOnCredentials")
    @JsonIgnore
    public ActionRequestNoReturn deletePasswordSingleSignOnCredentials(String id) {
        Preconditions.checkNotNull(id, "id cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("id", "Edm.String", Checks.checkIsAscii(id))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.deletePasswordSingleSignOnCredentials"), _parameters);
    }

    @Action(name = "updatePasswordSingleSignOnCredentials")
    @JsonIgnore
    public ActionRequestNoReturn updatePasswordSingleSignOnCredentials(String id, List<Credential> credentials) {
        Preconditions.checkNotNull(id, "id cannot be null");
        Preconditions.checkNotNull(credentials, "credentials cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("id", "Edm.String", Checks.checkIsAscii(id))
            .put("credentials", "Collection(microsoft.graph.credential)", credentials)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updatePasswordSingleSignOnCredentials"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ServicePrincipal[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deletedDateTime=");
        b.append(this.deletedDateTime);
        b.append(", ");
        b.append("accountEnabled=");
        b.append(this.accountEnabled);
        b.append(", ");
        b.append("addIns=");
        b.append(this.addIns);
        b.append(", ");
        b.append("alternativeNames=");
        b.append(this.alternativeNames);
        b.append(", ");
        b.append("appDescription=");
        b.append(this.appDescription);
        b.append(", ");
        b.append("appDisplayName=");
        b.append(this.appDisplayName);
        b.append(", ");
        b.append("appId=");
        b.append(this.appId);
        b.append(", ");
        b.append("applicationTemplateId=");
        b.append(this.applicationTemplateId);
        b.append(", ");
        b.append("appOwnerOrganizationId=");
        b.append(this.appOwnerOrganizationId);
        b.append(", ");
        b.append("appRoleAssignmentRequired=");
        b.append(this.appRoleAssignmentRequired);
        b.append(", ");
        b.append("appRoles=");
        b.append(this.appRoles);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("errorUrl=");
        b.append(this.errorUrl);
        b.append(", ");
        b.append("homepage=");
        b.append(this.homepage);
        b.append(", ");
        b.append("info=");
        b.append(this.info);
        b.append(", ");
        b.append("keyCredentials=");
        b.append(this.keyCredentials);
        b.append(", ");
        b.append("loginUrl=");
        b.append(this.loginUrl);
        b.append(", ");
        b.append("logoutUrl=");
        b.append(this.logoutUrl);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("notificationEmailAddresses=");
        b.append(this.notificationEmailAddresses);
        b.append(", ");
        b.append("publishedPermissionScopes=");
        b.append(this.publishedPermissionScopes);
        b.append(", ");
        b.append("passwordCredentials=");
        b.append(this.passwordCredentials);
        b.append(", ");
        b.append("preferredTokenSigningKeyEndDateTime=");
        b.append(this.preferredTokenSigningKeyEndDateTime);
        b.append(", ");
        b.append("preferredTokenSigningKeyThumbprint=");
        b.append(this.preferredTokenSigningKeyThumbprint);
        b.append(", ");
        b.append("preferredSingleSignOnMode=");
        b.append(this.preferredSingleSignOnMode);
        b.append(", ");
        b.append("publisherName=");
        b.append(this.publisherName);
        b.append(", ");
        b.append("replyUrls=");
        b.append(this.replyUrls);
        b.append(", ");
        b.append("samlMetadataUrl=");
        b.append(this.samlMetadataUrl);
        b.append(", ");
        b.append("samlSingleSignOnSettings=");
        b.append(this.samlSingleSignOnSettings);
        b.append(", ");
        b.append("servicePrincipalNames=");
        b.append(this.servicePrincipalNames);
        b.append(", ");
        b.append("servicePrincipalType=");
        b.append(this.servicePrincipalType);
        b.append(", ");
        b.append("signInAudience=");
        b.append(this.signInAudience);
        b.append(", ");
        b.append("tags=");
        b.append(this.tags);
        b.append(", ");
        b.append("tokenEncryptionKeyId=");
        b.append(this.tokenEncryptionKeyId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
