package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.SensitivityLabelTarget;

@JsonPropertyOrder({
    "@odata.type", 
    "isMandatory", 
    "helpWebUrl", 
    "downgradeSensitivityRequiresJustification", 
    "applicableTo"})
@JsonInclude(Include.NON_NULL)
public class SensitivityPolicySettings extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.sensitivityPolicySettings";
    }

    @JsonProperty("isMandatory")
    protected Boolean isMandatory;

    @JsonProperty("helpWebUrl")
    protected String helpWebUrl;

    @JsonProperty("downgradeSensitivityRequiresJustification")
    protected Boolean downgradeSensitivityRequiresJustification;

    @JsonProperty("applicableTo")
    protected SensitivityLabelTarget applicableTo;

    protected SensitivityPolicySettings() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSensitivityPolicySettings() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean isMandatory;
        private String helpWebUrl;
        private Boolean downgradeSensitivityRequiresJustification;
        private SensitivityLabelTarget applicableTo;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder isMandatory(Boolean isMandatory) {
            this.isMandatory = isMandatory;
            this.changedFields = changedFields.add("isMandatory");
            return this;
        }

        public Builder helpWebUrl(String helpWebUrl) {
            this.helpWebUrl = helpWebUrl;
            this.changedFields = changedFields.add("helpWebUrl");
            return this;
        }

        public Builder downgradeSensitivityRequiresJustification(Boolean downgradeSensitivityRequiresJustification) {
            this.downgradeSensitivityRequiresJustification = downgradeSensitivityRequiresJustification;
            this.changedFields = changedFields.add("downgradeSensitivityRequiresJustification");
            return this;
        }

        public Builder applicableTo(SensitivityLabelTarget applicableTo) {
            this.applicableTo = applicableTo;
            this.changedFields = changedFields.add("applicableTo");
            return this;
        }

        public SensitivityPolicySettings build() {
            SensitivityPolicySettings _x = new SensitivityPolicySettings();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.sensitivityPolicySettings";
            _x.id = id;
            _x.isMandatory = isMandatory;
            _x.helpWebUrl = helpWebUrl;
            _x.downgradeSensitivityRequiresJustification = downgradeSensitivityRequiresJustification;
            _x.applicableTo = applicableTo;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="isMandatory")
    @JsonIgnore
    public Optional<Boolean> getIsMandatory() {
        return Optional.ofNullable(isMandatory);
    }

    public SensitivityPolicySettings withIsMandatory(Boolean isMandatory) {
        SensitivityPolicySettings _x = _copy();
        _x.changedFields = changedFields.add("isMandatory");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitivityPolicySettings");
        _x.isMandatory = isMandatory;
        return _x;
    }

    @Property(name="helpWebUrl")
    @JsonIgnore
    public Optional<String> getHelpWebUrl() {
        return Optional.ofNullable(helpWebUrl);
    }

    public SensitivityPolicySettings withHelpWebUrl(String helpWebUrl) {
        SensitivityPolicySettings _x = _copy();
        _x.changedFields = changedFields.add("helpWebUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitivityPolicySettings");
        _x.helpWebUrl = helpWebUrl;
        return _x;
    }

    @Property(name="downgradeSensitivityRequiresJustification")
    @JsonIgnore
    public Optional<Boolean> getDowngradeSensitivityRequiresJustification() {
        return Optional.ofNullable(downgradeSensitivityRequiresJustification);
    }

    public SensitivityPolicySettings withDowngradeSensitivityRequiresJustification(Boolean downgradeSensitivityRequiresJustification) {
        SensitivityPolicySettings _x = _copy();
        _x.changedFields = changedFields.add("downgradeSensitivityRequiresJustification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitivityPolicySettings");
        _x.downgradeSensitivityRequiresJustification = downgradeSensitivityRequiresJustification;
        return _x;
    }

    @Property(name="applicableTo")
    @JsonIgnore
    public Optional<SensitivityLabelTarget> getApplicableTo() {
        return Optional.ofNullable(applicableTo);
    }

    public SensitivityPolicySettings withApplicableTo(SensitivityLabelTarget applicableTo) {
        SensitivityPolicySettings _x = _copy();
        _x.changedFields = changedFields.add("applicableTo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.sensitivityPolicySettings");
        _x.applicableTo = applicableTo;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SensitivityPolicySettings patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SensitivityPolicySettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SensitivityPolicySettings put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SensitivityPolicySettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SensitivityPolicySettings _copy() {
        SensitivityPolicySettings _x = new SensitivityPolicySettings();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.isMandatory = isMandatory;
        _x.helpWebUrl = helpWebUrl;
        _x.downgradeSensitivityRequiresJustification = downgradeSensitivityRequiresJustification;
        _x.applicableTo = applicableTo;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SensitivityPolicySettings[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("isMandatory=");
        b.append(this.isMandatory);
        b.append(", ");
        b.append("helpWebUrl=");
        b.append(this.helpWebUrl);
        b.append(", ");
        b.append("downgradeSensitivityRequiresJustification=");
        b.append(this.downgradeSensitivityRequiresJustification);
        b.append(", ");
        b.append("applicableTo=");
        b.append(this.applicableTo);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
