package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;

import odata.msgraph.client.beta.entity.collection.request.SecurityBaselineCategoryStateSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SecurityBaselineDeviceStateCollectionRequest;
import odata.msgraph.client.beta.entity.request.SecurityBaselineStateSummaryRequest;
import odata.msgraph.client.beta.enums.DeviceManagementTemplateSubtype;
import odata.msgraph.client.beta.enums.DeviceManagementTemplateType;
import odata.msgraph.client.beta.enums.PolicyPlatformType;


/**
 * <i>“The security baseline template of the account”</i>
 */@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class SecurityBaselineTemplate extends DeviceManagementTemplate implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.securityBaselineTemplate";
    }

    protected SecurityBaselineTemplate() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSecurityBaselineTemplate() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private String versionInfo;
        private Boolean isDeprecated;
        private Integer intentCount;
        private DeviceManagementTemplateType templateType;
        private PolicyPlatformType platformType;
        private DeviceManagementTemplateSubtype templateSubtype;
        private OffsetDateTime publishedDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder versionInfo(String versionInfo) {
            this.versionInfo = versionInfo;
            this.changedFields = changedFields.add("versionInfo");
            return this;
        }

        public Builder isDeprecated(Boolean isDeprecated) {
            this.isDeprecated = isDeprecated;
            this.changedFields = changedFields.add("isDeprecated");
            return this;
        }

        public Builder intentCount(Integer intentCount) {
            this.intentCount = intentCount;
            this.changedFields = changedFields.add("intentCount");
            return this;
        }

        public Builder templateType(DeviceManagementTemplateType templateType) {
            this.templateType = templateType;
            this.changedFields = changedFields.add("templateType");
            return this;
        }

        public Builder platformType(PolicyPlatformType platformType) {
            this.platformType = platformType;
            this.changedFields = changedFields.add("platformType");
            return this;
        }

        public Builder templateSubtype(DeviceManagementTemplateSubtype templateSubtype) {
            this.templateSubtype = templateSubtype;
            this.changedFields = changedFields.add("templateSubtype");
            return this;
        }

        public Builder publishedDateTime(OffsetDateTime publishedDateTime) {
            this.publishedDateTime = publishedDateTime;
            this.changedFields = changedFields.add("publishedDateTime");
            return this;
        }

        public SecurityBaselineTemplate build() {
            SecurityBaselineTemplate _x = new SecurityBaselineTemplate();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.securityBaselineTemplate";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.versionInfo = versionInfo;
            _x.isDeprecated = isDeprecated;
            _x.intentCount = intentCount;
            _x.templateType = templateType;
            _x.platformType = platformType;
            _x.templateSubtype = templateSubtype;
            _x.publishedDateTime = publishedDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The security baseline device state summary”</i>
     * 
     * @return navigational property deviceStateSummary
     */
    @NavigationProperty(name="deviceStateSummary")
    @JsonIgnore
    public SecurityBaselineStateSummaryRequest getDeviceStateSummary() {
        return new SecurityBaselineStateSummaryRequest(contextPath.addSegment("deviceStateSummary"));
    }

    /**
     * <i>“The security baseline device states”</i>
     * 
     * @return navigational property deviceStates
     */
    @NavigationProperty(name="deviceStates")
    @JsonIgnore
    public SecurityBaselineDeviceStateCollectionRequest getDeviceStates() {
        return new SecurityBaselineDeviceStateCollectionRequest(
                        contextPath.addSegment("deviceStates"));
    }

    /**
     * <i>“The security baseline per category device state summary”</i>
     * 
     * @return navigational property categoryDeviceStateSummaries
     */
    @NavigationProperty(name="categoryDeviceStateSummaries")
    @JsonIgnore
    public SecurityBaselineCategoryStateSummaryCollectionRequest getCategoryDeviceStateSummaries() {
        return new SecurityBaselineCategoryStateSummaryCollectionRequest(
                        contextPath.addSegment("categoryDeviceStateSummaries"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SecurityBaselineTemplate patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SecurityBaselineTemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SecurityBaselineTemplate put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SecurityBaselineTemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SecurityBaselineTemplate _copy() {
        SecurityBaselineTemplate _x = new SecurityBaselineTemplate();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.versionInfo = versionInfo;
        _x.isDeprecated = isDeprecated;
        _x.intentCount = intentCount;
        _x.templateType = templateType;
        _x.platformType = platformType;
        _x.templateSubtype = templateSubtype;
        _x.publishedDateTime = publishedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SecurityBaselineTemplate[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("versionInfo=");
        b.append(this.versionInfo);
        b.append(", ");
        b.append("isDeprecated=");
        b.append(this.isDeprecated);
        b.append(", ");
        b.append("intentCount=");
        b.append(this.intentCount);
        b.append(", ");
        b.append("templateType=");
        b.append(this.templateType);
        b.append(", ");
        b.append("platformType=");
        b.append(this.platformType);
        b.append(", ");
        b.append("templateSubtype=");
        b.append(this.templateSubtype);
        b.append(", ");
        b.append("publishedDateTime=");
        b.append(this.publishedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
