package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“The security baseline compliance state summary for the security baseline of the
 * account.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "secureCount", 
    "notSecureCount", 
    "unknownCount", 
    "errorCount", 
    "conflictCount", 
    "notApplicableCount"})
@JsonInclude(Include.NON_NULL)
public class SecurityBaselineStateSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.securityBaselineStateSummary";
    }

    @JsonProperty("secureCount")
    protected Integer secureCount;

    @JsonProperty("notSecureCount")
    protected Integer notSecureCount;

    @JsonProperty("unknownCount")
    protected Integer unknownCount;

    @JsonProperty("errorCount")
    protected Integer errorCount;

    @JsonProperty("conflictCount")
    protected Integer conflictCount;

    @JsonProperty("notApplicableCount")
    protected Integer notApplicableCount;

    protected SecurityBaselineStateSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSecurityBaselineStateSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer secureCount;
        private Integer notSecureCount;
        private Integer unknownCount;
        private Integer errorCount;
        private Integer conflictCount;
        private Integer notApplicableCount;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Number of secure devices”</i>
         * 
         * @param secureCount
         *            value of {@code secureCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder secureCount(Integer secureCount) {
            this.secureCount = secureCount;
            this.changedFields = changedFields.add("secureCount");
            return this;
        }

        /**
         * <i>“Number of not secure devices”</i>
         * 
         * @param notSecureCount
         *            value of {@code notSecureCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notSecureCount(Integer notSecureCount) {
            this.notSecureCount = notSecureCount;
            this.changedFields = changedFields.add("notSecureCount");
            return this;
        }

        /**
         * <i>“Number of unknown devices”</i>
         * 
         * @param unknownCount
         *            value of {@code unknownCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder unknownCount(Integer unknownCount) {
            this.unknownCount = unknownCount;
            this.changedFields = changedFields.add("unknownCount");
            return this;
        }

        /**
         * <i>“Number of error devices”</i>
         * 
         * @param errorCount
         *            value of {@code errorCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorCount(Integer errorCount) {
            this.errorCount = errorCount;
            this.changedFields = changedFields.add("errorCount");
            return this;
        }

        /**
         * <i>“Number of conflict devices”</i>
         * 
         * @param conflictCount
         *            value of {@code conflictCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder conflictCount(Integer conflictCount) {
            this.conflictCount = conflictCount;
            this.changedFields = changedFields.add("conflictCount");
            return this;
        }

        /**
         * <i>“Number of not applicable devices”</i>
         * 
         * @param notApplicableCount
         *            value of {@code notApplicableCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notApplicableCount(Integer notApplicableCount) {
            this.notApplicableCount = notApplicableCount;
            this.changedFields = changedFields.add("notApplicableCount");
            return this;
        }

        public SecurityBaselineStateSummary build() {
            SecurityBaselineStateSummary _x = new SecurityBaselineStateSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.securityBaselineStateSummary";
            _x.id = id;
            _x.secureCount = secureCount;
            _x.notSecureCount = notSecureCount;
            _x.unknownCount = unknownCount;
            _x.errorCount = errorCount;
            _x.conflictCount = conflictCount;
            _x.notApplicableCount = notApplicableCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Number of secure devices”</i>
     * 
     * @return property secureCount
     */
    @Property(name="secureCount")
    @JsonIgnore
    public Optional<Integer> getSecureCount() {
        return Optional.ofNullable(secureCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code secureCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of secure devices”</i>
     * 
     * @param secureCount
     *            new value of {@code secureCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code secureCount} field changed
     */
    public SecurityBaselineStateSummary withSecureCount(Integer secureCount) {
        SecurityBaselineStateSummary _x = _copy();
        _x.changedFields = changedFields.add("secureCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineStateSummary");
        _x.secureCount = secureCount;
        return _x;
    }

    /**
     * <i>“Number of not secure devices”</i>
     * 
     * @return property notSecureCount
     */
    @Property(name="notSecureCount")
    @JsonIgnore
    public Optional<Integer> getNotSecureCount() {
        return Optional.ofNullable(notSecureCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code notSecureCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of not secure devices”</i>
     * 
     * @param notSecureCount
     *            new value of {@code notSecureCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notSecureCount} field changed
     */
    public SecurityBaselineStateSummary withNotSecureCount(Integer notSecureCount) {
        SecurityBaselineStateSummary _x = _copy();
        _x.changedFields = changedFields.add("notSecureCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineStateSummary");
        _x.notSecureCount = notSecureCount;
        return _x;
    }

    /**
     * <i>“Number of unknown devices”</i>
     * 
     * @return property unknownCount
     */
    @Property(name="unknownCount")
    @JsonIgnore
    public Optional<Integer> getUnknownCount() {
        return Optional.ofNullable(unknownCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code unknownCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of unknown devices”</i>
     * 
     * @param unknownCount
     *            new value of {@code unknownCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code unknownCount} field changed
     */
    public SecurityBaselineStateSummary withUnknownCount(Integer unknownCount) {
        SecurityBaselineStateSummary _x = _copy();
        _x.changedFields = changedFields.add("unknownCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineStateSummary");
        _x.unknownCount = unknownCount;
        return _x;
    }

    /**
     * <i>“Number of error devices”</i>
     * 
     * @return property errorCount
     */
    @Property(name="errorCount")
    @JsonIgnore
    public Optional<Integer> getErrorCount() {
        return Optional.ofNullable(errorCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorCount} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Number of error devices”</i>
     * 
     * @param errorCount
     *            new value of {@code errorCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorCount} field changed
     */
    public SecurityBaselineStateSummary withErrorCount(Integer errorCount) {
        SecurityBaselineStateSummary _x = _copy();
        _x.changedFields = changedFields.add("errorCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineStateSummary");
        _x.errorCount = errorCount;
        return _x;
    }

    /**
     * <i>“Number of conflict devices”</i>
     * 
     * @return property conflictCount
     */
    @Property(name="conflictCount")
    @JsonIgnore
    public Optional<Integer> getConflictCount() {
        return Optional.ofNullable(conflictCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code conflictCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of conflict devices”</i>
     * 
     * @param conflictCount
     *            new value of {@code conflictCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code conflictCount} field changed
     */
    public SecurityBaselineStateSummary withConflictCount(Integer conflictCount) {
        SecurityBaselineStateSummary _x = _copy();
        _x.changedFields = changedFields.add("conflictCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineStateSummary");
        _x.conflictCount = conflictCount;
        return _x;
    }

    /**
     * <i>“Number of not applicable devices”</i>
     * 
     * @return property notApplicableCount
     */
    @Property(name="notApplicableCount")
    @JsonIgnore
    public Optional<Integer> getNotApplicableCount() {
        return Optional.ofNullable(notApplicableCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * notApplicableCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of not applicable devices”</i>
     * 
     * @param notApplicableCount
     *            new value of {@code notApplicableCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code notApplicableCount} field changed
     */
    public SecurityBaselineStateSummary withNotApplicableCount(Integer notApplicableCount) {
        SecurityBaselineStateSummary _x = _copy();
        _x.changedFields = changedFields.add("notApplicableCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineStateSummary");
        _x.notApplicableCount = notApplicableCount;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SecurityBaselineStateSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SecurityBaselineStateSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SecurityBaselineStateSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SecurityBaselineStateSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SecurityBaselineStateSummary _copy() {
        SecurityBaselineStateSummary _x = new SecurityBaselineStateSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.secureCount = secureCount;
        _x.notSecureCount = notSecureCount;
        _x.unknownCount = unknownCount;
        _x.errorCount = errorCount;
        _x.conflictCount = conflictCount;
        _x.notApplicableCount = notApplicableCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SecurityBaselineStateSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("secureCount=");
        b.append(this.secureCount);
        b.append(", ");
        b.append("notSecureCount=");
        b.append(this.notSecureCount);
        b.append(", ");
        b.append("unknownCount=");
        b.append(this.unknownCount);
        b.append(", ");
        b.append("errorCount=");
        b.append(this.errorCount);
        b.append(", ");
        b.append("conflictCount=");
        b.append(this.conflictCount);
        b.append(", ");
        b.append("notApplicableCount=");
        b.append(this.notApplicableCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
