package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.SecurityBaselineComplianceState;


/**
 * <i>“The security baseline compliance state of a setting for a device”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "settingName", 
    "state", 
    "settingCategoryId"})
@JsonInclude(Include.NON_NULL)
public class SecurityBaselineSettingState extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.securityBaselineSettingState";
    }

    @JsonProperty("settingName")
    protected String settingName;

    @JsonProperty("state")
    protected SecurityBaselineComplianceState state;

    @JsonProperty("settingCategoryId")
    protected String settingCategoryId;

    protected SecurityBaselineSettingState() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSecurityBaselineSettingState() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String settingName;
        private SecurityBaselineComplianceState state;
        private String settingCategoryId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The setting name that is being reported”</i>
         * 
         * @param settingName
         *            value of {@code settingName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingName(String settingName) {
            this.settingName = settingName;
            this.changedFields = changedFields.add("settingName");
            return this;
        }

        /**
         * <i>“The compliance state of the security baseline setting”</i>
         * 
         * @param state
         *            value of {@code state} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder state(SecurityBaselineComplianceState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        /**
         * <i>“The setting category id which this setting belongs to”</i>
         * 
         * @param settingCategoryId
         *            value of {@code settingCategoryId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder settingCategoryId(String settingCategoryId) {
            this.settingCategoryId = settingCategoryId;
            this.changedFields = changedFields.add("settingCategoryId");
            return this;
        }

        public SecurityBaselineSettingState build() {
            SecurityBaselineSettingState _x = new SecurityBaselineSettingState();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.securityBaselineSettingState";
            _x.id = id;
            _x.settingName = settingName;
            _x.state = state;
            _x.settingCategoryId = settingCategoryId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The setting name that is being reported”</i>
     * 
     * @return property settingName
     */
    @Property(name="settingName")
    @JsonIgnore
    public Optional<String> getSettingName() {
        return Optional.ofNullable(settingName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settingName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The setting name that is being reported”</i>
     * 
     * @param settingName
     *            new value of {@code settingName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingName} field changed
     */
    public SecurityBaselineSettingState withSettingName(String settingName) {
        SecurityBaselineSettingState _x = _copy();
        _x.changedFields = changedFields.add("settingName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineSettingState");
        _x.settingName = settingName;
        return _x;
    }

    /**
     * <i>“The compliance state of the security baseline setting”</i>
     * 
     * @return property state
     */
    @Property(name="state")
    @JsonIgnore
    public Optional<SecurityBaselineComplianceState> getState() {
        return Optional.ofNullable(state);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code state} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The compliance state of the security baseline setting”</i>
     * 
     * @param state
     *            new value of {@code state} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code state} field changed
     */
    public SecurityBaselineSettingState withState(SecurityBaselineComplianceState state) {
        SecurityBaselineSettingState _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineSettingState");
        _x.state = state;
        return _x;
    }

    /**
     * <i>“The setting category id which this setting belongs to”</i>
     * 
     * @return property settingCategoryId
     */
    @Property(name="settingCategoryId")
    @JsonIgnore
    public Optional<String> getSettingCategoryId() {
        return Optional.ofNullable(settingCategoryId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code settingCategoryId
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The setting category id which this setting belongs to”</i>
     * 
     * @param settingCategoryId
     *            new value of {@code settingCategoryId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code settingCategoryId} field changed
     */
    public SecurityBaselineSettingState withSettingCategoryId(String settingCategoryId) {
        SecurityBaselineSettingState _x = _copy();
        _x.changedFields = changedFields.add("settingCategoryId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineSettingState");
        _x.settingCategoryId = settingCategoryId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SecurityBaselineSettingState patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SecurityBaselineSettingState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SecurityBaselineSettingState put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SecurityBaselineSettingState _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SecurityBaselineSettingState _copy() {
        SecurityBaselineSettingState _x = new SecurityBaselineSettingState();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.settingName = settingName;
        _x.state = state;
        _x.settingCategoryId = settingCategoryId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SecurityBaselineSettingState[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("settingName=");
        b.append(this.settingName);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("settingCategoryId=");
        b.append(this.settingCategoryId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
