package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“The security baseline per category compliance state summary for the security
 * baseline of the account.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName"})
@JsonInclude(Include.NON_NULL)
public class SecurityBaselineCategoryStateSummary extends SecurityBaselineStateSummary implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.securityBaselineCategoryStateSummary";
    }

    @JsonProperty("displayName")
    protected String displayName;

    protected SecurityBaselineCategoryStateSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSecurityBaselineCategoryStateSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer secureCount;
        private Integer notSecureCount;
        private Integer unknownCount;
        private Integer errorCount;
        private Integer conflictCount;
        private Integer notApplicableCount;
        private String displayName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder secureCount(Integer secureCount) {
            this.secureCount = secureCount;
            this.changedFields = changedFields.add("secureCount");
            return this;
        }

        public Builder notSecureCount(Integer notSecureCount) {
            this.notSecureCount = notSecureCount;
            this.changedFields = changedFields.add("notSecureCount");
            return this;
        }

        public Builder unknownCount(Integer unknownCount) {
            this.unknownCount = unknownCount;
            this.changedFields = changedFields.add("unknownCount");
            return this;
        }

        public Builder errorCount(Integer errorCount) {
            this.errorCount = errorCount;
            this.changedFields = changedFields.add("errorCount");
            return this;
        }

        public Builder conflictCount(Integer conflictCount) {
            this.conflictCount = conflictCount;
            this.changedFields = changedFields.add("conflictCount");
            return this;
        }

        public Builder notApplicableCount(Integer notApplicableCount) {
            this.notApplicableCount = notApplicableCount;
            this.changedFields = changedFields.add("notApplicableCount");
            return this;
        }

        /**
         * <i>“The category name”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public SecurityBaselineCategoryStateSummary build() {
            SecurityBaselineCategoryStateSummary _x = new SecurityBaselineCategoryStateSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.securityBaselineCategoryStateSummary";
            _x.id = id;
            _x.secureCount = secureCount;
            _x.notSecureCount = notSecureCount;
            _x.unknownCount = unknownCount;
            _x.errorCount = errorCount;
            _x.conflictCount = conflictCount;
            _x.notApplicableCount = notApplicableCount;
            _x.displayName = displayName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The category name”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The category name”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public SecurityBaselineCategoryStateSummary withDisplayName(String displayName) {
        SecurityBaselineCategoryStateSummary _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityBaselineCategoryStateSummary");
        _x.displayName = displayName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SecurityBaselineCategoryStateSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SecurityBaselineCategoryStateSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SecurityBaselineCategoryStateSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SecurityBaselineCategoryStateSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SecurityBaselineCategoryStateSummary _copy() {
        SecurityBaselineCategoryStateSummary _x = new SecurityBaselineCategoryStateSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.secureCount = secureCount;
        _x.notSecureCount = notSecureCount;
        _x.unknownCount = unknownCount;
        _x.errorCount = errorCount;
        _x.conflictCount = conflictCount;
        _x.notApplicableCount = notApplicableCount;
        _x.displayName = displayName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SecurityBaselineCategoryStateSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("secureCount=");
        b.append(this.secureCount);
        b.append(", ");
        b.append("notSecureCount=");
        b.append(this.notSecureCount);
        b.append(", ");
        b.append("unknownCount=");
        b.append(this.unknownCount);
        b.append(", ");
        b.append("errorCount=");
        b.append(this.errorCount);
        b.append(", ");
        b.append("conflictCount=");
        b.append(this.conflictCount);
        b.append(", ");
        b.append("notApplicableCount=");
        b.append(this.notApplicableCount);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
