package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.KeyValuePair;
import odata.msgraph.client.beta.complex.ResultInfo;
import odata.msgraph.client.beta.complex.SecurityActionState;
import odata.msgraph.client.beta.complex.SecurityVendorInformation;
import odata.msgraph.client.beta.enums.OperationStatus;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SortRestrictions</b>
 * <p>
 * Sortable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * true
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * true
 */@JsonPropertyOrder({
    "@odata.type", 
    "actionReason", 
    "appId", 
    "azureTenantId", 
    "clientContext", 
    "completedDateTime", 
    "createdDateTime", 
    "errorInfo", 
    "lastActionDateTime", 
    "name", 
    "parameters", 
    "states", 
    "status", 
    "user", 
    "vendorInformation"})
@JsonInclude(Include.NON_NULL)
public class SecurityAction extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.securityAction";
    }

    @JsonProperty("actionReason")
    protected String actionReason;

    @JsonProperty("appId")
    protected String appId;

    @JsonProperty("azureTenantId")
    protected String azureTenantId;

    @JsonProperty("clientContext")
    protected String clientContext;

    @JsonProperty("completedDateTime")
    protected OffsetDateTime completedDateTime;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("errorInfo")
    protected ResultInfo errorInfo;

    @JsonProperty("lastActionDateTime")
    protected OffsetDateTime lastActionDateTime;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("parameters")
    protected List<KeyValuePair> parameters;

    @JsonProperty("parameters@nextLink")
    protected String parametersNextLink;

    @JsonProperty("states")
    protected List<SecurityActionState> states;

    @JsonProperty("states@nextLink")
    protected String statesNextLink;

    @JsonProperty("status")
    protected OperationStatus status;

    @JsonProperty("user")
    protected String user;

    @JsonProperty("vendorInformation")
    protected SecurityVendorInformation vendorInformation;

    protected SecurityAction() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSecurityAction() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String actionReason;
        private String appId;
        private String azureTenantId;
        private String clientContext;
        private OffsetDateTime completedDateTime;
        private OffsetDateTime createdDateTime;
        private ResultInfo errorInfo;
        private OffsetDateTime lastActionDateTime;
        private String name;
        private List<KeyValuePair> parameters;
        private String parametersNextLink;
        private List<SecurityActionState> states;
        private String statesNextLink;
        private OperationStatus status;
        private String user;
        private SecurityVendorInformation vendorInformation;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder actionReason(String actionReason) {
            this.actionReason = actionReason;
            this.changedFields = changedFields.add("actionReason");
            return this;
        }

        public Builder appId(String appId) {
            this.appId = appId;
            this.changedFields = changedFields.add("appId");
            return this;
        }

        public Builder azureTenantId(String azureTenantId) {
            this.azureTenantId = azureTenantId;
            this.changedFields = changedFields.add("azureTenantId");
            return this;
        }

        public Builder clientContext(String clientContext) {
            this.clientContext = clientContext;
            this.changedFields = changedFields.add("clientContext");
            return this;
        }

        public Builder completedDateTime(OffsetDateTime completedDateTime) {
            this.completedDateTime = completedDateTime;
            this.changedFields = changedFields.add("completedDateTime");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder errorInfo(ResultInfo errorInfo) {
            this.errorInfo = errorInfo;
            this.changedFields = changedFields.add("errorInfo");
            return this;
        }

        public Builder lastActionDateTime(OffsetDateTime lastActionDateTime) {
            this.lastActionDateTime = lastActionDateTime;
            this.changedFields = changedFields.add("lastActionDateTime");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder parameters(List<KeyValuePair> parameters) {
            this.parameters = parameters;
            this.changedFields = changedFields.add("parameters");
            return this;
        }

        public Builder parameters(KeyValuePair... parameters) {
            return parameters(Arrays.asList(parameters));
        }

        public Builder parametersNextLink(String parametersNextLink) {
            this.parametersNextLink = parametersNextLink;
            this.changedFields = changedFields.add("parameters");
            return this;
        }

        public Builder states(List<SecurityActionState> states) {
            this.states = states;
            this.changedFields = changedFields.add("states");
            return this;
        }

        public Builder states(SecurityActionState... states) {
            return states(Arrays.asList(states));
        }

        public Builder statesNextLink(String statesNextLink) {
            this.statesNextLink = statesNextLink;
            this.changedFields = changedFields.add("states");
            return this;
        }

        public Builder status(OperationStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            this.changedFields = changedFields.add("user");
            return this;
        }

        public Builder vendorInformation(SecurityVendorInformation vendorInformation) {
            this.vendorInformation = vendorInformation;
            this.changedFields = changedFields.add("vendorInformation");
            return this;
        }

        public SecurityAction build() {
            SecurityAction _x = new SecurityAction();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.securityAction";
            _x.id = id;
            _x.actionReason = actionReason;
            _x.appId = appId;
            _x.azureTenantId = azureTenantId;
            _x.clientContext = clientContext;
            _x.completedDateTime = completedDateTime;
            _x.createdDateTime = createdDateTime;
            _x.errorInfo = errorInfo;
            _x.lastActionDateTime = lastActionDateTime;
            _x.name = name;
            _x.parameters = parameters;
            _x.parametersNextLink = parametersNextLink;
            _x.states = states;
            _x.statesNextLink = statesNextLink;
            _x.status = status;
            _x.user = user;
            _x.vendorInformation = vendorInformation;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="actionReason")
    @JsonIgnore
    public Optional<String> getActionReason() {
        return Optional.ofNullable(actionReason);
    }

    public SecurityAction withActionReason(String actionReason) {
        SecurityAction _x = _copy();
        _x.changedFields = changedFields.add("actionReason");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityAction");
        _x.actionReason = actionReason;
        return _x;
    }

    @Property(name="appId")
    @JsonIgnore
    public Optional<String> getAppId() {
        return Optional.ofNullable(appId);
    }

    public SecurityAction withAppId(String appId) {
        SecurityAction _x = _copy();
        _x.changedFields = changedFields.add("appId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityAction");
        _x.appId = appId;
        return _x;
    }

    @Property(name="azureTenantId")
    @JsonIgnore
    public Optional<String> getAzureTenantId() {
        return Optional.ofNullable(azureTenantId);
    }

    public SecurityAction withAzureTenantId(String azureTenantId) {
        SecurityAction _x = _copy();
        _x.changedFields = changedFields.add("azureTenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityAction");
        _x.azureTenantId = azureTenantId;
        return _x;
    }

    @Property(name="clientContext")
    @JsonIgnore
    public Optional<String> getClientContext() {
        return Optional.ofNullable(clientContext);
    }

    public SecurityAction withClientContext(String clientContext) {
        SecurityAction _x = _copy();
        _x.changedFields = changedFields.add("clientContext");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityAction");
        _x.clientContext = clientContext;
        return _x;
    }

    @Property(name="completedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCompletedDateTime() {
        return Optional.ofNullable(completedDateTime);
    }

    public SecurityAction withCompletedDateTime(OffsetDateTime completedDateTime) {
        SecurityAction _x = _copy();
        _x.changedFields = changedFields.add("completedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityAction");
        _x.completedDateTime = completedDateTime;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public SecurityAction withCreatedDateTime(OffsetDateTime createdDateTime) {
        SecurityAction _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityAction");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="errorInfo")
    @JsonIgnore
    public Optional<ResultInfo> getErrorInfo() {
        return Optional.ofNullable(errorInfo);
    }

    public SecurityAction withErrorInfo(ResultInfo errorInfo) {
        SecurityAction _x = _copy();
        _x.changedFields = changedFields.add("errorInfo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityAction");
        _x.errorInfo = errorInfo;
        return _x;
    }

    @Property(name="lastActionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastActionDateTime() {
        return Optional.ofNullable(lastActionDateTime);
    }

    public SecurityAction withLastActionDateTime(OffsetDateTime lastActionDateTime) {
        SecurityAction _x = _copy();
        _x.changedFields = changedFields.add("lastActionDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityAction");
        _x.lastActionDateTime = lastActionDateTime;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public SecurityAction withName(String name) {
        SecurityAction _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityAction");
        _x.name = name;
        return _x;
    }

    @Property(name="parameters")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getParameters() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, parameters, Optional.ofNullable(parametersNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="parameters")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getParameters(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, parameters, Optional.ofNullable(parametersNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="states")
    @JsonIgnore
    public CollectionPage<SecurityActionState> getStates() {
        return new CollectionPage<SecurityActionState>(contextPath, SecurityActionState.class, states, Optional.ofNullable(statesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="states")
    @JsonIgnore
    public CollectionPage<SecurityActionState> getStates(HttpRequestOptions options) {
        return new CollectionPage<SecurityActionState>(contextPath, SecurityActionState.class, states, Optional.ofNullable(statesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<OperationStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public SecurityAction withStatus(OperationStatus status) {
        SecurityAction _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityAction");
        _x.status = status;
        return _x;
    }

    @Property(name="user")
    @JsonIgnore
    public Optional<String> getUser() {
        return Optional.ofNullable(user);
    }

    public SecurityAction withUser(String user) {
        SecurityAction _x = _copy();
        _x.changedFields = changedFields.add("user");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityAction");
        _x.user = user;
        return _x;
    }

    @Property(name="vendorInformation")
    @JsonIgnore
    public Optional<SecurityVendorInformation> getVendorInformation() {
        return Optional.ofNullable(vendorInformation);
    }

    public SecurityAction withVendorInformation(SecurityVendorInformation vendorInformation) {
        SecurityAction _x = _copy();
        _x.changedFields = changedFields.add("vendorInformation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.securityAction");
        _x.vendorInformation = vendorInformation;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SecurityAction patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SecurityAction _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SecurityAction put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SecurityAction _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SecurityAction _copy() {
        SecurityAction _x = new SecurityAction();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.actionReason = actionReason;
        _x.appId = appId;
        _x.azureTenantId = azureTenantId;
        _x.clientContext = clientContext;
        _x.completedDateTime = completedDateTime;
        _x.createdDateTime = createdDateTime;
        _x.errorInfo = errorInfo;
        _x.lastActionDateTime = lastActionDateTime;
        _x.name = name;
        _x.parameters = parameters;
        _x.states = states;
        _x.status = status;
        _x.user = user;
        _x.vendorInformation = vendorInformation;
        return _x;
    }

    @Action(name = "cancelSecurityAction")
    @JsonIgnore
    public ActionRequestNoReturn cancelSecurityAction() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancelSecurityAction"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SecurityAction[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("actionReason=");
        b.append(this.actionReason);
        b.append(", ");
        b.append("appId=");
        b.append(this.appId);
        b.append(", ");
        b.append("azureTenantId=");
        b.append(this.azureTenantId);
        b.append(", ");
        b.append("clientContext=");
        b.append(this.clientContext);
        b.append(", ");
        b.append("completedDateTime=");
        b.append(this.completedDateTime);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("errorInfo=");
        b.append(this.errorInfo);
        b.append(", ");
        b.append("lastActionDateTime=");
        b.append(this.lastActionDateTime);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("parameters=");
        b.append(this.parameters);
        b.append(", ");
        b.append("states=");
        b.append(this.states);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("user=");
        b.append(this.user);
        b.append(", ");
        b.append("vendorInformation=");
        b.append(this.vendorInformation);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
