package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ComplianceInformation;
import odata.msgraph.client.beta.complex.SecureScoreControlStateUpdate;
import odata.msgraph.client.beta.complex.SecurityVendorInformation;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SortRestrictions</b>
 * <p>
 * Sortable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * true
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * true
 */@JsonPropertyOrder({
    "@odata.type", 
    "actionType", 
    "actionUrl", 
    "azureTenantId", 
    "complianceInformation", 
    "controlCategory", 
    "controlStateUpdates", 
    "deprecated", 
    "implementationCost", 
    "lastModifiedDateTime", 
    "maxScore", 
    "rank", 
    "remediation", 
    "remediationImpact", 
    "service", 
    "threats", 
    "tier", 
    "title", 
    "userImpact", 
    "vendorInformation"})
@JsonInclude(Include.NON_NULL)
public class SecureScoreControlProfile extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.secureScoreControlProfile";
    }

    @JsonProperty("actionType")
    protected String actionType;

    @JsonProperty("actionUrl")
    protected String actionUrl;

    @JsonProperty("azureTenantId")
    protected String azureTenantId;

    @JsonProperty("complianceInformation")
    protected List<ComplianceInformation> complianceInformation;

    @JsonProperty("complianceInformation@nextLink")
    protected String complianceInformationNextLink;

    @JsonProperty("controlCategory")
    protected String controlCategory;

    @JsonProperty("controlStateUpdates")
    protected List<SecureScoreControlStateUpdate> controlStateUpdates;

    @JsonProperty("controlStateUpdates@nextLink")
    protected String controlStateUpdatesNextLink;

    @JsonProperty("deprecated")
    protected Boolean deprecated;

    @JsonProperty("implementationCost")
    protected String implementationCost;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("maxScore")
    protected Double maxScore;

    @JsonProperty("rank")
    protected Integer rank;

    @JsonProperty("remediation")
    protected String remediation;

    @JsonProperty("remediationImpact")
    protected String remediationImpact;

    @JsonProperty("service")
    protected String service;

    @JsonProperty("threats")
    protected List<String> threats;

    @JsonProperty("threats@nextLink")
    protected String threatsNextLink;

    @JsonProperty("tier")
    protected String tier;

    @JsonProperty("title")
    protected String title;

    @JsonProperty("userImpact")
    protected String userImpact;

    @JsonProperty("vendorInformation")
    protected SecurityVendorInformation vendorInformation;

    protected SecureScoreControlProfile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSecureScoreControlProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String actionType;
        private String actionUrl;
        private String azureTenantId;
        private List<ComplianceInformation> complianceInformation;
        private String complianceInformationNextLink;
        private String controlCategory;
        private List<SecureScoreControlStateUpdate> controlStateUpdates;
        private String controlStateUpdatesNextLink;
        private Boolean deprecated;
        private String implementationCost;
        private OffsetDateTime lastModifiedDateTime;
        private Double maxScore;
        private Integer rank;
        private String remediation;
        private String remediationImpact;
        private String service;
        private List<String> threats;
        private String threatsNextLink;
        private String tier;
        private String title;
        private String userImpact;
        private SecurityVendorInformation vendorInformation;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder actionType(String actionType) {
            this.actionType = actionType;
            this.changedFields = changedFields.add("actionType");
            return this;
        }

        public Builder actionUrl(String actionUrl) {
            this.actionUrl = actionUrl;
            this.changedFields = changedFields.add("actionUrl");
            return this;
        }

        public Builder azureTenantId(String azureTenantId) {
            this.azureTenantId = azureTenantId;
            this.changedFields = changedFields.add("azureTenantId");
            return this;
        }

        public Builder complianceInformation(List<ComplianceInformation> complianceInformation) {
            this.complianceInformation = complianceInformation;
            this.changedFields = changedFields.add("complianceInformation");
            return this;
        }

        public Builder complianceInformation(ComplianceInformation... complianceInformation) {
            return complianceInformation(Arrays.asList(complianceInformation));
        }

        public Builder complianceInformationNextLink(String complianceInformationNextLink) {
            this.complianceInformationNextLink = complianceInformationNextLink;
            this.changedFields = changedFields.add("complianceInformation");
            return this;
        }

        public Builder controlCategory(String controlCategory) {
            this.controlCategory = controlCategory;
            this.changedFields = changedFields.add("controlCategory");
            return this;
        }

        public Builder controlStateUpdates(List<SecureScoreControlStateUpdate> controlStateUpdates) {
            this.controlStateUpdates = controlStateUpdates;
            this.changedFields = changedFields.add("controlStateUpdates");
            return this;
        }

        public Builder controlStateUpdates(SecureScoreControlStateUpdate... controlStateUpdates) {
            return controlStateUpdates(Arrays.asList(controlStateUpdates));
        }

        public Builder controlStateUpdatesNextLink(String controlStateUpdatesNextLink) {
            this.controlStateUpdatesNextLink = controlStateUpdatesNextLink;
            this.changedFields = changedFields.add("controlStateUpdates");
            return this;
        }

        public Builder deprecated(Boolean deprecated) {
            this.deprecated = deprecated;
            this.changedFields = changedFields.add("deprecated");
            return this;
        }

        public Builder implementationCost(String implementationCost) {
            this.implementationCost = implementationCost;
            this.changedFields = changedFields.add("implementationCost");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder maxScore(Double maxScore) {
            this.maxScore = maxScore;
            this.changedFields = changedFields.add("maxScore");
            return this;
        }

        public Builder rank(Integer rank) {
            this.rank = rank;
            this.changedFields = changedFields.add("rank");
            return this;
        }

        public Builder remediation(String remediation) {
            this.remediation = remediation;
            this.changedFields = changedFields.add("remediation");
            return this;
        }

        public Builder remediationImpact(String remediationImpact) {
            this.remediationImpact = remediationImpact;
            this.changedFields = changedFields.add("remediationImpact");
            return this;
        }

        public Builder service(String service) {
            this.service = service;
            this.changedFields = changedFields.add("service");
            return this;
        }

        public Builder threats(List<String> threats) {
            this.threats = threats;
            this.changedFields = changedFields.add("threats");
            return this;
        }

        public Builder threats(String... threats) {
            return threats(Arrays.asList(threats));
        }

        public Builder threatsNextLink(String threatsNextLink) {
            this.threatsNextLink = threatsNextLink;
            this.changedFields = changedFields.add("threats");
            return this;
        }

        public Builder tier(String tier) {
            this.tier = tier;
            this.changedFields = changedFields.add("tier");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public Builder userImpact(String userImpact) {
            this.userImpact = userImpact;
            this.changedFields = changedFields.add("userImpact");
            return this;
        }

        public Builder vendorInformation(SecurityVendorInformation vendorInformation) {
            this.vendorInformation = vendorInformation;
            this.changedFields = changedFields.add("vendorInformation");
            return this;
        }

        public SecureScoreControlProfile build() {
            SecureScoreControlProfile _x = new SecureScoreControlProfile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.secureScoreControlProfile";
            _x.id = id;
            _x.actionType = actionType;
            _x.actionUrl = actionUrl;
            _x.azureTenantId = azureTenantId;
            _x.complianceInformation = complianceInformation;
            _x.complianceInformationNextLink = complianceInformationNextLink;
            _x.controlCategory = controlCategory;
            _x.controlStateUpdates = controlStateUpdates;
            _x.controlStateUpdatesNextLink = controlStateUpdatesNextLink;
            _x.deprecated = deprecated;
            _x.implementationCost = implementationCost;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.maxScore = maxScore;
            _x.rank = rank;
            _x.remediation = remediation;
            _x.remediationImpact = remediationImpact;
            _x.service = service;
            _x.threats = threats;
            _x.threatsNextLink = threatsNextLink;
            _x.tier = tier;
            _x.title = title;
            _x.userImpact = userImpact;
            _x.vendorInformation = vendorInformation;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="actionType")
    @JsonIgnore
    public Optional<String> getActionType() {
        return Optional.ofNullable(actionType);
    }

    public SecureScoreControlProfile withActionType(String actionType) {
        SecureScoreControlProfile _x = _copy();
        _x.changedFields = changedFields.add("actionType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScoreControlProfile");
        _x.actionType = actionType;
        return _x;
    }

    @Property(name="actionUrl")
    @JsonIgnore
    public Optional<String> getActionUrl() {
        return Optional.ofNullable(actionUrl);
    }

    public SecureScoreControlProfile withActionUrl(String actionUrl) {
        SecureScoreControlProfile _x = _copy();
        _x.changedFields = changedFields.add("actionUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScoreControlProfile");
        _x.actionUrl = actionUrl;
        return _x;
    }

    @Property(name="azureTenantId")
    @JsonIgnore
    public Optional<String> getAzureTenantId() {
        return Optional.ofNullable(azureTenantId);
    }

    public SecureScoreControlProfile withAzureTenantId(String azureTenantId) {
        SecureScoreControlProfile _x = _copy();
        _x.changedFields = changedFields.add("azureTenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScoreControlProfile");
        _x.azureTenantId = azureTenantId;
        return _x;
    }

    @Property(name="complianceInformation")
    @JsonIgnore
    public CollectionPage<ComplianceInformation> getComplianceInformation() {
        return new CollectionPage<ComplianceInformation>(contextPath, ComplianceInformation.class, complianceInformation, Optional.ofNullable(complianceInformationNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="complianceInformation")
    @JsonIgnore
    public CollectionPage<ComplianceInformation> getComplianceInformation(HttpRequestOptions options) {
        return new CollectionPage<ComplianceInformation>(contextPath, ComplianceInformation.class, complianceInformation, Optional.ofNullable(complianceInformationNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="controlCategory")
    @JsonIgnore
    public Optional<String> getControlCategory() {
        return Optional.ofNullable(controlCategory);
    }

    public SecureScoreControlProfile withControlCategory(String controlCategory) {
        SecureScoreControlProfile _x = _copy();
        _x.changedFields = changedFields.add("controlCategory");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScoreControlProfile");
        _x.controlCategory = controlCategory;
        return _x;
    }

    @Property(name="controlStateUpdates")
    @JsonIgnore
    public CollectionPage<SecureScoreControlStateUpdate> getControlStateUpdates() {
        return new CollectionPage<SecureScoreControlStateUpdate>(contextPath, SecureScoreControlStateUpdate.class, controlStateUpdates, Optional.ofNullable(controlStateUpdatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="controlStateUpdates")
    @JsonIgnore
    public CollectionPage<SecureScoreControlStateUpdate> getControlStateUpdates(HttpRequestOptions options) {
        return new CollectionPage<SecureScoreControlStateUpdate>(contextPath, SecureScoreControlStateUpdate.class, controlStateUpdates, Optional.ofNullable(controlStateUpdatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="deprecated")
    @JsonIgnore
    public Optional<Boolean> getDeprecated() {
        return Optional.ofNullable(deprecated);
    }

    public SecureScoreControlProfile withDeprecated(Boolean deprecated) {
        SecureScoreControlProfile _x = _copy();
        _x.changedFields = changedFields.add("deprecated");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScoreControlProfile");
        _x.deprecated = deprecated;
        return _x;
    }

    @Property(name="implementationCost")
    @JsonIgnore
    public Optional<String> getImplementationCost() {
        return Optional.ofNullable(implementationCost);
    }

    public SecureScoreControlProfile withImplementationCost(String implementationCost) {
        SecureScoreControlProfile _x = _copy();
        _x.changedFields = changedFields.add("implementationCost");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScoreControlProfile");
        _x.implementationCost = implementationCost;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public SecureScoreControlProfile withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        SecureScoreControlProfile _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScoreControlProfile");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="maxScore")
    @JsonIgnore
    public Optional<Double> getMaxScore() {
        return Optional.ofNullable(maxScore);
    }

    public SecureScoreControlProfile withMaxScore(Double maxScore) {
        SecureScoreControlProfile _x = _copy();
        _x.changedFields = changedFields.add("maxScore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScoreControlProfile");
        _x.maxScore = maxScore;
        return _x;
    }

    @Property(name="rank")
    @JsonIgnore
    public Optional<Integer> getRank() {
        return Optional.ofNullable(rank);
    }

    public SecureScoreControlProfile withRank(Integer rank) {
        SecureScoreControlProfile _x = _copy();
        _x.changedFields = changedFields.add("rank");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScoreControlProfile");
        _x.rank = rank;
        return _x;
    }

    @Property(name="remediation")
    @JsonIgnore
    public Optional<String> getRemediation() {
        return Optional.ofNullable(remediation);
    }

    public SecureScoreControlProfile withRemediation(String remediation) {
        SecureScoreControlProfile _x = _copy();
        _x.changedFields = changedFields.add("remediation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScoreControlProfile");
        _x.remediation = remediation;
        return _x;
    }

    @Property(name="remediationImpact")
    @JsonIgnore
    public Optional<String> getRemediationImpact() {
        return Optional.ofNullable(remediationImpact);
    }

    public SecureScoreControlProfile withRemediationImpact(String remediationImpact) {
        SecureScoreControlProfile _x = _copy();
        _x.changedFields = changedFields.add("remediationImpact");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScoreControlProfile");
        _x.remediationImpact = remediationImpact;
        return _x;
    }

    @Property(name="service")
    @JsonIgnore
    public Optional<String> getService() {
        return Optional.ofNullable(service);
    }

    public SecureScoreControlProfile withService(String service) {
        SecureScoreControlProfile _x = _copy();
        _x.changedFields = changedFields.add("service");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScoreControlProfile");
        _x.service = service;
        return _x;
    }

    @Property(name="threats")
    @JsonIgnore
    public CollectionPage<String> getThreats() {
        return new CollectionPage<String>(contextPath, String.class, threats, Optional.ofNullable(threatsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="threats")
    @JsonIgnore
    public CollectionPage<String> getThreats(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, threats, Optional.ofNullable(threatsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="tier")
    @JsonIgnore
    public Optional<String> getTier() {
        return Optional.ofNullable(tier);
    }

    public SecureScoreControlProfile withTier(String tier) {
        SecureScoreControlProfile _x = _copy();
        _x.changedFields = changedFields.add("tier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScoreControlProfile");
        _x.tier = tier;
        return _x;
    }

    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public SecureScoreControlProfile withTitle(String title) {
        SecureScoreControlProfile _x = _copy();
        _x.changedFields = changedFields.add("title");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScoreControlProfile");
        _x.title = title;
        return _x;
    }

    @Property(name="userImpact")
    @JsonIgnore
    public Optional<String> getUserImpact() {
        return Optional.ofNullable(userImpact);
    }

    public SecureScoreControlProfile withUserImpact(String userImpact) {
        SecureScoreControlProfile _x = _copy();
        _x.changedFields = changedFields.add("userImpact");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScoreControlProfile");
        _x.userImpact = userImpact;
        return _x;
    }

    @Property(name="vendorInformation")
    @JsonIgnore
    public Optional<SecurityVendorInformation> getVendorInformation() {
        return Optional.ofNullable(vendorInformation);
    }

    public SecureScoreControlProfile withVendorInformation(SecurityVendorInformation vendorInformation) {
        SecureScoreControlProfile _x = _copy();
        _x.changedFields = changedFields.add("vendorInformation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.secureScoreControlProfile");
        _x.vendorInformation = vendorInformation;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SecureScoreControlProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SecureScoreControlProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SecureScoreControlProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SecureScoreControlProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SecureScoreControlProfile _copy() {
        SecureScoreControlProfile _x = new SecureScoreControlProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.actionType = actionType;
        _x.actionUrl = actionUrl;
        _x.azureTenantId = azureTenantId;
        _x.complianceInformation = complianceInformation;
        _x.controlCategory = controlCategory;
        _x.controlStateUpdates = controlStateUpdates;
        _x.deprecated = deprecated;
        _x.implementationCost = implementationCost;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.maxScore = maxScore;
        _x.rank = rank;
        _x.remediation = remediation;
        _x.remediationImpact = remediationImpact;
        _x.service = service;
        _x.threats = threats;
        _x.tier = tier;
        _x.title = title;
        _x.userImpact = userImpact;
        _x.vendorInformation = vendorInformation;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SecureScoreControlProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("actionType=");
        b.append(this.actionType);
        b.append(", ");
        b.append("actionUrl=");
        b.append(this.actionUrl);
        b.append(", ");
        b.append("azureTenantId=");
        b.append(this.azureTenantId);
        b.append(", ");
        b.append("complianceInformation=");
        b.append(this.complianceInformation);
        b.append(", ");
        b.append("controlCategory=");
        b.append(this.controlCategory);
        b.append(", ");
        b.append("controlStateUpdates=");
        b.append(this.controlStateUpdates);
        b.append(", ");
        b.append("deprecated=");
        b.append(this.deprecated);
        b.append(", ");
        b.append("implementationCost=");
        b.append(this.implementationCost);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("maxScore=");
        b.append(this.maxScore);
        b.append(", ");
        b.append("rank=");
        b.append(this.rank);
        b.append(", ");
        b.append("remediation=");
        b.append(this.remediation);
        b.append(", ");
        b.append("remediationImpact=");
        b.append(this.remediationImpact);
        b.append(", ");
        b.append("service=");
        b.append(this.service);
        b.append(", ");
        b.append("threats=");
        b.append(this.threats);
        b.append(", ");
        b.append("tier=");
        b.append(this.tier);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append(", ");
        b.append("userImpact=");
        b.append(this.userImpact);
        b.append(", ");
        b.append("vendorInformation=");
        b.append(this.vendorInformation);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
