package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ExtensionSchemaProperty;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "targetTypes", 
    "properties", 
    "status", 
    "owner"})
@JsonInclude(Include.NON_NULL)
public class SchemaExtension extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.schemaExtension";
    }

    @JsonProperty("description")
    protected String description;

    @JsonProperty("targetTypes")
    protected List<String> targetTypes;

    @JsonProperty("targetTypes@nextLink")
    protected String targetTypesNextLink;

    @JsonProperty("properties")
    protected List<ExtensionSchemaProperty> properties;

    @JsonProperty("properties@nextLink")
    protected String propertiesNextLink;

    @JsonProperty("status")
    protected String status;

    @JsonProperty("owner")
    protected String owner;

    protected SchemaExtension() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSchemaExtension() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String description;
        private List<String> targetTypes;
        private String targetTypesNextLink;
        private List<ExtensionSchemaProperty> properties;
        private String propertiesNextLink;
        private String status;
        private String owner;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder targetTypes(List<String> targetTypes) {
            this.targetTypes = targetTypes;
            this.changedFields = changedFields.add("targetTypes");
            return this;
        }

        public Builder targetTypes(String... targetTypes) {
            return targetTypes(Arrays.asList(targetTypes));
        }

        public Builder targetTypesNextLink(String targetTypesNextLink) {
            this.targetTypesNextLink = targetTypesNextLink;
            this.changedFields = changedFields.add("targetTypes");
            return this;
        }

        public Builder properties(List<ExtensionSchemaProperty> properties) {
            this.properties = properties;
            this.changedFields = changedFields.add("properties");
            return this;
        }

        public Builder properties(ExtensionSchemaProperty... properties) {
            return properties(Arrays.asList(properties));
        }

        public Builder propertiesNextLink(String propertiesNextLink) {
            this.propertiesNextLink = propertiesNextLink;
            this.changedFields = changedFields.add("properties");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            this.changedFields = changedFields.add("owner");
            return this;
        }

        public SchemaExtension build() {
            SchemaExtension _x = new SchemaExtension();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.schemaExtension";
            _x.id = id;
            _x.description = description;
            _x.targetTypes = targetTypes;
            _x.targetTypesNextLink = targetTypesNextLink;
            _x.properties = properties;
            _x.propertiesNextLink = propertiesNextLink;
            _x.status = status;
            _x.owner = owner;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public SchemaExtension withDescription(String description) {
        SchemaExtension _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.schemaExtension");
        _x.description = description;
        return _x;
    }

    @Property(name="targetTypes")
    @JsonIgnore
    public CollectionPage<String> getTargetTypes() {
        return new CollectionPage<String>(contextPath, String.class, targetTypes, Optional.ofNullable(targetTypesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="targetTypes")
    @JsonIgnore
    public CollectionPage<String> getTargetTypes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, targetTypes, Optional.ofNullable(targetTypesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="properties")
    @JsonIgnore
    public CollectionPage<ExtensionSchemaProperty> getProperties() {
        return new CollectionPage<ExtensionSchemaProperty>(contextPath, ExtensionSchemaProperty.class, properties, Optional.ofNullable(propertiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="properties")
    @JsonIgnore
    public CollectionPage<ExtensionSchemaProperty> getProperties(HttpRequestOptions options) {
        return new CollectionPage<ExtensionSchemaProperty>(contextPath, ExtensionSchemaProperty.class, properties, Optional.ofNullable(propertiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public SchemaExtension withStatus(String status) {
        SchemaExtension _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.schemaExtension");
        _x.status = status;
        return _x;
    }

    @Property(name="owner")
    @JsonIgnore
    public Optional<String> getOwner() {
        return Optional.ofNullable(owner);
    }

    public SchemaExtension withOwner(String owner) {
        SchemaExtension _x = _copy();
        _x.changedFields = changedFields.add("owner");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.schemaExtension");
        _x.owner = owner;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SchemaExtension patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SchemaExtension _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SchemaExtension put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SchemaExtension _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SchemaExtension _copy() {
        SchemaExtension _x = new SchemaExtension();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.description = description;
        _x.targetTypes = targetTypes;
        _x.properties = properties;
        _x.status = status;
        _x.owner = owner;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SchemaExtension[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("targetTypes=");
        b.append(this.targetTypes);
        b.append(", ");
        b.append("properties=");
        b.append(this.properties);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("owner=");
        b.append(this.owner);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
