package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySet;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "isActive", 
    "userIds"})
@JsonInclude(Include.NON_NULL)
public class SchedulingGroup extends ChangeTrackedEntity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.schedulingGroup";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("isActive")
    protected Boolean isActive;

    @JsonProperty("userIds")
    protected List<String> userIds;

    @JsonProperty("userIds@nextLink")
    protected String userIdsNextLink;

    protected SchedulingGroup() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSchedulingGroup() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private IdentitySet lastModifiedBy;
        private String displayName;
        private Boolean isActive;
        private List<String> userIds;
        private String userIdsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param isActive
         *            value of {@code isActive} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            this.changedFields = changedFields.add("isActive");
            return this;
        }

        public Builder userIds(List<String> userIds) {
            this.userIds = userIds;
            this.changedFields = changedFields.add("userIds");
            return this;
        }

        public Builder userIds(String... userIds) {
            return userIds(Arrays.asList(userIds));
        }

        public Builder userIdsNextLink(String userIdsNextLink) {
            this.userIdsNextLink = userIdsNextLink;
            this.changedFields = changedFields.add("userIds");
            return this;
        }

        public SchedulingGroup build() {
            SchedulingGroup _x = new SchedulingGroup();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.schedulingGroup";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.lastModifiedBy = lastModifiedBy;
            _x.displayName = displayName;
            _x.isActive = isActive;
            _x.userIds = userIds;
            _x.userIdsNextLink = userIdsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public SchedulingGroup withDisplayName(String displayName) {
        SchedulingGroup _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.schedulingGroup");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property isActive
     */
    @Property(name="isActive")
    @JsonIgnore
    public Optional<Boolean> getIsActive() {
        return Optional.ofNullable(isActive);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isActive} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param isActive
     *            new value of {@code isActive} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isActive} field changed
     */
    public SchedulingGroup withIsActive(Boolean isActive) {
        SchedulingGroup _x = _copy();
        _x.changedFields = changedFields.add("isActive");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.schedulingGroup");
        _x.isActive = isActive;
        return _x;
    }

    @Property(name="userIds")
    @JsonIgnore
    public CollectionPage<String> getUserIds() {
        return new CollectionPage<String>(contextPath, String.class, userIds, Optional.ofNullable(userIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="userIds")
    @JsonIgnore
    public CollectionPage<String> getUserIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, userIds, Optional.ofNullable(userIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SchedulingGroup patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SchedulingGroup _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SchedulingGroup put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SchedulingGroup _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SchedulingGroup _copy() {
        SchedulingGroup _x = new SchedulingGroup();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.lastModifiedBy = lastModifiedBy;
        _x.displayName = displayName;
        _x.isActive = isActive;
        _x.userIds = userIds;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SchedulingGroup[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("isActive=");
        b.append(this.isActive);
        b.append(", ");
        b.append("userIds=");
        b.append(this.userIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
