package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ScheduleChangeRequestActor;
import odata.msgraph.client.beta.enums.ScheduleChangeState;

@JsonPropertyOrder({
    "@odata.type", 
    "assignedTo", 
    "state", 
    "senderMessage", 
    "senderDateTime", 
    "managerActionMessage", 
    "managerActionDateTime", 
    "senderUserId", 
    "managerUserId"})
@JsonInclude(Include.NON_NULL)
public class ScheduleChangeRequest extends ChangeTrackedEntity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.scheduleChangeRequest";
    }

    @JsonProperty("assignedTo")
    protected ScheduleChangeRequestActor assignedTo;

    @JsonProperty("state")
    protected ScheduleChangeState state;

    @JsonProperty("senderMessage")
    protected String senderMessage;

    @JsonProperty("senderDateTime")
    protected OffsetDateTime senderDateTime;

    @JsonProperty("managerActionMessage")
    protected String managerActionMessage;

    @JsonProperty("managerActionDateTime")
    protected OffsetDateTime managerActionDateTime;

    @JsonProperty("senderUserId")
    protected String senderUserId;

    @JsonProperty("managerUserId")
    protected String managerUserId;

    protected ScheduleChangeRequest() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="assignedTo")
    @JsonIgnore
    public Optional<ScheduleChangeRequestActor> getAssignedTo() {
        return Optional.ofNullable(assignedTo);
    }

    public ScheduleChangeRequest withAssignedTo(ScheduleChangeRequestActor assignedTo) {
        ScheduleChangeRequest _x = _copy();
        _x.changedFields = changedFields.add("assignedTo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.scheduleChangeRequest");
        _x.assignedTo = assignedTo;
        return _x;
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<ScheduleChangeState> getState() {
        return Optional.ofNullable(state);
    }

    public ScheduleChangeRequest withState(ScheduleChangeState state) {
        ScheduleChangeRequest _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.scheduleChangeRequest");
        _x.state = state;
        return _x;
    }

    @Property(name="senderMessage")
    @JsonIgnore
    public Optional<String> getSenderMessage() {
        return Optional.ofNullable(senderMessage);
    }

    public ScheduleChangeRequest withSenderMessage(String senderMessage) {
        ScheduleChangeRequest _x = _copy();
        _x.changedFields = changedFields.add("senderMessage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.scheduleChangeRequest");
        _x.senderMessage = senderMessage;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property senderDateTime
     */
    @Property(name="senderDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getSenderDateTime() {
        return Optional.ofNullable(senderDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code senderDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param senderDateTime
     *            new value of {@code senderDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code senderDateTime} field changed
     */
    public ScheduleChangeRequest withSenderDateTime(OffsetDateTime senderDateTime) {
        ScheduleChangeRequest _x = _copy();
        _x.changedFields = changedFields.add("senderDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.scheduleChangeRequest");
        _x.senderDateTime = senderDateTime;
        return _x;
    }

    @Property(name="managerActionMessage")
    @JsonIgnore
    public Optional<String> getManagerActionMessage() {
        return Optional.ofNullable(managerActionMessage);
    }

    public ScheduleChangeRequest withManagerActionMessage(String managerActionMessage) {
        ScheduleChangeRequest _x = _copy();
        _x.changedFields = changedFields.add("managerActionMessage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.scheduleChangeRequest");
        _x.managerActionMessage = managerActionMessage;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property managerActionDateTime
     */
    @Property(name="managerActionDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getManagerActionDateTime() {
        return Optional.ofNullable(managerActionDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * managerActionDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param managerActionDateTime
     *            new value of {@code managerActionDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managerActionDateTime} field changed
     */
    public ScheduleChangeRequest withManagerActionDateTime(OffsetDateTime managerActionDateTime) {
        ScheduleChangeRequest _x = _copy();
        _x.changedFields = changedFields.add("managerActionDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.scheduleChangeRequest");
        _x.managerActionDateTime = managerActionDateTime;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property senderUserId
     */
    @Property(name="senderUserId")
    @JsonIgnore
    public Optional<String> getSenderUserId() {
        return Optional.ofNullable(senderUserId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code senderUserId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param senderUserId
     *            new value of {@code senderUserId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code senderUserId} field changed
     */
    public ScheduleChangeRequest withSenderUserId(String senderUserId) {
        ScheduleChangeRequest _x = _copy();
        _x.changedFields = changedFields.add("senderUserId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.scheduleChangeRequest");
        _x.senderUserId = senderUserId;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property managerUserId
     */
    @Property(name="managerUserId")
    @JsonIgnore
    public Optional<String> getManagerUserId() {
        return Optional.ofNullable(managerUserId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code managerUserId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param managerUserId
     *            new value of {@code managerUserId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managerUserId} field changed
     */
    public ScheduleChangeRequest withManagerUserId(String managerUserId) {
        ScheduleChangeRequest _x = _copy();
        _x.changedFields = changedFields.add("managerUserId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.scheduleChangeRequest");
        _x.managerUserId = managerUserId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ScheduleChangeRequest patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ScheduleChangeRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ScheduleChangeRequest put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ScheduleChangeRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ScheduleChangeRequest _copy() {
        ScheduleChangeRequest _x = new ScheduleChangeRequest();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.lastModifiedBy = lastModifiedBy;
        _x.assignedTo = assignedTo;
        _x.state = state;
        _x.senderMessage = senderMessage;
        _x.senderDateTime = senderDateTime;
        _x.managerActionMessage = managerActionMessage;
        _x.managerActionDateTime = managerActionDateTime;
        _x.senderUserId = senderUserId;
        _x.managerUserId = managerUserId;
        return _x;
    }

    @Action(name = "approve")
    @JsonIgnore
    public ActionRequestNoReturn approve(String message) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("message", "Edm.String", Checks.checkIsAscii(message))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.approve"), _parameters);
    }

    @Action(name = "decline")
    @JsonIgnore
    public ActionRequestNoReturn decline(String message) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("message", "Edm.String", Checks.checkIsAscii(message))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.decline"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ScheduleChangeRequest[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("assignedTo=");
        b.append(this.assignedTo);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("senderMessage=");
        b.append(this.senderMessage);
        b.append(", ");
        b.append("senderDateTime=");
        b.append(this.senderDateTime);
        b.append(", ");
        b.append("managerActionMessage=");
        b.append(this.managerActionMessage);
        b.append(", ");
        b.append("managerActionDateTime=");
        b.append(this.managerActionDateTime);
        b.append(", ");
        b.append("senderUserId=");
        b.append(this.senderUserId);
        b.append(", ");
        b.append("managerUserId=");
        b.append(this.managerUserId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
