package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.OfferShiftRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OpenShiftChangeRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OpenShiftCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SchedulingGroupCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ShiftCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SwapShiftsChangeRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TimeOffCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TimeOffReasonCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TimeOffRequestCollectionRequest;
import odata.msgraph.client.beta.enums.OperationStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "enabled", 
    "timeZone", 
    "provisionStatus", 
    "provisionStatusCode", 
    "workforceIntegrationIds", 
    "timeClockEnabled", 
    "openShiftsEnabled", 
    "swapShiftsRequestsEnabled", 
    "offerShiftRequestsEnabled", 
    "timeOffRequestsEnabled"})
@JsonInclude(Include.NON_NULL)
public class Schedule extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.schedule";
    }

    @JsonProperty("enabled")
    protected Boolean enabled;

    @JsonProperty("timeZone")
    protected String timeZone;

    @JsonProperty("provisionStatus")
    protected OperationStatus provisionStatus;

    @JsonProperty("provisionStatusCode")
    protected String provisionStatusCode;

    @JsonProperty("workforceIntegrationIds")
    protected List<String> workforceIntegrationIds;

    @JsonProperty("workforceIntegrationIds@nextLink")
    protected String workforceIntegrationIdsNextLink;

    @JsonProperty("timeClockEnabled")
    protected Boolean timeClockEnabled;

    @JsonProperty("openShiftsEnabled")
    protected Boolean openShiftsEnabled;

    @JsonProperty("swapShiftsRequestsEnabled")
    protected Boolean swapShiftsRequestsEnabled;

    @JsonProperty("offerShiftRequestsEnabled")
    protected Boolean offerShiftRequestsEnabled;

    @JsonProperty("timeOffRequestsEnabled")
    protected Boolean timeOffRequestsEnabled;

    protected Schedule() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSchedule() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean enabled;
        private String timeZone;
        private OperationStatus provisionStatus;
        private String provisionStatusCode;
        private List<String> workforceIntegrationIds;
        private String workforceIntegrationIdsNextLink;
        private Boolean timeClockEnabled;
        private Boolean openShiftsEnabled;
        private Boolean swapShiftsRequestsEnabled;
        private Boolean offerShiftRequestsEnabled;
        private Boolean timeOffRequestsEnabled;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            this.changedFields = changedFields.add("enabled");
            return this;
        }

        public Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            this.changedFields = changedFields.add("timeZone");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param provisionStatus
         *            value of {@code provisionStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder provisionStatus(OperationStatus provisionStatus) {
            this.provisionStatus = provisionStatus;
            this.changedFields = changedFields.add("provisionStatus");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param provisionStatusCode
         *            value of {@code provisionStatusCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder provisionStatusCode(String provisionStatusCode) {
            this.provisionStatusCode = provisionStatusCode;
            this.changedFields = changedFields.add("provisionStatusCode");
            return this;
        }

        public Builder workforceIntegrationIds(List<String> workforceIntegrationIds) {
            this.workforceIntegrationIds = workforceIntegrationIds;
            this.changedFields = changedFields.add("workforceIntegrationIds");
            return this;
        }

        public Builder workforceIntegrationIds(String... workforceIntegrationIds) {
            return workforceIntegrationIds(Arrays.asList(workforceIntegrationIds));
        }

        public Builder workforceIntegrationIdsNextLink(String workforceIntegrationIdsNextLink) {
            this.workforceIntegrationIdsNextLink = workforceIntegrationIdsNextLink;
            this.changedFields = changedFields.add("workforceIntegrationIds");
            return this;
        }

        public Builder timeClockEnabled(Boolean timeClockEnabled) {
            this.timeClockEnabled = timeClockEnabled;
            this.changedFields = changedFields.add("timeClockEnabled");
            return this;
        }

        public Builder openShiftsEnabled(Boolean openShiftsEnabled) {
            this.openShiftsEnabled = openShiftsEnabled;
            this.changedFields = changedFields.add("openShiftsEnabled");
            return this;
        }

        public Builder swapShiftsRequestsEnabled(Boolean swapShiftsRequestsEnabled) {
            this.swapShiftsRequestsEnabled = swapShiftsRequestsEnabled;
            this.changedFields = changedFields.add("swapShiftsRequestsEnabled");
            return this;
        }

        public Builder offerShiftRequestsEnabled(Boolean offerShiftRequestsEnabled) {
            this.offerShiftRequestsEnabled = offerShiftRequestsEnabled;
            this.changedFields = changedFields.add("offerShiftRequestsEnabled");
            return this;
        }

        public Builder timeOffRequestsEnabled(Boolean timeOffRequestsEnabled) {
            this.timeOffRequestsEnabled = timeOffRequestsEnabled;
            this.changedFields = changedFields.add("timeOffRequestsEnabled");
            return this;
        }

        public Schedule build() {
            Schedule _x = new Schedule();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.schedule";
            _x.id = id;
            _x.enabled = enabled;
            _x.timeZone = timeZone;
            _x.provisionStatus = provisionStatus;
            _x.provisionStatusCode = provisionStatusCode;
            _x.workforceIntegrationIds = workforceIntegrationIds;
            _x.workforceIntegrationIdsNextLink = workforceIntegrationIdsNextLink;
            _x.timeClockEnabled = timeClockEnabled;
            _x.openShiftsEnabled = openShiftsEnabled;
            _x.swapShiftsRequestsEnabled = swapShiftsRequestsEnabled;
            _x.offerShiftRequestsEnabled = offerShiftRequestsEnabled;
            _x.timeOffRequestsEnabled = timeOffRequestsEnabled;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="enabled")
    @JsonIgnore
    public Optional<Boolean> getEnabled() {
        return Optional.ofNullable(enabled);
    }

    public Schedule withEnabled(Boolean enabled) {
        Schedule _x = _copy();
        _x.changedFields = changedFields.add("enabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.schedule");
        _x.enabled = enabled;
        return _x;
    }

    @Property(name="timeZone")
    @JsonIgnore
    public Optional<String> getTimeZone() {
        return Optional.ofNullable(timeZone);
    }

    public Schedule withTimeZone(String timeZone) {
        Schedule _x = _copy();
        _x.changedFields = changedFields.add("timeZone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.schedule");
        _x.timeZone = timeZone;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property provisionStatus
     */
    @Property(name="provisionStatus")
    @JsonIgnore
    public Optional<OperationStatus> getProvisionStatus() {
        return Optional.ofNullable(provisionStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code provisionStatus}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param provisionStatus
     *            new value of {@code provisionStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code provisionStatus} field changed
     */
    public Schedule withProvisionStatus(OperationStatus provisionStatus) {
        Schedule _x = _copy();
        _x.changedFields = changedFields.add("provisionStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.schedule");
        _x.provisionStatus = provisionStatus;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property provisionStatusCode
     */
    @Property(name="provisionStatusCode")
    @JsonIgnore
    public Optional<String> getProvisionStatusCode() {
        return Optional.ofNullable(provisionStatusCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * provisionStatusCode} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param provisionStatusCode
     *            new value of {@code provisionStatusCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code provisionStatusCode} field changed
     */
    public Schedule withProvisionStatusCode(String provisionStatusCode) {
        Schedule _x = _copy();
        _x.changedFields = changedFields.add("provisionStatusCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.schedule");
        _x.provisionStatusCode = provisionStatusCode;
        return _x;
    }

    @Property(name="workforceIntegrationIds")
    @JsonIgnore
    public CollectionPage<String> getWorkforceIntegrationIds() {
        return new CollectionPage<String>(contextPath, String.class, workforceIntegrationIds, Optional.ofNullable(workforceIntegrationIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="workforceIntegrationIds")
    @JsonIgnore
    public CollectionPage<String> getWorkforceIntegrationIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, workforceIntegrationIds, Optional.ofNullable(workforceIntegrationIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="timeClockEnabled")
    @JsonIgnore
    public Optional<Boolean> getTimeClockEnabled() {
        return Optional.ofNullable(timeClockEnabled);
    }

    public Schedule withTimeClockEnabled(Boolean timeClockEnabled) {
        Schedule _x = _copy();
        _x.changedFields = changedFields.add("timeClockEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.schedule");
        _x.timeClockEnabled = timeClockEnabled;
        return _x;
    }

    @Property(name="openShiftsEnabled")
    @JsonIgnore
    public Optional<Boolean> getOpenShiftsEnabled() {
        return Optional.ofNullable(openShiftsEnabled);
    }

    public Schedule withOpenShiftsEnabled(Boolean openShiftsEnabled) {
        Schedule _x = _copy();
        _x.changedFields = changedFields.add("openShiftsEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.schedule");
        _x.openShiftsEnabled = openShiftsEnabled;
        return _x;
    }

    @Property(name="swapShiftsRequestsEnabled")
    @JsonIgnore
    public Optional<Boolean> getSwapShiftsRequestsEnabled() {
        return Optional.ofNullable(swapShiftsRequestsEnabled);
    }

    public Schedule withSwapShiftsRequestsEnabled(Boolean swapShiftsRequestsEnabled) {
        Schedule _x = _copy();
        _x.changedFields = changedFields.add("swapShiftsRequestsEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.schedule");
        _x.swapShiftsRequestsEnabled = swapShiftsRequestsEnabled;
        return _x;
    }

    @Property(name="offerShiftRequestsEnabled")
    @JsonIgnore
    public Optional<Boolean> getOfferShiftRequestsEnabled() {
        return Optional.ofNullable(offerShiftRequestsEnabled);
    }

    public Schedule withOfferShiftRequestsEnabled(Boolean offerShiftRequestsEnabled) {
        Schedule _x = _copy();
        _x.changedFields = changedFields.add("offerShiftRequestsEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.schedule");
        _x.offerShiftRequestsEnabled = offerShiftRequestsEnabled;
        return _x;
    }

    @Property(name="timeOffRequestsEnabled")
    @JsonIgnore
    public Optional<Boolean> getTimeOffRequestsEnabled() {
        return Optional.ofNullable(timeOffRequestsEnabled);
    }

    public Schedule withTimeOffRequestsEnabled(Boolean timeOffRequestsEnabled) {
        Schedule _x = _copy();
        _x.changedFields = changedFields.add("timeOffRequestsEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.schedule");
        _x.timeOffRequestsEnabled = timeOffRequestsEnabled;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * 
     * @return navigational property shifts
     */
    @NavigationProperty(name="shifts")
    @JsonIgnore
    public ShiftCollectionRequest getShifts() {
        return new ShiftCollectionRequest(
                        contextPath.addSegment("shifts"));
    }

    @NavigationProperty(name="openShifts")
    @JsonIgnore
    public OpenShiftCollectionRequest getOpenShifts() {
        return new OpenShiftCollectionRequest(
                        contextPath.addSegment("openShifts"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * 
     * @return navigational property timesOff
     */
    @NavigationProperty(name="timesOff")
    @JsonIgnore
    public TimeOffCollectionRequest getTimesOff() {
        return new TimeOffCollectionRequest(
                        contextPath.addSegment("timesOff"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * 
     * @return navigational property timeOffReasons
     */
    @NavigationProperty(name="timeOffReasons")
    @JsonIgnore
    public TimeOffReasonCollectionRequest getTimeOffReasons() {
        return new TimeOffReasonCollectionRequest(
                        contextPath.addSegment("timeOffReasons"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * 
     * @return navigational property schedulingGroups
     */
    @NavigationProperty(name="schedulingGroups")
    @JsonIgnore
    public SchedulingGroupCollectionRequest getSchedulingGroups() {
        return new SchedulingGroupCollectionRequest(
                        contextPath.addSegment("schedulingGroups"));
    }

    @NavigationProperty(name="swapShiftsChangeRequests")
    @JsonIgnore
    public SwapShiftsChangeRequestCollectionRequest getSwapShiftsChangeRequests() {
        return new SwapShiftsChangeRequestCollectionRequest(
                        contextPath.addSegment("swapShiftsChangeRequests"));
    }

    @NavigationProperty(name="openShiftChangeRequests")
    @JsonIgnore
    public OpenShiftChangeRequestCollectionRequest getOpenShiftChangeRequests() {
        return new OpenShiftChangeRequestCollectionRequest(
                        contextPath.addSegment("openShiftChangeRequests"));
    }

    @NavigationProperty(name="offerShiftRequests")
    @JsonIgnore
    public OfferShiftRequestCollectionRequest getOfferShiftRequests() {
        return new OfferShiftRequestCollectionRequest(
                        contextPath.addSegment("offerShiftRequests"));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * 
     * @return navigational property timeOffRequests
     */
    @NavigationProperty(name="timeOffRequests")
    @JsonIgnore
    public TimeOffRequestCollectionRequest getTimeOffRequests() {
        return new TimeOffRequestCollectionRequest(
                        contextPath.addSegment("timeOffRequests"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Schedule patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Schedule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Schedule put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Schedule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Schedule _copy() {
        Schedule _x = new Schedule();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.enabled = enabled;
        _x.timeZone = timeZone;
        _x.provisionStatus = provisionStatus;
        _x.provisionStatusCode = provisionStatusCode;
        _x.workforceIntegrationIds = workforceIntegrationIds;
        _x.timeClockEnabled = timeClockEnabled;
        _x.openShiftsEnabled = openShiftsEnabled;
        _x.swapShiftsRequestsEnabled = swapShiftsRequestsEnabled;
        _x.offerShiftRequestsEnabled = offerShiftRequestsEnabled;
        _x.timeOffRequestsEnabled = timeOffRequestsEnabled;
        return _x;
    }

    @Action(name = "share")
    @JsonIgnore
    public ActionRequestNoReturn share(Boolean notifyTeam, OffsetDateTime startDateTime, OffsetDateTime endDateTime) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("notifyTeam", "Edm.Boolean", notifyTeam)
            .put("startDateTime", "Edm.DateTimeOffset", startDateTime)
            .put("endDateTime", "Edm.DateTimeOffset", endDateTime)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.share"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Schedule[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("enabled=");
        b.append(this.enabled);
        b.append(", ");
        b.append("timeZone=");
        b.append(this.timeZone);
        b.append(", ");
        b.append("provisionStatus=");
        b.append(this.provisionStatus);
        b.append(", ");
        b.append("provisionStatusCode=");
        b.append(this.provisionStatusCode);
        b.append(", ");
        b.append("workforceIntegrationIds=");
        b.append(this.workforceIntegrationIds);
        b.append(", ");
        b.append("timeClockEnabled=");
        b.append(this.timeClockEnabled);
        b.append(", ");
        b.append("openShiftsEnabled=");
        b.append(this.openShiftsEnabled);
        b.append(", ");
        b.append("swapShiftsRequestsEnabled=");
        b.append(this.swapShiftsRequestsEnabled);
        b.append(", ");
        b.append("offerShiftRequestsEnabled=");
        b.append(this.offerShiftRequestsEnabled);
        b.append(", ");
        b.append("timeOffRequestsEnabled=");
        b.append(this.timeOffRequestsEnabled);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
