package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.AccountRequest;
import odata.msgraph.client.beta.entity.request.ItemRequest;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
 * <p>
 * Updatable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
 * <p>
 * Insertable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
 * <p>
 * Deletable = false
 */@JsonPropertyOrder({
    "@odata.type", 
    "documentId", 
    "sequence", 
    "itemId", 
    "accountId", 
    "lineType", 
    "description", 
    "unitOfMeasureId", 
    "quantity", 
    "unitPrice", 
    "discountAmount", 
    "discountPercent", 
    "discountAppliedBeforeTax", 
    "amountExcludingTax", 
    "taxCode", 
    "taxPercent", 
    "totalTaxAmount", 
    "amountIncludingTax", 
    "invoiceDiscountAllocation", 
    "netAmount", 
    "netTaxAmount", 
    "netAmountIncludingTax", 
    "shipmentDate", 
    "shippedQuantity", 
    "invoicedQuantity", 
    "invoiceQuantity", 
    "shipQuantity"})
@JsonInclude(Include.NON_NULL)
public class SalesOrderLine extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.salesOrderLine";
    }

    @JsonProperty("documentId")
    protected String documentId;

    @JsonProperty("sequence")
    protected Integer sequence;

    @JsonProperty("itemId")
    protected String itemId;

    @JsonProperty("accountId")
    protected String accountId;

    @JsonProperty("lineType")
    protected String lineType;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("unitOfMeasureId")
    protected String unitOfMeasureId;

    @JsonProperty("quantity")
    protected BigDecimal quantity;

    @JsonProperty("unitPrice")
    protected BigDecimal unitPrice;

    @JsonProperty("discountAmount")
    protected BigDecimal discountAmount;

    @JsonProperty("discountPercent")
    protected BigDecimal discountPercent;

    @JsonProperty("discountAppliedBeforeTax")
    protected Boolean discountAppliedBeforeTax;

    @JsonProperty("amountExcludingTax")
    protected BigDecimal amountExcludingTax;

    @JsonProperty("taxCode")
    protected String taxCode;

    @JsonProperty("taxPercent")
    protected BigDecimal taxPercent;

    @JsonProperty("totalTaxAmount")
    protected BigDecimal totalTaxAmount;

    @JsonProperty("amountIncludingTax")
    protected BigDecimal amountIncludingTax;

    @JsonProperty("invoiceDiscountAllocation")
    protected BigDecimal invoiceDiscountAllocation;

    @JsonProperty("netAmount")
    protected BigDecimal netAmount;

    @JsonProperty("netTaxAmount")
    protected BigDecimal netTaxAmount;

    @JsonProperty("netAmountIncludingTax")
    protected BigDecimal netAmountIncludingTax;

    @JsonProperty("shipmentDate")
    protected LocalDate shipmentDate;

    @JsonProperty("shippedQuantity")
    protected BigDecimal shippedQuantity;

    @JsonProperty("invoicedQuantity")
    protected BigDecimal invoicedQuantity;

    @JsonProperty("invoiceQuantity")
    protected BigDecimal invoiceQuantity;

    @JsonProperty("shipQuantity")
    protected BigDecimal shipQuantity;

    protected SalesOrderLine() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSalesOrderLine() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String documentId;
        private Integer sequence;
        private String itemId;
        private String accountId;
        private String lineType;
        private String description;
        private String unitOfMeasureId;
        private BigDecimal quantity;
        private BigDecimal unitPrice;
        private BigDecimal discountAmount;
        private BigDecimal discountPercent;
        private Boolean discountAppliedBeforeTax;
        private BigDecimal amountExcludingTax;
        private String taxCode;
        private BigDecimal taxPercent;
        private BigDecimal totalTaxAmount;
        private BigDecimal amountIncludingTax;
        private BigDecimal invoiceDiscountAllocation;
        private BigDecimal netAmount;
        private BigDecimal netTaxAmount;
        private BigDecimal netAmountIncludingTax;
        private LocalDate shipmentDate;
        private BigDecimal shippedQuantity;
        private BigDecimal invoicedQuantity;
        private BigDecimal invoiceQuantity;
        private BigDecimal shipQuantity;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder documentId(String documentId) {
            this.documentId = documentId;
            this.changedFields = changedFields.add("documentId");
            return this;
        }

        public Builder sequence(Integer sequence) {
            this.sequence = sequence;
            this.changedFields = changedFields.add("sequence");
            return this;
        }

        public Builder itemId(String itemId) {
            this.itemId = itemId;
            this.changedFields = changedFields.add("itemId");
            return this;
        }

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            this.changedFields = changedFields.add("accountId");
            return this;
        }

        public Builder lineType(String lineType) {
            this.lineType = lineType;
            this.changedFields = changedFields.add("lineType");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder unitOfMeasureId(String unitOfMeasureId) {
            this.unitOfMeasureId = unitOfMeasureId;
            this.changedFields = changedFields.add("unitOfMeasureId");
            return this;
        }

        public Builder quantity(BigDecimal quantity) {
            this.quantity = quantity;
            this.changedFields = changedFields.add("quantity");
            return this;
        }

        public Builder unitPrice(BigDecimal unitPrice) {
            this.unitPrice = unitPrice;
            this.changedFields = changedFields.add("unitPrice");
            return this;
        }

        public Builder discountAmount(BigDecimal discountAmount) {
            this.discountAmount = discountAmount;
            this.changedFields = changedFields.add("discountAmount");
            return this;
        }

        public Builder discountPercent(BigDecimal discountPercent) {
            this.discountPercent = discountPercent;
            this.changedFields = changedFields.add("discountPercent");
            return this;
        }

        public Builder discountAppliedBeforeTax(Boolean discountAppliedBeforeTax) {
            this.discountAppliedBeforeTax = discountAppliedBeforeTax;
            this.changedFields = changedFields.add("discountAppliedBeforeTax");
            return this;
        }

        public Builder amountExcludingTax(BigDecimal amountExcludingTax) {
            this.amountExcludingTax = amountExcludingTax;
            this.changedFields = changedFields.add("amountExcludingTax");
            return this;
        }

        public Builder taxCode(String taxCode) {
            this.taxCode = taxCode;
            this.changedFields = changedFields.add("taxCode");
            return this;
        }

        public Builder taxPercent(BigDecimal taxPercent) {
            this.taxPercent = taxPercent;
            this.changedFields = changedFields.add("taxPercent");
            return this;
        }

        public Builder totalTaxAmount(BigDecimal totalTaxAmount) {
            this.totalTaxAmount = totalTaxAmount;
            this.changedFields = changedFields.add("totalTaxAmount");
            return this;
        }

        public Builder amountIncludingTax(BigDecimal amountIncludingTax) {
            this.amountIncludingTax = amountIncludingTax;
            this.changedFields = changedFields.add("amountIncludingTax");
            return this;
        }

        public Builder invoiceDiscountAllocation(BigDecimal invoiceDiscountAllocation) {
            this.invoiceDiscountAllocation = invoiceDiscountAllocation;
            this.changedFields = changedFields.add("invoiceDiscountAllocation");
            return this;
        }

        public Builder netAmount(BigDecimal netAmount) {
            this.netAmount = netAmount;
            this.changedFields = changedFields.add("netAmount");
            return this;
        }

        public Builder netTaxAmount(BigDecimal netTaxAmount) {
            this.netTaxAmount = netTaxAmount;
            this.changedFields = changedFields.add("netTaxAmount");
            return this;
        }

        public Builder netAmountIncludingTax(BigDecimal netAmountIncludingTax) {
            this.netAmountIncludingTax = netAmountIncludingTax;
            this.changedFields = changedFields.add("netAmountIncludingTax");
            return this;
        }

        public Builder shipmentDate(LocalDate shipmentDate) {
            this.shipmentDate = shipmentDate;
            this.changedFields = changedFields.add("shipmentDate");
            return this;
        }

        public Builder shippedQuantity(BigDecimal shippedQuantity) {
            this.shippedQuantity = shippedQuantity;
            this.changedFields = changedFields.add("shippedQuantity");
            return this;
        }

        public Builder invoicedQuantity(BigDecimal invoicedQuantity) {
            this.invoicedQuantity = invoicedQuantity;
            this.changedFields = changedFields.add("invoicedQuantity");
            return this;
        }

        public Builder invoiceQuantity(BigDecimal invoiceQuantity) {
            this.invoiceQuantity = invoiceQuantity;
            this.changedFields = changedFields.add("invoiceQuantity");
            return this;
        }

        public Builder shipQuantity(BigDecimal shipQuantity) {
            this.shipQuantity = shipQuantity;
            this.changedFields = changedFields.add("shipQuantity");
            return this;
        }

        public SalesOrderLine build() {
            SalesOrderLine _x = new SalesOrderLine();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.salesOrderLine";
            _x.id = id;
            _x.documentId = documentId;
            _x.sequence = sequence;
            _x.itemId = itemId;
            _x.accountId = accountId;
            _x.lineType = lineType;
            _x.description = description;
            _x.unitOfMeasureId = unitOfMeasureId;
            _x.quantity = quantity;
            _x.unitPrice = unitPrice;
            _x.discountAmount = discountAmount;
            _x.discountPercent = discountPercent;
            _x.discountAppliedBeforeTax = discountAppliedBeforeTax;
            _x.amountExcludingTax = amountExcludingTax;
            _x.taxCode = taxCode;
            _x.taxPercent = taxPercent;
            _x.totalTaxAmount = totalTaxAmount;
            _x.amountIncludingTax = amountIncludingTax;
            _x.invoiceDiscountAllocation = invoiceDiscountAllocation;
            _x.netAmount = netAmount;
            _x.netTaxAmount = netTaxAmount;
            _x.netAmountIncludingTax = netAmountIncludingTax;
            _x.shipmentDate = shipmentDate;
            _x.shippedQuantity = shippedQuantity;
            _x.invoicedQuantity = invoicedQuantity;
            _x.invoiceQuantity = invoiceQuantity;
            _x.shipQuantity = shipQuantity;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="documentId")
    @JsonIgnore
    public Optional<String> getDocumentId() {
        return Optional.ofNullable(documentId);
    }

    public SalesOrderLine withDocumentId(String documentId) {
        SalesOrderLine _x = _copy();
        _x.changedFields = changedFields.add("documentId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrderLine");
        _x.documentId = documentId;
        return _x;
    }

    @Property(name="sequence")
    @JsonIgnore
    public Optional<Integer> getSequence() {
        return Optional.ofNullable(sequence);
    }

    public SalesOrderLine withSequence(Integer sequence) {
        SalesOrderLine _x = _copy();
        _x.changedFields = changedFields.add("sequence");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrderLine");
        _x.sequence = sequence;
        return _x;
    }

    @Property(name="itemId")
    @JsonIgnore
    public Optional<String> getItemId() {
        return Optional.ofNullable(itemId);
    }

    public SalesOrderLine withItemId(String itemId) {
        SalesOrderLine _x = _copy();
        _x.changedFields = changedFields.add("itemId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrderLine");
        _x.itemId = itemId;
        return _x;
    }

    @Property(name="accountId")
    @JsonIgnore
    public Optional<String> getAccountId() {
        return Optional.ofNullable(accountId);
    }

    public SalesOrderLine withAccountId(String accountId) {
        SalesOrderLine _x = _copy();
        _x.changedFields = changedFields.add("accountId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrderLine");
        _x.accountId = accountId;
        return _x;
    }

    @Property(name="lineType")
    @JsonIgnore
    public Optional<String> getLineType() {
        return Optional.ofNullable(lineType);
    }

    public SalesOrderLine withLineType(String lineType) {
        SalesOrderLine _x = _copy();
        _x.changedFields = changedFields.add("lineType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrderLine");
        _x.lineType = lineType;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public SalesOrderLine withDescription(String description) {
        SalesOrderLine _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrderLine");
        _x.description = description;
        return _x;
    }

    @Property(name="unitOfMeasureId")
    @JsonIgnore
    public Optional<String> getUnitOfMeasureId() {
        return Optional.ofNullable(unitOfMeasureId);
    }

    public SalesOrderLine withUnitOfMeasureId(String unitOfMeasureId) {
        SalesOrderLine _x = _copy();
        _x.changedFields = changedFields.add("unitOfMeasureId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrderLine");
        _x.unitOfMeasureId = unitOfMeasureId;
        return _x;
    }

    @Property(name="quantity")
    @JsonIgnore
    public Optional<BigDecimal> getQuantity() {
        return Optional.ofNullable(quantity);
    }

    public SalesOrderLine withQuantity(BigDecimal quantity) {
        SalesOrderLine _x = _copy();
        _x.changedFields = changedFields.add("quantity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrderLine");
        _x.quantity = quantity;
        return _x;
    }

    @Property(name="unitPrice")
    @JsonIgnore
    public Optional<BigDecimal> getUnitPrice() {
        return Optional.ofNullable(unitPrice);
    }

    public SalesOrderLine withUnitPrice(BigDecimal unitPrice) {
        SalesOrderLine _x = _copy();
        _x.changedFields = changedFields.add("unitPrice");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrderLine");
        _x.unitPrice = unitPrice;
        return _x;
    }

    @Property(name="discountAmount")
    @JsonIgnore
    public Optional<BigDecimal> getDiscountAmount() {
        return Optional.ofNullable(discountAmount);
    }

    public SalesOrderLine withDiscountAmount(BigDecimal discountAmount) {
        SalesOrderLine _x = _copy();
        _x.changedFields = changedFields.add("discountAmount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrderLine");
        _x.discountAmount = discountAmount;
        return _x;
    }

    @Property(name="discountPercent")
    @JsonIgnore
    public Optional<BigDecimal> getDiscountPercent() {
        return Optional.ofNullable(discountPercent);
    }

    public SalesOrderLine withDiscountPercent(BigDecimal discountPercent) {
        SalesOrderLine _x = _copy();
        _x.changedFields = changedFields.add("discountPercent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrderLine");
        _x.discountPercent = discountPercent;
        return _x;
    }

    @Property(name="discountAppliedBeforeTax")
    @JsonIgnore
    public Optional<Boolean> getDiscountAppliedBeforeTax() {
        return Optional.ofNullable(discountAppliedBeforeTax);
    }

    public SalesOrderLine withDiscountAppliedBeforeTax(Boolean discountAppliedBeforeTax) {
        SalesOrderLine _x = _copy();
        _x.changedFields = changedFields.add("discountAppliedBeforeTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrderLine");
        _x.discountAppliedBeforeTax = discountAppliedBeforeTax;
        return _x;
    }

    @Property(name="amountExcludingTax")
    @JsonIgnore
    public Optional<BigDecimal> getAmountExcludingTax() {
        return Optional.ofNullable(amountExcludingTax);
    }

    public SalesOrderLine withAmountExcludingTax(BigDecimal amountExcludingTax) {
        SalesOrderLine _x = _copy();
        _x.changedFields = changedFields.add("amountExcludingTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrderLine");
        _x.amountExcludingTax = amountExcludingTax;
        return _x;
    }

    @Property(name="taxCode")
    @JsonIgnore
    public Optional<String> getTaxCode() {
        return Optional.ofNullable(taxCode);
    }

    public SalesOrderLine withTaxCode(String taxCode) {
        SalesOrderLine _x = _copy();
        _x.changedFields = changedFields.add("taxCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrderLine");
        _x.taxCode = taxCode;
        return _x;
    }

    @Property(name="taxPercent")
    @JsonIgnore
    public Optional<BigDecimal> getTaxPercent() {
        return Optional.ofNullable(taxPercent);
    }

    public SalesOrderLine withTaxPercent(BigDecimal taxPercent) {
        SalesOrderLine _x = _copy();
        _x.changedFields = changedFields.add("taxPercent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrderLine");
        _x.taxPercent = taxPercent;
        return _x;
    }

    @Property(name="totalTaxAmount")
    @JsonIgnore
    public Optional<BigDecimal> getTotalTaxAmount() {
        return Optional.ofNullable(totalTaxAmount);
    }

    public SalesOrderLine withTotalTaxAmount(BigDecimal totalTaxAmount) {
        SalesOrderLine _x = _copy();
        _x.changedFields = changedFields.add("totalTaxAmount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrderLine");
        _x.totalTaxAmount = totalTaxAmount;
        return _x;
    }

    @Property(name="amountIncludingTax")
    @JsonIgnore
    public Optional<BigDecimal> getAmountIncludingTax() {
        return Optional.ofNullable(amountIncludingTax);
    }

    public SalesOrderLine withAmountIncludingTax(BigDecimal amountIncludingTax) {
        SalesOrderLine _x = _copy();
        _x.changedFields = changedFields.add("amountIncludingTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrderLine");
        _x.amountIncludingTax = amountIncludingTax;
        return _x;
    }

    @Property(name="invoiceDiscountAllocation")
    @JsonIgnore
    public Optional<BigDecimal> getInvoiceDiscountAllocation() {
        return Optional.ofNullable(invoiceDiscountAllocation);
    }

    public SalesOrderLine withInvoiceDiscountAllocation(BigDecimal invoiceDiscountAllocation) {
        SalesOrderLine _x = _copy();
        _x.changedFields = changedFields.add("invoiceDiscountAllocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrderLine");
        _x.invoiceDiscountAllocation = invoiceDiscountAllocation;
        return _x;
    }

    @Property(name="netAmount")
    @JsonIgnore
    public Optional<BigDecimal> getNetAmount() {
        return Optional.ofNullable(netAmount);
    }

    public SalesOrderLine withNetAmount(BigDecimal netAmount) {
        SalesOrderLine _x = _copy();
        _x.changedFields = changedFields.add("netAmount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrderLine");
        _x.netAmount = netAmount;
        return _x;
    }

    @Property(name="netTaxAmount")
    @JsonIgnore
    public Optional<BigDecimal> getNetTaxAmount() {
        return Optional.ofNullable(netTaxAmount);
    }

    public SalesOrderLine withNetTaxAmount(BigDecimal netTaxAmount) {
        SalesOrderLine _x = _copy();
        _x.changedFields = changedFields.add("netTaxAmount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrderLine");
        _x.netTaxAmount = netTaxAmount;
        return _x;
    }

    @Property(name="netAmountIncludingTax")
    @JsonIgnore
    public Optional<BigDecimal> getNetAmountIncludingTax() {
        return Optional.ofNullable(netAmountIncludingTax);
    }

    public SalesOrderLine withNetAmountIncludingTax(BigDecimal netAmountIncludingTax) {
        SalesOrderLine _x = _copy();
        _x.changedFields = changedFields.add("netAmountIncludingTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrderLine");
        _x.netAmountIncludingTax = netAmountIncludingTax;
        return _x;
    }

    @Property(name="shipmentDate")
    @JsonIgnore
    public Optional<LocalDate> getShipmentDate() {
        return Optional.ofNullable(shipmentDate);
    }

    public SalesOrderLine withShipmentDate(LocalDate shipmentDate) {
        SalesOrderLine _x = _copy();
        _x.changedFields = changedFields.add("shipmentDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrderLine");
        _x.shipmentDate = shipmentDate;
        return _x;
    }

    @Property(name="shippedQuantity")
    @JsonIgnore
    public Optional<BigDecimal> getShippedQuantity() {
        return Optional.ofNullable(shippedQuantity);
    }

    public SalesOrderLine withShippedQuantity(BigDecimal shippedQuantity) {
        SalesOrderLine _x = _copy();
        _x.changedFields = changedFields.add("shippedQuantity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrderLine");
        _x.shippedQuantity = shippedQuantity;
        return _x;
    }

    @Property(name="invoicedQuantity")
    @JsonIgnore
    public Optional<BigDecimal> getInvoicedQuantity() {
        return Optional.ofNullable(invoicedQuantity);
    }

    public SalesOrderLine withInvoicedQuantity(BigDecimal invoicedQuantity) {
        SalesOrderLine _x = _copy();
        _x.changedFields = changedFields.add("invoicedQuantity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrderLine");
        _x.invoicedQuantity = invoicedQuantity;
        return _x;
    }

    @Property(name="invoiceQuantity")
    @JsonIgnore
    public Optional<BigDecimal> getInvoiceQuantity() {
        return Optional.ofNullable(invoiceQuantity);
    }

    public SalesOrderLine withInvoiceQuantity(BigDecimal invoiceQuantity) {
        SalesOrderLine _x = _copy();
        _x.changedFields = changedFields.add("invoiceQuantity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrderLine");
        _x.invoiceQuantity = invoiceQuantity;
        return _x;
    }

    @Property(name="shipQuantity")
    @JsonIgnore
    public Optional<BigDecimal> getShipQuantity() {
        return Optional.ofNullable(shipQuantity);
    }

    public SalesOrderLine withShipQuantity(BigDecimal shipQuantity) {
        SalesOrderLine _x = _copy();
        _x.changedFields = changedFields.add("shipQuantity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrderLine");
        _x.shipQuantity = shipQuantity;
        return _x;
    }

    @NavigationProperty(name="item")
    @JsonIgnore
    public ItemRequest getItem() {
        return new ItemRequest(contextPath.addSegment("item"));
    }

    @NavigationProperty(name="account")
    @JsonIgnore
    public AccountRequest getAccount() {
        return new AccountRequest(contextPath.addSegment("account"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SalesOrderLine patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SalesOrderLine _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SalesOrderLine put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SalesOrderLine _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SalesOrderLine _copy() {
        SalesOrderLine _x = new SalesOrderLine();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.documentId = documentId;
        _x.sequence = sequence;
        _x.itemId = itemId;
        _x.accountId = accountId;
        _x.lineType = lineType;
        _x.description = description;
        _x.unitOfMeasureId = unitOfMeasureId;
        _x.quantity = quantity;
        _x.unitPrice = unitPrice;
        _x.discountAmount = discountAmount;
        _x.discountPercent = discountPercent;
        _x.discountAppliedBeforeTax = discountAppliedBeforeTax;
        _x.amountExcludingTax = amountExcludingTax;
        _x.taxCode = taxCode;
        _x.taxPercent = taxPercent;
        _x.totalTaxAmount = totalTaxAmount;
        _x.amountIncludingTax = amountIncludingTax;
        _x.invoiceDiscountAllocation = invoiceDiscountAllocation;
        _x.netAmount = netAmount;
        _x.netTaxAmount = netTaxAmount;
        _x.netAmountIncludingTax = netAmountIncludingTax;
        _x.shipmentDate = shipmentDate;
        _x.shippedQuantity = shippedQuantity;
        _x.invoicedQuantity = invoicedQuantity;
        _x.invoiceQuantity = invoiceQuantity;
        _x.shipQuantity = shipQuantity;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SalesOrderLine[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("documentId=");
        b.append(this.documentId);
        b.append(", ");
        b.append("sequence=");
        b.append(this.sequence);
        b.append(", ");
        b.append("itemId=");
        b.append(this.itemId);
        b.append(", ");
        b.append("accountId=");
        b.append(this.accountId);
        b.append(", ");
        b.append("lineType=");
        b.append(this.lineType);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("unitOfMeasureId=");
        b.append(this.unitOfMeasureId);
        b.append(", ");
        b.append("quantity=");
        b.append(this.quantity);
        b.append(", ");
        b.append("unitPrice=");
        b.append(this.unitPrice);
        b.append(", ");
        b.append("discountAmount=");
        b.append(this.discountAmount);
        b.append(", ");
        b.append("discountPercent=");
        b.append(this.discountPercent);
        b.append(", ");
        b.append("discountAppliedBeforeTax=");
        b.append(this.discountAppliedBeforeTax);
        b.append(", ");
        b.append("amountExcludingTax=");
        b.append(this.amountExcludingTax);
        b.append(", ");
        b.append("taxCode=");
        b.append(this.taxCode);
        b.append(", ");
        b.append("taxPercent=");
        b.append(this.taxPercent);
        b.append(", ");
        b.append("totalTaxAmount=");
        b.append(this.totalTaxAmount);
        b.append(", ");
        b.append("amountIncludingTax=");
        b.append(this.amountIncludingTax);
        b.append(", ");
        b.append("invoiceDiscountAllocation=");
        b.append(this.invoiceDiscountAllocation);
        b.append(", ");
        b.append("netAmount=");
        b.append(this.netAmount);
        b.append(", ");
        b.append("netTaxAmount=");
        b.append(this.netTaxAmount);
        b.append(", ");
        b.append("netAmountIncludingTax=");
        b.append(this.netAmountIncludingTax);
        b.append(", ");
        b.append("shipmentDate=");
        b.append(this.shipmentDate);
        b.append(", ");
        b.append("shippedQuantity=");
        b.append(this.shippedQuantity);
        b.append(", ");
        b.append("invoicedQuantity=");
        b.append(this.invoicedQuantity);
        b.append(", ");
        b.append("invoiceQuantity=");
        b.append(this.invoiceQuantity);
        b.append(", ");
        b.append("shipQuantity=");
        b.append(this.shipQuantity);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
