package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.PostalAddressType;
import odata.msgraph.client.beta.entity.collection.request.SalesOrderLineCollectionRequest;
import odata.msgraph.client.beta.entity.request.CurrencyRequest;
import odata.msgraph.client.beta.entity.request.CustomerRequest;
import odata.msgraph.client.beta.entity.request.PaymentTermRequest;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
 * <p>
 * Updatable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
 * <p>
 * Insertable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
 * <p>
 * Deletable = false
 */@JsonPropertyOrder({
    "@odata.type", 
    "number", 
    "externalDocumentNumber", 
    "orderDate", 
    "customerId", 
    "customerNumber", 
    "customerName", 
    "billToName", 
    "billToCustomerId", 
    "billToCustomerNumber", 
    "shipToName", 
    "shipToContact", 
    "sellingPostalAddress", 
    "billingPostalAddress", 
    "shippingPostalAddress", 
    "currencyId", 
    "currencyCode", 
    "pricesIncludeTax", 
    "paymentTermsId", 
    "salesperson", 
    "partialShipping", 
    "requestedDeliveryDate", 
    "discountAmount", 
    "discountAppliedBeforeTax", 
    "totalAmountExcludingTax", 
    "totalTaxAmount", 
    "totalAmountIncludingTax", 
    "fullyShipped", 
    "status", 
    "lastModifiedDateTime", 
    "phoneNumber", 
    "email"})
@JsonInclude(Include.NON_NULL)
public class SalesOrder extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.salesOrder";
    }

    @JsonProperty("number")
    protected String number;

    @JsonProperty("externalDocumentNumber")
    protected String externalDocumentNumber;

    @JsonProperty("orderDate")
    protected LocalDate orderDate;

    @JsonProperty("customerId")
    protected String customerId;

    @JsonProperty("customerNumber")
    protected String customerNumber;

    @JsonProperty("customerName")
    protected String customerName;

    @JsonProperty("billToName")
    protected String billToName;

    @JsonProperty("billToCustomerId")
    protected String billToCustomerId;

    @JsonProperty("billToCustomerNumber")
    protected String billToCustomerNumber;

    @JsonProperty("shipToName")
    protected String shipToName;

    @JsonProperty("shipToContact")
    protected String shipToContact;

    @JsonProperty("sellingPostalAddress")
    protected PostalAddressType sellingPostalAddress;

    @JsonProperty("billingPostalAddress")
    protected PostalAddressType billingPostalAddress;

    @JsonProperty("shippingPostalAddress")
    protected PostalAddressType shippingPostalAddress;

    @JsonProperty("currencyId")
    protected String currencyId;

    @JsonProperty("currencyCode")
    protected String currencyCode;

    @JsonProperty("pricesIncludeTax")
    protected Boolean pricesIncludeTax;

    @JsonProperty("paymentTermsId")
    protected String paymentTermsId;

    @JsonProperty("salesperson")
    protected String salesperson;

    @JsonProperty("partialShipping")
    protected Boolean partialShipping;

    @JsonProperty("requestedDeliveryDate")
    protected LocalDate requestedDeliveryDate;

    @JsonProperty("discountAmount")
    protected BigDecimal discountAmount;

    @JsonProperty("discountAppliedBeforeTax")
    protected Boolean discountAppliedBeforeTax;

    @JsonProperty("totalAmountExcludingTax")
    protected BigDecimal totalAmountExcludingTax;

    @JsonProperty("totalTaxAmount")
    protected BigDecimal totalTaxAmount;

    @JsonProperty("totalAmountIncludingTax")
    protected BigDecimal totalAmountIncludingTax;

    @JsonProperty("fullyShipped")
    protected Boolean fullyShipped;

    @JsonProperty("status")
    protected String status;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("phoneNumber")
    protected String phoneNumber;

    @JsonProperty("email")
    protected String email;

    protected SalesOrder() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSalesOrder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String number;
        private String externalDocumentNumber;
        private LocalDate orderDate;
        private String customerId;
        private String customerNumber;
        private String customerName;
        private String billToName;
        private String billToCustomerId;
        private String billToCustomerNumber;
        private String shipToName;
        private String shipToContact;
        private PostalAddressType sellingPostalAddress;
        private PostalAddressType billingPostalAddress;
        private PostalAddressType shippingPostalAddress;
        private String currencyId;
        private String currencyCode;
        private Boolean pricesIncludeTax;
        private String paymentTermsId;
        private String salesperson;
        private Boolean partialShipping;
        private LocalDate requestedDeliveryDate;
        private BigDecimal discountAmount;
        private Boolean discountAppliedBeforeTax;
        private BigDecimal totalAmountExcludingTax;
        private BigDecimal totalTaxAmount;
        private BigDecimal totalAmountIncludingTax;
        private Boolean fullyShipped;
        private String status;
        private OffsetDateTime lastModifiedDateTime;
        private String phoneNumber;
        private String email;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder number(String number) {
            this.number = number;
            this.changedFields = changedFields.add("number");
            return this;
        }

        public Builder externalDocumentNumber(String externalDocumentNumber) {
            this.externalDocumentNumber = externalDocumentNumber;
            this.changedFields = changedFields.add("externalDocumentNumber");
            return this;
        }

        public Builder orderDate(LocalDate orderDate) {
            this.orderDate = orderDate;
            this.changedFields = changedFields.add("orderDate");
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = customerId;
            this.changedFields = changedFields.add("customerId");
            return this;
        }

        public Builder customerNumber(String customerNumber) {
            this.customerNumber = customerNumber;
            this.changedFields = changedFields.add("customerNumber");
            return this;
        }

        public Builder customerName(String customerName) {
            this.customerName = customerName;
            this.changedFields = changedFields.add("customerName");
            return this;
        }

        public Builder billToName(String billToName) {
            this.billToName = billToName;
            this.changedFields = changedFields.add("billToName");
            return this;
        }

        public Builder billToCustomerId(String billToCustomerId) {
            this.billToCustomerId = billToCustomerId;
            this.changedFields = changedFields.add("billToCustomerId");
            return this;
        }

        public Builder billToCustomerNumber(String billToCustomerNumber) {
            this.billToCustomerNumber = billToCustomerNumber;
            this.changedFields = changedFields.add("billToCustomerNumber");
            return this;
        }

        public Builder shipToName(String shipToName) {
            this.shipToName = shipToName;
            this.changedFields = changedFields.add("shipToName");
            return this;
        }

        public Builder shipToContact(String shipToContact) {
            this.shipToContact = shipToContact;
            this.changedFields = changedFields.add("shipToContact");
            return this;
        }

        public Builder sellingPostalAddress(PostalAddressType sellingPostalAddress) {
            this.sellingPostalAddress = sellingPostalAddress;
            this.changedFields = changedFields.add("sellingPostalAddress");
            return this;
        }

        public Builder billingPostalAddress(PostalAddressType billingPostalAddress) {
            this.billingPostalAddress = billingPostalAddress;
            this.changedFields = changedFields.add("billingPostalAddress");
            return this;
        }

        public Builder shippingPostalAddress(PostalAddressType shippingPostalAddress) {
            this.shippingPostalAddress = shippingPostalAddress;
            this.changedFields = changedFields.add("shippingPostalAddress");
            return this;
        }

        public Builder currencyId(String currencyId) {
            this.currencyId = currencyId;
            this.changedFields = changedFields.add("currencyId");
            return this;
        }

        public Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            this.changedFields = changedFields.add("currencyCode");
            return this;
        }

        public Builder pricesIncludeTax(Boolean pricesIncludeTax) {
            this.pricesIncludeTax = pricesIncludeTax;
            this.changedFields = changedFields.add("pricesIncludeTax");
            return this;
        }

        public Builder paymentTermsId(String paymentTermsId) {
            this.paymentTermsId = paymentTermsId;
            this.changedFields = changedFields.add("paymentTermsId");
            return this;
        }

        public Builder salesperson(String salesperson) {
            this.salesperson = salesperson;
            this.changedFields = changedFields.add("salesperson");
            return this;
        }

        public Builder partialShipping(Boolean partialShipping) {
            this.partialShipping = partialShipping;
            this.changedFields = changedFields.add("partialShipping");
            return this;
        }

        public Builder requestedDeliveryDate(LocalDate requestedDeliveryDate) {
            this.requestedDeliveryDate = requestedDeliveryDate;
            this.changedFields = changedFields.add("requestedDeliveryDate");
            return this;
        }

        public Builder discountAmount(BigDecimal discountAmount) {
            this.discountAmount = discountAmount;
            this.changedFields = changedFields.add("discountAmount");
            return this;
        }

        public Builder discountAppliedBeforeTax(Boolean discountAppliedBeforeTax) {
            this.discountAppliedBeforeTax = discountAppliedBeforeTax;
            this.changedFields = changedFields.add("discountAppliedBeforeTax");
            return this;
        }

        public Builder totalAmountExcludingTax(BigDecimal totalAmountExcludingTax) {
            this.totalAmountExcludingTax = totalAmountExcludingTax;
            this.changedFields = changedFields.add("totalAmountExcludingTax");
            return this;
        }

        public Builder totalTaxAmount(BigDecimal totalTaxAmount) {
            this.totalTaxAmount = totalTaxAmount;
            this.changedFields = changedFields.add("totalTaxAmount");
            return this;
        }

        public Builder totalAmountIncludingTax(BigDecimal totalAmountIncludingTax) {
            this.totalAmountIncludingTax = totalAmountIncludingTax;
            this.changedFields = changedFields.add("totalAmountIncludingTax");
            return this;
        }

        public Builder fullyShipped(Boolean fullyShipped) {
            this.fullyShipped = fullyShipped;
            this.changedFields = changedFields.add("fullyShipped");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            this.changedFields = changedFields.add("phoneNumber");
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            this.changedFields = changedFields.add("email");
            return this;
        }

        public SalesOrder build() {
            SalesOrder _x = new SalesOrder();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.salesOrder";
            _x.id = id;
            _x.number = number;
            _x.externalDocumentNumber = externalDocumentNumber;
            _x.orderDate = orderDate;
            _x.customerId = customerId;
            _x.customerNumber = customerNumber;
            _x.customerName = customerName;
            _x.billToName = billToName;
            _x.billToCustomerId = billToCustomerId;
            _x.billToCustomerNumber = billToCustomerNumber;
            _x.shipToName = shipToName;
            _x.shipToContact = shipToContact;
            _x.sellingPostalAddress = sellingPostalAddress;
            _x.billingPostalAddress = billingPostalAddress;
            _x.shippingPostalAddress = shippingPostalAddress;
            _x.currencyId = currencyId;
            _x.currencyCode = currencyCode;
            _x.pricesIncludeTax = pricesIncludeTax;
            _x.paymentTermsId = paymentTermsId;
            _x.salesperson = salesperson;
            _x.partialShipping = partialShipping;
            _x.requestedDeliveryDate = requestedDeliveryDate;
            _x.discountAmount = discountAmount;
            _x.discountAppliedBeforeTax = discountAppliedBeforeTax;
            _x.totalAmountExcludingTax = totalAmountExcludingTax;
            _x.totalTaxAmount = totalTaxAmount;
            _x.totalAmountIncludingTax = totalAmountIncludingTax;
            _x.fullyShipped = fullyShipped;
            _x.status = status;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.phoneNumber = phoneNumber;
            _x.email = email;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="number")
    @JsonIgnore
    public Optional<String> getNumber() {
        return Optional.ofNullable(number);
    }

    public SalesOrder withNumber(String number) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("number");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.number = number;
        return _x;
    }

    @Property(name="externalDocumentNumber")
    @JsonIgnore
    public Optional<String> getExternalDocumentNumber() {
        return Optional.ofNullable(externalDocumentNumber);
    }

    public SalesOrder withExternalDocumentNumber(String externalDocumentNumber) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("externalDocumentNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.externalDocumentNumber = externalDocumentNumber;
        return _x;
    }

    @Property(name="orderDate")
    @JsonIgnore
    public Optional<LocalDate> getOrderDate() {
        return Optional.ofNullable(orderDate);
    }

    public SalesOrder withOrderDate(LocalDate orderDate) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("orderDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.orderDate = orderDate;
        return _x;
    }

    @Property(name="customerId")
    @JsonIgnore
    public Optional<String> getCustomerId() {
        return Optional.ofNullable(customerId);
    }

    public SalesOrder withCustomerId(String customerId) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("customerId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.customerId = customerId;
        return _x;
    }

    @Property(name="customerNumber")
    @JsonIgnore
    public Optional<String> getCustomerNumber() {
        return Optional.ofNullable(customerNumber);
    }

    public SalesOrder withCustomerNumber(String customerNumber) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("customerNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.customerNumber = customerNumber;
        return _x;
    }

    @Property(name="customerName")
    @JsonIgnore
    public Optional<String> getCustomerName() {
        return Optional.ofNullable(customerName);
    }

    public SalesOrder withCustomerName(String customerName) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("customerName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.customerName = customerName;
        return _x;
    }

    @Property(name="billToName")
    @JsonIgnore
    public Optional<String> getBillToName() {
        return Optional.ofNullable(billToName);
    }

    public SalesOrder withBillToName(String billToName) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("billToName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.billToName = billToName;
        return _x;
    }

    @Property(name="billToCustomerId")
    @JsonIgnore
    public Optional<String> getBillToCustomerId() {
        return Optional.ofNullable(billToCustomerId);
    }

    public SalesOrder withBillToCustomerId(String billToCustomerId) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("billToCustomerId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.billToCustomerId = billToCustomerId;
        return _x;
    }

    @Property(name="billToCustomerNumber")
    @JsonIgnore
    public Optional<String> getBillToCustomerNumber() {
        return Optional.ofNullable(billToCustomerNumber);
    }

    public SalesOrder withBillToCustomerNumber(String billToCustomerNumber) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("billToCustomerNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.billToCustomerNumber = billToCustomerNumber;
        return _x;
    }

    @Property(name="shipToName")
    @JsonIgnore
    public Optional<String> getShipToName() {
        return Optional.ofNullable(shipToName);
    }

    public SalesOrder withShipToName(String shipToName) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("shipToName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.shipToName = shipToName;
        return _x;
    }

    @Property(name="shipToContact")
    @JsonIgnore
    public Optional<String> getShipToContact() {
        return Optional.ofNullable(shipToContact);
    }

    public SalesOrder withShipToContact(String shipToContact) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("shipToContact");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.shipToContact = shipToContact;
        return _x;
    }

    @Property(name="sellingPostalAddress")
    @JsonIgnore
    public Optional<PostalAddressType> getSellingPostalAddress() {
        return Optional.ofNullable(sellingPostalAddress);
    }

    public SalesOrder withSellingPostalAddress(PostalAddressType sellingPostalAddress) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("sellingPostalAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.sellingPostalAddress = sellingPostalAddress;
        return _x;
    }

    @Property(name="billingPostalAddress")
    @JsonIgnore
    public Optional<PostalAddressType> getBillingPostalAddress() {
        return Optional.ofNullable(billingPostalAddress);
    }

    public SalesOrder withBillingPostalAddress(PostalAddressType billingPostalAddress) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("billingPostalAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.billingPostalAddress = billingPostalAddress;
        return _x;
    }

    @Property(name="shippingPostalAddress")
    @JsonIgnore
    public Optional<PostalAddressType> getShippingPostalAddress() {
        return Optional.ofNullable(shippingPostalAddress);
    }

    public SalesOrder withShippingPostalAddress(PostalAddressType shippingPostalAddress) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("shippingPostalAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.shippingPostalAddress = shippingPostalAddress;
        return _x;
    }

    @Property(name="currencyId")
    @JsonIgnore
    public Optional<String> getCurrencyId() {
        return Optional.ofNullable(currencyId);
    }

    public SalesOrder withCurrencyId(String currencyId) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("currencyId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.currencyId = currencyId;
        return _x;
    }

    @Property(name="currencyCode")
    @JsonIgnore
    public Optional<String> getCurrencyCode() {
        return Optional.ofNullable(currencyCode);
    }

    public SalesOrder withCurrencyCode(String currencyCode) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("currencyCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.currencyCode = currencyCode;
        return _x;
    }

    @Property(name="pricesIncludeTax")
    @JsonIgnore
    public Optional<Boolean> getPricesIncludeTax() {
        return Optional.ofNullable(pricesIncludeTax);
    }

    public SalesOrder withPricesIncludeTax(Boolean pricesIncludeTax) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("pricesIncludeTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.pricesIncludeTax = pricesIncludeTax;
        return _x;
    }

    @Property(name="paymentTermsId")
    @JsonIgnore
    public Optional<String> getPaymentTermsId() {
        return Optional.ofNullable(paymentTermsId);
    }

    public SalesOrder withPaymentTermsId(String paymentTermsId) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("paymentTermsId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.paymentTermsId = paymentTermsId;
        return _x;
    }

    @Property(name="salesperson")
    @JsonIgnore
    public Optional<String> getSalesperson() {
        return Optional.ofNullable(salesperson);
    }

    public SalesOrder withSalesperson(String salesperson) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("salesperson");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.salesperson = salesperson;
        return _x;
    }

    @Property(name="partialShipping")
    @JsonIgnore
    public Optional<Boolean> getPartialShipping() {
        return Optional.ofNullable(partialShipping);
    }

    public SalesOrder withPartialShipping(Boolean partialShipping) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("partialShipping");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.partialShipping = partialShipping;
        return _x;
    }

    @Property(name="requestedDeliveryDate")
    @JsonIgnore
    public Optional<LocalDate> getRequestedDeliveryDate() {
        return Optional.ofNullable(requestedDeliveryDate);
    }

    public SalesOrder withRequestedDeliveryDate(LocalDate requestedDeliveryDate) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("requestedDeliveryDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.requestedDeliveryDate = requestedDeliveryDate;
        return _x;
    }

    @Property(name="discountAmount")
    @JsonIgnore
    public Optional<BigDecimal> getDiscountAmount() {
        return Optional.ofNullable(discountAmount);
    }

    public SalesOrder withDiscountAmount(BigDecimal discountAmount) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("discountAmount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.discountAmount = discountAmount;
        return _x;
    }

    @Property(name="discountAppliedBeforeTax")
    @JsonIgnore
    public Optional<Boolean> getDiscountAppliedBeforeTax() {
        return Optional.ofNullable(discountAppliedBeforeTax);
    }

    public SalesOrder withDiscountAppliedBeforeTax(Boolean discountAppliedBeforeTax) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("discountAppliedBeforeTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.discountAppliedBeforeTax = discountAppliedBeforeTax;
        return _x;
    }

    @Property(name="totalAmountExcludingTax")
    @JsonIgnore
    public Optional<BigDecimal> getTotalAmountExcludingTax() {
        return Optional.ofNullable(totalAmountExcludingTax);
    }

    public SalesOrder withTotalAmountExcludingTax(BigDecimal totalAmountExcludingTax) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("totalAmountExcludingTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.totalAmountExcludingTax = totalAmountExcludingTax;
        return _x;
    }

    @Property(name="totalTaxAmount")
    @JsonIgnore
    public Optional<BigDecimal> getTotalTaxAmount() {
        return Optional.ofNullable(totalTaxAmount);
    }

    public SalesOrder withTotalTaxAmount(BigDecimal totalTaxAmount) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("totalTaxAmount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.totalTaxAmount = totalTaxAmount;
        return _x;
    }

    @Property(name="totalAmountIncludingTax")
    @JsonIgnore
    public Optional<BigDecimal> getTotalAmountIncludingTax() {
        return Optional.ofNullable(totalAmountIncludingTax);
    }

    public SalesOrder withTotalAmountIncludingTax(BigDecimal totalAmountIncludingTax) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("totalAmountIncludingTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.totalAmountIncludingTax = totalAmountIncludingTax;
        return _x;
    }

    @Property(name="fullyShipped")
    @JsonIgnore
    public Optional<Boolean> getFullyShipped() {
        return Optional.ofNullable(fullyShipped);
    }

    public SalesOrder withFullyShipped(Boolean fullyShipped) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("fullyShipped");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.fullyShipped = fullyShipped;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public SalesOrder withStatus(String status) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.status = status;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public SalesOrder withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="phoneNumber")
    @JsonIgnore
    public Optional<String> getPhoneNumber() {
        return Optional.ofNullable(phoneNumber);
    }

    public SalesOrder withPhoneNumber(String phoneNumber) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("phoneNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.phoneNumber = phoneNumber;
        return _x;
    }

    @Property(name="email")
    @JsonIgnore
    public Optional<String> getEmail() {
        return Optional.ofNullable(email);
    }

    public SalesOrder withEmail(String email) {
        SalesOrder _x = _copy();
        _x.changedFields = changedFields.add("email");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesOrder");
        _x.email = email;
        return _x;
    }

    @NavigationProperty(name="salesOrderLines")
    @JsonIgnore
    public SalesOrderLineCollectionRequest getSalesOrderLines() {
        return new SalesOrderLineCollectionRequest(
                        contextPath.addSegment("salesOrderLines"));
    }

    @NavigationProperty(name="customer")
    @JsonIgnore
    public CustomerRequest getCustomer() {
        return new CustomerRequest(contextPath.addSegment("customer"));
    }

    @NavigationProperty(name="currency")
    @JsonIgnore
    public CurrencyRequest getCurrency() {
        return new CurrencyRequest(contextPath.addSegment("currency"));
    }

    @NavigationProperty(name="paymentTerm")
    @JsonIgnore
    public PaymentTermRequest getPaymentTerm() {
        return new PaymentTermRequest(contextPath.addSegment("paymentTerm"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SalesOrder patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SalesOrder _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SalesOrder put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SalesOrder _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SalesOrder _copy() {
        SalesOrder _x = new SalesOrder();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.number = number;
        _x.externalDocumentNumber = externalDocumentNumber;
        _x.orderDate = orderDate;
        _x.customerId = customerId;
        _x.customerNumber = customerNumber;
        _x.customerName = customerName;
        _x.billToName = billToName;
        _x.billToCustomerId = billToCustomerId;
        _x.billToCustomerNumber = billToCustomerNumber;
        _x.shipToName = shipToName;
        _x.shipToContact = shipToContact;
        _x.sellingPostalAddress = sellingPostalAddress;
        _x.billingPostalAddress = billingPostalAddress;
        _x.shippingPostalAddress = shippingPostalAddress;
        _x.currencyId = currencyId;
        _x.currencyCode = currencyCode;
        _x.pricesIncludeTax = pricesIncludeTax;
        _x.paymentTermsId = paymentTermsId;
        _x.salesperson = salesperson;
        _x.partialShipping = partialShipping;
        _x.requestedDeliveryDate = requestedDeliveryDate;
        _x.discountAmount = discountAmount;
        _x.discountAppliedBeforeTax = discountAppliedBeforeTax;
        _x.totalAmountExcludingTax = totalAmountExcludingTax;
        _x.totalTaxAmount = totalTaxAmount;
        _x.totalAmountIncludingTax = totalAmountIncludingTax;
        _x.fullyShipped = fullyShipped;
        _x.status = status;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.phoneNumber = phoneNumber;
        _x.email = email;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SalesOrder[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("number=");
        b.append(this.number);
        b.append(", ");
        b.append("externalDocumentNumber=");
        b.append(this.externalDocumentNumber);
        b.append(", ");
        b.append("orderDate=");
        b.append(this.orderDate);
        b.append(", ");
        b.append("customerId=");
        b.append(this.customerId);
        b.append(", ");
        b.append("customerNumber=");
        b.append(this.customerNumber);
        b.append(", ");
        b.append("customerName=");
        b.append(this.customerName);
        b.append(", ");
        b.append("billToName=");
        b.append(this.billToName);
        b.append(", ");
        b.append("billToCustomerId=");
        b.append(this.billToCustomerId);
        b.append(", ");
        b.append("billToCustomerNumber=");
        b.append(this.billToCustomerNumber);
        b.append(", ");
        b.append("shipToName=");
        b.append(this.shipToName);
        b.append(", ");
        b.append("shipToContact=");
        b.append(this.shipToContact);
        b.append(", ");
        b.append("sellingPostalAddress=");
        b.append(this.sellingPostalAddress);
        b.append(", ");
        b.append("billingPostalAddress=");
        b.append(this.billingPostalAddress);
        b.append(", ");
        b.append("shippingPostalAddress=");
        b.append(this.shippingPostalAddress);
        b.append(", ");
        b.append("currencyId=");
        b.append(this.currencyId);
        b.append(", ");
        b.append("currencyCode=");
        b.append(this.currencyCode);
        b.append(", ");
        b.append("pricesIncludeTax=");
        b.append(this.pricesIncludeTax);
        b.append(", ");
        b.append("paymentTermsId=");
        b.append(this.paymentTermsId);
        b.append(", ");
        b.append("salesperson=");
        b.append(this.salesperson);
        b.append(", ");
        b.append("partialShipping=");
        b.append(this.partialShipping);
        b.append(", ");
        b.append("requestedDeliveryDate=");
        b.append(this.requestedDeliveryDate);
        b.append(", ");
        b.append("discountAmount=");
        b.append(this.discountAmount);
        b.append(", ");
        b.append("discountAppliedBeforeTax=");
        b.append(this.discountAppliedBeforeTax);
        b.append(", ");
        b.append("totalAmountExcludingTax=");
        b.append(this.totalAmountExcludingTax);
        b.append(", ");
        b.append("totalTaxAmount=");
        b.append(this.totalTaxAmount);
        b.append(", ");
        b.append("totalAmountIncludingTax=");
        b.append(this.totalAmountIncludingTax);
        b.append(", ");
        b.append("fullyShipped=");
        b.append(this.fullyShipped);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("phoneNumber=");
        b.append(this.phoneNumber);
        b.append(", ");
        b.append("email=");
        b.append(this.email);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
