package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.PostalAddressType;
import odata.msgraph.client.beta.entity.collection.request.SalesInvoiceLineCollectionRequest;
import odata.msgraph.client.beta.entity.request.CurrencyRequest;
import odata.msgraph.client.beta.entity.request.CustomerRequest;
import odata.msgraph.client.beta.entity.request.PaymentTermRequest;
import odata.msgraph.client.beta.entity.request.ShipmentMethodRequest;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
 * <p>
 * Updatable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
 * <p>
 * Insertable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
 * <p>
 * Deletable = false
 */@JsonPropertyOrder({
    "@odata.type", 
    "number", 
    "externalDocumentNumber", 
    "invoiceDate", 
    "dueDate", 
    "customerPurchaseOrderReference", 
    "customerId", 
    "customerNumber", 
    "customerName", 
    "billToName", 
    "billToCustomerId", 
    "billToCustomerNumber", 
    "shipToName", 
    "shipToContact", 
    "sellingPostalAddress", 
    "billingPostalAddress", 
    "shippingPostalAddress", 
    "currencyId", 
    "currencyCode", 
    "orderId", 
    "orderNumber", 
    "paymentTermsId", 
    "shipmentMethodId", 
    "salesperson", 
    "pricesIncludeTax", 
    "discountAmount", 
    "discountAppliedBeforeTax", 
    "totalAmountExcludingTax", 
    "totalTaxAmount", 
    "totalAmountIncludingTax", 
    "status", 
    "lastModifiedDateTime", 
    "phoneNumber", 
    "email"})
@JsonInclude(Include.NON_NULL)
public class SalesInvoice extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.salesInvoice";
    }

    @JsonProperty("number")
    protected String number;

    @JsonProperty("externalDocumentNumber")
    protected String externalDocumentNumber;

    @JsonProperty("invoiceDate")
    protected LocalDate invoiceDate;

    @JsonProperty("dueDate")
    protected LocalDate dueDate;

    @JsonProperty("customerPurchaseOrderReference")
    protected String customerPurchaseOrderReference;

    @JsonProperty("customerId")
    protected String customerId;

    @JsonProperty("customerNumber")
    protected String customerNumber;

    @JsonProperty("customerName")
    protected String customerName;

    @JsonProperty("billToName")
    protected String billToName;

    @JsonProperty("billToCustomerId")
    protected String billToCustomerId;

    @JsonProperty("billToCustomerNumber")
    protected String billToCustomerNumber;

    @JsonProperty("shipToName")
    protected String shipToName;

    @JsonProperty("shipToContact")
    protected String shipToContact;

    @JsonProperty("sellingPostalAddress")
    protected PostalAddressType sellingPostalAddress;

    @JsonProperty("billingPostalAddress")
    protected PostalAddressType billingPostalAddress;

    @JsonProperty("shippingPostalAddress")
    protected PostalAddressType shippingPostalAddress;

    @JsonProperty("currencyId")
    protected String currencyId;

    @JsonProperty("currencyCode")
    protected String currencyCode;

    @JsonProperty("orderId")
    protected String orderId;

    @JsonProperty("orderNumber")
    protected String orderNumber;

    @JsonProperty("paymentTermsId")
    protected String paymentTermsId;

    @JsonProperty("shipmentMethodId")
    protected String shipmentMethodId;

    @JsonProperty("salesperson")
    protected String salesperson;

    @JsonProperty("pricesIncludeTax")
    protected Boolean pricesIncludeTax;

    @JsonProperty("discountAmount")
    protected BigDecimal discountAmount;

    @JsonProperty("discountAppliedBeforeTax")
    protected Boolean discountAppliedBeforeTax;

    @JsonProperty("totalAmountExcludingTax")
    protected BigDecimal totalAmountExcludingTax;

    @JsonProperty("totalTaxAmount")
    protected BigDecimal totalTaxAmount;

    @JsonProperty("totalAmountIncludingTax")
    protected BigDecimal totalAmountIncludingTax;

    @JsonProperty("status")
    protected String status;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("phoneNumber")
    protected String phoneNumber;

    @JsonProperty("email")
    protected String email;

    protected SalesInvoice() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSalesInvoice() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String number;
        private String externalDocumentNumber;
        private LocalDate invoiceDate;
        private LocalDate dueDate;
        private String customerPurchaseOrderReference;
        private String customerId;
        private String customerNumber;
        private String customerName;
        private String billToName;
        private String billToCustomerId;
        private String billToCustomerNumber;
        private String shipToName;
        private String shipToContact;
        private PostalAddressType sellingPostalAddress;
        private PostalAddressType billingPostalAddress;
        private PostalAddressType shippingPostalAddress;
        private String currencyId;
        private String currencyCode;
        private String orderId;
        private String orderNumber;
        private String paymentTermsId;
        private String shipmentMethodId;
        private String salesperson;
        private Boolean pricesIncludeTax;
        private BigDecimal discountAmount;
        private Boolean discountAppliedBeforeTax;
        private BigDecimal totalAmountExcludingTax;
        private BigDecimal totalTaxAmount;
        private BigDecimal totalAmountIncludingTax;
        private String status;
        private OffsetDateTime lastModifiedDateTime;
        private String phoneNumber;
        private String email;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder number(String number) {
            this.number = number;
            this.changedFields = changedFields.add("number");
            return this;
        }

        public Builder externalDocumentNumber(String externalDocumentNumber) {
            this.externalDocumentNumber = externalDocumentNumber;
            this.changedFields = changedFields.add("externalDocumentNumber");
            return this;
        }

        public Builder invoiceDate(LocalDate invoiceDate) {
            this.invoiceDate = invoiceDate;
            this.changedFields = changedFields.add("invoiceDate");
            return this;
        }

        public Builder dueDate(LocalDate dueDate) {
            this.dueDate = dueDate;
            this.changedFields = changedFields.add("dueDate");
            return this;
        }

        public Builder customerPurchaseOrderReference(String customerPurchaseOrderReference) {
            this.customerPurchaseOrderReference = customerPurchaseOrderReference;
            this.changedFields = changedFields.add("customerPurchaseOrderReference");
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = customerId;
            this.changedFields = changedFields.add("customerId");
            return this;
        }

        public Builder customerNumber(String customerNumber) {
            this.customerNumber = customerNumber;
            this.changedFields = changedFields.add("customerNumber");
            return this;
        }

        public Builder customerName(String customerName) {
            this.customerName = customerName;
            this.changedFields = changedFields.add("customerName");
            return this;
        }

        public Builder billToName(String billToName) {
            this.billToName = billToName;
            this.changedFields = changedFields.add("billToName");
            return this;
        }

        public Builder billToCustomerId(String billToCustomerId) {
            this.billToCustomerId = billToCustomerId;
            this.changedFields = changedFields.add("billToCustomerId");
            return this;
        }

        public Builder billToCustomerNumber(String billToCustomerNumber) {
            this.billToCustomerNumber = billToCustomerNumber;
            this.changedFields = changedFields.add("billToCustomerNumber");
            return this;
        }

        public Builder shipToName(String shipToName) {
            this.shipToName = shipToName;
            this.changedFields = changedFields.add("shipToName");
            return this;
        }

        public Builder shipToContact(String shipToContact) {
            this.shipToContact = shipToContact;
            this.changedFields = changedFields.add("shipToContact");
            return this;
        }

        public Builder sellingPostalAddress(PostalAddressType sellingPostalAddress) {
            this.sellingPostalAddress = sellingPostalAddress;
            this.changedFields = changedFields.add("sellingPostalAddress");
            return this;
        }

        public Builder billingPostalAddress(PostalAddressType billingPostalAddress) {
            this.billingPostalAddress = billingPostalAddress;
            this.changedFields = changedFields.add("billingPostalAddress");
            return this;
        }

        public Builder shippingPostalAddress(PostalAddressType shippingPostalAddress) {
            this.shippingPostalAddress = shippingPostalAddress;
            this.changedFields = changedFields.add("shippingPostalAddress");
            return this;
        }

        public Builder currencyId(String currencyId) {
            this.currencyId = currencyId;
            this.changedFields = changedFields.add("currencyId");
            return this;
        }

        public Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            this.changedFields = changedFields.add("currencyCode");
            return this;
        }

        public Builder orderId(String orderId) {
            this.orderId = orderId;
            this.changedFields = changedFields.add("orderId");
            return this;
        }

        public Builder orderNumber(String orderNumber) {
            this.orderNumber = orderNumber;
            this.changedFields = changedFields.add("orderNumber");
            return this;
        }

        public Builder paymentTermsId(String paymentTermsId) {
            this.paymentTermsId = paymentTermsId;
            this.changedFields = changedFields.add("paymentTermsId");
            return this;
        }

        public Builder shipmentMethodId(String shipmentMethodId) {
            this.shipmentMethodId = shipmentMethodId;
            this.changedFields = changedFields.add("shipmentMethodId");
            return this;
        }

        public Builder salesperson(String salesperson) {
            this.salesperson = salesperson;
            this.changedFields = changedFields.add("salesperson");
            return this;
        }

        public Builder pricesIncludeTax(Boolean pricesIncludeTax) {
            this.pricesIncludeTax = pricesIncludeTax;
            this.changedFields = changedFields.add("pricesIncludeTax");
            return this;
        }

        public Builder discountAmount(BigDecimal discountAmount) {
            this.discountAmount = discountAmount;
            this.changedFields = changedFields.add("discountAmount");
            return this;
        }

        public Builder discountAppliedBeforeTax(Boolean discountAppliedBeforeTax) {
            this.discountAppliedBeforeTax = discountAppliedBeforeTax;
            this.changedFields = changedFields.add("discountAppliedBeforeTax");
            return this;
        }

        public Builder totalAmountExcludingTax(BigDecimal totalAmountExcludingTax) {
            this.totalAmountExcludingTax = totalAmountExcludingTax;
            this.changedFields = changedFields.add("totalAmountExcludingTax");
            return this;
        }

        public Builder totalTaxAmount(BigDecimal totalTaxAmount) {
            this.totalTaxAmount = totalTaxAmount;
            this.changedFields = changedFields.add("totalTaxAmount");
            return this;
        }

        public Builder totalAmountIncludingTax(BigDecimal totalAmountIncludingTax) {
            this.totalAmountIncludingTax = totalAmountIncludingTax;
            this.changedFields = changedFields.add("totalAmountIncludingTax");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            this.changedFields = changedFields.add("phoneNumber");
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            this.changedFields = changedFields.add("email");
            return this;
        }

        public SalesInvoice build() {
            SalesInvoice _x = new SalesInvoice();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.salesInvoice";
            _x.id = id;
            _x.number = number;
            _x.externalDocumentNumber = externalDocumentNumber;
            _x.invoiceDate = invoiceDate;
            _x.dueDate = dueDate;
            _x.customerPurchaseOrderReference = customerPurchaseOrderReference;
            _x.customerId = customerId;
            _x.customerNumber = customerNumber;
            _x.customerName = customerName;
            _x.billToName = billToName;
            _x.billToCustomerId = billToCustomerId;
            _x.billToCustomerNumber = billToCustomerNumber;
            _x.shipToName = shipToName;
            _x.shipToContact = shipToContact;
            _x.sellingPostalAddress = sellingPostalAddress;
            _x.billingPostalAddress = billingPostalAddress;
            _x.shippingPostalAddress = shippingPostalAddress;
            _x.currencyId = currencyId;
            _x.currencyCode = currencyCode;
            _x.orderId = orderId;
            _x.orderNumber = orderNumber;
            _x.paymentTermsId = paymentTermsId;
            _x.shipmentMethodId = shipmentMethodId;
            _x.salesperson = salesperson;
            _x.pricesIncludeTax = pricesIncludeTax;
            _x.discountAmount = discountAmount;
            _x.discountAppliedBeforeTax = discountAppliedBeforeTax;
            _x.totalAmountExcludingTax = totalAmountExcludingTax;
            _x.totalTaxAmount = totalTaxAmount;
            _x.totalAmountIncludingTax = totalAmountIncludingTax;
            _x.status = status;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.phoneNumber = phoneNumber;
            _x.email = email;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="number")
    @JsonIgnore
    public Optional<String> getNumber() {
        return Optional.ofNullable(number);
    }

    public SalesInvoice withNumber(String number) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("number");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.number = number;
        return _x;
    }

    @Property(name="externalDocumentNumber")
    @JsonIgnore
    public Optional<String> getExternalDocumentNumber() {
        return Optional.ofNullable(externalDocumentNumber);
    }

    public SalesInvoice withExternalDocumentNumber(String externalDocumentNumber) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("externalDocumentNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.externalDocumentNumber = externalDocumentNumber;
        return _x;
    }

    @Property(name="invoiceDate")
    @JsonIgnore
    public Optional<LocalDate> getInvoiceDate() {
        return Optional.ofNullable(invoiceDate);
    }

    public SalesInvoice withInvoiceDate(LocalDate invoiceDate) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("invoiceDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.invoiceDate = invoiceDate;
        return _x;
    }

    @Property(name="dueDate")
    @JsonIgnore
    public Optional<LocalDate> getDueDate() {
        return Optional.ofNullable(dueDate);
    }

    public SalesInvoice withDueDate(LocalDate dueDate) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("dueDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.dueDate = dueDate;
        return _x;
    }

    @Property(name="customerPurchaseOrderReference")
    @JsonIgnore
    public Optional<String> getCustomerPurchaseOrderReference() {
        return Optional.ofNullable(customerPurchaseOrderReference);
    }

    public SalesInvoice withCustomerPurchaseOrderReference(String customerPurchaseOrderReference) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("customerPurchaseOrderReference");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.customerPurchaseOrderReference = customerPurchaseOrderReference;
        return _x;
    }

    @Property(name="customerId")
    @JsonIgnore
    public Optional<String> getCustomerId() {
        return Optional.ofNullable(customerId);
    }

    public SalesInvoice withCustomerId(String customerId) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("customerId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.customerId = customerId;
        return _x;
    }

    @Property(name="customerNumber")
    @JsonIgnore
    public Optional<String> getCustomerNumber() {
        return Optional.ofNullable(customerNumber);
    }

    public SalesInvoice withCustomerNumber(String customerNumber) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("customerNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.customerNumber = customerNumber;
        return _x;
    }

    @Property(name="customerName")
    @JsonIgnore
    public Optional<String> getCustomerName() {
        return Optional.ofNullable(customerName);
    }

    public SalesInvoice withCustomerName(String customerName) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("customerName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.customerName = customerName;
        return _x;
    }

    @Property(name="billToName")
    @JsonIgnore
    public Optional<String> getBillToName() {
        return Optional.ofNullable(billToName);
    }

    public SalesInvoice withBillToName(String billToName) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("billToName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.billToName = billToName;
        return _x;
    }

    @Property(name="billToCustomerId")
    @JsonIgnore
    public Optional<String> getBillToCustomerId() {
        return Optional.ofNullable(billToCustomerId);
    }

    public SalesInvoice withBillToCustomerId(String billToCustomerId) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("billToCustomerId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.billToCustomerId = billToCustomerId;
        return _x;
    }

    @Property(name="billToCustomerNumber")
    @JsonIgnore
    public Optional<String> getBillToCustomerNumber() {
        return Optional.ofNullable(billToCustomerNumber);
    }

    public SalesInvoice withBillToCustomerNumber(String billToCustomerNumber) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("billToCustomerNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.billToCustomerNumber = billToCustomerNumber;
        return _x;
    }

    @Property(name="shipToName")
    @JsonIgnore
    public Optional<String> getShipToName() {
        return Optional.ofNullable(shipToName);
    }

    public SalesInvoice withShipToName(String shipToName) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("shipToName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.shipToName = shipToName;
        return _x;
    }

    @Property(name="shipToContact")
    @JsonIgnore
    public Optional<String> getShipToContact() {
        return Optional.ofNullable(shipToContact);
    }

    public SalesInvoice withShipToContact(String shipToContact) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("shipToContact");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.shipToContact = shipToContact;
        return _x;
    }

    @Property(name="sellingPostalAddress")
    @JsonIgnore
    public Optional<PostalAddressType> getSellingPostalAddress() {
        return Optional.ofNullable(sellingPostalAddress);
    }

    public SalesInvoice withSellingPostalAddress(PostalAddressType sellingPostalAddress) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("sellingPostalAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.sellingPostalAddress = sellingPostalAddress;
        return _x;
    }

    @Property(name="billingPostalAddress")
    @JsonIgnore
    public Optional<PostalAddressType> getBillingPostalAddress() {
        return Optional.ofNullable(billingPostalAddress);
    }

    public SalesInvoice withBillingPostalAddress(PostalAddressType billingPostalAddress) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("billingPostalAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.billingPostalAddress = billingPostalAddress;
        return _x;
    }

    @Property(name="shippingPostalAddress")
    @JsonIgnore
    public Optional<PostalAddressType> getShippingPostalAddress() {
        return Optional.ofNullable(shippingPostalAddress);
    }

    public SalesInvoice withShippingPostalAddress(PostalAddressType shippingPostalAddress) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("shippingPostalAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.shippingPostalAddress = shippingPostalAddress;
        return _x;
    }

    @Property(name="currencyId")
    @JsonIgnore
    public Optional<String> getCurrencyId() {
        return Optional.ofNullable(currencyId);
    }

    public SalesInvoice withCurrencyId(String currencyId) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("currencyId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.currencyId = currencyId;
        return _x;
    }

    @Property(name="currencyCode")
    @JsonIgnore
    public Optional<String> getCurrencyCode() {
        return Optional.ofNullable(currencyCode);
    }

    public SalesInvoice withCurrencyCode(String currencyCode) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("currencyCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.currencyCode = currencyCode;
        return _x;
    }

    @Property(name="orderId")
    @JsonIgnore
    public Optional<String> getOrderId() {
        return Optional.ofNullable(orderId);
    }

    public SalesInvoice withOrderId(String orderId) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("orderId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.orderId = orderId;
        return _x;
    }

    @Property(name="orderNumber")
    @JsonIgnore
    public Optional<String> getOrderNumber() {
        return Optional.ofNullable(orderNumber);
    }

    public SalesInvoice withOrderNumber(String orderNumber) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("orderNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.orderNumber = orderNumber;
        return _x;
    }

    @Property(name="paymentTermsId")
    @JsonIgnore
    public Optional<String> getPaymentTermsId() {
        return Optional.ofNullable(paymentTermsId);
    }

    public SalesInvoice withPaymentTermsId(String paymentTermsId) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("paymentTermsId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.paymentTermsId = paymentTermsId;
        return _x;
    }

    @Property(name="shipmentMethodId")
    @JsonIgnore
    public Optional<String> getShipmentMethodId() {
        return Optional.ofNullable(shipmentMethodId);
    }

    public SalesInvoice withShipmentMethodId(String shipmentMethodId) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("shipmentMethodId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.shipmentMethodId = shipmentMethodId;
        return _x;
    }

    @Property(name="salesperson")
    @JsonIgnore
    public Optional<String> getSalesperson() {
        return Optional.ofNullable(salesperson);
    }

    public SalesInvoice withSalesperson(String salesperson) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("salesperson");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.salesperson = salesperson;
        return _x;
    }

    @Property(name="pricesIncludeTax")
    @JsonIgnore
    public Optional<Boolean> getPricesIncludeTax() {
        return Optional.ofNullable(pricesIncludeTax);
    }

    public SalesInvoice withPricesIncludeTax(Boolean pricesIncludeTax) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("pricesIncludeTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.pricesIncludeTax = pricesIncludeTax;
        return _x;
    }

    @Property(name="discountAmount")
    @JsonIgnore
    public Optional<BigDecimal> getDiscountAmount() {
        return Optional.ofNullable(discountAmount);
    }

    public SalesInvoice withDiscountAmount(BigDecimal discountAmount) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("discountAmount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.discountAmount = discountAmount;
        return _x;
    }

    @Property(name="discountAppliedBeforeTax")
    @JsonIgnore
    public Optional<Boolean> getDiscountAppliedBeforeTax() {
        return Optional.ofNullable(discountAppliedBeforeTax);
    }

    public SalesInvoice withDiscountAppliedBeforeTax(Boolean discountAppliedBeforeTax) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("discountAppliedBeforeTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.discountAppliedBeforeTax = discountAppliedBeforeTax;
        return _x;
    }

    @Property(name="totalAmountExcludingTax")
    @JsonIgnore
    public Optional<BigDecimal> getTotalAmountExcludingTax() {
        return Optional.ofNullable(totalAmountExcludingTax);
    }

    public SalesInvoice withTotalAmountExcludingTax(BigDecimal totalAmountExcludingTax) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("totalAmountExcludingTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.totalAmountExcludingTax = totalAmountExcludingTax;
        return _x;
    }

    @Property(name="totalTaxAmount")
    @JsonIgnore
    public Optional<BigDecimal> getTotalTaxAmount() {
        return Optional.ofNullable(totalTaxAmount);
    }

    public SalesInvoice withTotalTaxAmount(BigDecimal totalTaxAmount) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("totalTaxAmount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.totalTaxAmount = totalTaxAmount;
        return _x;
    }

    @Property(name="totalAmountIncludingTax")
    @JsonIgnore
    public Optional<BigDecimal> getTotalAmountIncludingTax() {
        return Optional.ofNullable(totalAmountIncludingTax);
    }

    public SalesInvoice withTotalAmountIncludingTax(BigDecimal totalAmountIncludingTax) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("totalAmountIncludingTax");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.totalAmountIncludingTax = totalAmountIncludingTax;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public SalesInvoice withStatus(String status) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.status = status;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public SalesInvoice withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="phoneNumber")
    @JsonIgnore
    public Optional<String> getPhoneNumber() {
        return Optional.ofNullable(phoneNumber);
    }

    public SalesInvoice withPhoneNumber(String phoneNumber) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("phoneNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.phoneNumber = phoneNumber;
        return _x;
    }

    @Property(name="email")
    @JsonIgnore
    public Optional<String> getEmail() {
        return Optional.ofNullable(email);
    }

    public SalesInvoice withEmail(String email) {
        SalesInvoice _x = _copy();
        _x.changedFields = changedFields.add("email");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.salesInvoice");
        _x.email = email;
        return _x;
    }

    @NavigationProperty(name="salesInvoiceLines")
    @JsonIgnore
    public SalesInvoiceLineCollectionRequest getSalesInvoiceLines() {
        return new SalesInvoiceLineCollectionRequest(
                        contextPath.addSegment("salesInvoiceLines"));
    }

    @NavigationProperty(name="customer")
    @JsonIgnore
    public CustomerRequest getCustomer() {
        return new CustomerRequest(contextPath.addSegment("customer"));
    }

    @NavigationProperty(name="currency")
    @JsonIgnore
    public CurrencyRequest getCurrency() {
        return new CurrencyRequest(contextPath.addSegment("currency"));
    }

    @NavigationProperty(name="paymentTerm")
    @JsonIgnore
    public PaymentTermRequest getPaymentTerm() {
        return new PaymentTermRequest(contextPath.addSegment("paymentTerm"));
    }

    @NavigationProperty(name="shipmentMethod")
    @JsonIgnore
    public ShipmentMethodRequest getShipmentMethod() {
        return new ShipmentMethodRequest(contextPath.addSegment("shipmentMethod"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SalesInvoice patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        SalesInvoice _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public SalesInvoice put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        SalesInvoice _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private SalesInvoice _copy() {
        SalesInvoice _x = new SalesInvoice();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.number = number;
        _x.externalDocumentNumber = externalDocumentNumber;
        _x.invoiceDate = invoiceDate;
        _x.dueDate = dueDate;
        _x.customerPurchaseOrderReference = customerPurchaseOrderReference;
        _x.customerId = customerId;
        _x.customerNumber = customerNumber;
        _x.customerName = customerName;
        _x.billToName = billToName;
        _x.billToCustomerId = billToCustomerId;
        _x.billToCustomerNumber = billToCustomerNumber;
        _x.shipToName = shipToName;
        _x.shipToContact = shipToContact;
        _x.sellingPostalAddress = sellingPostalAddress;
        _x.billingPostalAddress = billingPostalAddress;
        _x.shippingPostalAddress = shippingPostalAddress;
        _x.currencyId = currencyId;
        _x.currencyCode = currencyCode;
        _x.orderId = orderId;
        _x.orderNumber = orderNumber;
        _x.paymentTermsId = paymentTermsId;
        _x.shipmentMethodId = shipmentMethodId;
        _x.salesperson = salesperson;
        _x.pricesIncludeTax = pricesIncludeTax;
        _x.discountAmount = discountAmount;
        _x.discountAppliedBeforeTax = discountAppliedBeforeTax;
        _x.totalAmountExcludingTax = totalAmountExcludingTax;
        _x.totalTaxAmount = totalTaxAmount;
        _x.totalAmountIncludingTax = totalAmountIncludingTax;
        _x.status = status;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.phoneNumber = phoneNumber;
        _x.email = email;
        return _x;
    }

    @Action(name = "cancelAndSend")
    @JsonIgnore
    public ActionRequestNoReturn cancelAndSend() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancelAndSend"), _parameters);
    }

    @Action(name = "cancel")
    @JsonIgnore
    public ActionRequestNoReturn cancel() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancel"), _parameters);
    }

    @Action(name = "postAndSend")
    @JsonIgnore
    public ActionRequestNoReturn postAndSend() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.postAndSend"), _parameters);
    }

    @Action(name = "post")
    @JsonIgnore
    public ActionRequestNoReturn post() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.post"), _parameters);
    }

    @Action(name = "send")
    @JsonIgnore
    public ActionRequestNoReturn send() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.send"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SalesInvoice[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("number=");
        b.append(this.number);
        b.append(", ");
        b.append("externalDocumentNumber=");
        b.append(this.externalDocumentNumber);
        b.append(", ");
        b.append("invoiceDate=");
        b.append(this.invoiceDate);
        b.append(", ");
        b.append("dueDate=");
        b.append(this.dueDate);
        b.append(", ");
        b.append("customerPurchaseOrderReference=");
        b.append(this.customerPurchaseOrderReference);
        b.append(", ");
        b.append("customerId=");
        b.append(this.customerId);
        b.append(", ");
        b.append("customerNumber=");
        b.append(this.customerNumber);
        b.append(", ");
        b.append("customerName=");
        b.append(this.customerName);
        b.append(", ");
        b.append("billToName=");
        b.append(this.billToName);
        b.append(", ");
        b.append("billToCustomerId=");
        b.append(this.billToCustomerId);
        b.append(", ");
        b.append("billToCustomerNumber=");
        b.append(this.billToCustomerNumber);
        b.append(", ");
        b.append("shipToName=");
        b.append(this.shipToName);
        b.append(", ");
        b.append("shipToContact=");
        b.append(this.shipToContact);
        b.append(", ");
        b.append("sellingPostalAddress=");
        b.append(this.sellingPostalAddress);
        b.append(", ");
        b.append("billingPostalAddress=");
        b.append(this.billingPostalAddress);
        b.append(", ");
        b.append("shippingPostalAddress=");
        b.append(this.shippingPostalAddress);
        b.append(", ");
        b.append("currencyId=");
        b.append(this.currencyId);
        b.append(", ");
        b.append("currencyCode=");
        b.append(this.currencyCode);
        b.append(", ");
        b.append("orderId=");
        b.append(this.orderId);
        b.append(", ");
        b.append("orderNumber=");
        b.append(this.orderNumber);
        b.append(", ");
        b.append("paymentTermsId=");
        b.append(this.paymentTermsId);
        b.append(", ");
        b.append("shipmentMethodId=");
        b.append(this.shipmentMethodId);
        b.append(", ");
        b.append("salesperson=");
        b.append(this.salesperson);
        b.append(", ");
        b.append("pricesIncludeTax=");
        b.append(this.pricesIncludeTax);
        b.append(", ");
        b.append("discountAmount=");
        b.append(this.discountAmount);
        b.append(", ");
        b.append("discountAppliedBeforeTax=");
        b.append(this.discountAppliedBeforeTax);
        b.append(", ");
        b.append("totalAmountExcludingTax=");
        b.append(this.totalAmountExcludingTax);
        b.append(", ");
        b.append("totalTaxAmount=");
        b.append(this.totalTaxAmount);
        b.append(", ");
        b.append("totalAmountIncludingTax=");
        b.append(this.totalAmountIncludingTax);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("phoneNumber=");
        b.append(this.phoneNumber);
        b.append(", ");
        b.append("email=");
        b.append(this.email);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
