package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.OutlookGeoCoordinates;
import odata.msgraph.client.beta.complex.PhysicalAddress;
import odata.msgraph.client.beta.entity.collection.request.RoomCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "emailAddress"})
@JsonInclude(Include.NON_NULL)
public class RoomList extends Place implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.roomList";
    }

    @JsonProperty("emailAddress")
    protected String emailAddress;

    protected RoomList() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRoomList() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private OutlookGeoCoordinates geoCoordinates;
        private String phone;
        private PhysicalAddress address;
        private String emailAddress;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder geoCoordinates(OutlookGeoCoordinates geoCoordinates) {
            this.geoCoordinates = geoCoordinates;
            this.changedFields = changedFields.add("geoCoordinates");
            return this;
        }

        public Builder phone(String phone) {
            this.phone = phone;
            this.changedFields = changedFields.add("phone");
            return this;
        }

        public Builder address(PhysicalAddress address) {
            this.address = address;
            this.changedFields = changedFields.add("address");
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            this.changedFields = changedFields.add("emailAddress");
            return this;
        }

        public RoomList build() {
            RoomList _x = new RoomList();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.roomList";
            _x.id = id;
            _x.displayName = displayName;
            _x.geoCoordinates = geoCoordinates;
            _x.phone = phone;
            _x.address = address;
            _x.emailAddress = emailAddress;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="emailAddress")
    @JsonIgnore
    public Optional<String> getEmailAddress() {
        return Optional.ofNullable(emailAddress);
    }

    public RoomList withEmailAddress(String emailAddress) {
        RoomList _x = _copy();
        _x.changedFields = changedFields.add("emailAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roomList");
        _x.emailAddress = emailAddress;
        return _x;
    }

    @NavigationProperty(name="rooms")
    @JsonIgnore
    public RoomCollectionRequest getRooms() {
        return new RoomCollectionRequest(
                        contextPath.addSegment("rooms"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RoomList patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        RoomList _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RoomList put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        RoomList _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private RoomList _copy() {
        RoomList _x = new RoomList();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.geoCoordinates = geoCoordinates;
        _x.phone = phone;
        _x.address = address;
        _x.emailAddress = emailAddress;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RoomList[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("geoCoordinates=");
        b.append(this.geoCoordinates);
        b.append(", ");
        b.append("phone=");
        b.append(this.phone);
        b.append(", ");
        b.append("address=");
        b.append(this.address);
        b.append(", ");
        b.append("emailAddress=");
        b.append(this.emailAddress);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
