package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceAndAppManagementAssignmentTarget;


/**
 * <i>“Contains the properties for auto-assigning a Role Scope Tag to a group to be
 * applied to Devices.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "target"})
@JsonInclude(Include.NON_NULL)
public class RoleScopeTagAutoAssignment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.roleScopeTagAutoAssignment";
    }

    @JsonProperty("target")
    protected DeviceAndAppManagementAssignmentTarget target;

    protected RoleScopeTagAutoAssignment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRoleScopeTagAutoAssignment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private DeviceAndAppManagementAssignmentTarget target;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The auto-assignment target for the specific Role Scope Tag.”</i>
         * 
         * @param target
         *            value of {@code target} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder target(DeviceAndAppManagementAssignmentTarget target) {
            this.target = target;
            this.changedFields = changedFields.add("target");
            return this;
        }

        public RoleScopeTagAutoAssignment build() {
            RoleScopeTagAutoAssignment _x = new RoleScopeTagAutoAssignment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.roleScopeTagAutoAssignment";
            _x.id = id;
            _x.target = target;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The auto-assignment target for the specific Role Scope Tag.”</i>
     * 
     * @return property target
     */
    @Property(name="target")
    @JsonIgnore
    public Optional<DeviceAndAppManagementAssignmentTarget> getTarget() {
        return Optional.ofNullable(target);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code target} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The auto-assignment target for the specific Role Scope Tag.”</i>
     * 
     * @param target
     *            new value of {@code target} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code target} field changed
     */
    public RoleScopeTagAutoAssignment withTarget(DeviceAndAppManagementAssignmentTarget target) {
        RoleScopeTagAutoAssignment _x = _copy();
        _x.changedFields = changedFields.add("target");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleScopeTagAutoAssignment");
        _x.target = target;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RoleScopeTagAutoAssignment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        RoleScopeTagAutoAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RoleScopeTagAutoAssignment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        RoleScopeTagAutoAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private RoleScopeTagAutoAssignment _copy() {
        RoleScopeTagAutoAssignment _x = new RoleScopeTagAutoAssignment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.target = target;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RoleScopeTagAutoAssignment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("target=");
        b.append(this.target);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
