package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.RolePermission;
import odata.msgraph.client.beta.entity.collection.request.RoleAssignmentCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“The Role Definition resource. The role definition is the foundation of role
 * based access in Intune. The role combines an Intune resource such as a Mobile
 * App and associated role permissions such as Create or Read for the resource.
 * There are two types of roles, built-in and custom. Built-in roles cannot be
 * modified. Both built-in roles and custom roles must have assignments to be
 * enforced. Create custom roles if you want to define a role that allows any of
 * the available resources and role permissions to be combined into a single role.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "description", 
    "permissions", 
    "rolePermissions", 
    "isBuiltInRoleDefinition", 
    "isBuiltIn", 
    "roleScopeTagIds"})
@JsonInclude(Include.NON_NULL)
public class RoleDefinition extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.roleDefinition";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("permissions")
    protected List<RolePermission> permissions;

    @JsonProperty("permissions@nextLink")
    protected String permissionsNextLink;

    @JsonProperty("rolePermissions")
    protected List<RolePermission> rolePermissions;

    @JsonProperty("rolePermissions@nextLink")
    protected String rolePermissionsNextLink;

    @JsonProperty("isBuiltInRoleDefinition")
    protected Boolean isBuiltInRoleDefinition;

    @JsonProperty("isBuiltIn")
    protected Boolean isBuiltIn;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    protected RoleDefinition() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRoleDefinition() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private List<RolePermission> permissions;
        private String permissionsNextLink;
        private List<RolePermission> rolePermissions;
        private String rolePermissionsNextLink;
        private Boolean isBuiltInRoleDefinition;
        private Boolean isBuiltIn;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Display Name of the Role definition.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Description of the Role definition.”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“List of Role Permissions this role is allowed to perform. These must match the
         * actionName that is defined as part of the rolePermission.”</i>
         * 
         * @param permissions
         *            value of {@code permissions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder permissions(List<RolePermission> permissions) {
            this.permissions = permissions;
            this.changedFields = changedFields.add("permissions");
            return this;
        }

        /**
         * <i>“List of Role Permissions this role is allowed to perform. These must match the
         * actionName that is defined as part of the rolePermission.”</i>
         * 
         * @param permissions
         *            value of {@code permissions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder permissions(RolePermission... permissions) {
            return permissions(Arrays.asList(permissions));
        }

        /**
         * <i>“List of Role Permissions this role is allowed to perform. These must match the
         * actionName that is defined as part of the rolePermission.”</i>
         * 
         * @param permissionsNextLink
         *            value of {@code permissions@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder permissionsNextLink(String permissionsNextLink) {
            this.permissionsNextLink = permissionsNextLink;
            this.changedFields = changedFields.add("permissions");
            return this;
        }

        /**
         * <i>“List of Role Permissions this role is allowed to perform. These must match the
         * actionName that is defined as part of the rolePermission.”</i>
         * 
         * @param rolePermissions
         *            value of {@code rolePermissions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder rolePermissions(List<RolePermission> rolePermissions) {
            this.rolePermissions = rolePermissions;
            this.changedFields = changedFields.add("rolePermissions");
            return this;
        }

        /**
         * <i>“List of Role Permissions this role is allowed to perform. These must match the
         * actionName that is defined as part of the rolePermission.”</i>
         * 
         * @param rolePermissions
         *            value of {@code rolePermissions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder rolePermissions(RolePermission... rolePermissions) {
            return rolePermissions(Arrays.asList(rolePermissions));
        }

        /**
         * <i>“List of Role Permissions this role is allowed to perform. These must match the
         * actionName that is defined as part of the rolePermission.”</i>
         * 
         * @param rolePermissionsNextLink
         *            value of {@code rolePermissions@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder rolePermissionsNextLink(String rolePermissionsNextLink) {
            this.rolePermissionsNextLink = rolePermissionsNextLink;
            this.changedFields = changedFields.add("rolePermissions");
            return this;
        }

        /**
         * <i>“Type of Role. Set to True if it is built-in, or set to False if it is a custom
         * role definition.”</i>
         * 
         * @param isBuiltInRoleDefinition
         *            value of {@code isBuiltInRoleDefinition} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isBuiltInRoleDefinition(Boolean isBuiltInRoleDefinition) {
            this.isBuiltInRoleDefinition = isBuiltInRoleDefinition;
            this.changedFields = changedFields.add("isBuiltInRoleDefinition");
            return this;
        }

        /**
         * <i>“Type of Role. Set to True if it is built-in, or set to False if it is a custom
         * role definition.”</i>
         * 
         * @param isBuiltIn
         *            value of {@code isBuiltIn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isBuiltIn(Boolean isBuiltIn) {
            this.isBuiltIn = isBuiltIn;
            this.changedFields = changedFields.add("isBuiltIn");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIdsNextLink
         *            value of {@code roleScopeTagIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public RoleDefinition build() {
            RoleDefinition _x = new RoleDefinition();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.roleDefinition";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.permissions = permissions;
            _x.permissionsNextLink = permissionsNextLink;
            _x.rolePermissions = rolePermissions;
            _x.rolePermissionsNextLink = rolePermissionsNextLink;
            _x.isBuiltInRoleDefinition = isBuiltInRoleDefinition;
            _x.isBuiltIn = isBuiltIn;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Display Name of the Role definition.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Display Name of the Role definition.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public RoleDefinition withDisplayName(String displayName) {
        RoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleDefinition");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Description of the Role definition.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Description of the Role definition.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public RoleDefinition withDescription(String description) {
        RoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleDefinition");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“List of Role Permissions this role is allowed to perform. These must match the
     * actionName that is defined as part of the rolePermission.”</i>
     * 
     * @return property permissions
     */
    @Property(name="permissions")
    @JsonIgnore
    public CollectionPage<RolePermission> getPermissions() {
        return new CollectionPage<RolePermission>(contextPath, RolePermission.class, permissions, Optional.ofNullable(permissionsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of Role Permissions this role is allowed to perform. These must match the
     * actionName that is defined as part of the rolePermission.”</i>
     * 
     * @return property permissions
     */
    @Property(name="permissions")
    @JsonIgnore
    public CollectionPage<RolePermission> getPermissions(HttpRequestOptions options) {
        return new CollectionPage<RolePermission>(contextPath, RolePermission.class, permissions, Optional.ofNullable(permissionsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“List of Role Permissions this role is allowed to perform. These must match the
     * actionName that is defined as part of the rolePermission.”</i>
     * 
     * @return property rolePermissions
     */
    @Property(name="rolePermissions")
    @JsonIgnore
    public CollectionPage<RolePermission> getRolePermissions() {
        return new CollectionPage<RolePermission>(contextPath, RolePermission.class, rolePermissions, Optional.ofNullable(rolePermissionsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of Role Permissions this role is allowed to perform. These must match the
     * actionName that is defined as part of the rolePermission.”</i>
     * 
     * @return property rolePermissions
     */
    @Property(name="rolePermissions")
    @JsonIgnore
    public CollectionPage<RolePermission> getRolePermissions(HttpRequestOptions options) {
        return new CollectionPage<RolePermission>(contextPath, RolePermission.class, rolePermissions, Optional.ofNullable(rolePermissionsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Type of Role. Set to True if it is built-in, or set to False if it is a custom
     * role definition.”</i>
     * 
     * @return property isBuiltInRoleDefinition
     */
    @Property(name="isBuiltInRoleDefinition")
    @JsonIgnore
    public Optional<Boolean> getIsBuiltInRoleDefinition() {
        return Optional.ofNullable(isBuiltInRoleDefinition);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * isBuiltInRoleDefinition} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Type of Role. Set to True if it is built-in, or set to False if it is a custom
     * role definition.”</i>
     * 
     * @param isBuiltInRoleDefinition
     *            new value of {@code isBuiltInRoleDefinition} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isBuiltInRoleDefinition} field changed
     */
    public RoleDefinition withIsBuiltInRoleDefinition(Boolean isBuiltInRoleDefinition) {
        RoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("isBuiltInRoleDefinition");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleDefinition");
        _x.isBuiltInRoleDefinition = isBuiltInRoleDefinition;
        return _x;
    }

    /**
     * <i>“Type of Role. Set to True if it is built-in, or set to False if it is a custom
     * role definition.”</i>
     * 
     * @return property isBuiltIn
     */
    @Property(name="isBuiltIn")
    @JsonIgnore
    public Optional<Boolean> getIsBuiltIn() {
        return Optional.ofNullable(isBuiltIn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isBuiltIn} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Type of Role. Set to True if it is built-in, or set to False if it is a custom
     * role definition.”</i>
     * 
     * @param isBuiltIn
     *            new value of {@code isBuiltIn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isBuiltIn} field changed
     */
    public RoleDefinition withIsBuiltIn(Boolean isBuiltIn) {
        RoleDefinition _x = _copy();
        _x.changedFields = changedFields.add("isBuiltIn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleDefinition");
        _x.isBuiltIn = isBuiltIn;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“List of Role assignments for this role definition.”</i>
     * 
     * @return navigational property roleAssignments
     */
    @NavigationProperty(name="roleAssignments")
    @JsonIgnore
    public RoleAssignmentCollectionRequest getRoleAssignments() {
        return new RoleAssignmentCollectionRequest(
                        contextPath.addSegment("roleAssignments"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RoleDefinition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        RoleDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RoleDefinition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        RoleDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private RoleDefinition _copy() {
        RoleDefinition _x = new RoleDefinition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.permissions = permissions;
        _x.rolePermissions = rolePermissions;
        _x.isBuiltInRoleDefinition = isBuiltInRoleDefinition;
        _x.isBuiltIn = isBuiltIn;
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RoleDefinition[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("permissions=");
        b.append(this.permissions);
        b.append(", ");
        b.append("rolePermissions=");
        b.append(this.rolePermissions);
        b.append(", ");
        b.append("isBuiltInRoleDefinition=");
        b.append(this.isBuiltInRoleDefinition);
        b.append(", ");
        b.append("isBuiltIn=");
        b.append(this.isBuiltIn);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
