package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.RoleDefinitionRequest;
import odata.msgraph.client.beta.enums.RoleAssignmentScopeType;


/**
 * <i>“The Role Assignment resource. Role assignments tie together a role definition
 * with members and scopes. There can be one or more role assignments per role.
 * This applies to custom and built-in roles.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "description", 
    "scopeMembers", 
    "scopeType", 
    "resourceScopes"})
@JsonInclude(Include.NON_NULL)
public class RoleAssignment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.roleAssignment";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("scopeMembers")
    protected List<String> scopeMembers;

    @JsonProperty("scopeMembers@nextLink")
    protected String scopeMembersNextLink;

    @JsonProperty("scopeType")
    protected RoleAssignmentScopeType scopeType;

    @JsonProperty("resourceScopes")
    protected List<String> resourceScopes;

    @JsonProperty("resourceScopes@nextLink")
    protected String resourceScopesNextLink;

    protected RoleAssignment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRoleAssignment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private List<String> scopeMembers;
        private String scopeMembersNextLink;
        private RoleAssignmentScopeType scopeType;
        private List<String> resourceScopes;
        private String resourceScopesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The display or friendly name of the role Assignment.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Description of the Role Assignment.”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“List of ids of role scope member security groups.  These are IDs from Azure
         * Active Directory.”</i>
         * 
         * @param scopeMembers
         *            value of {@code scopeMembers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scopeMembers(List<String> scopeMembers) {
            this.scopeMembers = scopeMembers;
            this.changedFields = changedFields.add("scopeMembers");
            return this;
        }

        /**
         * <i>“List of ids of role scope member security groups.  These are IDs from Azure
         * Active Directory.”</i>
         * 
         * @param scopeMembers
         *            value of {@code scopeMembers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scopeMembers(String... scopeMembers) {
            return scopeMembers(Arrays.asList(scopeMembers));
        }

        /**
         * <i>“List of ids of role scope member security groups.  These are IDs from Azure
         * Active Directory.”</i>
         * 
         * @param scopeMembersNextLink
         *            value of {@code scopeMembers@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scopeMembersNextLink(String scopeMembersNextLink) {
            this.scopeMembersNextLink = scopeMembersNextLink;
            this.changedFields = changedFields.add("scopeMembers");
            return this;
        }

        /**
         * <i>“Specifies the type of scope for a Role Assignment. Default type 'ResourceScope'
         * allows assignment of ResourceScopes. For 'AllDevices', 'AllLicensedUsers', and '
         * AllDevicesAndLicensedUsers', the ResourceScopes property should be left empty.”</i>
         * 
         * @param scopeType
         *            value of {@code scopeType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scopeType(RoleAssignmentScopeType scopeType) {
            this.scopeType = scopeType;
            this.changedFields = changedFields.add("scopeType");
            return this;
        }

        /**
         * <i>“List of ids of role scope member security groups.  These are IDs from Azure
         * Active Directory.”</i>
         * 
         * @param resourceScopes
         *            value of {@code resourceScopes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resourceScopes(List<String> resourceScopes) {
            this.resourceScopes = resourceScopes;
            this.changedFields = changedFields.add("resourceScopes");
            return this;
        }

        /**
         * <i>“List of ids of role scope member security groups.  These are IDs from Azure
         * Active Directory.”</i>
         * 
         * @param resourceScopes
         *            value of {@code resourceScopes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resourceScopes(String... resourceScopes) {
            return resourceScopes(Arrays.asList(resourceScopes));
        }

        /**
         * <i>“List of ids of role scope member security groups.  These are IDs from Azure
         * Active Directory.”</i>
         * 
         * @param resourceScopesNextLink
         *            value of {@code resourceScopes@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resourceScopesNextLink(String resourceScopesNextLink) {
            this.resourceScopesNextLink = resourceScopesNextLink;
            this.changedFields = changedFields.add("resourceScopes");
            return this;
        }

        public RoleAssignment build() {
            RoleAssignment _x = new RoleAssignment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.roleAssignment";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.scopeMembers = scopeMembers;
            _x.scopeMembersNextLink = scopeMembersNextLink;
            _x.scopeType = scopeType;
            _x.resourceScopes = resourceScopes;
            _x.resourceScopesNextLink = resourceScopesNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The display or friendly name of the role Assignment.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The display or friendly name of the role Assignment.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public RoleAssignment withDisplayName(String displayName) {
        RoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleAssignment");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Description of the Role Assignment.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Description of the Role Assignment.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public RoleAssignment withDescription(String description) {
        RoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleAssignment");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“List of ids of role scope member security groups.  These are IDs from Azure
     * Active Directory.”</i>
     * 
     * @return property scopeMembers
     */
    @Property(name="scopeMembers")
    @JsonIgnore
    public CollectionPage<String> getScopeMembers() {
        return new CollectionPage<String>(contextPath, String.class, scopeMembers, Optional.ofNullable(scopeMembersNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of ids of role scope member security groups.  These are IDs from Azure
     * Active Directory.”</i>
     * 
     * @return property scopeMembers
     */
    @Property(name="scopeMembers")
    @JsonIgnore
    public CollectionPage<String> getScopeMembers(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, scopeMembers, Optional.ofNullable(scopeMembersNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Specifies the type of scope for a Role Assignment. Default type 'ResourceScope'
     * allows assignment of ResourceScopes. For 'AllDevices', 'AllLicensedUsers', and '
     * AllDevicesAndLicensedUsers', the ResourceScopes property should be left empty.”</i>
     * 
     * @return property scopeType
     */
    @Property(name="scopeType")
    @JsonIgnore
    public Optional<RoleAssignmentScopeType> getScopeType() {
        return Optional.ofNullable(scopeType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code scopeType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Specifies the type of scope for a Role Assignment. Default type 'ResourceScope'
     * allows assignment of ResourceScopes. For 'AllDevices', 'AllLicensedUsers', and '
     * AllDevicesAndLicensedUsers', the ResourceScopes property should be left empty.”</i>
     * 
     * @param scopeType
     *            new value of {@code scopeType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code scopeType} field changed
     */
    public RoleAssignment withScopeType(RoleAssignmentScopeType scopeType) {
        RoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("scopeType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.roleAssignment");
        _x.scopeType = scopeType;
        return _x;
    }

    /**
     * <i>“List of ids of role scope member security groups.  These are IDs from Azure
     * Active Directory.”</i>
     * 
     * @return property resourceScopes
     */
    @Property(name="resourceScopes")
    @JsonIgnore
    public CollectionPage<String> getResourceScopes() {
        return new CollectionPage<String>(contextPath, String.class, resourceScopes, Optional.ofNullable(resourceScopesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of ids of role scope member security groups.  These are IDs from Azure
     * Active Directory.”</i>
     * 
     * @return property resourceScopes
     */
    @Property(name="resourceScopes")
    @JsonIgnore
    public CollectionPage<String> getResourceScopes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, resourceScopes, Optional.ofNullable(resourceScopesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Role definition this assignment is part of.”</i>
     * 
     * @return navigational property roleDefinition
     */
    @NavigationProperty(name="roleDefinition")
    @JsonIgnore
    public RoleDefinitionRequest getRoleDefinition() {
        return new RoleDefinitionRequest(contextPath.addSegment("roleDefinition"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RoleAssignment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        RoleAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RoleAssignment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        RoleAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private RoleAssignment _copy() {
        RoleAssignment _x = new RoleAssignment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.scopeMembers = scopeMembers;
        _x.scopeType = scopeType;
        _x.resourceScopes = resourceScopes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RoleAssignment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("scopeMembers=");
        b.append(this.scopeMembers);
        b.append(", ");
        b.append("scopeType=");
        b.append(this.scopeType);
        b.append(", ");
        b.append("resourceScopes=");
        b.append(this.resourceScopes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
