package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.RiskyUserHistoryItemCollectionRequest;
import odata.msgraph.client.beta.enums.RiskDetail;
import odata.msgraph.client.beta.enums.RiskLevel;
import odata.msgraph.client.beta.enums.RiskState;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "isDeleted", 
    "isProcessing", 
    "riskLastUpdatedDateTime", 
    "riskLevel", 
    "riskState", 
    "riskDetail", 
    "userDisplayName", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class RiskyUser extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.riskyUser";
    }

    @JsonProperty("isDeleted")
    protected Boolean isDeleted;

    @JsonProperty("isProcessing")
    protected Boolean isProcessing;

    @JsonProperty("riskLastUpdatedDateTime")
    protected OffsetDateTime riskLastUpdatedDateTime;

    @JsonProperty("riskLevel")
    protected RiskLevel riskLevel;

    @JsonProperty("riskState")
    protected RiskState riskState;

    @JsonProperty("riskDetail")
    protected RiskDetail riskDetail;

    @JsonProperty("userDisplayName")
    protected String userDisplayName;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected RiskyUser() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRiskyUser() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean isDeleted;
        private Boolean isProcessing;
        private OffsetDateTime riskLastUpdatedDateTime;
        private RiskLevel riskLevel;
        private RiskState riskState;
        private RiskDetail riskDetail;
        private String userDisplayName;
        private String userPrincipalName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            this.changedFields = changedFields.add("isDeleted");
            return this;
        }

        public Builder isProcessing(Boolean isProcessing) {
            this.isProcessing = isProcessing;
            this.changedFields = changedFields.add("isProcessing");
            return this;
        }

        public Builder riskLastUpdatedDateTime(OffsetDateTime riskLastUpdatedDateTime) {
            this.riskLastUpdatedDateTime = riskLastUpdatedDateTime;
            this.changedFields = changedFields.add("riskLastUpdatedDateTime");
            return this;
        }

        public Builder riskLevel(RiskLevel riskLevel) {
            this.riskLevel = riskLevel;
            this.changedFields = changedFields.add("riskLevel");
            return this;
        }

        public Builder riskState(RiskState riskState) {
            this.riskState = riskState;
            this.changedFields = changedFields.add("riskState");
            return this;
        }

        public Builder riskDetail(RiskDetail riskDetail) {
            this.riskDetail = riskDetail;
            this.changedFields = changedFields.add("riskDetail");
            return this;
        }

        public Builder userDisplayName(String userDisplayName) {
            this.userDisplayName = userDisplayName;
            this.changedFields = changedFields.add("userDisplayName");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public RiskyUser build() {
            RiskyUser _x = new RiskyUser();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.riskyUser";
            _x.id = id;
            _x.isDeleted = isDeleted;
            _x.isProcessing = isProcessing;
            _x.riskLastUpdatedDateTime = riskLastUpdatedDateTime;
            _x.riskLevel = riskLevel;
            _x.riskState = riskState;
            _x.riskDetail = riskDetail;
            _x.userDisplayName = userDisplayName;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="isDeleted")
    @JsonIgnore
    public Optional<Boolean> getIsDeleted() {
        return Optional.ofNullable(isDeleted);
    }

    public RiskyUser withIsDeleted(Boolean isDeleted) {
        RiskyUser _x = _copy();
        _x.changedFields = changedFields.add("isDeleted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.riskyUser");
        _x.isDeleted = isDeleted;
        return _x;
    }

    @Property(name="isProcessing")
    @JsonIgnore
    public Optional<Boolean> getIsProcessing() {
        return Optional.ofNullable(isProcessing);
    }

    public RiskyUser withIsProcessing(Boolean isProcessing) {
        RiskyUser _x = _copy();
        _x.changedFields = changedFields.add("isProcessing");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.riskyUser");
        _x.isProcessing = isProcessing;
        return _x;
    }

    @Property(name="riskLastUpdatedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getRiskLastUpdatedDateTime() {
        return Optional.ofNullable(riskLastUpdatedDateTime);
    }

    public RiskyUser withRiskLastUpdatedDateTime(OffsetDateTime riskLastUpdatedDateTime) {
        RiskyUser _x = _copy();
        _x.changedFields = changedFields.add("riskLastUpdatedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.riskyUser");
        _x.riskLastUpdatedDateTime = riskLastUpdatedDateTime;
        return _x;
    }

    @Property(name="riskLevel")
    @JsonIgnore
    public Optional<RiskLevel> getRiskLevel() {
        return Optional.ofNullable(riskLevel);
    }

    public RiskyUser withRiskLevel(RiskLevel riskLevel) {
        RiskyUser _x = _copy();
        _x.changedFields = changedFields.add("riskLevel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.riskyUser");
        _x.riskLevel = riskLevel;
        return _x;
    }

    @Property(name="riskState")
    @JsonIgnore
    public Optional<RiskState> getRiskState() {
        return Optional.ofNullable(riskState);
    }

    public RiskyUser withRiskState(RiskState riskState) {
        RiskyUser _x = _copy();
        _x.changedFields = changedFields.add("riskState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.riskyUser");
        _x.riskState = riskState;
        return _x;
    }

    @Property(name="riskDetail")
    @JsonIgnore
    public Optional<RiskDetail> getRiskDetail() {
        return Optional.ofNullable(riskDetail);
    }

    public RiskyUser withRiskDetail(RiskDetail riskDetail) {
        RiskyUser _x = _copy();
        _x.changedFields = changedFields.add("riskDetail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.riskyUser");
        _x.riskDetail = riskDetail;
        return _x;
    }

    @Property(name="userDisplayName")
    @JsonIgnore
    public Optional<String> getUserDisplayName() {
        return Optional.ofNullable(userDisplayName);
    }

    public RiskyUser withUserDisplayName(String userDisplayName) {
        RiskyUser _x = _copy();
        _x.changedFields = changedFields.add("userDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.riskyUser");
        _x.userDisplayName = userDisplayName;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public RiskyUser withUserPrincipalName(String userPrincipalName) {
        RiskyUser _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.riskyUser");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @NavigationProperty(name="history")
    @JsonIgnore
    public RiskyUserHistoryItemCollectionRequest getHistory() {
        return new RiskyUserHistoryItemCollectionRequest(
                        contextPath.addSegment("history"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RiskyUser patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        RiskyUser _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RiskyUser put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        RiskyUser _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private RiskyUser _copy() {
        RiskyUser _x = new RiskyUser();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.isDeleted = isDeleted;
        _x.isProcessing = isProcessing;
        _x.riskLastUpdatedDateTime = riskLastUpdatedDateTime;
        _x.riskLevel = riskLevel;
        _x.riskState = riskState;
        _x.riskDetail = riskDetail;
        _x.userDisplayName = userDisplayName;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RiskyUser[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("isDeleted=");
        b.append(this.isDeleted);
        b.append(", ");
        b.append("isProcessing=");
        b.append(this.isProcessing);
        b.append(", ");
        b.append("riskLastUpdatedDateTime=");
        b.append(this.riskLastUpdatedDateTime);
        b.append(", ");
        b.append("riskLevel=");
        b.append(this.riskLevel);
        b.append(", ");
        b.append("riskState=");
        b.append(this.riskState);
        b.append(", ");
        b.append("riskDetail=");
        b.append(this.riskDetail);
        b.append(", ");
        b.append("userDisplayName=");
        b.append(this.userDisplayName);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
