package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AppliedConditionalAccessPolicy;
import odata.msgraph.client.beta.complex.AuthenticationDetail;
import odata.msgraph.client.beta.complex.AuthenticationRequirementPolicy;
import odata.msgraph.client.beta.complex.DeviceDetail;
import odata.msgraph.client.beta.complex.KeyValue;
import odata.msgraph.client.beta.complex.MfaDetail;
import odata.msgraph.client.beta.complex.NetworkLocationDetail;
import odata.msgraph.client.beta.complex.SignInLocation;
import odata.msgraph.client.beta.complex.SignInStatus;
import odata.msgraph.client.beta.enums.ConditionalAccessStatus;
import odata.msgraph.client.beta.enums.RiskDetail;
import odata.msgraph.client.beta.enums.RiskEventType;
import odata.msgraph.client.beta.enums.RiskLevel;
import odata.msgraph.client.beta.enums.RiskState;
import odata.msgraph.client.beta.enums.TokenIssuerType;

@JsonPropertyOrder({
    "@odata.type", 
    "targetTenantId"})
@JsonInclude(Include.NON_NULL)
public class RestrictedSignIn extends SignIn implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.restrictedSignIn";
    }

    @JsonProperty("targetTenantId")
    protected String targetTenantId;

    protected RestrictedSignIn() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRestrictedSignIn() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String alternateSignInName;
        private String appDisplayName;
        private String appId;
        private List<AppliedConditionalAccessPolicy> appliedConditionalAccessPolicies;
        private String appliedConditionalAccessPoliciesNextLink;
        private List<AuthenticationDetail> authenticationDetails;
        private String authenticationDetailsNextLink;
        private List<String> authenticationMethodsUsed;
        private String authenticationMethodsUsedNextLink;
        private List<KeyValue> authenticationProcessingDetails;
        private String authenticationProcessingDetailsNextLink;
        private String authenticationRequirement;
        private List<AuthenticationRequirementPolicy> authenticationRequirementPolicies;
        private String authenticationRequirementPoliciesNextLink;
        private String clientAppUsed;
        private ConditionalAccessStatus conditionalAccessStatus;
        private String correlationId;
        private OffsetDateTime createdDateTime;
        private DeviceDetail deviceDetail;
        private Boolean isInteractive;
        private String ipAddress;
        private SignInLocation location;
        private MfaDetail mfaDetail;
        private List<NetworkLocationDetail> networkLocationDetails;
        private String networkLocationDetailsNextLink;
        private String originalRequestId;
        private Integer processingTimeInMilliseconds;
        private RiskDetail riskDetail;
        private List<RiskEventType> riskEventTypes;
        private String riskEventTypesNextLink;
        private List<String> riskEventTypes_v2;
        private String riskEventTypes_v2NextLink;
        private RiskLevel riskLevelAggregated;
        private RiskLevel riskLevelDuringSignIn;
        private RiskState riskState;
        private String resourceDisplayName;
        private String resourceId;
        private String resourceTenantId;
        private String servicePrincipalId;
        private String servicePrincipalName;
        private List<String> signInEventTypes;
        private String signInEventTypesNextLink;
        private SignInStatus status;
        private String tokenIssuerName;
        private TokenIssuerType tokenIssuerType;
        private String userAgent;
        private String userDisplayName;
        private String userId;
        private String userPrincipalName;
        private String targetTenantId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder alternateSignInName(String alternateSignInName) {
            this.alternateSignInName = alternateSignInName;
            this.changedFields = changedFields.add("alternateSignInName");
            return this;
        }

        public Builder appDisplayName(String appDisplayName) {
            this.appDisplayName = appDisplayName;
            this.changedFields = changedFields.add("appDisplayName");
            return this;
        }

        public Builder appId(String appId) {
            this.appId = appId;
            this.changedFields = changedFields.add("appId");
            return this;
        }

        public Builder appliedConditionalAccessPolicies(List<AppliedConditionalAccessPolicy> appliedConditionalAccessPolicies) {
            this.appliedConditionalAccessPolicies = appliedConditionalAccessPolicies;
            this.changedFields = changedFields.add("appliedConditionalAccessPolicies");
            return this;
        }

        public Builder appliedConditionalAccessPolicies(AppliedConditionalAccessPolicy... appliedConditionalAccessPolicies) {
            return appliedConditionalAccessPolicies(Arrays.asList(appliedConditionalAccessPolicies));
        }

        public Builder appliedConditionalAccessPoliciesNextLink(String appliedConditionalAccessPoliciesNextLink) {
            this.appliedConditionalAccessPoliciesNextLink = appliedConditionalAccessPoliciesNextLink;
            this.changedFields = changedFields.add("appliedConditionalAccessPolicies");
            return this;
        }

        public Builder authenticationDetails(List<AuthenticationDetail> authenticationDetails) {
            this.authenticationDetails = authenticationDetails;
            this.changedFields = changedFields.add("authenticationDetails");
            return this;
        }

        public Builder authenticationDetails(AuthenticationDetail... authenticationDetails) {
            return authenticationDetails(Arrays.asList(authenticationDetails));
        }

        public Builder authenticationDetailsNextLink(String authenticationDetailsNextLink) {
            this.authenticationDetailsNextLink = authenticationDetailsNextLink;
            this.changedFields = changedFields.add("authenticationDetails");
            return this;
        }

        public Builder authenticationMethodsUsed(List<String> authenticationMethodsUsed) {
            this.authenticationMethodsUsed = authenticationMethodsUsed;
            this.changedFields = changedFields.add("authenticationMethodsUsed");
            return this;
        }

        public Builder authenticationMethodsUsed(String... authenticationMethodsUsed) {
            return authenticationMethodsUsed(Arrays.asList(authenticationMethodsUsed));
        }

        public Builder authenticationMethodsUsedNextLink(String authenticationMethodsUsedNextLink) {
            this.authenticationMethodsUsedNextLink = authenticationMethodsUsedNextLink;
            this.changedFields = changedFields.add("authenticationMethodsUsed");
            return this;
        }

        public Builder authenticationProcessingDetails(List<KeyValue> authenticationProcessingDetails) {
            this.authenticationProcessingDetails = authenticationProcessingDetails;
            this.changedFields = changedFields.add("authenticationProcessingDetails");
            return this;
        }

        public Builder authenticationProcessingDetails(KeyValue... authenticationProcessingDetails) {
            return authenticationProcessingDetails(Arrays.asList(authenticationProcessingDetails));
        }

        public Builder authenticationProcessingDetailsNextLink(String authenticationProcessingDetailsNextLink) {
            this.authenticationProcessingDetailsNextLink = authenticationProcessingDetailsNextLink;
            this.changedFields = changedFields.add("authenticationProcessingDetails");
            return this;
        }

        public Builder authenticationRequirement(String authenticationRequirement) {
            this.authenticationRequirement = authenticationRequirement;
            this.changedFields = changedFields.add("authenticationRequirement");
            return this;
        }

        public Builder authenticationRequirementPolicies(List<AuthenticationRequirementPolicy> authenticationRequirementPolicies) {
            this.authenticationRequirementPolicies = authenticationRequirementPolicies;
            this.changedFields = changedFields.add("authenticationRequirementPolicies");
            return this;
        }

        public Builder authenticationRequirementPolicies(AuthenticationRequirementPolicy... authenticationRequirementPolicies) {
            return authenticationRequirementPolicies(Arrays.asList(authenticationRequirementPolicies));
        }

        public Builder authenticationRequirementPoliciesNextLink(String authenticationRequirementPoliciesNextLink) {
            this.authenticationRequirementPoliciesNextLink = authenticationRequirementPoliciesNextLink;
            this.changedFields = changedFields.add("authenticationRequirementPolicies");
            return this;
        }

        public Builder clientAppUsed(String clientAppUsed) {
            this.clientAppUsed = clientAppUsed;
            this.changedFields = changedFields.add("clientAppUsed");
            return this;
        }

        public Builder conditionalAccessStatus(ConditionalAccessStatus conditionalAccessStatus) {
            this.conditionalAccessStatus = conditionalAccessStatus;
            this.changedFields = changedFields.add("conditionalAccessStatus");
            return this;
        }

        public Builder correlationId(String correlationId) {
            this.correlationId = correlationId;
            this.changedFields = changedFields.add("correlationId");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder deviceDetail(DeviceDetail deviceDetail) {
            this.deviceDetail = deviceDetail;
            this.changedFields = changedFields.add("deviceDetail");
            return this;
        }

        public Builder isInteractive(Boolean isInteractive) {
            this.isInteractive = isInteractive;
            this.changedFields = changedFields.add("isInteractive");
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.changedFields = changedFields.add("ipAddress");
            return this;
        }

        public Builder location(SignInLocation location) {
            this.location = location;
            this.changedFields = changedFields.add("location");
            return this;
        }

        public Builder mfaDetail(MfaDetail mfaDetail) {
            this.mfaDetail = mfaDetail;
            this.changedFields = changedFields.add("mfaDetail");
            return this;
        }

        public Builder networkLocationDetails(List<NetworkLocationDetail> networkLocationDetails) {
            this.networkLocationDetails = networkLocationDetails;
            this.changedFields = changedFields.add("networkLocationDetails");
            return this;
        }

        public Builder networkLocationDetails(NetworkLocationDetail... networkLocationDetails) {
            return networkLocationDetails(Arrays.asList(networkLocationDetails));
        }

        public Builder networkLocationDetailsNextLink(String networkLocationDetailsNextLink) {
            this.networkLocationDetailsNextLink = networkLocationDetailsNextLink;
            this.changedFields = changedFields.add("networkLocationDetails");
            return this;
        }

        public Builder originalRequestId(String originalRequestId) {
            this.originalRequestId = originalRequestId;
            this.changedFields = changedFields.add("originalRequestId");
            return this;
        }

        public Builder processingTimeInMilliseconds(Integer processingTimeInMilliseconds) {
            this.processingTimeInMilliseconds = processingTimeInMilliseconds;
            this.changedFields = changedFields.add("processingTimeInMilliseconds");
            return this;
        }

        public Builder riskDetail(RiskDetail riskDetail) {
            this.riskDetail = riskDetail;
            this.changedFields = changedFields.add("riskDetail");
            return this;
        }

        public Builder riskEventTypes(List<RiskEventType> riskEventTypes) {
            this.riskEventTypes = riskEventTypes;
            this.changedFields = changedFields.add("riskEventTypes");
            return this;
        }

        public Builder riskEventTypes(RiskEventType... riskEventTypes) {
            return riskEventTypes(Arrays.asList(riskEventTypes));
        }

        public Builder riskEventTypesNextLink(String riskEventTypesNextLink) {
            this.riskEventTypesNextLink = riskEventTypesNextLink;
            this.changedFields = changedFields.add("riskEventTypes");
            return this;
        }

        public Builder riskEventTypes_v2(List<String> riskEventTypes_v2) {
            this.riskEventTypes_v2 = riskEventTypes_v2;
            this.changedFields = changedFields.add("riskEventTypes_v2");
            return this;
        }

        public Builder riskEventTypes_v2(String... riskEventTypes_v2) {
            return riskEventTypes_v2(Arrays.asList(riskEventTypes_v2));
        }

        public Builder riskEventTypes_v2NextLink(String riskEventTypes_v2NextLink) {
            this.riskEventTypes_v2NextLink = riskEventTypes_v2NextLink;
            this.changedFields = changedFields.add("riskEventTypes_v2");
            return this;
        }

        public Builder riskLevelAggregated(RiskLevel riskLevelAggregated) {
            this.riskLevelAggregated = riskLevelAggregated;
            this.changedFields = changedFields.add("riskLevelAggregated");
            return this;
        }

        public Builder riskLevelDuringSignIn(RiskLevel riskLevelDuringSignIn) {
            this.riskLevelDuringSignIn = riskLevelDuringSignIn;
            this.changedFields = changedFields.add("riskLevelDuringSignIn");
            return this;
        }

        public Builder riskState(RiskState riskState) {
            this.riskState = riskState;
            this.changedFields = changedFields.add("riskState");
            return this;
        }

        public Builder resourceDisplayName(String resourceDisplayName) {
            this.resourceDisplayName = resourceDisplayName;
            this.changedFields = changedFields.add("resourceDisplayName");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.changedFields = changedFields.add("resourceId");
            return this;
        }

        public Builder resourceTenantId(String resourceTenantId) {
            this.resourceTenantId = resourceTenantId;
            this.changedFields = changedFields.add("resourceTenantId");
            return this;
        }

        public Builder servicePrincipalId(String servicePrincipalId) {
            this.servicePrincipalId = servicePrincipalId;
            this.changedFields = changedFields.add("servicePrincipalId");
            return this;
        }

        public Builder servicePrincipalName(String servicePrincipalName) {
            this.servicePrincipalName = servicePrincipalName;
            this.changedFields = changedFields.add("servicePrincipalName");
            return this;
        }

        public Builder signInEventTypes(List<String> signInEventTypes) {
            this.signInEventTypes = signInEventTypes;
            this.changedFields = changedFields.add("signInEventTypes");
            return this;
        }

        public Builder signInEventTypes(String... signInEventTypes) {
            return signInEventTypes(Arrays.asList(signInEventTypes));
        }

        public Builder signInEventTypesNextLink(String signInEventTypesNextLink) {
            this.signInEventTypesNextLink = signInEventTypesNextLink;
            this.changedFields = changedFields.add("signInEventTypes");
            return this;
        }

        public Builder status(SignInStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder tokenIssuerName(String tokenIssuerName) {
            this.tokenIssuerName = tokenIssuerName;
            this.changedFields = changedFields.add("tokenIssuerName");
            return this;
        }

        public Builder tokenIssuerType(TokenIssuerType tokenIssuerType) {
            this.tokenIssuerType = tokenIssuerType;
            this.changedFields = changedFields.add("tokenIssuerType");
            return this;
        }

        public Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            this.changedFields = changedFields.add("userAgent");
            return this;
        }

        public Builder userDisplayName(String userDisplayName) {
            this.userDisplayName = userDisplayName;
            this.changedFields = changedFields.add("userDisplayName");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public Builder targetTenantId(String targetTenantId) {
            this.targetTenantId = targetTenantId;
            this.changedFields = changedFields.add("targetTenantId");
            return this;
        }

        public RestrictedSignIn build() {
            RestrictedSignIn _x = new RestrictedSignIn();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.restrictedSignIn";
            _x.id = id;
            _x.alternateSignInName = alternateSignInName;
            _x.appDisplayName = appDisplayName;
            _x.appId = appId;
            _x.appliedConditionalAccessPolicies = appliedConditionalAccessPolicies;
            _x.appliedConditionalAccessPoliciesNextLink = appliedConditionalAccessPoliciesNextLink;
            _x.authenticationDetails = authenticationDetails;
            _x.authenticationDetailsNextLink = authenticationDetailsNextLink;
            _x.authenticationMethodsUsed = authenticationMethodsUsed;
            _x.authenticationMethodsUsedNextLink = authenticationMethodsUsedNextLink;
            _x.authenticationProcessingDetails = authenticationProcessingDetails;
            _x.authenticationProcessingDetailsNextLink = authenticationProcessingDetailsNextLink;
            _x.authenticationRequirement = authenticationRequirement;
            _x.authenticationRequirementPolicies = authenticationRequirementPolicies;
            _x.authenticationRequirementPoliciesNextLink = authenticationRequirementPoliciesNextLink;
            _x.clientAppUsed = clientAppUsed;
            _x.conditionalAccessStatus = conditionalAccessStatus;
            _x.correlationId = correlationId;
            _x.createdDateTime = createdDateTime;
            _x.deviceDetail = deviceDetail;
            _x.isInteractive = isInteractive;
            _x.ipAddress = ipAddress;
            _x.location = location;
            _x.mfaDetail = mfaDetail;
            _x.networkLocationDetails = networkLocationDetails;
            _x.networkLocationDetailsNextLink = networkLocationDetailsNextLink;
            _x.originalRequestId = originalRequestId;
            _x.processingTimeInMilliseconds = processingTimeInMilliseconds;
            _x.riskDetail = riskDetail;
            _x.riskEventTypes = riskEventTypes;
            _x.riskEventTypesNextLink = riskEventTypesNextLink;
            _x.riskEventTypes_v2 = riskEventTypes_v2;
            _x.riskEventTypes_v2NextLink = riskEventTypes_v2NextLink;
            _x.riskLevelAggregated = riskLevelAggregated;
            _x.riskLevelDuringSignIn = riskLevelDuringSignIn;
            _x.riskState = riskState;
            _x.resourceDisplayName = resourceDisplayName;
            _x.resourceId = resourceId;
            _x.resourceTenantId = resourceTenantId;
            _x.servicePrincipalId = servicePrincipalId;
            _x.servicePrincipalName = servicePrincipalName;
            _x.signInEventTypes = signInEventTypes;
            _x.signInEventTypesNextLink = signInEventTypesNextLink;
            _x.status = status;
            _x.tokenIssuerName = tokenIssuerName;
            _x.tokenIssuerType = tokenIssuerType;
            _x.userAgent = userAgent;
            _x.userDisplayName = userDisplayName;
            _x.userId = userId;
            _x.userPrincipalName = userPrincipalName;
            _x.targetTenantId = targetTenantId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="targetTenantId")
    @JsonIgnore
    public Optional<String> getTargetTenantId() {
        return Optional.ofNullable(targetTenantId);
    }

    public RestrictedSignIn withTargetTenantId(String targetTenantId) {
        RestrictedSignIn _x = _copy();
        _x.changedFields = changedFields.add("targetTenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.restrictedSignIn");
        _x.targetTenantId = targetTenantId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RestrictedSignIn patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        RestrictedSignIn _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RestrictedSignIn put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        RestrictedSignIn _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private RestrictedSignIn _copy() {
        RestrictedSignIn _x = new RestrictedSignIn();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.alternateSignInName = alternateSignInName;
        _x.appDisplayName = appDisplayName;
        _x.appId = appId;
        _x.appliedConditionalAccessPolicies = appliedConditionalAccessPolicies;
        _x.authenticationDetails = authenticationDetails;
        _x.authenticationMethodsUsed = authenticationMethodsUsed;
        _x.authenticationProcessingDetails = authenticationProcessingDetails;
        _x.authenticationRequirement = authenticationRequirement;
        _x.authenticationRequirementPolicies = authenticationRequirementPolicies;
        _x.clientAppUsed = clientAppUsed;
        _x.conditionalAccessStatus = conditionalAccessStatus;
        _x.correlationId = correlationId;
        _x.createdDateTime = createdDateTime;
        _x.deviceDetail = deviceDetail;
        _x.isInteractive = isInteractive;
        _x.ipAddress = ipAddress;
        _x.location = location;
        _x.mfaDetail = mfaDetail;
        _x.networkLocationDetails = networkLocationDetails;
        _x.originalRequestId = originalRequestId;
        _x.processingTimeInMilliseconds = processingTimeInMilliseconds;
        _x.riskDetail = riskDetail;
        _x.riskEventTypes = riskEventTypes;
        _x.riskEventTypes_v2 = riskEventTypes_v2;
        _x.riskLevelAggregated = riskLevelAggregated;
        _x.riskLevelDuringSignIn = riskLevelDuringSignIn;
        _x.riskState = riskState;
        _x.resourceDisplayName = resourceDisplayName;
        _x.resourceId = resourceId;
        _x.resourceTenantId = resourceTenantId;
        _x.servicePrincipalId = servicePrincipalId;
        _x.servicePrincipalName = servicePrincipalName;
        _x.signInEventTypes = signInEventTypes;
        _x.status = status;
        _x.tokenIssuerName = tokenIssuerName;
        _x.tokenIssuerType = tokenIssuerType;
        _x.userAgent = userAgent;
        _x.userDisplayName = userDisplayName;
        _x.userId = userId;
        _x.userPrincipalName = userPrincipalName;
        _x.targetTenantId = targetTenantId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RestrictedSignIn[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("alternateSignInName=");
        b.append(this.alternateSignInName);
        b.append(", ");
        b.append("appDisplayName=");
        b.append(this.appDisplayName);
        b.append(", ");
        b.append("appId=");
        b.append(this.appId);
        b.append(", ");
        b.append("appliedConditionalAccessPolicies=");
        b.append(this.appliedConditionalAccessPolicies);
        b.append(", ");
        b.append("authenticationDetails=");
        b.append(this.authenticationDetails);
        b.append(", ");
        b.append("authenticationMethodsUsed=");
        b.append(this.authenticationMethodsUsed);
        b.append(", ");
        b.append("authenticationProcessingDetails=");
        b.append(this.authenticationProcessingDetails);
        b.append(", ");
        b.append("authenticationRequirement=");
        b.append(this.authenticationRequirement);
        b.append(", ");
        b.append("authenticationRequirementPolicies=");
        b.append(this.authenticationRequirementPolicies);
        b.append(", ");
        b.append("clientAppUsed=");
        b.append(this.clientAppUsed);
        b.append(", ");
        b.append("conditionalAccessStatus=");
        b.append(this.conditionalAccessStatus);
        b.append(", ");
        b.append("correlationId=");
        b.append(this.correlationId);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("deviceDetail=");
        b.append(this.deviceDetail);
        b.append(", ");
        b.append("isInteractive=");
        b.append(this.isInteractive);
        b.append(", ");
        b.append("ipAddress=");
        b.append(this.ipAddress);
        b.append(", ");
        b.append("location=");
        b.append(this.location);
        b.append(", ");
        b.append("mfaDetail=");
        b.append(this.mfaDetail);
        b.append(", ");
        b.append("networkLocationDetails=");
        b.append(this.networkLocationDetails);
        b.append(", ");
        b.append("originalRequestId=");
        b.append(this.originalRequestId);
        b.append(", ");
        b.append("processingTimeInMilliseconds=");
        b.append(this.processingTimeInMilliseconds);
        b.append(", ");
        b.append("riskDetail=");
        b.append(this.riskDetail);
        b.append(", ");
        b.append("riskEventTypes=");
        b.append(this.riskEventTypes);
        b.append(", ");
        b.append("riskEventTypes_v2=");
        b.append(this.riskEventTypes_v2);
        b.append(", ");
        b.append("riskLevelAggregated=");
        b.append(this.riskLevelAggregated);
        b.append(", ");
        b.append("riskLevelDuringSignIn=");
        b.append(this.riskLevelDuringSignIn);
        b.append(", ");
        b.append("riskState=");
        b.append(this.riskState);
        b.append(", ");
        b.append("resourceDisplayName=");
        b.append(this.resourceDisplayName);
        b.append(", ");
        b.append("resourceId=");
        b.append(this.resourceId);
        b.append(", ");
        b.append("resourceTenantId=");
        b.append(this.resourceTenantId);
        b.append(", ");
        b.append("servicePrincipalId=");
        b.append(this.servicePrincipalId);
        b.append(", ");
        b.append("servicePrincipalName=");
        b.append(this.servicePrincipalName);
        b.append(", ");
        b.append("signInEventTypes=");
        b.append(this.signInEventTypes);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("tokenIssuerName=");
        b.append(this.tokenIssuerName);
        b.append(", ");
        b.append("tokenIssuerType=");
        b.append(this.tokenIssuerType);
        b.append(", ");
        b.append("userAgent=");
        b.append(this.userAgent);
        b.append(", ");
        b.append("userDisplayName=");
        b.append(this.userDisplayName);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("targetTenantId=");
        b.append(this.targetTenantId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
