package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
 * <p>
 * Expandable = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "clientId", 
    "clientAppId", 
    "resourceAppId", 
    "permissionType", 
    "permission"})
@JsonInclude(Include.NON_NULL)
public class ResourceSpecificPermissionGrant extends DirectoryObject implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.resourceSpecificPermissionGrant";
    }

    @JsonProperty("clientId")
    protected String clientId;

    @JsonProperty("clientAppId")
    protected String clientAppId;

    @JsonProperty("resourceAppId")
    protected String resourceAppId;

    @JsonProperty("permissionType")
    protected String permissionType;

    @JsonProperty("permission")
    protected String permission;

    protected ResourceSpecificPermissionGrant() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderResourceSpecificPermissionGrant() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime deletedDateTime;
        private String clientId;
        private String clientAppId;
        private String resourceAppId;
        private String permissionType;
        private String permission;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder deletedDateTime(OffsetDateTime deletedDateTime) {
            this.deletedDateTime = deletedDateTime;
            this.changedFields = changedFields.add("deletedDateTime");
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            this.changedFields = changedFields.add("clientId");
            return this;
        }

        public Builder clientAppId(String clientAppId) {
            this.clientAppId = clientAppId;
            this.changedFields = changedFields.add("clientAppId");
            return this;
        }

        public Builder resourceAppId(String resourceAppId) {
            this.resourceAppId = resourceAppId;
            this.changedFields = changedFields.add("resourceAppId");
            return this;
        }

        public Builder permissionType(String permissionType) {
            this.permissionType = permissionType;
            this.changedFields = changedFields.add("permissionType");
            return this;
        }

        public Builder permission(String permission) {
            this.permission = permission;
            this.changedFields = changedFields.add("permission");
            return this;
        }

        public ResourceSpecificPermissionGrant build() {
            ResourceSpecificPermissionGrant _x = new ResourceSpecificPermissionGrant();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.resourceSpecificPermissionGrant";
            _x.id = id;
            _x.deletedDateTime = deletedDateTime;
            _x.clientId = clientId;
            _x.clientAppId = clientAppId;
            _x.resourceAppId = resourceAppId;
            _x.permissionType = permissionType;
            _x.permission = permission;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="clientId")
    @JsonIgnore
    public Optional<String> getClientId() {
        return Optional.ofNullable(clientId);
    }

    public ResourceSpecificPermissionGrant withClientId(String clientId) {
        ResourceSpecificPermissionGrant _x = _copy();
        _x.changedFields = changedFields.add("clientId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.resourceSpecificPermissionGrant");
        _x.clientId = clientId;
        return _x;
    }

    @Property(name="clientAppId")
    @JsonIgnore
    public Optional<String> getClientAppId() {
        return Optional.ofNullable(clientAppId);
    }

    public ResourceSpecificPermissionGrant withClientAppId(String clientAppId) {
        ResourceSpecificPermissionGrant _x = _copy();
        _x.changedFields = changedFields.add("clientAppId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.resourceSpecificPermissionGrant");
        _x.clientAppId = clientAppId;
        return _x;
    }

    @Property(name="resourceAppId")
    @JsonIgnore
    public Optional<String> getResourceAppId() {
        return Optional.ofNullable(resourceAppId);
    }

    public ResourceSpecificPermissionGrant withResourceAppId(String resourceAppId) {
        ResourceSpecificPermissionGrant _x = _copy();
        _x.changedFields = changedFields.add("resourceAppId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.resourceSpecificPermissionGrant");
        _x.resourceAppId = resourceAppId;
        return _x;
    }

    @Property(name="permissionType")
    @JsonIgnore
    public Optional<String> getPermissionType() {
        return Optional.ofNullable(permissionType);
    }

    public ResourceSpecificPermissionGrant withPermissionType(String permissionType) {
        ResourceSpecificPermissionGrant _x = _copy();
        _x.changedFields = changedFields.add("permissionType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.resourceSpecificPermissionGrant");
        _x.permissionType = permissionType;
        return _x;
    }

    @Property(name="permission")
    @JsonIgnore
    public Optional<String> getPermission() {
        return Optional.ofNullable(permission);
    }

    public ResourceSpecificPermissionGrant withPermission(String permission) {
        ResourceSpecificPermissionGrant _x = _copy();
        _x.changedFields = changedFields.add("permission");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.resourceSpecificPermissionGrant");
        _x.permission = permission;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ResourceSpecificPermissionGrant patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ResourceSpecificPermissionGrant _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ResourceSpecificPermissionGrant put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ResourceSpecificPermissionGrant _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ResourceSpecificPermissionGrant _copy() {
        ResourceSpecificPermissionGrant _x = new ResourceSpecificPermissionGrant();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.deletedDateTime = deletedDateTime;
        _x.clientId = clientId;
        _x.clientAppId = clientAppId;
        _x.resourceAppId = resourceAppId;
        _x.permissionType = permissionType;
        _x.permission = permission;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ResourceSpecificPermissionGrant[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deletedDateTime=");
        b.append(this.deletedDateTime);
        b.append(", ");
        b.append("clientId=");
        b.append(this.clientId);
        b.append(", ");
        b.append("clientAppId=");
        b.append(this.clientAppId);
        b.append(", ");
        b.append("resourceAppId=");
        b.append(this.resourceAppId);
        b.append(", ");
        b.append("permissionType=");
        b.append(this.permissionType);
        b.append(", ");
        b.append("permission=");
        b.append(this.permission);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
