package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Map;
import java.util.Optional;


/**
 * <i>“Describes the resourceOperation resource (entity) of the Microsoft Graph API (
 * REST), which supports Intune workflows related to role-based access control (
 * RBAC).”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "resource", 
    "resourceName", 
    "actionName", 
    "description", 
    "enabledForScopeValidation"})
@JsonInclude(Include.NON_NULL)
public class ResourceOperation extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.resourceOperation";
    }

    @JsonProperty("resource")
    protected String resource;

    @JsonProperty("resourceName")
    protected String resourceName;

    @JsonProperty("actionName")
    protected String actionName;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("enabledForScopeValidation")
    protected Boolean enabledForScopeValidation;

    protected ResourceOperation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderResourceOperation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String resource;
        private String resourceName;
        private String actionName;
        private String description;
        private Boolean enabledForScopeValidation;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Resource category to which this Operation belongs.”</i>
         * 
         * @param resource
         *            value of {@code resource} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resource(String resource) {
            this.resource = resource;
            this.changedFields = changedFields.add("resource");
            return this;
        }

        /**
         * <i>“Name of the Resource this operation is performed on.”</i>
         * 
         * @param resourceName
         *            value of {@code resourceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            this.changedFields = changedFields.add("resourceName");
            return this;
        }

        /**
         * <i>“Type of action this operation is going to perform. The actionName should be
         * concise and limited to as few words as possible.”</i>
         * 
         * @param actionName
         *            value of {@code actionName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder actionName(String actionName) {
            this.actionName = actionName;
            this.changedFields = changedFields.add("actionName");
            return this;
        }

        /**
         * <i>“Description of the resource operation. The description is used in mouse-over
         * text for the operation when shown in the Azure Portal.”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“Determines whether the Permission is validated for Scopes defined per Role
         * Assignment.”</i>
         * 
         * @param enabledForScopeValidation
         *            value of {@code enabledForScopeValidation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enabledForScopeValidation(Boolean enabledForScopeValidation) {
            this.enabledForScopeValidation = enabledForScopeValidation;
            this.changedFields = changedFields.add("enabledForScopeValidation");
            return this;
        }

        public ResourceOperation build() {
            ResourceOperation _x = new ResourceOperation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.resourceOperation";
            _x.id = id;
            _x.resource = resource;
            _x.resourceName = resourceName;
            _x.actionName = actionName;
            _x.description = description;
            _x.enabledForScopeValidation = enabledForScopeValidation;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Resource category to which this Operation belongs.”</i>
     * 
     * @return property resource
     */
    @Property(name="resource")
    @JsonIgnore
    public Optional<String> getResource() {
        return Optional.ofNullable(resource);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code resource} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Resource category to which this Operation belongs.”</i>
     * 
     * @param resource
     *            new value of {@code resource} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code resource} field changed
     */
    public ResourceOperation withResource(String resource) {
        ResourceOperation _x = _copy();
        _x.changedFields = changedFields.add("resource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.resourceOperation");
        _x.resource = resource;
        return _x;
    }

    /**
     * <i>“Name of the Resource this operation is performed on.”</i>
     * 
     * @return property resourceName
     */
    @Property(name="resourceName")
    @JsonIgnore
    public Optional<String> getResourceName() {
        return Optional.ofNullable(resourceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code resourceName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Name of the Resource this operation is performed on.”</i>
     * 
     * @param resourceName
     *            new value of {@code resourceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code resourceName} field changed
     */
    public ResourceOperation withResourceName(String resourceName) {
        ResourceOperation _x = _copy();
        _x.changedFields = changedFields.add("resourceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.resourceOperation");
        _x.resourceName = resourceName;
        return _x;
    }

    /**
     * <i>“Type of action this operation is going to perform. The actionName should be
     * concise and limited to as few words as possible.”</i>
     * 
     * @return property actionName
     */
    @Property(name="actionName")
    @JsonIgnore
    public Optional<String> getActionName() {
        return Optional.ofNullable(actionName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code actionName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Type of action this operation is going to perform. The actionName should be
     * concise and limited to as few words as possible.”</i>
     * 
     * @param actionName
     *            new value of {@code actionName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code actionName} field changed
     */
    public ResourceOperation withActionName(String actionName) {
        ResourceOperation _x = _copy();
        _x.changedFields = changedFields.add("actionName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.resourceOperation");
        _x.actionName = actionName;
        return _x;
    }

    /**
     * <i>“Description of the resource operation. The description is used in mouse-over
     * text for the operation when shown in the Azure Portal.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Description of the resource operation. The description is used in mouse-over
     * text for the operation when shown in the Azure Portal.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public ResourceOperation withDescription(String description) {
        ResourceOperation _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.resourceOperation");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Determines whether the Permission is validated for Scopes defined per Role
     * Assignment.”</i>
     * 
     * @return property enabledForScopeValidation
     */
    @Property(name="enabledForScopeValidation")
    @JsonIgnore
    public Optional<Boolean> getEnabledForScopeValidation() {
        return Optional.ofNullable(enabledForScopeValidation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enabledForScopeValidation} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Determines whether the Permission is validated for Scopes defined per Role
     * Assignment.”</i>
     * 
     * @param enabledForScopeValidation
     *            new value of {@code enabledForScopeValidation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enabledForScopeValidation} field changed
     */
    public ResourceOperation withEnabledForScopeValidation(Boolean enabledForScopeValidation) {
        ResourceOperation _x = _copy();
        _x.changedFields = changedFields.add("enabledForScopeValidation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.resourceOperation");
        _x.enabledForScopeValidation = enabledForScopeValidation;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ResourceOperation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ResourceOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ResourceOperation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ResourceOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ResourceOperation _copy() {
        ResourceOperation _x = new ResourceOperation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.resource = resource;
        _x.resourceName = resourceName;
        _x.actionName = actionName;
        _x.description = description;
        _x.enabledForScopeValidation = enabledForScopeValidation;
        return _x;
    }

    @Function(name = "getScopesForUser")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> getScopesForUser(String userid) {
        Preconditions.checkNotNull(userid, "userid cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("userid", "Edm.String", Checks.checkIsAscii(userid))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getScopesForUser"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ResourceOperation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("resource=");
        b.append(this.resource);
        b.append(", ");
        b.append("resourceName=");
        b.append(this.resourceName);
        b.append(", ");
        b.append("actionName=");
        b.append(this.actionName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("enabledForScopeValidation=");
        b.append(this.enabledForScopeValidation);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
