package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ActionState;
import odata.msgraph.client.beta.enums.RemoteAction;


/**
 * <i>“Report of remote actions initiated on the devices belonging to a certain tenant.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceDisplayName", 
    "userName", 
    "initiatedByUserPrincipalName", 
    "action", 
    "requestDateTime", 
    "deviceOwnerUserPrincipalName", 
    "deviceIMEI", 
    "actionState", 
    "managedDeviceId"})
@JsonInclude(Include.NON_NULL)
public class RemoteActionAudit extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.remoteActionAudit";
    }

    @JsonProperty("deviceDisplayName")
    protected String deviceDisplayName;

    @JsonProperty("userName")
    protected String userName;

    @JsonProperty("initiatedByUserPrincipalName")
    protected String initiatedByUserPrincipalName;

    @JsonProperty("action")
    protected RemoteAction action;

    @JsonProperty("requestDateTime")
    protected OffsetDateTime requestDateTime;

    @JsonProperty("deviceOwnerUserPrincipalName")
    protected String deviceOwnerUserPrincipalName;

    @JsonProperty("deviceIMEI")
    protected String deviceIMEI;

    @JsonProperty("actionState")
    protected ActionState actionState;

    @JsonProperty("managedDeviceId")
    protected String managedDeviceId;

    protected RemoteActionAudit() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRemoteActionAudit() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String deviceDisplayName;
        private String userName;
        private String initiatedByUserPrincipalName;
        private RemoteAction action;
        private OffsetDateTime requestDateTime;
        private String deviceOwnerUserPrincipalName;
        private String deviceIMEI;
        private ActionState actionState;
        private String managedDeviceId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Intune device name.”</i>
         * 
         * @param deviceDisplayName
         *            value of {@code deviceDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceDisplayName(String deviceDisplayName) {
            this.deviceDisplayName = deviceDisplayName;
            this.changedFields = changedFields.add("deviceDisplayName");
            return this;
        }

        /**
         * <i>“[deprecated] Please use InitiatedByUserPrincipalName instead.”</i>
         * 
         * @param userName
         *            value of {@code userName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userName(String userName) {
            this.userName = userName;
            this.changedFields = changedFields.add("userName");
            return this;
        }

        /**
         * <i>“User who initiated the device action, format is UPN.”</i>
         * 
         * @param initiatedByUserPrincipalName
         *            value of {@code initiatedByUserPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder initiatedByUserPrincipalName(String initiatedByUserPrincipalName) {
            this.initiatedByUserPrincipalName = initiatedByUserPrincipalName;
            this.changedFields = changedFields.add("initiatedByUserPrincipalName");
            return this;
        }

        /**
         * <i>“The action name.”</i>
         * 
         * @param action
         *            value of {@code action} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder action(RemoteAction action) {
            this.action = action;
            this.changedFields = changedFields.add("action");
            return this;
        }

        /**
         * <i>“Time when the action was issued, given in UTC.”</i>
         * 
         * @param requestDateTime
         *            value of {@code requestDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requestDateTime(OffsetDateTime requestDateTime) {
            this.requestDateTime = requestDateTime;
            this.changedFields = changedFields.add("requestDateTime");
            return this;
        }

        /**
         * <i>“Upn of the device owner.”</i>
         * 
         * @param deviceOwnerUserPrincipalName
         *            value of {@code deviceOwnerUserPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceOwnerUserPrincipalName(String deviceOwnerUserPrincipalName) {
            this.deviceOwnerUserPrincipalName = deviceOwnerUserPrincipalName;
            this.changedFields = changedFields.add("deviceOwnerUserPrincipalName");
            return this;
        }

        /**
         * <i>“IMEI of the device.”</i>
         * 
         * @param deviceIMEI
         *            value of {@code deviceIMEI} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceIMEI(String deviceIMEI) {
            this.deviceIMEI = deviceIMEI;
            this.changedFields = changedFields.add("deviceIMEI");
            return this;
        }

        /**
         * <i>“Action state.”</i>
         * 
         * @param actionState
         *            value of {@code actionState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder actionState(ActionState actionState) {
            this.actionState = actionState;
            this.changedFields = changedFields.add("actionState");
            return this;
        }

        /**
         * <i>“Action target.”</i>
         * 
         * @param managedDeviceId
         *            value of {@code managedDeviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
            this.changedFields = changedFields.add("managedDeviceId");
            return this;
        }

        public RemoteActionAudit build() {
            RemoteActionAudit _x = new RemoteActionAudit();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.remoteActionAudit";
            _x.id = id;
            _x.deviceDisplayName = deviceDisplayName;
            _x.userName = userName;
            _x.initiatedByUserPrincipalName = initiatedByUserPrincipalName;
            _x.action = action;
            _x.requestDateTime = requestDateTime;
            _x.deviceOwnerUserPrincipalName = deviceOwnerUserPrincipalName;
            _x.deviceIMEI = deviceIMEI;
            _x.actionState = actionState;
            _x.managedDeviceId = managedDeviceId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Intune device name.”</i>
     * 
     * @return property deviceDisplayName
     */
    @Property(name="deviceDisplayName")
    @JsonIgnore
    public Optional<String> getDeviceDisplayName() {
        return Optional.ofNullable(deviceDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceDisplayName
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Intune device name.”</i>
     * 
     * @param deviceDisplayName
     *            new value of {@code deviceDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceDisplayName} field changed
     */
    public RemoteActionAudit withDeviceDisplayName(String deviceDisplayName) {
        RemoteActionAudit _x = _copy();
        _x.changedFields = changedFields.add("deviceDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteActionAudit");
        _x.deviceDisplayName = deviceDisplayName;
        return _x;
    }

    /**
     * <i>“[deprecated] Please use InitiatedByUserPrincipalName instead.”</i>
     * 
     * @return property userName
     */
    @Property(name="userName")
    @JsonIgnore
    public Optional<String> getUserName() {
        return Optional.ofNullable(userName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“[deprecated] Please use InitiatedByUserPrincipalName instead.”</i>
     * 
     * @param userName
     *            new value of {@code userName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userName} field changed
     */
    public RemoteActionAudit withUserName(String userName) {
        RemoteActionAudit _x = _copy();
        _x.changedFields = changedFields.add("userName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteActionAudit");
        _x.userName = userName;
        return _x;
    }

    /**
     * <i>“User who initiated the device action, format is UPN.”</i>
     * 
     * @return property initiatedByUserPrincipalName
     */
    @Property(name="initiatedByUserPrincipalName")
    @JsonIgnore
    public Optional<String> getInitiatedByUserPrincipalName() {
        return Optional.ofNullable(initiatedByUserPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * initiatedByUserPrincipalName} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“User who initiated the device action, format is UPN.”</i>
     * 
     * @param initiatedByUserPrincipalName
     *            new value of {@code initiatedByUserPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code initiatedByUserPrincipalName} field changed
     */
    public RemoteActionAudit withInitiatedByUserPrincipalName(String initiatedByUserPrincipalName) {
        RemoteActionAudit _x = _copy();
        _x.changedFields = changedFields.add("initiatedByUserPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteActionAudit");
        _x.initiatedByUserPrincipalName = initiatedByUserPrincipalName;
        return _x;
    }

    /**
     * <i>“The action name.”</i>
     * 
     * @return property action
     */
    @Property(name="action")
    @JsonIgnore
    public Optional<RemoteAction> getAction() {
        return Optional.ofNullable(action);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code action} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The action name.”</i>
     * 
     * @param action
     *            new value of {@code action} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code action} field changed
     */
    public RemoteActionAudit withAction(RemoteAction action) {
        RemoteActionAudit _x = _copy();
        _x.changedFields = changedFields.add("action");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteActionAudit");
        _x.action = action;
        return _x;
    }

    /**
     * <i>“Time when the action was issued, given in UTC.”</i>
     * 
     * @return property requestDateTime
     */
    @Property(name="requestDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getRequestDateTime() {
        return Optional.ofNullable(requestDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code requestDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Time when the action was issued, given in UTC.”</i>
     * 
     * @param requestDateTime
     *            new value of {@code requestDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requestDateTime} field changed
     */
    public RemoteActionAudit withRequestDateTime(OffsetDateTime requestDateTime) {
        RemoteActionAudit _x = _copy();
        _x.changedFields = changedFields.add("requestDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteActionAudit");
        _x.requestDateTime = requestDateTime;
        return _x;
    }

    /**
     * <i>“Upn of the device owner.”</i>
     * 
     * @return property deviceOwnerUserPrincipalName
     */
    @Property(name="deviceOwnerUserPrincipalName")
    @JsonIgnore
    public Optional<String> getDeviceOwnerUserPrincipalName() {
        return Optional.ofNullable(deviceOwnerUserPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceOwnerUserPrincipalName} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Upn of the device owner.”</i>
     * 
     * @param deviceOwnerUserPrincipalName
     *            new value of {@code deviceOwnerUserPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceOwnerUserPrincipalName} field changed
     */
    public RemoteActionAudit withDeviceOwnerUserPrincipalName(String deviceOwnerUserPrincipalName) {
        RemoteActionAudit _x = _copy();
        _x.changedFields = changedFields.add("deviceOwnerUserPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteActionAudit");
        _x.deviceOwnerUserPrincipalName = deviceOwnerUserPrincipalName;
        return _x;
    }

    /**
     * <i>“IMEI of the device.”</i>
     * 
     * @return property deviceIMEI
     */
    @Property(name="deviceIMEI")
    @JsonIgnore
    public Optional<String> getDeviceIMEI() {
        return Optional.ofNullable(deviceIMEI);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceIMEI} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“IMEI of the device.”</i>
     * 
     * @param deviceIMEI
     *            new value of {@code deviceIMEI} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceIMEI} field changed
     */
    public RemoteActionAudit withDeviceIMEI(String deviceIMEI) {
        RemoteActionAudit _x = _copy();
        _x.changedFields = changedFields.add("deviceIMEI");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteActionAudit");
        _x.deviceIMEI = deviceIMEI;
        return _x;
    }

    /**
     * <i>“Action state.”</i>
     * 
     * @return property actionState
     */
    @Property(name="actionState")
    @JsonIgnore
    public Optional<ActionState> getActionState() {
        return Optional.ofNullable(actionState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code actionState}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Action state.”</i>
     * 
     * @param actionState
     *            new value of {@code actionState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code actionState} field changed
     */
    public RemoteActionAudit withActionState(ActionState actionState) {
        RemoteActionAudit _x = _copy();
        _x.changedFields = changedFields.add("actionState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteActionAudit");
        _x.actionState = actionState;
        return _x;
    }

    /**
     * <i>“Action target.”</i>
     * 
     * @return property managedDeviceId
     */
    @Property(name="managedDeviceId")
    @JsonIgnore
    public Optional<String> getManagedDeviceId() {
        return Optional.ofNullable(managedDeviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code managedDeviceId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Action target.”</i>
     * 
     * @param managedDeviceId
     *            new value of {@code managedDeviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedDeviceId} field changed
     */
    public RemoteActionAudit withManagedDeviceId(String managedDeviceId) {
        RemoteActionAudit _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.remoteActionAudit");
        _x.managedDeviceId = managedDeviceId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RemoteActionAudit patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        RemoteActionAudit _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public RemoteActionAudit put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        RemoteActionAudit _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private RemoteActionAudit _copy() {
        RemoteActionAudit _x = new RemoteActionAudit();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.deviceDisplayName = deviceDisplayName;
        _x.userName = userName;
        _x.initiatedByUserPrincipalName = initiatedByUserPrincipalName;
        _x.action = action;
        _x.requestDateTime = requestDateTime;
        _x.deviceOwnerUserPrincipalName = deviceOwnerUserPrincipalName;
        _x.deviceIMEI = deviceIMEI;
        _x.actionState = actionState;
        _x.managedDeviceId = managedDeviceId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RemoteActionAudit[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deviceDisplayName=");
        b.append(this.deviceDisplayName);
        b.append(", ");
        b.append("userName=");
        b.append(this.userName);
        b.append(", ");
        b.append("initiatedByUserPrincipalName=");
        b.append(this.initiatedByUserPrincipalName);
        b.append(", ");
        b.append("action=");
        b.append(this.action);
        b.append(", ");
        b.append("requestDateTime=");
        b.append(this.requestDateTime);
        b.append(", ");
        b.append("deviceOwnerUserPrincipalName=");
        b.append(this.deviceOwnerUserPrincipalName);
        b.append(", ");
        b.append("deviceIMEI=");
        b.append(this.deviceIMEI);
        b.append(", ");
        b.append("actionState=");
        b.append(this.actionState);
        b.append(", ");
        b.append("managedDeviceId=");
        b.append(this.managedDeviceId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
