package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.OnPremisesAgentGroupCollectionRequest;
import odata.msgraph.client.beta.enums.OnPremisesPublishingType;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "resourceName", 
    "publishingType"})
@JsonInclude(Include.NON_NULL)
public class PublishedResource extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.publishedResource";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("resourceName")
    protected String resourceName;

    @JsonProperty("publishingType")
    protected OnPremisesPublishingType publishingType;

    protected PublishedResource() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPublishedResource() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String resourceName;
        private OnPremisesPublishingType publishingType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            this.changedFields = changedFields.add("resourceName");
            return this;
        }

        public Builder publishingType(OnPremisesPublishingType publishingType) {
            this.publishingType = publishingType;
            this.changedFields = changedFields.add("publishingType");
            return this;
        }

        public PublishedResource build() {
            PublishedResource _x = new PublishedResource();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.publishedResource";
            _x.id = id;
            _x.displayName = displayName;
            _x.resourceName = resourceName;
            _x.publishingType = publishingType;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public PublishedResource withDisplayName(String displayName) {
        PublishedResource _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.publishedResource");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="resourceName")
    @JsonIgnore
    public Optional<String> getResourceName() {
        return Optional.ofNullable(resourceName);
    }

    public PublishedResource withResourceName(String resourceName) {
        PublishedResource _x = _copy();
        _x.changedFields = changedFields.add("resourceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.publishedResource");
        _x.resourceName = resourceName;
        return _x;
    }

    @Property(name="publishingType")
    @JsonIgnore
    public Optional<OnPremisesPublishingType> getPublishingType() {
        return Optional.ofNullable(publishingType);
    }

    public PublishedResource withPublishingType(OnPremisesPublishingType publishingType) {
        PublishedResource _x = _copy();
        _x.changedFields = changedFields.add("publishingType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.publishedResource");
        _x.publishingType = publishingType;
        return _x;
    }

    @NavigationProperty(name="agentGroups")
    @JsonIgnore
    public OnPremisesAgentGroupCollectionRequest getAgentGroups() {
        return new OnPremisesAgentGroupCollectionRequest(
                        contextPath.addSegment("agentGroups"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PublishedResource patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PublishedResource _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PublishedResource put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PublishedResource _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PublishedResource _copy() {
        PublishedResource _x = new PublishedResource();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.resourceName = resourceName;
        _x.publishingType = publishingType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PublishedResource[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("resourceName=");
        b.append(this.resourceName);
        b.append(", ");
        b.append("publishingType=");
        b.append(this.publishingType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
