package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ProgramResource;
import odata.msgraph.client.beta.complex.UserIdentity;
import odata.msgraph.client.beta.entity.request.ProgramRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "controlId", 
    "programId", 
    "controlTypeId", 
    "displayName", 
    "status", 
    "owner", 
    "resource", 
    "createdDateTime"})
@JsonInclude(Include.NON_NULL)
public class ProgramControl extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.programControl";
    }

    @JsonProperty("controlId")
    protected String controlId;

    @JsonProperty("programId")
    protected String programId;

    @JsonProperty("controlTypeId")
    protected String controlTypeId;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("status")
    protected String status;

    @JsonProperty("owner")
    protected UserIdentity owner;

    @JsonProperty("resource")
    protected ProgramResource resource;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    protected ProgramControl() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderProgramControl() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String controlId;
        private String programId;
        private String controlTypeId;
        private String displayName;
        private String status;
        private UserIdentity owner;
        private ProgramResource resource;
        private OffsetDateTime createdDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder controlId(String controlId) {
            this.controlId = controlId;
            this.changedFields = changedFields.add("controlId");
            return this;
        }

        public Builder programId(String programId) {
            this.programId = programId;
            this.changedFields = changedFields.add("programId");
            return this;
        }

        public Builder controlTypeId(String controlTypeId) {
            this.controlTypeId = controlTypeId;
            this.changedFields = changedFields.add("controlTypeId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder owner(UserIdentity owner) {
            this.owner = owner;
            this.changedFields = changedFields.add("owner");
            return this;
        }

        public Builder resource(ProgramResource resource) {
            this.resource = resource;
            this.changedFields = changedFields.add("resource");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public ProgramControl build() {
            ProgramControl _x = new ProgramControl();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.programControl";
            _x.id = id;
            _x.controlId = controlId;
            _x.programId = programId;
            _x.controlTypeId = controlTypeId;
            _x.displayName = displayName;
            _x.status = status;
            _x.owner = owner;
            _x.resource = resource;
            _x.createdDateTime = createdDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="controlId")
    @JsonIgnore
    public Optional<String> getControlId() {
        return Optional.ofNullable(controlId);
    }

    public ProgramControl withControlId(String controlId) {
        ProgramControl _x = _copy();
        _x.changedFields = changedFields.add("controlId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.programControl");
        _x.controlId = controlId;
        return _x;
    }

    @Property(name="programId")
    @JsonIgnore
    public Optional<String> getProgramId() {
        return Optional.ofNullable(programId);
    }

    public ProgramControl withProgramId(String programId) {
        ProgramControl _x = _copy();
        _x.changedFields = changedFields.add("programId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.programControl");
        _x.programId = programId;
        return _x;
    }

    @Property(name="controlTypeId")
    @JsonIgnore
    public Optional<String> getControlTypeId() {
        return Optional.ofNullable(controlTypeId);
    }

    public ProgramControl withControlTypeId(String controlTypeId) {
        ProgramControl _x = _copy();
        _x.changedFields = changedFields.add("controlTypeId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.programControl");
        _x.controlTypeId = controlTypeId;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ProgramControl withDisplayName(String displayName) {
        ProgramControl _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.programControl");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public ProgramControl withStatus(String status) {
        ProgramControl _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.programControl");
        _x.status = status;
        return _x;
    }

    @Property(name="owner")
    @JsonIgnore
    public Optional<UserIdentity> getOwner() {
        return Optional.ofNullable(owner);
    }

    public ProgramControl withOwner(UserIdentity owner) {
        ProgramControl _x = _copy();
        _x.changedFields = changedFields.add("owner");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.programControl");
        _x.owner = owner;
        return _x;
    }

    @Property(name="resource")
    @JsonIgnore
    public Optional<ProgramResource> getResource() {
        return Optional.ofNullable(resource);
    }

    public ProgramControl withResource(ProgramResource resource) {
        ProgramControl _x = _copy();
        _x.changedFields = changedFields.add("resource");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.programControl");
        _x.resource = resource;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public ProgramControl withCreatedDateTime(OffsetDateTime createdDateTime) {
        ProgramControl _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.programControl");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @NavigationProperty(name="program")
    @JsonIgnore
    public ProgramRequest getProgram() {
        return new ProgramRequest(contextPath.addSegment("program"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ProgramControl patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ProgramControl _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ProgramControl put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ProgramControl _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ProgramControl _copy() {
        ProgramControl _x = new ProgramControl();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.controlId = controlId;
        _x.programId = programId;
        _x.controlTypeId = controlTypeId;
        _x.displayName = displayName;
        _x.status = status;
        _x.owner = owner;
        _x.resource = resource;
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ProgramControl[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("controlId=");
        b.append(this.controlId);
        b.append(", ");
        b.append("programId=");
        b.append(this.programId);
        b.append(", ");
        b.append("controlTypeId=");
        b.append(this.controlTypeId);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("owner=");
        b.append(this.owner);
        b.append(", ");
        b.append("resource=");
        b.append(this.resource);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
