package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ProfileCardAnnotation;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "directoryPropertyName", 
    "annotations"})
@JsonInclude(Include.NON_NULL)
public class ProfileCardProperty extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.profileCardProperty";
    }

    @JsonProperty("directoryPropertyName")
    protected String directoryPropertyName;

    @JsonProperty("annotations")
    protected List<ProfileCardAnnotation> annotations;

    @JsonProperty("annotations@nextLink")
    protected String annotationsNextLink;

    protected ProfileCardProperty() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderProfileCardProperty() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String directoryPropertyName;
        private List<ProfileCardAnnotation> annotations;
        private String annotationsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder directoryPropertyName(String directoryPropertyName) {
            this.directoryPropertyName = directoryPropertyName;
            this.changedFields = changedFields.add("directoryPropertyName");
            return this;
        }

        public Builder annotations(List<ProfileCardAnnotation> annotations) {
            this.annotations = annotations;
            this.changedFields = changedFields.add("annotations");
            return this;
        }

        public Builder annotations(ProfileCardAnnotation... annotations) {
            return annotations(Arrays.asList(annotations));
        }

        public Builder annotationsNextLink(String annotationsNextLink) {
            this.annotationsNextLink = annotationsNextLink;
            this.changedFields = changedFields.add("annotations");
            return this;
        }

        public ProfileCardProperty build() {
            ProfileCardProperty _x = new ProfileCardProperty();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.profileCardProperty";
            _x.id = id;
            _x.directoryPropertyName = directoryPropertyName;
            _x.annotations = annotations;
            _x.annotationsNextLink = annotationsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="directoryPropertyName")
    @JsonIgnore
    public Optional<String> getDirectoryPropertyName() {
        return Optional.ofNullable(directoryPropertyName);
    }

    public ProfileCardProperty withDirectoryPropertyName(String directoryPropertyName) {
        ProfileCardProperty _x = _copy();
        _x.changedFields = changedFields.add("directoryPropertyName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.profileCardProperty");
        _x.directoryPropertyName = directoryPropertyName;
        return _x;
    }

    @Property(name="annotations")
    @JsonIgnore
    public CollectionPage<ProfileCardAnnotation> getAnnotations() {
        return new CollectionPage<ProfileCardAnnotation>(contextPath, ProfileCardAnnotation.class, annotations, Optional.ofNullable(annotationsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="annotations")
    @JsonIgnore
    public CollectionPage<ProfileCardAnnotation> getAnnotations(HttpRequestOptions options) {
        return new CollectionPage<ProfileCardAnnotation>(contextPath, ProfileCardAnnotation.class, annotations, Optional.ofNullable(annotationsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ProfileCardProperty patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ProfileCardProperty _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ProfileCardProperty put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ProfileCardProperty _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ProfileCardProperty _copy() {
        ProfileCardProperty _x = new ProfileCardProperty();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.directoryPropertyName = directoryPropertyName;
        _x.annotations = annotations;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ProfileCardProperty[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("directoryPropertyName=");
        b.append(this.directoryPropertyName);
        b.append(", ");
        b.append("annotations=");
        b.append(this.annotations);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
