package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import odata.msgraph.client.beta.entity.collection.request.EducationalActivityCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemAddressCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemEmailCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemPhoneCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.LanguageProficiencyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PersonAnniversaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PersonAnnotationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PersonInterestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PersonNameCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PersonWebsiteCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ProjectParticipationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SkillProficiencyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserAccountInformationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WebAccountCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WorkPositionCollectionRequest;

@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class Profile extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.profile";
    }

    protected Profile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Profile build() {
            Profile _x = new Profile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.profile";
            _x.id = id;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @NavigationProperty(name="account")
    @JsonIgnore
    public UserAccountInformationCollectionRequest getAccount() {
        return new UserAccountInformationCollectionRequest(
                        contextPath.addSegment("account"));
    }

    @NavigationProperty(name="addresses")
    @JsonIgnore
    public ItemAddressCollectionRequest getAddresses() {
        return new ItemAddressCollectionRequest(
                        contextPath.addSegment("addresses"));
    }

    @NavigationProperty(name="anniversaries")
    @JsonIgnore
    public PersonAnniversaryCollectionRequest getAnniversaries() {
        return new PersonAnniversaryCollectionRequest(
                        contextPath.addSegment("anniversaries"));
    }

    @NavigationProperty(name="educationalActivities")
    @JsonIgnore
    public EducationalActivityCollectionRequest getEducationalActivities() {
        return new EducationalActivityCollectionRequest(
                        contextPath.addSegment("educationalActivities"));
    }

    @NavigationProperty(name="emails")
    @JsonIgnore
    public ItemEmailCollectionRequest getEmails() {
        return new ItemEmailCollectionRequest(
                        contextPath.addSegment("emails"));
    }

    @NavigationProperty(name="interests")
    @JsonIgnore
    public PersonInterestCollectionRequest getInterests() {
        return new PersonInterestCollectionRequest(
                        contextPath.addSegment("interests"));
    }

    @NavigationProperty(name="languages")
    @JsonIgnore
    public LanguageProficiencyCollectionRequest getLanguages() {
        return new LanguageProficiencyCollectionRequest(
                        contextPath.addSegment("languages"));
    }

    @NavigationProperty(name="names")
    @JsonIgnore
    public PersonNameCollectionRequest getNames() {
        return new PersonNameCollectionRequest(
                        contextPath.addSegment("names"));
    }

    @NavigationProperty(name="phones")
    @JsonIgnore
    public ItemPhoneCollectionRequest getPhones() {
        return new ItemPhoneCollectionRequest(
                        contextPath.addSegment("phones"));
    }

    @NavigationProperty(name="positions")
    @JsonIgnore
    public WorkPositionCollectionRequest getPositions() {
        return new WorkPositionCollectionRequest(
                        contextPath.addSegment("positions"));
    }

    @NavigationProperty(name="projects")
    @JsonIgnore
    public ProjectParticipationCollectionRequest getProjects() {
        return new ProjectParticipationCollectionRequest(
                        contextPath.addSegment("projects"));
    }

    @NavigationProperty(name="notes")
    @JsonIgnore
    public PersonAnnotationCollectionRequest getNotes() {
        return new PersonAnnotationCollectionRequest(
                        contextPath.addSegment("notes"));
    }

    @NavigationProperty(name="skills")
    @JsonIgnore
    public SkillProficiencyCollectionRequest getSkills() {
        return new SkillProficiencyCollectionRequest(
                        contextPath.addSegment("skills"));
    }

    @NavigationProperty(name="webAccounts")
    @JsonIgnore
    public WebAccountCollectionRequest getWebAccounts() {
        return new WebAccountCollectionRequest(
                        contextPath.addSegment("webAccounts"));
    }

    @NavigationProperty(name="websites")
    @JsonIgnore
    public PersonWebsiteCollectionRequest getWebsites() {
        return new PersonWebsiteCollectionRequest(
                        contextPath.addSegment("websites"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Profile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Profile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Profile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Profile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Profile _copy() {
        Profile _x = new Profile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Profile[");
        b.append("id=");
        b.append(this.id);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
