package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "approverIds", 
    "minElevationDuration", 
    "maxElavationDuration", 
    "elevationDuration", 
    "notificationToUserOnElevation", 
    "ticketingInfoOnElevation", 
    "mfaOnElevation", 
    "lastGlobalAdmin", 
    "isMfaOnElevationConfigurable", 
    "approvalOnElevation"})
@JsonInclude(Include.NON_NULL)
public class PrivilegedRoleSettings extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.privilegedRoleSettings";
    }

    @JsonProperty("approverIds")
    protected List<String> approverIds;

    @JsonProperty("approverIds@nextLink")
    protected String approverIdsNextLink;

    @JsonProperty("minElevationDuration")
    protected Duration minElevationDuration;

    @JsonProperty("maxElavationDuration")
    protected Duration maxElavationDuration;

    @JsonProperty("elevationDuration")
    protected Duration elevationDuration;

    @JsonProperty("notificationToUserOnElevation")
    protected Boolean notificationToUserOnElevation;

    @JsonProperty("ticketingInfoOnElevation")
    protected Boolean ticketingInfoOnElevation;

    @JsonProperty("mfaOnElevation")
    protected Boolean mfaOnElevation;

    @JsonProperty("lastGlobalAdmin")
    protected Boolean lastGlobalAdmin;

    @JsonProperty("isMfaOnElevationConfigurable")
    protected Boolean isMfaOnElevationConfigurable;

    @JsonProperty("approvalOnElevation")
    protected Boolean approvalOnElevation;

    protected PrivilegedRoleSettings() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPrivilegedRoleSettings() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<String> approverIds;
        private String approverIdsNextLink;
        private Duration minElevationDuration;
        private Duration maxElavationDuration;
        private Duration elevationDuration;
        private Boolean notificationToUserOnElevation;
        private Boolean ticketingInfoOnElevation;
        private Boolean mfaOnElevation;
        private Boolean lastGlobalAdmin;
        private Boolean isMfaOnElevationConfigurable;
        private Boolean approvalOnElevation;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder approverIds(List<String> approverIds) {
            this.approverIds = approverIds;
            this.changedFields = changedFields.add("approverIds");
            return this;
        }

        public Builder approverIds(String... approverIds) {
            return approverIds(Arrays.asList(approverIds));
        }

        public Builder approverIdsNextLink(String approverIdsNextLink) {
            this.approverIdsNextLink = approverIdsNextLink;
            this.changedFields = changedFields.add("approverIds");
            return this;
        }

        public Builder minElevationDuration(Duration minElevationDuration) {
            this.minElevationDuration = minElevationDuration;
            this.changedFields = changedFields.add("minElevationDuration");
            return this;
        }

        public Builder maxElavationDuration(Duration maxElavationDuration) {
            this.maxElavationDuration = maxElavationDuration;
            this.changedFields = changedFields.add("maxElavationDuration");
            return this;
        }

        public Builder elevationDuration(Duration elevationDuration) {
            this.elevationDuration = elevationDuration;
            this.changedFields = changedFields.add("elevationDuration");
            return this;
        }

        public Builder notificationToUserOnElevation(Boolean notificationToUserOnElevation) {
            this.notificationToUserOnElevation = notificationToUserOnElevation;
            this.changedFields = changedFields.add("notificationToUserOnElevation");
            return this;
        }

        public Builder ticketingInfoOnElevation(Boolean ticketingInfoOnElevation) {
            this.ticketingInfoOnElevation = ticketingInfoOnElevation;
            this.changedFields = changedFields.add("ticketingInfoOnElevation");
            return this;
        }

        public Builder mfaOnElevation(Boolean mfaOnElevation) {
            this.mfaOnElevation = mfaOnElevation;
            this.changedFields = changedFields.add("mfaOnElevation");
            return this;
        }

        public Builder lastGlobalAdmin(Boolean lastGlobalAdmin) {
            this.lastGlobalAdmin = lastGlobalAdmin;
            this.changedFields = changedFields.add("lastGlobalAdmin");
            return this;
        }

        public Builder isMfaOnElevationConfigurable(Boolean isMfaOnElevationConfigurable) {
            this.isMfaOnElevationConfigurable = isMfaOnElevationConfigurable;
            this.changedFields = changedFields.add("isMfaOnElevationConfigurable");
            return this;
        }

        public Builder approvalOnElevation(Boolean approvalOnElevation) {
            this.approvalOnElevation = approvalOnElevation;
            this.changedFields = changedFields.add("approvalOnElevation");
            return this;
        }

        public PrivilegedRoleSettings build() {
            PrivilegedRoleSettings _x = new PrivilegedRoleSettings();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.privilegedRoleSettings";
            _x.id = id;
            _x.approverIds = approverIds;
            _x.approverIdsNextLink = approverIdsNextLink;
            _x.minElevationDuration = minElevationDuration;
            _x.maxElavationDuration = maxElavationDuration;
            _x.elevationDuration = elevationDuration;
            _x.notificationToUserOnElevation = notificationToUserOnElevation;
            _x.ticketingInfoOnElevation = ticketingInfoOnElevation;
            _x.mfaOnElevation = mfaOnElevation;
            _x.lastGlobalAdmin = lastGlobalAdmin;
            _x.isMfaOnElevationConfigurable = isMfaOnElevationConfigurable;
            _x.approvalOnElevation = approvalOnElevation;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="approverIds")
    @JsonIgnore
    public CollectionPage<String> getApproverIds() {
        return new CollectionPage<String>(contextPath, String.class, approverIds, Optional.ofNullable(approverIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="approverIds")
    @JsonIgnore
    public CollectionPage<String> getApproverIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, approverIds, Optional.ofNullable(approverIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="minElevationDuration")
    @JsonIgnore
    public Optional<Duration> getMinElevationDuration() {
        return Optional.ofNullable(minElevationDuration);
    }

    public PrivilegedRoleSettings withMinElevationDuration(Duration minElevationDuration) {
        PrivilegedRoleSettings _x = _copy();
        _x.changedFields = changedFields.add("minElevationDuration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleSettings");
        _x.minElevationDuration = minElevationDuration;
        return _x;
    }

    @Property(name="maxElavationDuration")
    @JsonIgnore
    public Optional<Duration> getMaxElavationDuration() {
        return Optional.ofNullable(maxElavationDuration);
    }

    public PrivilegedRoleSettings withMaxElavationDuration(Duration maxElavationDuration) {
        PrivilegedRoleSettings _x = _copy();
        _x.changedFields = changedFields.add("maxElavationDuration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleSettings");
        _x.maxElavationDuration = maxElavationDuration;
        return _x;
    }

    @Property(name="elevationDuration")
    @JsonIgnore
    public Optional<Duration> getElevationDuration() {
        return Optional.ofNullable(elevationDuration);
    }

    public PrivilegedRoleSettings withElevationDuration(Duration elevationDuration) {
        PrivilegedRoleSettings _x = _copy();
        _x.changedFields = changedFields.add("elevationDuration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleSettings");
        _x.elevationDuration = elevationDuration;
        return _x;
    }

    @Property(name="notificationToUserOnElevation")
    @JsonIgnore
    public Optional<Boolean> getNotificationToUserOnElevation() {
        return Optional.ofNullable(notificationToUserOnElevation);
    }

    public PrivilegedRoleSettings withNotificationToUserOnElevation(Boolean notificationToUserOnElevation) {
        PrivilegedRoleSettings _x = _copy();
        _x.changedFields = changedFields.add("notificationToUserOnElevation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleSettings");
        _x.notificationToUserOnElevation = notificationToUserOnElevation;
        return _x;
    }

    @Property(name="ticketingInfoOnElevation")
    @JsonIgnore
    public Optional<Boolean> getTicketingInfoOnElevation() {
        return Optional.ofNullable(ticketingInfoOnElevation);
    }

    public PrivilegedRoleSettings withTicketingInfoOnElevation(Boolean ticketingInfoOnElevation) {
        PrivilegedRoleSettings _x = _copy();
        _x.changedFields = changedFields.add("ticketingInfoOnElevation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleSettings");
        _x.ticketingInfoOnElevation = ticketingInfoOnElevation;
        return _x;
    }

    @Property(name="mfaOnElevation")
    @JsonIgnore
    public Optional<Boolean> getMfaOnElevation() {
        return Optional.ofNullable(mfaOnElevation);
    }

    public PrivilegedRoleSettings withMfaOnElevation(Boolean mfaOnElevation) {
        PrivilegedRoleSettings _x = _copy();
        _x.changedFields = changedFields.add("mfaOnElevation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleSettings");
        _x.mfaOnElevation = mfaOnElevation;
        return _x;
    }

    @Property(name="lastGlobalAdmin")
    @JsonIgnore
    public Optional<Boolean> getLastGlobalAdmin() {
        return Optional.ofNullable(lastGlobalAdmin);
    }

    public PrivilegedRoleSettings withLastGlobalAdmin(Boolean lastGlobalAdmin) {
        PrivilegedRoleSettings _x = _copy();
        _x.changedFields = changedFields.add("lastGlobalAdmin");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleSettings");
        _x.lastGlobalAdmin = lastGlobalAdmin;
        return _x;
    }

    @Property(name="isMfaOnElevationConfigurable")
    @JsonIgnore
    public Optional<Boolean> getIsMfaOnElevationConfigurable() {
        return Optional.ofNullable(isMfaOnElevationConfigurable);
    }

    public PrivilegedRoleSettings withIsMfaOnElevationConfigurable(Boolean isMfaOnElevationConfigurable) {
        PrivilegedRoleSettings _x = _copy();
        _x.changedFields = changedFields.add("isMfaOnElevationConfigurable");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleSettings");
        _x.isMfaOnElevationConfigurable = isMfaOnElevationConfigurable;
        return _x;
    }

    @Property(name="approvalOnElevation")
    @JsonIgnore
    public Optional<Boolean> getApprovalOnElevation() {
        return Optional.ofNullable(approvalOnElevation);
    }

    public PrivilegedRoleSettings withApprovalOnElevation(Boolean approvalOnElevation) {
        PrivilegedRoleSettings _x = _copy();
        _x.changedFields = changedFields.add("approvalOnElevation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleSettings");
        _x.approvalOnElevation = approvalOnElevation;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrivilegedRoleSettings patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PrivilegedRoleSettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrivilegedRoleSettings put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PrivilegedRoleSettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PrivilegedRoleSettings _copy() {
        PrivilegedRoleSettings _x = new PrivilegedRoleSettings();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.approverIds = approverIds;
        _x.minElevationDuration = minElevationDuration;
        _x.maxElavationDuration = maxElavationDuration;
        _x.elevationDuration = elevationDuration;
        _x.notificationToUserOnElevation = notificationToUserOnElevation;
        _x.ticketingInfoOnElevation = ticketingInfoOnElevation;
        _x.mfaOnElevation = mfaOnElevation;
        _x.lastGlobalAdmin = lastGlobalAdmin;
        _x.isMfaOnElevationConfigurable = isMfaOnElevationConfigurable;
        _x.approvalOnElevation = approvalOnElevation;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrivilegedRoleSettings[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("approverIds=");
        b.append(this.approverIds);
        b.append(", ");
        b.append("minElevationDuration=");
        b.append(this.minElevationDuration);
        b.append(", ");
        b.append("maxElavationDuration=");
        b.append(this.maxElavationDuration);
        b.append(", ");
        b.append("elevationDuration=");
        b.append(this.elevationDuration);
        b.append(", ");
        b.append("notificationToUserOnElevation=");
        b.append(this.notificationToUserOnElevation);
        b.append(", ");
        b.append("ticketingInfoOnElevation=");
        b.append(this.ticketingInfoOnElevation);
        b.append(", ");
        b.append("mfaOnElevation=");
        b.append(this.mfaOnElevation);
        b.append(", ");
        b.append("lastGlobalAdmin=");
        b.append(this.lastGlobalAdmin);
        b.append(", ");
        b.append("isMfaOnElevationConfigurable=");
        b.append(this.isMfaOnElevationConfigurable);
        b.append(", ");
        b.append("approvalOnElevation=");
        b.append(this.approvalOnElevation);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
