package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.GovernanceSchedule;
import odata.msgraph.client.beta.entity.request.PrivilegedRoleRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "schedule", 
    "userId", 
    "roleId", 
    "type", 
    "assignmentState", 
    "requestedDateTime", 
    "status", 
    "duration", 
    "reason", 
    "ticketNumber", 
    "ticketSystem"})
@JsonInclude(Include.NON_NULL)
public class PrivilegedRoleAssignmentRequest extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.privilegedRoleAssignmentRequest";
    }

    @JsonProperty("schedule")
    protected GovernanceSchedule schedule;

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("roleId")
    protected String roleId;

    @JsonProperty("type")
    protected String type;

    @JsonProperty("assignmentState")
    protected String assignmentState;

    @JsonProperty("requestedDateTime")
    protected OffsetDateTime requestedDateTime;

    @JsonProperty("status")
    protected String status;

    @JsonProperty("duration")
    protected String duration;

    @JsonProperty("reason")
    protected String reason;

    @JsonProperty("ticketNumber")
    protected String ticketNumber;

    @JsonProperty("ticketSystem")
    protected String ticketSystem;

    protected PrivilegedRoleAssignmentRequest() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPrivilegedRoleAssignmentRequest() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private GovernanceSchedule schedule;
        private String userId;
        private String roleId;
        private String type;
        private String assignmentState;
        private OffsetDateTime requestedDateTime;
        private String status;
        private String duration;
        private String reason;
        private String ticketNumber;
        private String ticketSystem;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder schedule(GovernanceSchedule schedule) {
            this.schedule = schedule;
            this.changedFields = changedFields.add("schedule");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        public Builder roleId(String roleId) {
            this.roleId = roleId;
            this.changedFields = changedFields.add("roleId");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder assignmentState(String assignmentState) {
            this.assignmentState = assignmentState;
            this.changedFields = changedFields.add("assignmentState");
            return this;
        }

        public Builder requestedDateTime(OffsetDateTime requestedDateTime) {
            this.requestedDateTime = requestedDateTime;
            this.changedFields = changedFields.add("requestedDateTime");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder duration(String duration) {
            this.duration = duration;
            this.changedFields = changedFields.add("duration");
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            this.changedFields = changedFields.add("reason");
            return this;
        }

        public Builder ticketNumber(String ticketNumber) {
            this.ticketNumber = ticketNumber;
            this.changedFields = changedFields.add("ticketNumber");
            return this;
        }

        public Builder ticketSystem(String ticketSystem) {
            this.ticketSystem = ticketSystem;
            this.changedFields = changedFields.add("ticketSystem");
            return this;
        }

        public PrivilegedRoleAssignmentRequest build() {
            PrivilegedRoleAssignmentRequest _x = new PrivilegedRoleAssignmentRequest();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.privilegedRoleAssignmentRequest";
            _x.id = id;
            _x.schedule = schedule;
            _x.userId = userId;
            _x.roleId = roleId;
            _x.type = type;
            _x.assignmentState = assignmentState;
            _x.requestedDateTime = requestedDateTime;
            _x.status = status;
            _x.duration = duration;
            _x.reason = reason;
            _x.ticketNumber = ticketNumber;
            _x.ticketSystem = ticketSystem;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="schedule")
    @JsonIgnore
    public Optional<GovernanceSchedule> getSchedule() {
        return Optional.ofNullable(schedule);
    }

    public PrivilegedRoleAssignmentRequest withSchedule(GovernanceSchedule schedule) {
        PrivilegedRoleAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("schedule");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleAssignmentRequest");
        _x.schedule = schedule;
        return _x;
    }

    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    public PrivilegedRoleAssignmentRequest withUserId(String userId) {
        PrivilegedRoleAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleAssignmentRequest");
        _x.userId = userId;
        return _x;
    }

    @Property(name="roleId")
    @JsonIgnore
    public Optional<String> getRoleId() {
        return Optional.ofNullable(roleId);
    }

    public PrivilegedRoleAssignmentRequest withRoleId(String roleId) {
        PrivilegedRoleAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("roleId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleAssignmentRequest");
        _x.roleId = roleId;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public PrivilegedRoleAssignmentRequest withType(String type) {
        PrivilegedRoleAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("type");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleAssignmentRequest");
        _x.type = type;
        return _x;
    }

    @Property(name="assignmentState")
    @JsonIgnore
    public Optional<String> getAssignmentState() {
        return Optional.ofNullable(assignmentState);
    }

    public PrivilegedRoleAssignmentRequest withAssignmentState(String assignmentState) {
        PrivilegedRoleAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("assignmentState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleAssignmentRequest");
        _x.assignmentState = assignmentState;
        return _x;
    }

    @Property(name="requestedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getRequestedDateTime() {
        return Optional.ofNullable(requestedDateTime);
    }

    public PrivilegedRoleAssignmentRequest withRequestedDateTime(OffsetDateTime requestedDateTime) {
        PrivilegedRoleAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("requestedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleAssignmentRequest");
        _x.requestedDateTime = requestedDateTime;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public PrivilegedRoleAssignmentRequest withStatus(String status) {
        PrivilegedRoleAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleAssignmentRequest");
        _x.status = status;
        return _x;
    }

    @Property(name="duration")
    @JsonIgnore
    public Optional<String> getDuration() {
        return Optional.ofNullable(duration);
    }

    public PrivilegedRoleAssignmentRequest withDuration(String duration) {
        PrivilegedRoleAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("duration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleAssignmentRequest");
        _x.duration = duration;
        return _x;
    }

    @Property(name="reason")
    @JsonIgnore
    public Optional<String> getReason() {
        return Optional.ofNullable(reason);
    }

    public PrivilegedRoleAssignmentRequest withReason(String reason) {
        PrivilegedRoleAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("reason");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleAssignmentRequest");
        _x.reason = reason;
        return _x;
    }

    @Property(name="ticketNumber")
    @JsonIgnore
    public Optional<String> getTicketNumber() {
        return Optional.ofNullable(ticketNumber);
    }

    public PrivilegedRoleAssignmentRequest withTicketNumber(String ticketNumber) {
        PrivilegedRoleAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("ticketNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleAssignmentRequest");
        _x.ticketNumber = ticketNumber;
        return _x;
    }

    @Property(name="ticketSystem")
    @JsonIgnore
    public Optional<String> getTicketSystem() {
        return Optional.ofNullable(ticketSystem);
    }

    public PrivilegedRoleAssignmentRequest withTicketSystem(String ticketSystem) {
        PrivilegedRoleAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("ticketSystem");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRoleAssignmentRequest");
        _x.ticketSystem = ticketSystem;
        return _x;
    }

    @NavigationProperty(name="roleInfo")
    @JsonIgnore
    public PrivilegedRoleRequest getRoleInfo() {
        return new PrivilegedRoleRequest(contextPath.addSegment("roleInfo"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrivilegedRoleAssignmentRequest patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PrivilegedRoleAssignmentRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrivilegedRoleAssignmentRequest put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PrivilegedRoleAssignmentRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PrivilegedRoleAssignmentRequest _copy() {
        PrivilegedRoleAssignmentRequest _x = new PrivilegedRoleAssignmentRequest();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.schedule = schedule;
        _x.userId = userId;
        _x.roleId = roleId;
        _x.type = type;
        _x.assignmentState = assignmentState;
        _x.requestedDateTime = requestedDateTime;
        _x.status = status;
        _x.duration = duration;
        _x.reason = reason;
        _x.ticketNumber = ticketNumber;
        _x.ticketSystem = ticketSystem;
        return _x;
    }

    @Action(name = "cancel")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PrivilegedRoleAssignmentRequest> cancel() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<PrivilegedRoleAssignmentRequest>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancel"), PrivilegedRoleAssignmentRequest.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrivilegedRoleAssignmentRequest[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("schedule=");
        b.append(this.schedule);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("roleId=");
        b.append(this.roleId);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("assignmentState=");
        b.append(this.assignmentState);
        b.append(", ");
        b.append("requestedDateTime=");
        b.append(this.requestedDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("duration=");
        b.append(this.duration);
        b.append(", ");
        b.append("reason=");
        b.append(this.reason);
        b.append(", ");
        b.append("ticketNumber=");
        b.append(this.ticketNumber);
        b.append(", ");
        b.append("ticketSystem=");
        b.append(this.ticketSystem);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
