package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.PrivilegedRoleAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.request.PrivilegedRoleSettingsRequest;
import odata.msgraph.client.beta.entity.request.PrivilegedRoleSummaryRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "name"})
@JsonInclude(Include.NON_NULL)
public class PrivilegedRole extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.privilegedRole";
    }

    @JsonProperty("name")
    protected String name;

    protected PrivilegedRole() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPrivilegedRole() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String name;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public PrivilegedRole build() {
            PrivilegedRole _x = new PrivilegedRole();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.privilegedRole";
            _x.id = id;
            _x.name = name;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public PrivilegedRole withName(String name) {
        PrivilegedRole _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedRole");
        _x.name = name;
        return _x;
    }

    @NavigationProperty(name="settings")
    @JsonIgnore
    public PrivilegedRoleSettingsRequest getSettings() {
        return new PrivilegedRoleSettingsRequest(contextPath.addSegment("settings"));
    }

    @NavigationProperty(name="assignments")
    @JsonIgnore
    public PrivilegedRoleAssignmentCollectionRequest getAssignments() {
        return new PrivilegedRoleAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    @NavigationProperty(name="summary")
    @JsonIgnore
    public PrivilegedRoleSummaryRequest getSummary() {
        return new PrivilegedRoleSummaryRequest(contextPath.addSegment("summary"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrivilegedRole patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PrivilegedRole _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrivilegedRole put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PrivilegedRole _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PrivilegedRole _copy() {
        PrivilegedRole _x = new PrivilegedRole();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.name = name;
        return _x;
    }

    @Action(name = "selfActivate")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PrivilegedRoleAssignment> selfActivate(String reason, String duration, String ticketNumber, String ticketSystem) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("reason", "Edm.String", Checks.checkIsAscii(reason))
            .put("duration", "Edm.String", Checks.checkIsAscii(duration))
            .put("ticketNumber", "Edm.String", Checks.checkIsAscii(ticketNumber))
            .put("ticketSystem", "Edm.String", Checks.checkIsAscii(ticketSystem))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<PrivilegedRoleAssignment>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.selfActivate"), PrivilegedRoleAssignment.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "selfDeactivate")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PrivilegedRoleAssignment> selfDeactivate() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<PrivilegedRoleAssignment>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.selfDeactivate"), PrivilegedRoleAssignment.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrivilegedRole[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
