package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.GovernanceResourceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GovernanceRoleAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GovernanceRoleAssignmentRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GovernanceRoleDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GovernanceRoleSettingCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName"})
@JsonInclude(Include.NON_NULL)
public class PrivilegedAccess extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.privilegedAccess";
    }

    @JsonProperty("displayName")
    protected String displayName;

    protected PrivilegedAccess() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPrivilegedAccess() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public PrivilegedAccess build() {
            PrivilegedAccess _x = new PrivilegedAccess();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.privilegedAccess";
            _x.id = id;
            _x.displayName = displayName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public PrivilegedAccess withDisplayName(String displayName) {
        PrivilegedAccess _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.privilegedAccess");
        _x.displayName = displayName;
        return _x;
    }

    @NavigationProperty(name="resources")
    @JsonIgnore
    public GovernanceResourceCollectionRequest getResources() {
        return new GovernanceResourceCollectionRequest(
                        contextPath.addSegment("resources"));
    }

    @NavigationProperty(name="roleDefinitions")
    @JsonIgnore
    public GovernanceRoleDefinitionCollectionRequest getRoleDefinitions() {
        return new GovernanceRoleDefinitionCollectionRequest(
                        contextPath.addSegment("roleDefinitions"));
    }

    @NavigationProperty(name="roleAssignments")
    @JsonIgnore
    public GovernanceRoleAssignmentCollectionRequest getRoleAssignments() {
        return new GovernanceRoleAssignmentCollectionRequest(
                        contextPath.addSegment("roleAssignments"));
    }

    @NavigationProperty(name="roleAssignmentRequests")
    @JsonIgnore
    public GovernanceRoleAssignmentRequestCollectionRequest getRoleAssignmentRequests() {
        return new GovernanceRoleAssignmentRequestCollectionRequest(
                        contextPath.addSegment("roleAssignmentRequests"));
    }

    @NavigationProperty(name="roleSettings")
    @JsonIgnore
    public GovernanceRoleSettingCollectionRequest getRoleSettings() {
        return new GovernanceRoleSettingCollectionRequest(
                        contextPath.addSegment("roleSettings"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrivilegedAccess patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PrivilegedAccess _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrivilegedAccess put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PrivilegedAccess _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PrivilegedAccess _copy() {
        PrivilegedAccess _x = new PrivilegedAccess();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrivilegedAccess[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
