package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.PrinterCapabilities;
import odata.msgraph.client.beta.complex.PrinterDefaults;
import odata.msgraph.client.beta.complex.PrinterLocation;
import odata.msgraph.client.beta.complex.PrinterStatus;
import odata.msgraph.client.beta.entity.collection.request.PrintConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintIdentityCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintTaskTriggerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintUserIdentityCollectionRequest;
import odata.msgraph.client.beta.entity.request.PrinterShareRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "registeredDateTime", 
    "isShared", 
    "acceptingJobs"})
@JsonInclude(Include.NON_NULL)
public class Printer extends PrinterBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.printer";
    }

    @JsonProperty("registeredDateTime")
    protected OffsetDateTime registeredDateTime;

    @JsonProperty("isShared")
    protected Boolean isShared;

    @JsonProperty("acceptingJobs")
    protected Boolean acceptingJobs;

    protected Printer() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPrinter() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String name;
        private String manufacturer;
        private String model;
        private Boolean isAcceptingJobs;
        private PrinterDefaults defaults;
        private PrinterLocation location;
        private PrinterCapabilities capabilities;
        private PrinterStatus status;
        private OffsetDateTime registeredDateTime;
        private Boolean isShared;
        private Boolean acceptingJobs;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            this.changedFields = changedFields.add("manufacturer");
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            this.changedFields = changedFields.add("model");
            return this;
        }

        public Builder isAcceptingJobs(Boolean isAcceptingJobs) {
            this.isAcceptingJobs = isAcceptingJobs;
            this.changedFields = changedFields.add("isAcceptingJobs");
            return this;
        }

        public Builder defaults(PrinterDefaults defaults) {
            this.defaults = defaults;
            this.changedFields = changedFields.add("defaults");
            return this;
        }

        public Builder location(PrinterLocation location) {
            this.location = location;
            this.changedFields = changedFields.add("location");
            return this;
        }

        public Builder capabilities(PrinterCapabilities capabilities) {
            this.capabilities = capabilities;
            this.changedFields = changedFields.add("capabilities");
            return this;
        }

        public Builder status(PrinterStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder registeredDateTime(OffsetDateTime registeredDateTime) {
            this.registeredDateTime = registeredDateTime;
            this.changedFields = changedFields.add("registeredDateTime");
            return this;
        }

        public Builder isShared(Boolean isShared) {
            this.isShared = isShared;
            this.changedFields = changedFields.add("isShared");
            return this;
        }

        public Builder acceptingJobs(Boolean acceptingJobs) {
            this.acceptingJobs = acceptingJobs;
            this.changedFields = changedFields.add("acceptingJobs");
            return this;
        }

        public Printer build() {
            Printer _x = new Printer();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.printer";
            _x.id = id;
            _x.name = name;
            _x.manufacturer = manufacturer;
            _x.model = model;
            _x.isAcceptingJobs = isAcceptingJobs;
            _x.defaults = defaults;
            _x.location = location;
            _x.capabilities = capabilities;
            _x.status = status;
            _x.registeredDateTime = registeredDateTime;
            _x.isShared = isShared;
            _x.acceptingJobs = acceptingJobs;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="registeredDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getRegisteredDateTime() {
        return Optional.ofNullable(registeredDateTime);
    }

    public Printer withRegisteredDateTime(OffsetDateTime registeredDateTime) {
        Printer _x = _copy();
        _x.changedFields = changedFields.add("registeredDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printer");
        _x.registeredDateTime = registeredDateTime;
        return _x;
    }

    @Property(name="isShared")
    @JsonIgnore
    public Optional<Boolean> getIsShared() {
        return Optional.ofNullable(isShared);
    }

    public Printer withIsShared(Boolean isShared) {
        Printer _x = _copy();
        _x.changedFields = changedFields.add("isShared");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printer");
        _x.isShared = isShared;
        return _x;
    }

    @Property(name="acceptingJobs")
    @JsonIgnore
    public Optional<Boolean> getAcceptingJobs() {
        return Optional.ofNullable(acceptingJobs);
    }

    public Printer withAcceptingJobs(Boolean acceptingJobs) {
        Printer _x = _copy();
        _x.changedFields = changedFields.add("acceptingJobs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.printer");
        _x.acceptingJobs = acceptingJobs;
        return _x;
    }

    @NavigationProperty(name="allowedUsers")
    @JsonIgnore
    public PrintUserIdentityCollectionRequest getAllowedUsers() {
        return new PrintUserIdentityCollectionRequest(
                        contextPath.addSegment("allowedUsers"));
    }

    @NavigationProperty(name="allowedGroups")
    @JsonIgnore
    public PrintIdentityCollectionRequest getAllowedGroups() {
        return new PrintIdentityCollectionRequest(
                        contextPath.addSegment("allowedGroups"));
    }

    @NavigationProperty(name="share")
    @JsonIgnore
    public PrinterShareRequest getShare() {
        return new PrinterShareRequest(contextPath.addSegment("share"));
    }

    @NavigationProperty(name="connectors")
    @JsonIgnore
    public PrintConnectorCollectionRequest getConnectors() {
        return new PrintConnectorCollectionRequest(
                        contextPath.addSegment("connectors"));
    }

    @NavigationProperty(name="taskTriggers")
    @JsonIgnore
    public PrintTaskTriggerCollectionRequest getTaskTriggers() {
        return new PrintTaskTriggerCollectionRequest(
                        contextPath.addSegment("taskTriggers"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Printer patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Printer _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Printer put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Printer _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Printer _copy() {
        Printer _x = new Printer();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.name = name;
        _x.manufacturer = manufacturer;
        _x.model = model;
        _x.isAcceptingJobs = isAcceptingJobs;
        _x.defaults = defaults;
        _x.location = location;
        _x.capabilities = capabilities;
        _x.status = status;
        _x.registeredDateTime = registeredDateTime;
        _x.isShared = isShared;
        _x.acceptingJobs = acceptingJobs;
        return _x;
    }

    @Action(name = "resetDefaults")
    @JsonIgnore
    public ActionRequestNoReturn resetDefaults() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.resetDefaults"), _parameters);
    }

    @Function(name = "getCapabilities")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<PrinterCapabilities> getCapabilities_Function() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<PrinterCapabilities>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getCapabilities"), PrinterCapabilities.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Printer[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("manufacturer=");
        b.append(this.manufacturer);
        b.append(", ");
        b.append("model=");
        b.append(this.model);
        b.append(", ");
        b.append("isAcceptingJobs=");
        b.append(this.isAcceptingJobs);
        b.append(", ");
        b.append("defaults=");
        b.append(this.defaults);
        b.append(", ");
        b.append("location=");
        b.append(this.location);
        b.append(", ");
        b.append("capabilities=");
        b.append(this.capabilities);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("registeredDateTime=");
        b.append(this.registeredDateTime);
        b.append(", ");
        b.append("isShared=");
        b.append(this.isShared);
        b.append(", ");
        b.append("acceptingJobs=");
        b.append(this.acceptingJobs);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
