package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "userPrincipalName", 
    "usageDate", 
    "completedBlackAndWhiteJobCount", 
    "completedColorJobCount", 
    "incompleteJobCount"})
@JsonInclude(Include.NON_NULL)
public class PrintUsageSummaryByUser extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.PrintUsageSummaryByUser";
    }

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    @JsonProperty("usageDate")
    protected LocalDate usageDate;

    @JsonProperty("completedBlackAndWhiteJobCount")
    protected Long completedBlackAndWhiteJobCount;

    @JsonProperty("completedColorJobCount")
    protected Long completedColorJobCount;

    @JsonProperty("incompleteJobCount")
    protected Long incompleteJobCount;

    protected PrintUsageSummaryByUser() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPrintUsageSummaryByUser() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String userPrincipalName;
        private LocalDate usageDate;
        private Long completedBlackAndWhiteJobCount;
        private Long completedColorJobCount;
        private Long incompleteJobCount;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public Builder usageDate(LocalDate usageDate) {
            this.usageDate = usageDate;
            this.changedFields = changedFields.add("usageDate");
            return this;
        }

        public Builder completedBlackAndWhiteJobCount(Long completedBlackAndWhiteJobCount) {
            this.completedBlackAndWhiteJobCount = completedBlackAndWhiteJobCount;
            this.changedFields = changedFields.add("completedBlackAndWhiteJobCount");
            return this;
        }

        public Builder completedColorJobCount(Long completedColorJobCount) {
            this.completedColorJobCount = completedColorJobCount;
            this.changedFields = changedFields.add("completedColorJobCount");
            return this;
        }

        public Builder incompleteJobCount(Long incompleteJobCount) {
            this.incompleteJobCount = incompleteJobCount;
            this.changedFields = changedFields.add("incompleteJobCount");
            return this;
        }

        public PrintUsageSummaryByUser build() {
            PrintUsageSummaryByUser _x = new PrintUsageSummaryByUser();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.PrintUsageSummaryByUser";
            _x.id = id;
            _x.userPrincipalName = userPrincipalName;
            _x.usageDate = usageDate;
            _x.completedBlackAndWhiteJobCount = completedBlackAndWhiteJobCount;
            _x.completedColorJobCount = completedColorJobCount;
            _x.incompleteJobCount = incompleteJobCount;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public PrintUsageSummaryByUser withUserPrincipalName(String userPrincipalName) {
        PrintUsageSummaryByUser _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.PrintUsageSummaryByUser");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Property(name="usageDate")
    @JsonIgnore
    public Optional<LocalDate> getUsageDate() {
        return Optional.ofNullable(usageDate);
    }

    public PrintUsageSummaryByUser withUsageDate(LocalDate usageDate) {
        PrintUsageSummaryByUser _x = _copy();
        _x.changedFields = changedFields.add("usageDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.PrintUsageSummaryByUser");
        _x.usageDate = usageDate;
        return _x;
    }

    @Property(name="completedBlackAndWhiteJobCount")
    @JsonIgnore
    public Optional<Long> getCompletedBlackAndWhiteJobCount() {
        return Optional.ofNullable(completedBlackAndWhiteJobCount);
    }

    public PrintUsageSummaryByUser withCompletedBlackAndWhiteJobCount(Long completedBlackAndWhiteJobCount) {
        PrintUsageSummaryByUser _x = _copy();
        _x.changedFields = changedFields.add("completedBlackAndWhiteJobCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.PrintUsageSummaryByUser");
        _x.completedBlackAndWhiteJobCount = completedBlackAndWhiteJobCount;
        return _x;
    }

    @Property(name="completedColorJobCount")
    @JsonIgnore
    public Optional<Long> getCompletedColorJobCount() {
        return Optional.ofNullable(completedColorJobCount);
    }

    public PrintUsageSummaryByUser withCompletedColorJobCount(Long completedColorJobCount) {
        PrintUsageSummaryByUser _x = _copy();
        _x.changedFields = changedFields.add("completedColorJobCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.PrintUsageSummaryByUser");
        _x.completedColorJobCount = completedColorJobCount;
        return _x;
    }

    @Property(name="incompleteJobCount")
    @JsonIgnore
    public Optional<Long> getIncompleteJobCount() {
        return Optional.ofNullable(incompleteJobCount);
    }

    public PrintUsageSummaryByUser withIncompleteJobCount(Long incompleteJobCount) {
        PrintUsageSummaryByUser _x = _copy();
        _x.changedFields = changedFields.add("incompleteJobCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.PrintUsageSummaryByUser");
        _x.incompleteJobCount = incompleteJobCount;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrintUsageSummaryByUser patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        PrintUsageSummaryByUser _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public PrintUsageSummaryByUser put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        PrintUsageSummaryByUser _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private PrintUsageSummaryByUser _copy() {
        PrintUsageSummaryByUser _x = new PrintUsageSummaryByUser();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.userPrincipalName = userPrincipalName;
        _x.usageDate = usageDate;
        _x.completedBlackAndWhiteJobCount = completedBlackAndWhiteJobCount;
        _x.completedColorJobCount = completedColorJobCount;
        _x.incompleteJobCount = incompleteJobCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PrintUsageSummaryByUser[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append(", ");
        b.append("usageDate=");
        b.append(this.usageDate);
        b.append(", ");
        b.append("completedBlackAndWhiteJobCount=");
        b.append(this.completedBlackAndWhiteJobCount);
        b.append(", ");
        b.append("completedColorJobCount=");
        b.append(this.completedColorJobCount);
        b.append(", ");
        b.append("incompleteJobCount=");
        b.append(this.incompleteJobCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
